/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.projectiles;

import mod.azure.doom.util.PlayerProperties;
import mod.azure.doom.util.registry.DoomEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class MeatHookEntity
extends AbstractArrow
implements IAnimatable {
    private static final EntityDataAccessor<Integer> HOOKED_ENTITY_ID = SynchedEntityData.m_135353_(MeatHookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> FORCED_YAW = SynchedEntityData.m_135353_(MeatHookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private double maxRange = 0.0;
    private double maxSpeed = 0.0;
    private boolean isPulling = false;
    public Entity hookedEntity;
    private ItemStack stack;

    public MeatHookEntity(EntityType<? extends AbstractArrow> type, Player owner, Level world) {
        super(type, (LivingEntity)owner, world);
        this.m_20242_(true);
        this.m_36781_(0.0);
    }

    public MeatHookEntity(Level world, LivingEntity owner) {
        super((EntityType)DoomEntities.MEATHOOOK_ENTITY.get(), owner, world);
        this.m_20242_(true);
        this.m_36781_(0.0);
    }

    public MeatHookEntity(Level world, double x, double y, double z) {
        super((EntityType)DoomEntities.MEATHOOOK_ENTITY.get(), x, y, z, world);
        this.m_20242_(true);
        this.m_36781_(0.0);
    }

    public MeatHookEntity(Level world) {
        super((EntityType)DoomEntities.MEATHOOOK_ENTITY.get(), world);
        this.m_20242_(true);
        this.m_36781_(0.0);
    }

    public MeatHookEntity(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOOKED_ENTITY_ID, (Object)0);
        this.f_19804_.m_135372_(FORCED_YAW, (Object)Float.valueOf(0.0f));
    }

    public void m_8119_() {
        super.m_8119_();
        Entity entity = this.m_37282_();
        if (entity instanceof Player) {
            Player owner = (Player)entity;
            this.m_146922_(((Float)this.f_19804_.m_135370_(FORCED_YAW)).floatValue());
            if (this.isPulling && this.f_19797_ % 2 == 0) {
                this.f_19853_.m_5594_(null, this.m_37282_().m_20183_(), SoundEvents.f_11745_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (!this.f_19853_.m_5776_()) {
                if (owner.m_21224_() || !((PlayerProperties)owner).hasMeatHook() || !((PlayerProperties)owner).hasMeatHook() || (double)owner.m_20270_((Entity)this) > this.maxRange || !((PlayerProperties)owner).hasMeatHook()) {
                    this.m_6074_();
                }
                if (this.hookedEntity != null) {
                    if (this.hookedEntity.m_213877_()) {
                        this.hookedEntity = null;
                        this.onRemovedFromWorld();
                    } else {
                        this.m_20248_(this.hookedEntity.m_20185_(), this.hookedEntity.m_20227_(0.8), this.hookedEntity.m_20189_());
                    }
                }
                if (owner.m_21206_() == this.stack) {
                    if (this.isPulling) {
                        Player target = owner;
                        MeatHookEntity origin = this;
                        if (owner.m_150108_() && this.hookedEntity != null) {
                            target = this.hookedEntity;
                            origin = owner;
                        }
                        double pullSpeed = 0.75;
                        Vec3 distance = origin.m_20182_().m_82546_(target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0));
                        Vec3 motion = distance.m_82541_().m_82490_(pullSpeed * distance.m_82553_() / 6.0);
                        if (Math.abs(distance.f_82480_) < 0.01) {
                            motion = new Vec3(motion.f_82479_, 0.0, motion.f_82481_);
                            this.m_6074_();
                        }
                        Vec3 vec3 = new Vec3(distance.f_82479_, 0.0, distance.f_82481_);
                        Vec3 vec32 = new Vec3((double)(target.m_20205_() / 2.0f), 0.0, (double)(target.m_20205_() / 2.0f));
                        if (vec3.m_82553_() < vec32.m_82553_() / 1.4) {
                            motion = new Vec3(motion.f_82479_, motion.f_82480_, motion.f_82481_);
                            this.m_6074_();
                        }
                        target.f_19789_ = 0.0f;
                        target.m_20256_(motion);
                        target.f_19864_ = true;
                    }
                } else {
                    this.m_6074_();
                }
            }
        } else {
            this.m_6074_();
        }
    }

    public void m_6074_() {
        Entity entity;
        if (!this.f_19853_.m_5776_() && (entity = this.m_37282_()) instanceof Player) {
            Player owner = (Player)entity;
            ((PlayerProperties)owner).setHasMeatHook(false);
            owner.m_20242_(false);
        }
        super.m_6074_();
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    protected float m_6882_() {
        return super.m_6882_();
    }

    public boolean m_6072_() {
        return false;
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        Entity entity;
        super.m_8060_(blockHitResult);
        this.isPulling = true;
        if (!this.f_19853_.m_5776_() && (entity = this.m_37282_()) instanceof Player) {
            Player owner = (Player)entity;
            if (this.hookedEntity == null) {
                owner.m_20242_(true);
            }
        }
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity;
        if (!this.f_19853_.m_5776_() && (entity = this.m_37282_()) instanceof Player) {
            Player owner = (Player)entity;
            if (entityHitResult.m_82443_() != owner && (entityHitResult.m_82443_() instanceof LivingEntity || entityHitResult.m_82443_() instanceof EnderDragonPart) && this.hookedEntity == null) {
                this.hookedEntity = entityHitResult.m_82443_();
                this.f_19804_.m_135381_(HOOKED_ENTITY_ID, (Object)(this.hookedEntity.m_19879_() + 1));
                this.isPulling = true;
            }
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(FORCED_YAW, (Object)Float.valueOf(tag.m_128457_("ForcedYaw")));
        this.maxRange = tag.m_128459_("maxRange");
        this.maxSpeed = tag.m_128459_("maxSpeed");
        this.isPulling = tag.m_128471_("isPulling");
        this.stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("hookshotItem"));
        Entity entity = this.f_19853_.m_6815_(tag.m_128451_("owner"));
        if (entity instanceof Player) {
            Player owner = (Player)entity;
            this.m_5602_((Entity)owner);
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("ForcedYaw", ((Float)this.f_19804_.m_135370_(FORCED_YAW)).floatValue());
        tag.m_128347_("maxRange", this.maxRange);
        tag.m_128347_("maxSpeed", this.maxSpeed);
        tag.m_128379_("isPulling", this.isPulling);
        tag.m_128365_("hookshotItem", (Tag)this.stack.m_41739_(new CompoundTag()));
        Entity entity = this.m_37282_();
        if (entity instanceof Player) {
            Player owner = (Player)entity;
            tag.m_128405_("owner", owner.m_19879_());
        }
    }

    public void setProperties(ItemStack stack, double maxRange, double maxVelocity, float pitch, float yaw, float roll, float modifierZ) {
        float f = (float)Math.PI / 180;
        float x = -Mth.m_14031_((float)(yaw * f)) * Mth.m_14089_((float)(pitch * f));
        float y = -Mth.m_14031_((float)((pitch + roll) * f));
        float z = Mth.m_14089_((float)(yaw * f)) * Mth.m_14089_((float)(pitch * f));
        this.m_6686_(x, y, z, modifierZ, 0.0f);
        this.stack = stack;
        this.maxRange = maxRange;
        this.maxSpeed = maxVelocity;
    }
}

