/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.projectiles;

import mod.azure.doom.config.DoomConfig;
import mod.azure.doom.entity.tierheavy.CacodemonEntity;
import mod.azure.doom.util.registry.DoomEntities;
import mod.azure.doom.util.registry.DoomSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class GrenadeEntity
extends AbstractArrow
implements IAnimatable {
    protected int timeInAir;
    protected boolean inAir;
    protected String f_19847_;
    private int ticksInAir;
    private LivingEntity shooter;
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public SoundEvent hitSound = this.m_7239_();

    public GrenadeEntity(EntityType<? extends GrenadeEntity> entityType, Level world) {
        super(entityType, world);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    public GrenadeEntity(Level world, LivingEntity user) {
        super((EntityType)DoomEntities.GRENADE.get(), user, world);
        this.shooter = user;
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("spin", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
        areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123744_);
        areaeffectcloudentity.m_19712_(6.0f);
        areaeffectcloudentity.m_19734_(1);
        areaeffectcloudentity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.f_19853_.m_7967_((Entity)areaeffectcloudentity);
        this.explode();
        this.m_5496_(SoundEvents.f_11913_, 1.0f, 1.0f);
        super.m_142687_(reason);
    }

    protected void m_6901_() {
        ++this.ticksInAir;
        if (this.ticksInAir >= 80) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity, inaccuracy);
        this.ticksInAir = 0;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128376_("life", (short)this.ticksInAir);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.ticksInAir = compound.m_128448_("life");
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_41852_);
    }

    public void m_36740_(SoundEvent soundIn) {
        this.hitSound = soundIn;
    }

    protected SoundEvent m_7239_() {
        return (SoundEvent)DoomSounds.BEEP.get();
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.m_36740_(SoundEvents.f_11913_);
        if (!this.f_19853_.m_5776_() && this.f_19797_ >= 46) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        if (!this.f_19853_.m_5776_()) {
            if (entity instanceof CacodemonEntity) {
                entity.m_6469_(DamageSource.m_19344_((Player)((Player)this.shooter)), ((LivingEntity)entity).m_21233_());
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            } else {
                this.explode();
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected void explode() {
        this.f_19853_.m_45933_((Entity)this, new AABB(this.m_20183_().m_7494_()).m_82400_(8.0)).forEach(e -> this.doDamage((Entity)this, (Entity)e));
    }

    private void doDamage(Entity user, Entity target) {
        if (target instanceof LivingEntity) {
            target.f_19802_ = 0;
            target.m_6469_(DamageSource.m_19367_((Entity)this, (Entity)target), ((Double)DoomConfig.SERVER.grenade_damage.get()).floatValue());
        }
    }

    public boolean m_6051_() {
        return false;
    }
}

