/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.attack;

import mod.azure.doom.entity.DemonEntity;
import mod.azure.doom.entity.attack.AttackSound;
import mod.azure.doom.entity.attack.IRangedAttack;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractRangedAttack
implements IRangedAttack {
    public DemonEntity parentEntity;
    public double xOffSetModifier = 2.0;
    public double entityHeightFraction = 0.5;
    public double zOffSetModifier = 2.0;
    public float damage = 1.0f;
    public double accuracy = 0.95;
    private AttackSound sound;

    public AbstractRangedAttack(DemonEntity parentEntity) {
        this.parentEntity = parentEntity;
    }

    public AbstractRangedAttack(DemonEntity parentEntity, double xOffSetModifier, double entityHeightFraction, double zOffSetModifier, float damage) {
        this.parentEntity = parentEntity;
        this.xOffSetModifier = xOffSetModifier;
        this.entityHeightFraction = entityHeightFraction;
        this.zOffSetModifier = zOffSetModifier;
        this.damage = damage;
    }

    public AbstractRangedAttack setProjectileOriginOffset(double x, double entityHeightFraction, double z) {
        this.xOffSetModifier = x;
        this.entityHeightFraction = entityHeightFraction;
        this.zOffSetModifier = z;
        return this;
    }

    public AbstractRangedAttack setDamage(float damage) {
        this.damage = damage;
        return this;
    }

    public AbstractRangedAttack setSound(AttackSound sound) {
        this.sound = sound;
        return this;
    }

    public AbstractRangedAttack setSound(SoundEvent sound, float volume, float pitch) {
        this.sound = new AttackSound(sound, volume, pitch);
        return this;
    }

    public AbstractRangedAttack setAccuracy(double accuracy) {
        this.accuracy = accuracy;
        return this;
    }

    public double rollAccuracy(double directional) {
        return directional + (1.0 - this.accuracy) * directional * this.parentEntity.m_217043_().m_188583_();
    }

    public void shoot() {
        LivingEntity livingentity = this.parentEntity.m_5448_();
        Level world = this.parentEntity.m_20193_();
        Vec3 vector3d = this.parentEntity.m_20252_(1.0f);
        double d2 = livingentity.m_20185_() - (this.parentEntity.m_20185_() + vector3d.f_82479_ * this.xOffSetModifier);
        double d3 = livingentity.m_20227_(0.5) - this.parentEntity.m_20227_(this.entityHeightFraction);
        double d4 = livingentity.m_20189_() - (this.parentEntity.m_20189_() + vector3d.f_82481_ * this.zOffSetModifier);
        Projectile projectile = this.getProjectile(world, this.rollAccuracy(d2), this.rollAccuracy(d3), this.rollAccuracy(d4));
        projectile.m_6034_(this.parentEntity.m_20185_() + vector3d.f_82479_ * this.xOffSetModifier, this.parentEntity.m_20227_(this.entityHeightFraction), this.parentEntity.m_20189_() + vector3d.f_82481_ * this.zOffSetModifier);
        world.m_7967_((Entity)projectile);
        if (this.sound == null) {
            this.getDefaultAttackSound().play((Entity)this.parentEntity);
        } else {
            this.sound.play((Entity)this.parentEntity);
        }
    }
}

