/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.ai.goal;

import java.util.EnumSet;
import mod.azure.doom.entity.attack.AbstractDoubleRangedAttack;
import mod.azure.doom.entity.tierboss.GladiatorEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.Vec3;

public class RangedStrafeGladiatorAttackGoal
extends Goal {
    private final GladiatorEntity entity;
    private int attackTime = -1;
    private int summonTime = -1;
    private AbstractDoubleRangedAttack attack;

    public RangedStrafeGladiatorAttackGoal(GladiatorEntity mob, AbstractDoubleRangedAttack attack) {
        this.entity = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        this.attack = attack;
    }

    public boolean m_8036_() {
        return this.entity.m_5448_() != null;
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.entity.m_21561_(true);
        this.entity.m_20225_(false);
        this.entity.setTextureState(0);
        this.entity.f_19853_.m_46518_((Entity)this.entity, this.entity.m_20185_(), this.entity.m_20186_() + 5.0, this.entity.m_20189_(), 3.0f, false, Explosion.BlockInteraction.BREAK);
    }

    public void m_8041_() {
        super.m_8041_();
        this.entity.m_21561_(false);
        this.entity.setAttackingState(0);
        this.entity.setTextureState(0);
        this.attackTime = -1;
        this.entity.m_5810_();
        this.entity.m_20225_(false);
        this.entity.f_19853_.m_46518_((Entity)this.entity, this.entity.m_20185_(), this.entity.m_20186_() + 5.0, this.entity.m_20189_(), 3.0f, false, Explosion.BlockInteraction.BREAK);
    }

    public void m_8037_() {
        LivingEntity livingentity = this.entity.m_5448_();
        if (livingentity != null) {
            boolean inLineOfSight = this.entity.m_21574_().m_148306_((Entity)livingentity);
            ++this.attackTime;
            ++this.summonTime;
            this.entity.m_21391_((Entity)livingentity, 30.0f, 30.0f);
            if (inLineOfSight) {
                if ((double)this.entity.m_20270_((Entity)livingentity) >= 3.0) {
                    if (this.entity.getDeathState() == 0 && this.summonTime > 10) {
                        this.entity.m_21573_().m_26573_();
                        if (this.attackTime == 1) {
                            this.entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 80, -20));
                            this.entity.setAttackingState(1);
                            this.entity.setTextureState(1);
                        }
                        if (this.attackTime == 20) {
                            this.entity.setTextureState(2);
                        }
                        if (this.attackTime == 23) {
                            AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.entity.f_19853_, this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_());
                            areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123745_);
                            areaeffectcloudentity.m_19712_(3.0f);
                            areaeffectcloudentity.m_19734_(10);
                            areaeffectcloudentity.m_6034_(this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_());
                            this.entity.f_19853_.m_7967_((Entity)areaeffectcloudentity);
                            this.attack.shoot();
                            boolean isInsideWaterBlock = this.entity.f_19853_.m_46801_(this.entity.m_20183_());
                            this.entity.spawnLightSource((Entity)this.entity, isInsideWaterBlock);
                            this.entity.setTextureState(0);
                            this.entity.m_21573_().m_5624_((Entity)livingentity, 1.0);
                            this.summonTime = -40;
                        }
                        if (this.attackTime == 48) {
                            this.entity.setAttackingState(0);
                            this.entity.setTextureState(0);
                        }
                        if (this.attackTime == 83) {
                            this.attackTime = -5;
                            this.entity.setTextureState(0);
                            this.entity.setAttackingState(0);
                            this.entity.m_21573_().m_5624_((Entity)livingentity, 1.0);
                        }
                    } else if (this.entity.getDeathState() == 1 && this.summonTime > 10) {
                        if (this.attackTime == 1) {
                            this.entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 13, -20));
                            this.entity.m_21573_().m_26573_();
                            this.entity.setTextureState(0);
                            this.entity.setAttackingState(0);
                        }
                        if (this.attackTime == 5) {
                            this.entity.setAttackingState(4);
                        }
                        if (this.attackTime == 8) {
                            this.attack.shoot2();
                            boolean isInsideWaterBlock = this.entity.f_19853_.m_46801_(this.entity.m_20183_());
                            this.entity.spawnLightSource((Entity)this.entity, isInsideWaterBlock);
                            this.summonTime = -8;
                        }
                        if (this.attackTime >= 13) {
                            this.entity.m_21573_().m_5624_((Entity)livingentity, 1.0);
                            this.entity.setTextureState(0);
                            this.entity.setAttackingState(0);
                            this.attackTime = -5;
                        }
                    } else {
                        this.attackTime = -25;
                        this.entity.setTextureState(0);
                        this.entity.setAttackingState(0);
                        this.entity.m_21573_().m_5624_((Entity)livingentity, 1.0);
                    }
                } else {
                    this.entity.m_21573_().m_5624_((Entity)livingentity, this.entity.getDeathState() == 0 ? 1.0 : 1.25);
                    if (this.attackTime == 1) {
                        ++this.summonTime;
                        this.entity.setAttackingState(3);
                        Vec3 vec3d = this.entity.m_20184_();
                        Vec3 vec3d2 = new Vec3(livingentity.m_20185_() - this.entity.m_20185_(), 0.0, livingentity.m_20189_() - this.entity.m_20189_());
                        vec3d2 = vec3d2.m_82541_().m_82490_(0.4).m_82549_(vec3d.m_82490_(0.4));
                        this.entity.m_20334_(vec3d2.f_82479_, 0.5, vec3d2.f_82481_);
                    }
                    if (this.attackTime == 18) {
                        this.entity.m_21573_().m_26573_();
                        AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.entity.f_19853_, this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_());
                        areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123762_);
                        areaeffectcloudentity.m_19712_(3.0f);
                        areaeffectcloudentity.m_19734_(55);
                        areaeffectcloudentity.m_6034_(this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_());
                        this.entity.f_19853_.m_7967_((Entity)areaeffectcloudentity);
                        this.entity.m_7327_((Entity)livingentity);
                        livingentity.f_19802_ = 0;
                    }
                    if (this.attackTime == 19 && this.entity.getDeathState() == 1) {
                        this.entity.doHurtTarget1((Entity)livingentity);
                        livingentity.f_19802_ = 0;
                    }
                    if (this.attackTime >= 25) {
                        this.attackTime = -5;
                        this.entity.setTextureState(0);
                        this.entity.setAttackingState(0);
                    }
                }
            }
        }
    }

    protected double getAttackReachSqr(LivingEntity attackTarget) {
        return this.entity.m_20205_() * 2.0f * this.entity.m_20205_() * 2.0f + attackTarget.m_20205_();
    }
}

