/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import mod.azure.doom.client.models.projectiles.MeatHookEntityModel;
import mod.azure.doom.entity.projectiles.MeatHookEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoProjectilesRenderer;

public class MeatHookEntityRenderer
extends GeoProjectilesRenderer<MeatHookEntity> {
    private static final ResourceLocation CHAIN_TEXTURE = new ResourceLocation("doom", "textures/entity/chain.png");
    private static final RenderType CHAIN_LAYER = RenderType.m_110476_((ResourceLocation)CHAIN_TEXTURE);

    public MeatHookEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (AnimatedGeoModel)new MeatHookEntityModel());
    }

    protected int getBlockLight(MeatHookEntity entityIn, BlockPos partialTicks) {
        return 15;
    }

    public RenderType getRenderType(MeatHookEntity animatable, float partialTicks, PoseStack stack, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.m_110473_((ResourceLocation)this.m_5478_((Entity)animatable));
    }

    public void render(MeatHookEntity hookshot, float yaw, float tickDelta, PoseStack stack, MultiBufferSource provider, int light) {
        super.m_7392_((Entity)hookshot, yaw, tickDelta, stack, provider, light);
        Entity entity = hookshot.m_37282_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            HumanoidArm mainArm = (HumanoidArm)Minecraft.m_91087_().f_91066_.m_232107_().m_231551_();
            InteractionHand activeHand = player.m_7655_();
            stack.m_85836_();
            boolean rightHandIsActive = mainArm == HumanoidArm.RIGHT && activeHand == InteractionHand.MAIN_HAND || mainArm == HumanoidArm.LEFT && activeHand == InteractionHand.OFF_HAND;
            double bodyYawToRads = Math.toRadians(player.f_20883_);
            double radius = rightHandIsActive ? -0.4 : 0.9;
            double startX = player.m_20185_() + radius * Math.cos(bodyYawToRads);
            double startY = player.m_20186_() + (double)player.m_20206_() / 3.0;
            double startZ = player.m_20189_() + radius * Math.sin(bodyYawToRads);
            float distanceX = (float)(startX - hookshot.m_20185_());
            float distanceY = (float)(startY - hookshot.m_20186_());
            float distanceZ = (float)(startZ - hookshot.m_20189_());
            this.renderChain(distanceX, distanceY, distanceZ, tickDelta, hookshot.f_19797_, stack, provider, light);
            stack.m_85849_();
        }
    }

    public void renderChain(float x, float y, float z, float tickDelta, int age, PoseStack stack, MultiBufferSource provider, int light) {
        float lengthXY = Mth.m_14116_((float)(x * x + z * z));
        float squaredLength = x * x + y * y + z * z;
        float length = Mth.m_14116_((float)squaredLength);
        stack.m_85836_();
        stack.m_85845_(Vector3f.f_122225_.m_122270_((float)(-Math.atan2(z, x)) - 1.5707964f));
        stack.m_85845_(Vector3f.f_122223_.m_122270_((float)(-Math.atan2(lengthXY, y)) - 1.5707964f));
        stack.m_85845_(Vector3f.f_122227_.m_122270_(25.0f));
        stack.m_85836_();
        stack.m_85837_(0.015, -0.2, 0.0);
        VertexConsumer vertexConsumer = provider.m_6299_(CHAIN_LAYER);
        float vertX1 = 0.0f;
        float vertY1 = 0.25f;
        float vertX2 = Mth.m_14031_((float)((float)Math.PI * 2)) * 0.125f;
        float vertY2 = Mth.m_14089_((float)((float)Math.PI * 2)) * 0.125f;
        float minU = 0.0f;
        float maxU = 0.1875f;
        float minV = 0.0f - ((float)age + tickDelta) * 0.01f;
        float maxV = Mth.m_14116_((float)squaredLength) / 8.0f - ((float)age + tickDelta) * 0.01f;
        PoseStack.Pose entry = stack.m_85850_();
        Matrix4f matrix4f = entry.m_85861_();
        Matrix3f matrix3f = entry.m_85864_();
        vertexConsumer.m_85982_(matrix4f, vertX1, vertY1, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix4f, vertX1, vertY1, length).m_6122_(255, 255, 255, 255).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix4f, vertX2, vertY2, length).m_6122_(255, 255, 255, 255).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix4f, vertX2, vertY2, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        stack.m_85849_();
        stack.m_85845_(Vector3f.f_122227_.m_122270_(90.0f));
        stack.m_85837_(-0.015, -0.2, 0.0);
        entry = stack.m_85850_();
        matrix4f = entry.m_85861_();
        matrix3f = entry.m_85864_();
        vertexConsumer.m_85982_(matrix4f, vertX1, vertY1, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix4f, vertX1, vertY1, length).m_6122_(255, 255, 255, 255).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix4f, vertX2, vertY2, length).m_6122_(255, 255, 255, 255).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix4f, vertX2, vertY2, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        stack.m_85849_();
    }
}

