/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.client.models;

import com.mojang.math.Vector3f;
import mod.azure.doom.entity.tierheavy.SpectreEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedTickingGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class SpectreModel
extends AnimatedTickingGeoModel<SpectreEntity> {
    public ResourceLocation getModelResource(SpectreEntity object) {
        return new ResourceLocation("doom", "geo/" + (object.getVariant() > 1 ? "pinky" : "pinky2016") + ".geo.json");
    }

    public ResourceLocation getTextureResource(SpectreEntity object) {
        return new ResourceLocation("doom", "textures/entity/" + (object.getVariant() == 2 ? "pinky-texturemap" : (object.getVariant() == 3 ? "pinky_green" : "pinky2016")) + ".png");
    }

    public ResourceLocation getAnimationResource(SpectreEntity object) {
        return new ResourceLocation("doom", "animations/" + (object.getVariant() > 1 ? "pinky_" : "pinky2016.") + "animation.json");
    }

    public void setLivingAnimations(SpectreEntity entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("neck");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (head != null) {
            head.setRotationX(Vector3f.f_122223_.m_122270_((extraData.headPitch + (float)(entity.getVariant() == 1 ? 270 : 30)) * ((float)Math.PI / 360)).m_80140_());
            head.setRotationY(Vector3f.f_122225_.m_122270_(extraData.netHeadYaw * 0.0062831854f).m_80150_());
        }
    }
}

