/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.client.models;

import com.mojang.math.Vector3f;
import mod.azure.doom.entity.tierheavy.PinkyEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedTickingGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class PinkyModel
extends AnimatedTickingGeoModel<PinkyEntity> {
    public ResourceLocation getModelResource(PinkyEntity object) {
        return new ResourceLocation("doom", "geo/" + (object.getVariant() == 3 ? "pinky2016" : "pinky") + ".geo.json");
    }

    public ResourceLocation getTextureResource(PinkyEntity object) {
        return new ResourceLocation("doom", "textures/entity/" + (object.getVariant() == 4 ? "pinky_green" : (object.getVariant() == 2 ? "pinky-64" : (object.getVariant() == 3 ? "pinky2016" : "pinky-texturemap"))) + ".png");
    }

    public ResourceLocation getAnimationResource(PinkyEntity object) {
        return new ResourceLocation("doom", "animations/" + (object.getVariant() == 3 ? "pinky2016." : "pinky_") + "animation.json");
    }

    public void setLivingAnimations(PinkyEntity entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("neck");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (head != null) {
            head.setRotationX(Vector3f.f_122223_.m_122270_((extraData.headPitch + (float)(entity.getVariant() == 3 ? 180 : 30)) * ((float)Math.PI / 360)).m_80140_());
            head.setRotationY(Vector3f.f_122225_.m_122270_(extraData.netHeadYaw * 0.0062831854f).m_80150_());
        }
    }
}

