/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.client.gui.weapons;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mod.azure.doom.client.gui.weapons.DoomGunInventory;
import mod.azure.doom.client.gui.weapons.GunTableOutputSlot;
import mod.azure.doom.recipes.GunTableRecipe;
import mod.azure.doom.util.registry.DoomBlocks;
import mod.azure.doom.util.registry.DoomScreens;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class GunTableScreenHandler
extends AbstractContainerMenu {
    private final Inventory playerInventory;
    private final DoomGunInventory gunTableInventory;
    private final ContainerLevelAccess context;
    private int recipeIndex;

    public GunTableScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public GunTableScreenHandler(int syncId, Inventory playerInventory, ContainerLevelAccess context) {
        super((MenuType)DoomScreens.SCREEN_HANDLER_TYPE.get(), syncId);
        int k;
        this.playerInventory = playerInventory;
        this.gunTableInventory = new DoomGunInventory(this);
        this.context = context;
        this.m_38897_(new Slot((Container)this.gunTableInventory, 0, 155, 13));
        this.m_38897_(new Slot((Container)this.gunTableInventory, 1, 175, 33));
        this.m_38897_(new Slot((Container)this.gunTableInventory, 2, 135, 33));
        this.m_38897_(new Slot((Container)this.gunTableInventory, 3, 142, 56));
        this.m_38897_(new Slot((Container)this.gunTableInventory, 4, 168, 56));
        this.m_38897_(new GunTableOutputSlot(playerInventory.f_35978_, this.gunTableInventory, 5, 238, 38));
        for (k = 0; k < 3; ++k) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + k * 9 + 9, 127 + j * 18, 84 + k * 18));
            }
        }
        for (k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 127 + k * 18, 142));
        }
    }

    protected static void updateResult(int syncId, Level world, Player player, DoomGunInventory craftingInventory) {
        if (!world.m_5776_()) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            ItemStack itemStack = ItemStack.f_41583_;
            Optional optional = world.m_7654_().m_129894_().m_44015_((RecipeType)GunTableRecipe.Type.INSTANCE, (Container)craftingInventory, world);
            if (optional.isPresent()) {
                GunTableRecipe craftingRecipe = (GunTableRecipe)optional.get();
                itemStack = craftingRecipe.assemble(craftingInventory);
            }
            craftingInventory.m_6836_(5, itemStack);
            serverPlayerEntity.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(syncId, 0, 5, itemStack));
        }
    }

    public void onContentChanged(Container inventory) {
        this.context.m_39292_((world, blockPos) -> GunTableScreenHandler.updateResult(this.f_38840_, world, this.playerInventory.f_35978_, this.gunTableInventory));
    }

    public boolean m_6875_(Player player) {
        return GunTableScreenHandler.m_38889_((ContainerLevelAccess)this.context, (Player)player, (Block)((Block)DoomBlocks.GUN_TABLE.get()));
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return false;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemStack2 = slot.m_7993_();
            itemStack = itemStack2.m_41777_();
            if (index == 2) {
                if (!this.m_38903_(itemStack2, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemStack2, itemStack);
            } else if (index != 0 && index != 1 ? (index >= 3 && index < 30 ? !this.m_38903_(itemStack2, 30, 39, false) : index >= 30 && index < 39 && !this.m_38903_(itemStack2, 3, 30, false)) : !this.m_38903_(itemStack2, 3, 39, false)) {
                return ItemStack.f_41583_;
            }
            if (itemStack2.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemStack2.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemStack2);
        }
        return itemStack;
    }

    public List<GunTableRecipe> getRecipes() {
        ArrayList<GunTableRecipe> list = new ArrayList<GunTableRecipe>(this.playerInventory.f_35978_.f_19853_.m_7465_().m_44013_((RecipeType)GunTableRecipe.Type.INSTANCE));
        list.sort(null);
        return list;
    }

    public void setRecipeIndex(int index) {
        this.recipeIndex = index;
    }

    public void switchTo(int recipeIndex) {
        if (this.getRecipes().size() > recipeIndex) {
            int i;
            GunTableRecipe gunTableRecipe = this.getRecipes().get(recipeIndex);
            for (i = 0; i < 5; ++i) {
                ItemStack slotStack = this.gunTableInventory.m_8020_(i);
                if (slotStack.m_41619_()) continue;
                if (!this.m_38903_(slotStack, 6, 39, false)) {
                    return;
                }
                this.gunTableInventory.m_6836_(i, slotStack);
            }
            for (i = 0; i < 5; ++i) {
                ItemStack[] possibleItems;
                Ingredient ingredient = gunTableRecipe.getIngredientForSlot(i);
                if (ingredient.m_43947_() || (possibleItems = ingredient.m_43908_()) == null) continue;
                ItemStack first = new ItemStack((ItemLike)possibleItems[0].m_41720_(), gunTableRecipe.countRequired(i));
                this.moveFromInventoryToPaymentSlot(i, first);
            }
        }
    }

    private void moveFromInventoryToPaymentSlot(int slot, ItemStack stack) {
        if (!stack.m_41619_()) {
            int ingCount = stack.m_41613_();
            for (int index = 6; index < 42; ++index) {
                ItemStack slotStack = ((Slot)this.f_38839_.get(index)).m_7993_();
                if (slotStack.m_41619_() || !this.equals(stack, slotStack)) continue;
                ItemStack invStack = this.gunTableInventory.m_8020_(slot);
                int invStackCount = invStack.m_41619_() ? 0 : invStack.m_41613_();
                int countToMove = Math.min(ingCount - invStackCount, slotStack.m_41613_());
                ItemStack slotStackCopy = slotStack.m_41777_();
                int l = invStackCount + countToMove;
                slotStack.m_41774_(countToMove);
                slotStackCopy.m_41764_(l);
                this.gunTableInventory.m_6836_(slot, slotStackCopy);
                if (l >= stack.m_41741_()) break;
            }
        }
    }

    private boolean equals(ItemStack itemStack, ItemStack otherItemStack) {
        return itemStack.m_41720_() == otherItemStack.m_41720_() && ItemStack.m_41758_((ItemStack)itemStack, (ItemStack)otherItemStack);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!this.playerInventory.f_35978_.f_19853_.f_46443_) {
            if (!(!player.m_6084_() || player instanceof ServerPlayer && ((ServerPlayer)player).m_9232_())) {
                player.m_150109_().m_150079_(this.gunTableInventory.m_8016_(0));
                player.m_150109_().m_150079_(this.gunTableInventory.m_8016_(1));
                player.m_150109_().m_150079_(this.gunTableInventory.m_8016_(2));
                player.m_150109_().m_150079_(this.gunTableInventory.m_8016_(3));
                player.m_150109_().m_150079_(this.gunTableInventory.m_8016_(4));
            } else {
                ItemStack itemStack0 = this.gunTableInventory.m_8016_(0);
                ItemStack itemStack1 = this.gunTableInventory.m_8016_(1);
                ItemStack itemStack2 = this.gunTableInventory.m_8016_(2);
                ItemStack itemStack3 = this.gunTableInventory.m_8016_(3);
                ItemStack itemStack4 = this.gunTableInventory.m_8016_(4);
                if (!itemStack0.m_41619_()) {
                    player.m_36176_(itemStack0, false);
                }
                if (!itemStack1.m_41619_()) {
                    player.m_36176_(itemStack1, false);
                }
                if (!itemStack2.m_41619_()) {
                    player.m_36176_(itemStack2, false);
                }
                if (!itemStack3.m_41619_()) {
                    player.m_36176_(itemStack3, false);
                }
                if (!itemStack4.m_41619_()) {
                    player.m_36176_(itemStack4, false);
                }
            }
        }
    }
}

