/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.client.gui.weapons;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mod.azure.doom.client.gui.weapons.GunTableScreenHandler;
import mod.azure.doom.recipes.GunTableRecipe;
import mod.azure.doom.util.packets.DoomCraftingPacket;
import mod.azure.doom.util.packets.DoomPacketHandler;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GunTableScreen
extends AbstractContainerScreen<GunTableScreenHandler> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("doom", "textures/gui/gun_table_gui.png");
    private int selectedIndex;
    private final RecipeButton[] offers = new RecipeButton[7];
    private int scrollOff;
    private boolean scrolling;

    public GunTableScreen(GunTableScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.f_97726_ = 300;
        this.f_97730_ = 107;
    }

    private void postButtonClick() {
        ((GunTableScreenHandler)this.f_97732_).setRecipeIndex(this.selectedIndex);
        ((GunTableScreenHandler)this.f_97732_).switchTo(this.selectedIndex);
        DoomPacketHandler.CRAFTING.sendToServer((Object)new DoomCraftingPacket(this.selectedIndex));
    }

    protected void m_7856_() {
        super.m_7856_();
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        int k = j + 18;
        for (int l = 0; l < 7; ++l) {
            this.offers[l] = (RecipeButton)this.m_142416_((GuiEventListener)new RecipeButton(i, k, l, button -> {
                if (button instanceof RecipeButton) {
                    this.selectedIndex = ((RecipeButton)button).getIndex() + this.scrollOff;
                    this.postButtonClick();
                }
            }));
            k += 20;
        }
    }

    protected void m_7027_(PoseStack matrices, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(matrices, this.f_96539_, (float)(65 + this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2), 6.0f, 0x404040);
    }

    protected void m_7286_(PoseStack matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int i = (this.f_96543_ - this.f_97726_) / 2 - 5;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        GunTableScreen.m_93143_((PoseStack)matrices, (int)i, (int)j, (int)this.m_93252_(), (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)512, (int)256);
    }

    private void renderScroller(PoseStack matrices, int x, int y, List<GunTableRecipe> tradeOffers) {
        int i = tradeOffers.size() + 1 - 7;
        if (i > 1) {
            int j = 139 - (27 + (i - 1) * 139 / i);
            int k = 1 + j / i + 139 / i;
            int m = Math.min(113, this.scrollOff * k);
            if (this.scrollOff == i - 1) {
                m = 113;
            }
            GunTableScreen.m_93143_((PoseStack)matrices, (int)(x + 113), (int)(y + 18 + m), (int)this.m_93252_(), (float)0.0f, (float)199.0f, (int)6, (int)27, (int)512, (int)256);
        } else {
            GunTableScreen.m_93143_((PoseStack)matrices, (int)(x + 113), (int)(y + 18), (int)this.m_93252_(), (float)6.0f, (float)199.0f, (int)6, (int)27, (int)512, (int)256);
        }
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        super.m_6305_(matrices, mouseX, mouseY, delta);
        List<GunTableRecipe> tradeOfferList = ((GunTableScreenHandler)this.f_97732_).getRecipes();
        if (!tradeOfferList.isEmpty()) {
            int i = (this.f_96543_ - this.f_97726_) / 2;
            int j = (this.f_96544_ - this.f_97727_) / 2;
            int yPos = j + 17;
            int xPos = i + 3;
            matrices.m_85836_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            this.renderScroller(matrices, i, j, tradeOfferList);
            int m = 0;
            for (GunTableRecipe gunTableRecipe : tradeOfferList) {
                if (this.canScroll(tradeOfferList.size()) && (m < this.scrollOff || m >= 7 + this.scrollOff)) {
                    ++m;
                    continue;
                }
                ItemStack output = gunTableRecipe.m_8043_();
                this.f_96542_.f_115093_ = 100.0f;
                int n = yPos + 2;
                this.renderIngredients(matrices, gunTableRecipe, xPos, n);
                this.renderButtonArrows(matrices, gunTableRecipe, i + 20, n);
                this.f_96542_.m_115218_(output, i + 24 + 68, n);
                this.f_96542_.m_115169_(this.f_96547_, output, i + 24 + 68, n);
                this.f_96542_.f_115093_ = 0.0f;
                yPos += 20;
                ++m;
            }
            for (RecipeButton widgetButtonPage : this.offers) {
                if (widgetButtonPage.m_198029_()) {
                    widgetButtonPage.m_7428_(matrices, mouseX, mouseY);
                }
                widgetButtonPage.f_93624_ = widgetButtonPage.index < ((GunTableScreenHandler)this.f_97732_).getRecipes().size();
            }
            matrices.m_85849_();
            RenderSystem.m_69482_();
        }
        this.m_7025_(matrices, mouseX, mouseY);
    }

    public void renderButtonArrows(PoseStack matrices, GunTableRecipe tradeOffer, int x, int y) {
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        GunTableScreen.m_93143_((PoseStack)matrices, (int)(x + 5 + 35 + 20), (int)(y + 3), (int)this.m_93252_(), (float)15.0f, (float)171.0f, (int)10, (int)9, (int)512, (int)256);
    }

    private void renderIngredients(PoseStack matrices, GunTableRecipe gunTableRecipe, int x, int y) {
        for (int i = 0; i < 5; ++i) {
            ItemStack stack;
            ItemStack[] displayStacks = gunTableRecipe.getIngredientForSlot(i).m_43908_();
            if (displayStacks.length <= 0 || (stack = new ItemStack((ItemLike)displayStacks[0].m_41720_(), gunTableRecipe.countRequired(i))).m_41619_()) continue;
            this.f_96542_.m_115123_(stack, x, y);
            this.f_96542_.m_115169_(this.f_96547_, stack, x, y);
            x += 20;
        }
    }

    private boolean canScroll(int listSize) {
        return listSize > 7;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        int i = ((GunTableScreenHandler)this.f_97732_).getRecipes().size();
        if (this.canScroll(i)) {
            int j = i - 7;
            this.scrollOff = (int)((double)this.scrollOff - amount);
            this.scrollOff = Mth.m_14045_((int)this.scrollOff, (int)0, (int)j);
        }
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        int i = ((GunTableScreenHandler)this.f_97732_).getRecipes().size();
        if (this.scrolling) {
            int j = this.f_97736_ + 18;
            int k = j + 139;
            int l = i - 7;
            float f = ((float)mouseY - (float)j - 13.5f) / ((float)(k - j) - 27.0f);
            f = f * (float)l + 0.5f;
            this.scrollOff = Mth.m_14045_((int)((int)f), (int)0, (int)l);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        if (this.canScroll(((GunTableScreenHandler)this.f_97732_).getRecipes().size()) && mouseX > (double)(i + 94) && mouseX < (double)(i + 94 + 6) && mouseY > (double)(j + 18) && mouseY <= (double)(j + 18 + 139 + 1)) {
            this.scrolling = true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    class RecipeButton
    extends Button {
        final int index;

        public RecipeButton(int x, int y, int index, Button.OnPress onPress) {
            super(x, y, 112, 20, CommonComponents.f_237098_, onPress);
            this.index = index;
            this.f_93624_ = false;
        }

        public int getIndex() {
            return this.index;
        }

        public void m_7428_(PoseStack matrices, int mouseX, int mouseY) {
            if (this.f_93622_ && ((GunTableScreenHandler)GunTableScreen.this.f_97732_).getRecipes().size() > this.index + GunTableScreen.this.scrollOff) {
                if (mouseX < this.f_93620_ + 20) {
                    ItemStack stack = ((GunTableScreenHandler)GunTableScreen.this.f_97732_).getRecipes().get(this.index + GunTableScreen.this.scrollOff).m_8043_();
                    GunTableScreen.this.m_6057_(matrices, stack, mouseX, mouseY);
                } else if (mouseX < this.f_93620_ + 50 && mouseX > this.f_93620_ + 30) {
                    ItemStack stack = ((GunTableScreenHandler)GunTableScreen.this.f_97732_).getRecipes().get(this.index + GunTableScreen.this.scrollOff).m_8043_();
                    if (!stack.m_41619_()) {
                        GunTableScreen.this.m_6057_(matrices, stack, mouseX, mouseY);
                    }
                } else if (mouseX > this.f_93620_ + 65) {
                    ItemStack stack = ((GunTableScreenHandler)GunTableScreen.this.f_97732_).getRecipes().get(this.index + GunTableScreen.this.scrollOff).m_8043_();
                    GunTableScreen.this.m_6057_(matrices, stack, mouseX, mouseY);
                }
            }
        }
    }
}

