/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.block;

import mod.azure.doom.entity.tileentity.GunBlockEntity;
import mod.azure.doom.util.registry.DoomEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GunTableBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final VoxelShape XBASE1 = Block.m_49796_((double)0.0, (double)0.0, (double)-16.0, (double)16.0, (double)9.0, (double)32.0);
    private static final VoxelShape XBASE2 = Block.m_49796_((double)2.0, (double)9.0, (double)-14.0, (double)13.0, (double)25.0, (double)30.0);
    private static final VoxelShape YBASE1 = Block.m_49796_((double)-16.0, (double)0.0, (double)0.0, (double)32.0, (double)9.0, (double)16.0);
    private static final VoxelShape YBASE2 = Block.m_49796_((double)-14.0, (double)9.0, (double)2.0, (double)30.0, (double)25.0, (double)13.0);
    private static final VoxelShape X_AXIS_AABB = Shapes.m_83110_((VoxelShape)XBASE1, (VoxelShape)XBASE2);
    private static final VoxelShape Z_AXIS_AABB = Shapes.m_83110_((VoxelShape)YBASE1, (VoxelShape)YBASE2);
    public static final BooleanProperty light = RedstoneTorchBlock.f_55674_;

    public GunTableBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.WEST));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)DoomEntities.GUN_TABLE_ENTITY.get()).m_155264_(pos, state);
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        MenuProvider screenHandlerFactory;
        if (!world.f_46443_ && (screenHandlerFactory = state.m_60750_(world, pos)) != null) {
            player.m_5893_(screenHandlerFactory);
        }
        return InteractionResult.SUCCESS;
    }

    public MenuProvider m_7246_(BlockState state, Level world, BlockPos pos) {
        return (MenuProvider)world.m_7702_(pos);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof GunBlockEntity) {
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((GunBlockEntity)blockEntity));
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, moved);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, light});
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return 15;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return direction.m_122434_() == Direction.Axis.X ? X_AXIS_AABB : Z_AXIS_AABB;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return direction.m_122434_() == Direction.Axis.X ? world.m_8055_(pos.m_122019_()).m_60795_() && world.m_8055_(pos.m_122012_()).m_60795_() : world.m_8055_(pos.m_122029_()).m_60795_() && world.m_8055_(pos.m_122024_()).m_60795_();
    }
}

