/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.block;

import mod.azure.doom.entity.projectiles.BarrelEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BarrelBlock
extends Block {
    public static final DirectionProperty direction = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty light = RedstoneTorchBlock.f_55674_;

    public BarrelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)direction, (Comparable)Direction.NORTH)).m_61124_((Property)light, (Comparable)Boolean.valueOf(true)));
    }

    public boolean m_6903_(Explosion explosionIn) {
        return false;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 300;
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return true;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.onCaughtFire(state, worldIn, pos, null, null);
        worldIn.m_7471_(pos, false);
    }

    public void m_7592_(Level worldIn, BlockPos pos, Explosion explosionIn) {
        if (!worldIn.f_46443_) {
            BarrelEntity tntentity = new BarrelEntity(worldIn, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, explosionIn.m_46079_());
            worldIn.m_7967_((Entity)tntentity);
        }
    }

    public void onCaughtFire(BlockState state, Level world, BlockPos pos, Direction face, LivingEntity igniter) {
        if (!world.f_46443_) {
            BarrelEntity tntentity = new BarrelEntity(world, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, igniter);
            world.m_7967_((Entity)tntentity);
        }
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.m_5776_() && !player.m_7500_()) {
            this.onCaughtFire(state, worldIn, pos, null, null);
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        Item item = itemstack.m_41720_();
        if (item != Items.f_42409_ && item != Items.f_42613_) {
            return super.m_6227_(state, worldIn, pos, player, handIn, hit);
        }
        this.onCaughtFire(state, worldIn, pos, hit.m_82434_(), (LivingEntity)player);
        worldIn.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
        if (!player.m_7500_()) {
            if (item == Items.f_42409_) {
                itemstack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(handIn));
            } else {
                itemstack.m_41774_(1);
            }
        }
        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
    }

    public void m_5581_(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (!worldIn.f_46443_) {
            Entity entity = projectile.m_37282_();
            BlockPos blockpos = hit.m_82425_();
            this.onCaughtFire(state, worldIn, blockpos, null, entity instanceof LivingEntity ? (LivingEntity)entity : null);
            worldIn.m_7471_(blockpos, false);
        }
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return 10;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)direction, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)direction, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)direction)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)direction)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{direction, light});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83048_((double)0.06f, (double)0.0, (double)0.06f, (double)0.94f, (double)1.0, (double)0.94f);
    }
}

