/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom;

import java.util.List;
import mod.azure.doom.config.DoomConfig;
import mod.azure.doom.util.DoomVillagerTrades;
import mod.azure.doom.util.LootHandler;
import mod.azure.doom.util.SoulCubeHandler;
import mod.azure.doom.util.packets.DoomPacketHandler;
import mod.azure.doom.util.registry.DoomBlocks;
import mod.azure.doom.util.registry.DoomEntities;
import mod.azure.doom.util.registry.DoomItems;
import mod.azure.doom.util.registry.DoomParticles;
import mod.azure.doom.util.registry.DoomRecipes;
import mod.azure.doom.util.registry.DoomScreens;
import mod.azure.doom.util.registry.DoomSounds;
import mod.azure.doom.util.registry.DoomStructures;
import mod.azure.doom.util.registry.ModEntitySpawn;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeTier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import software.bernie.geckolib3.GeckoLib;
import software.bernie.geckolib3.network.GeckoLibNetwork;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="doom")
public class DoomMod {
    public static DoomMod instance;
    public static final String MODID = "doom";
    public static final TagKey<Block> ARGENT_TAG;
    public static final Tier ARGENT_TIER;
    public static final Tier DOOM_HIGHTEIR;
    public static final CreativeModeTab DoomWeaponItemGroup;
    public static final CreativeModeTab DoomArmorItemGroup;
    public static final CreativeModeTab DoomBlockItemGroup;
    public static final CreativeModeTab DoomEggItemGroup;
    public static final CreativeModeTab DoomPowerUPItemGroup;

    public DoomMod() {
        instance = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DoomConfig.SERVER_SPEC, "doom-newconfig.toml");
        DoomConfig.loadConfig(DoomConfig.SERVER_SPEC, FMLPaths.CONFIGDIR.get().resolve("doom-newconfig.toml").toString());
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (((Boolean)DoomConfig.SERVER.enable_soulcube_effects.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.register((Object)new SoulCubeHandler());
        }
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::enqueueIMC);
        if (((Boolean)DoomConfig.SERVER.enable_all_villager_trades.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.addListener(DoomVillagerTrades::onVillagerTradesEvent);
        }
        DoomSounds.MOD_SOUNDS.register(modEventBus);
        DoomEntities.ENTITY_TYPES.register(modEventBus);
        DoomItems.ITEMS.register(modEventBus);
        DoomBlocks.BLOCKS.register(modEventBus);
        DoomEntities.TILE_TYPES.register(modEventBus);
        DoomScreens.CONTAIN.register(modEventBus);
        DoomRecipes.SERIAL.register(modEventBus);
        DoomParticles.PARTICLES.register(modEventBus);
        DoomStructures.DEFERRED_REGISTRY_STRUCTURE.register(modEventBus);
        ModEntitySpawn.SERIALIZER.register(modEventBus);
        GeckoLib.initialize();
        GeckoLibNetwork.initialize();
    }

    private void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new LootHandler());
        DoomPacketHandler.register();
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"modify_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"modify_type", () -> SlotTypePreset.BELT.getMessageBuilder().build());
    }

    static {
        ARGENT_TAG = BlockTags.create((ResourceLocation)new ResourceLocation(MODID, "needs_argent_tool"));
        ARGENT_TIER = TierSortingRegistry.registerTier((Tier)new ForgeTier(17, 5000, 18.0f, 3.0f, 30, ARGENT_TAG, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DoomItems.ARGENT_BLOCK.get()})), (ResourceLocation)new ResourceLocation(MODID, "argent"), List.of(Tiers.NETHERITE), List.of());
        DOOM_HIGHTEIR = TierSortingRegistry.registerTier((Tier)new ForgeTier(17, 24, 18.0f, -1.9f, 30, ARGENT_TAG, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DoomItems.ARGENT_BLOCK.get()})), (ResourceLocation)new ResourceLocation(MODID, "doom_highertier"), List.of(Tiers.NETHERITE), List.of());
        DoomWeaponItemGroup = new CreativeModeTab("doomweapons"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)DoomItems.BFG_ETERNAL.get());
            }
        };
        DoomArmorItemGroup = new CreativeModeTab("doomarmor"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)DoomItems.DOOM_HELMET.get());
            }
        };
        DoomBlockItemGroup = new CreativeModeTab("doomblocks"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)DoomBlocks.BARREL_BLOCK.get());
            }
        };
        DoomEggItemGroup = new CreativeModeTab("doomeggs"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)DoomItems.IMP_SPAWN_EGG.get());
            }
        };
        DoomPowerUPItemGroup = new CreativeModeTab("doompowerup"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)DoomItems.INMORTAL.get());
            }
        };
    }
}

