/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.core.other;

import com.mojang.authlib.GameProfile;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedDataManager;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.savage_and_ravage.common.entity.OwnableMob;
import com.teamabnormals.savage_and_ravage.common.entity.ai.goal.CelebrateTargetBlockHitGoal;
import com.teamabnormals.savage_and_ravage.common.entity.ai.goal.ImprovedCrossbowGoal;
import com.teamabnormals.savage_and_ravage.common.entity.decoration.BurningBanner;
import com.teamabnormals.savage_and_ravage.common.entity.item.SporeBomb;
import com.teamabnormals.savage_and_ravage.common.entity.monster.Creepie;
import com.teamabnormals.savage_and_ravage.common.entity.monster.Executioner;
import com.teamabnormals.savage_and_ravage.common.entity.monster.Griefer;
import com.teamabnormals.savage_and_ravage.common.entity.monster.Iceologer;
import com.teamabnormals.savage_and_ravage.common.entity.monster.SkeletonVillager;
import com.teamabnormals.savage_and_ravage.common.entity.monster.Trickster;
import com.teamabnormals.savage_and_ravage.common.entity.projectile.SporeCloud;
import com.teamabnormals.savage_and_ravage.common.item.PottableItem;
import com.teamabnormals.savage_and_ravage.core.SRConfig;
import com.teamabnormals.savage_and_ravage.core.other.SRDataProcessors;
import com.teamabnormals.savage_and_ravage.core.other.tags.SREntityTypeTags;
import com.teamabnormals.savage_and_ravage.core.other.tags.SRItemTags;
import com.teamabnormals.savage_and_ravage.core.registry.SRAttributes;
import com.teamabnormals.savage_and_ravage.core.registry.SRBlocks;
import com.teamabnormals.savage_and_ravage.core.registry.SREntityTypes;
import com.teamabnormals.savage_and_ravage.core.registry.SRItems;
import com.teamabnormals.savage_and_ravage.core.registry.SRMobEffects;
import com.teamabnormals.savage_and_ravage.core.registry.SRParticleTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="savage_and_ravage")
public class SREvents {
    public static String POOF_KEY = "minecraft:poof";
    public static String NO_KNOCKBACK_KEY = "savage_and_ravageno_knockback";
    private static final String POISON_TAG = "savage_and_ravagepoison_potato_applied";

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (mob instanceof AbstractVillager) {
                AbstractVillager villager = (AbstractVillager)mob;
                villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, SkeletonVillager.class, 8.0f, 0.6, 0.6));
                villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, Griefer.class, 8.0f, 0.8, 0.8));
                villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, Iceologer.class, 8.0f, 0.8, 0.8));
                villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, Executioner.class, 8.0f, 0.8, 0.8));
                villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, Trickster.class, 8.0f, 0.8, 0.8));
                villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, Creepie.class, 8.0f, 0.8, 0.8, e -> {
                    Creepie creepie = (Creepie)e;
                    return creepie.getOwnerId() == null || creepie.getOwner() instanceof Griefer;
                }));
            } else if (mob instanceof Pillager) {
                Pillager pillager = (Pillager)mob;
                mob.f_21345_.f_25345_.stream().map(it -> it.f_25994_).filter(it -> it instanceof RangedCrossbowAttackGoal).findFirst().ifPresent(goal -> {
                    mob.f_21345_.m_25363_(goal);
                    mob.f_21345_.m_25352_(3, new ImprovedCrossbowGoal<Pillager>(pillager, 1.0, 8.0f, 5.0));
                });
                mob.f_21345_.m_25352_(5, (Goal)new CelebrateTargetBlockHitGoal((Raider)pillager));
            } else if (mob instanceof Cat || mob instanceof Ocelot) {
                mob.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal(mob, Creepie.class, false));
            } else if (mob instanceof Evoker && ((Boolean)SRConfig.COMMON.evokersUseTotems.get()).booleanValue()) {
                mob.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal<IronGolem>((PathfinderMob)((Evoker)mob), IronGolem.class, 8.0f, 0.6, 1.0){

                    public boolean m_8036_() {
                        return (Boolean)SRConfig.COMMON.evokersUseTotems.get() != false && (Integer)TrackedDataManager.INSTANCE.getValue((Entity)this.f_25015_, SRDataProcessors.TOTEM_SHIELD_TIME) > 0 && super.m_8036_();
                    }
                });
            } else if (mob instanceof Vex && ((Boolean)SRConfig.COMMON.reducedVexHealth.get()).booleanValue()) {
                AttributeInstance maxHealth = mob.m_21051_(Attributes.f_22276_);
                if (maxHealth != null) {
                    maxHealth.m_22100_(2.0);
                }
                if (mob.m_21223_() > mob.m_21233_()) {
                    mob.m_21153_(mob.m_21233_());
                }
            }
            if (!((Boolean)SRConfig.COMMON.creeperExplosionsDestroyBlocks.get()).booleanValue()) {
                if (mob instanceof IronGolem) {
                    mob.f_21346_.f_25345_.stream().map(it -> it.f_25994_).filter(it -> it instanceof NearestAttackableTargetGoal).findFirst().ifPresent(goal -> {
                        mob.f_21346_.m_25363_(goal);
                        mob.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal(mob, Mob.class, 5, false, false, e -> e instanceof Enemy));
                    });
                } else if (mob.m_6095_() == EntityType.f_20558_) {
                    mob.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal(mob, IronGolem.class, true));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        Entity target = event.getTarget();
        ItemStack stack = event.getItemStack();
        if (target instanceof Creepie && stack.m_41720_() == Items.f_42675_ && ((Boolean)SRConfig.COMMON.poisonPotatoCompat.get()).booleanValue() && ModList.get().isLoaded("quark")) {
            Player player = event.getEntity();
            CompoundTag persistentData = target.getPersistentData();
            if (!persistentData.m_128471_(POISON_TAG)) {
                if (target.f_19853_.f_46441_.m_188500_() < (Double)SRConfig.COMMON.poisonPotatoChance.get()) {
                    target.m_5496_(SoundEvents.f_11912_, 0.5f, 0.25f);
                    persistentData.m_128379_(POISON_TAG, true);
                    if (((Boolean)SRConfig.COMMON.poisonPotatoEffect.get()).booleanValue()) {
                        ((LivingEntity)target).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200));
                    }
                } else {
                    target.m_5496_(SoundEvents.f_11912_, 0.5f, 0.5f + target.f_19853_.f_46441_.m_188501_() / 2.0f);
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                event.setCancellationResult(InteractionResult.m_19078_((boolean)event.getLevel().m_5776_()));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onUpdateEntity(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Creepie) {
            Creepie creepie = (Creepie)entity;
            if (((Boolean)SRConfig.COMMON.poisonPotatoCompat.get()).booleanValue() && ModList.get().isLoaded("quark") && entity.getPersistentData().m_128471_(POISON_TAG)) {
                creepie.setGrowingAge(-24000);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_21124_((MobEffect)SRMobEffects.WEIGHT.get()) != null) {
            entity.m_20334_(entity.m_20184_().m_7096_(), 0.0, entity.m_20184_().m_7094_());
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        LivingEntity entity = event.getEntity();
        LivingEntity target = event.getTarget();
        if (target != null) {
            if (entity instanceof AbstractGolem && !(entity instanceof Shulker) && target instanceof OwnableMob && ((OwnableMob)target).getOwner() instanceof Player && ((Mob)target).m_5448_() != entity) {
                ((AbstractGolem)entity).m_6710_(null);
            }
            if (entity instanceof Evoker && ((Boolean)SRConfig.COMMON.evokersUseTotems.get()).booleanValue() && (Integer)TrackedDataManager.INSTANCE.getValue((Entity)entity, SRDataProcessors.TOTEM_SHIELD_TIME) > 0) {
                ((Evoker)entity).m_6710_(null);
            }
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        boolean isCreepie;
        Level world = event.getLevel();
        Explosion explosion = event.getExplosion();
        LivingEntity sourceEntity = explosion.m_46079_();
        boolean isCreeper = sourceEntity != null && sourceEntity.m_6095_() == EntityType.f_20558_;
        boolean bl = isCreepie = sourceEntity != null && sourceEntity.m_6095_() == SREntityTypes.CREEPIE.get();
        if (isCreeper) {
            if (!((Boolean)SRConfig.COMMON.creeperExplosionsDestroyBlocks.get()).booleanValue()) {
                event.getAffectedBlocks().clear();
            }
            if (((Boolean)SRConfig.COMMON.creeperExplosionsSpawnCreepies.get()).booleanValue()) {
                Creeper creeper = (Creeper)explosion.m_46079_();
                SporeCloud spores = (SporeCloud)((EntityType)SREntityTypes.SPORE_CLOUD.get()).m_20615_(world);
                if (spores == null) {
                    return;
                }
                spores.setSpawnCloudInstantly(true);
                spores.creepiesAttackPlayersOnly(true);
                if (creeper.m_7090_()) {
                    spores.setCharged(true);
                }
                spores.setCloudSize((int)(creeper.m_21223_() / creeper.m_21233_()) * (creeper.m_7090_() ? 10 : 4));
                spores.m_20359_((Entity)creeper);
                creeper.f_19853_.m_7967_((Entity)spores);
            }
        }
        if (explosion.getExploder() != null && explosion.getExploder().m_6095_() == SREntityTypes.SPORE_BOMB.get()) {
            for (BlockPos pos : event.getAffectedBlocks()) {
                if (world.m_8055_(pos).m_60734_() != SRBlocks.SPORE_BOMB.get()) continue;
                world.m_7471_(pos, false);
                SporeBomb sporebomb = new SporeBomb(world, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, explosion.m_46079_());
                sporebomb.m_32085_((short)(world.m_213780_().m_188503_(sporebomb.m_32100_() / 4) + sporebomb.m_32100_() / 8));
                world.m_7967_((Entity)sporebomb);
            }
        }
        ArrayList<Entity> safeItems = new ArrayList<Entity>();
        for (Entity entity : event.getAffectedEntities()) {
            boolean bl2 = isCreeper ? !((Boolean)SRConfig.COMMON.creeperExplosionsDestroyBlocks.get()).booleanValue() : isCreepie && (Boolean)SRConfig.COMMON.creepieExplosionsDestroyBlocks.get() == false;
            if (!SREvents.entitySafeFromExplosion(entity, bl2)) continue;
            safeItems.add(entity);
        }
        event.getAffectedEntities().removeAll(safeItems);
    }

    public static boolean entitySafeFromExplosion(Entity entity, boolean creeperTypeNoGriefing) {
        if (creeperTypeNoGriefing && entity.m_6095_().m_204039_(SREntityTypeTags.CREEPER_IMMUNE)) {
            return true;
        }
        if (entity instanceof ItemEntity) {
            ItemStack stack = ((ItemEntity)entity).m_32055_();
            return creeperTypeNoGriefing || stack.m_204117_(SRItemTags.EXPLOSION_IMMUNE);
        }
        return false;
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        ItemStack mainHandStack;
        Player player = event.getEntity();
        Entity target = event.getTarget();
        Level world = player.f_19853_;
        if (target instanceof LivingEntity && (mainHandStack = player.m_21205_()).m_41720_() == SRItems.CLEAVER_OF_BEHEADING.get()) {
            boolean shouldCrit;
            float attackDamage = (float)player.m_21133_(Attributes.f_22281_);
            float knockback = (float)player.m_21133_(Attributes.f_22282_);
            knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)player);
            float enchantDamageBonus = EnchantmentHelper.m_44833_((ItemStack)player.m_21205_(), (MobType)((LivingEntity)target).m_6336_());
            float attackStrength = player.m_36403_(0.5f);
            enchantDamageBonus *= attackStrength;
            if (((attackDamage *= 0.2f + attackStrength * attackStrength * 0.8f) > 0.0f || enchantDamageBonus > 0.0f) && attackStrength > 0.9f && !player.m_20142_() && player.m_20096_() && (double)(player.f_19787_ - player.f_19867_) < (double)player.m_6113_() && ForgeHooks.getCriticalHit((Player)player, (Entity)target, (boolean)(shouldCrit = player.f_19789_ > 0.0f && !player.m_20096_() && !player.m_6147_() && !player.m_20069_() && !player.m_21023_(MobEffects.f_19610_) && !player.m_20159_()), (float)(shouldCrit ? 1.5f : 1.0f)) == null) {
                target.getPersistentData().m_128379_(NO_KNOCKBACK_KEY, true);
                AABB targetBox = target.m_20191_().m_82377_(1.5, 0.25, 1.5);
                AABB shockwaveBox = new AABB(targetBox.f_82288_, targetBox.f_82289_, targetBox.f_82290_, targetBox.f_82291_, targetBox.f_82289_ + 3.25, targetBox.f_82293_);
                for (LivingEntity pushed : world.m_45976_(LivingEntity.class, shockwaveBox)) {
                    if (pushed == player || pushed == target || player.m_7307_((Entity)pushed) || pushed instanceof ArmorStand && ((ArmorStand)pushed).m_31677_()) continue;
                    pushed.m_147240_((double)(0.4f + knockback * 0.5f), (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
                    if (!pushed.m_5801_() || pushed.m_21023_(MobEffects.f_19597_)) continue;
                    pushed.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 2));
                }
                BlockPos.MutableBlockPos checkingPos = new BlockPos.MutableBlockPos();
                RandomSource random = world.m_213780_();
                if (!world.f_46443_) {
                    block1: for (int i = 0; i < 100; ++i) {
                        int minY;
                        double x = shockwaveBox.f_82288_ + random.m_188500_() * (shockwaveBox.f_82291_ - shockwaveBox.f_82288_);
                        double z = shockwaveBox.f_82290_ + random.m_188500_() * (shockwaveBox.f_82293_ - shockwaveBox.f_82290_);
                        for (int y = minY = Mth.m_14107_((double)shockwaveBox.f_82289_); y < Mth.m_14107_((double)shockwaveBox.f_82292_); ++y) {
                            checkingPos.m_122178_(Mth.m_14107_((double)x), Mth.m_14143_((float)y), Mth.m_14107_((double)z));
                            if (SREvents.isEmptySpace((BlockGetter)world, (BlockPos)checkingPos)) continue;
                            checkingPos.m_122173_(Direction.UP);
                            if (!SREvents.isEmptySpace((BlockGetter)world, (BlockPos)checkingPos)) continue;
                            checkingPos.m_122173_(Direction.DOWN);
                            BlockState state = world.m_8055_((BlockPos)checkingPos);
                            ((ServerLevel)world).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state).setPos((BlockPos)checkingPos), x, (double)y + state.m_60808_((BlockGetter)world, (BlockPos)checkingPos).m_83297_(Direction.Axis.Y), z, 0, 0.0, 0.0, 0.0, 0.15);
                            continue block1;
                        }
                    }
                    double xAngle = -Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180)));
                    double zAngle = Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)));
                    ((ServerLevel)world).m_8767_((ParticleOptions)((SimpleParticleType)SRParticleTypes.CLEAVER_SWEEP.get()), player.m_20185_() + xAngle, player.m_20227_(0.5), player.m_20189_() + zAngle, 0, xAngle, 0.0, zAngle, 0.0);
                }
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
            }
        }
    }

    public static boolean isEmptySpace(BlockGetter world, BlockPos pos) {
        return world.m_8055_(pos).m_60795_() || !world.m_6425_(pos).m_76178_();
    }

    @SubscribeEvent
    public static void onLivingKnockback(LivingKnockBackEvent event) {
        if (event.getEntity().getPersistentData().m_128471_(NO_KNOCKBACK_KEY)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Evoker && ((Boolean)SRConfig.COMMON.evokersUseTotems.get()).booleanValue() && (Integer)TrackedDataManager.INSTANCE.getValue((Entity)entity, SRDataProcessors.TOTEM_SHIELD_TIME) > 0 && event.getSource().m_7640_() instanceof Projectile) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity target = event.getEntity();
        if (event.getSource().m_19372_()) {
            double decrease = 0.0;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack = target.m_6844_(slot);
                Collection modifiers = stack.m_41638_(slot).get((Object)((Attribute)SRAttributes.EXPLOSIVE_DAMAGE_REDUCTION.get()));
                if (modifiers.isEmpty()) continue;
                decrease += modifiers.stream().mapToDouble(AttributeModifier::m_22218_).sum();
                stack.m_41622_(22 - EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44968_, (ItemStack)stack) * 8, target, onBroken -> onBroken.m_21166_(slot));
            }
            if (decrease != 0.0) {
                event.setAmount(event.getAmount() - (float)((double)event.getAmount() * decrease));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDamageDelayed(LivingDamageEvent event) {
        Player targetPlayer;
        LivingEntity target = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        if (attacker instanceof LivingEntity && ((LivingEntity)attacker).m_21205_().m_41720_() == SRItems.CLEAVER_OF_BEHEADING.get() && target instanceof Player && (targetPlayer = (Player)event.getEntity()) != null && targetPlayer.m_21223_() - event.getAmount() <= 0.0f) {
            ItemStack stack = new ItemStack((ItemLike)Items.f_42680_);
            stack.m_41700_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)targetPlayer.m_36316_()));
            target.m_19983_(stack);
        }
        if (target instanceof Evoker && ((Boolean)SRConfig.COMMON.evokersUseTotems.get()).booleanValue()) {
            IDataManager data = (IDataManager)target;
            if (target.m_21223_() - event.getAmount() <= 0.0f && event.getSource().m_7640_() instanceof Projectile && (Integer)data.getValue(SRDataProcessors.TOTEM_SHIELD_TIME) <= 0 && (Integer)data.getValue(SRDataProcessors.TOTEM_SHIELD_COOLDOWN) <= 0) {
                event.setCanceled(true);
                target.m_21153_(2.0f);
                data.setValue(SRDataProcessors.TOTEM_SHIELD_TIME, (Object)600);
                if (!target.f_19853_.m_5776_()) {
                    target.f_19853_.m_7605_((Entity)target, (byte)35);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        HitResult result = event.getRayTraceResult();
        if (result instanceof BlockHitResult) {
            IDataManager data;
            UUID id;
            BlockHitResult blockResult = (BlockHitResult)result;
            Entity entity = event.getEntity();
            if (entity.f_19853_.m_8055_(blockResult.m_82425_()).m_60713_(Blocks.f_50716_) && !entity.f_19853_.m_5776_() && (id = (UUID)((Optional)(data = (IDataManager)entity).getValue(SRDataProcessors.CROSSBOW_OWNER)).orElse(null)) != null) {
                Entity crossbowOwner = ((ServerLevel)entity.f_19853_).m_8791_(id);
                if (crossbowOwner instanceof Raider) {
                    TrackedDataManager.INSTANCE.setValue(crossbowOwner, SRDataProcessors.TARGET_HIT, (Object)true);
                }
                data.setValue(SRDataProcessors.CROSSBOW_OWNER, Optional.empty());
            }
        }
    }

    @SubscribeEvent
    public static void onInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        Entity target = event.getTarget();
        if ((target.m_6095_() == EntityType.f_20558_ || target.m_6095_() == SREntityTypes.CREEPIE.get()) && stack.m_41720_() == Items.f_42555_) {
            Level world = event.getLevel();
            Creepie creepie = (Creepie)((EntityType)SREntityTypes.CREEPIE.get()).m_20615_(world);
            if (creepie != null) {
                creepie.m_20359_(target);
                if (stack.m_41788_()) {
                    creepie.m_6593_(stack.m_41786_());
                }
                if (!event.getEntity().m_7500_()) {
                    stack.m_41774_(1);
                }
                creepie.attackPlayersOnly = true;
                world.m_7967_((Entity)creepie);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)world.m_5776_()));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos;
        Level world = event.getLevel();
        if (world.m_8055_(pos = event.getPos()).m_60734_() instanceof AbstractBannerBlock) {
            List burningBanners = world.m_45976_(BurningBanner.class, new AABB(pos));
            for (BurningBanner burningBanner : burningBanners) {
                if (burningBanner.getBannerPosition() == null || !burningBanner.getBannerPosition().equals((Object)pos)) continue;
                burningBanner.extinguishFire();
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        boolean isFlintAndSteel;
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        Level world = event.getLevel();
        if (stack.m_41720_() instanceof PottableItem && world.m_8055_(pos).m_60734_() == Blocks.f_50276_) {
            BlockState pottedState = ((PottableItem)stack.m_41720_()).getPottedState(player.m_6350_().m_122424_());
            if (pottedState == null) {
                return;
            }
            world.m_46597_(pos, pottedState);
            player.m_36220_(Stats.f_12961_);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        } else if (SREvents.isValidBurningBannerPos(world, pos) && ((isFlintAndSteel = stack.m_41720_() instanceof FlintAndSteelItem) || stack.m_41720_() instanceof FireChargeItem)) {
            SoundEvent sound = isFlintAndSteel ? SoundEvents.f_11942_ : SoundEvents.f_11874_;
            float pitch = isFlintAndSteel ? new Random().nextFloat() * 0.4f + 0.8f : (new Random().nextFloat() - new Random().nextFloat()) * 0.2f + 1.0f;
            world.m_5594_(player, pos, sound, SoundSource.BLOCKS, 1.0f, pitch);
            if (isFlintAndSteel) {
                stack.m_41622_(1, (LivingEntity)player, p_219998_1_ -> p_219998_1_.m_21190_(event.getHand()));
            } else if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            world.m_7967_((Entity)new BurningBanner(world, pos, player));
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void livingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        Level world = entity.f_19853_;
        IDataManager data = (IDataManager)entity;
        if (!world.m_5776_()) {
            boolean invisibleDueToMask;
            boolean canBeInvisible;
            boolean maskStateChanged;
            int celebrationTime;
            CompoundTag persistentData = entity.getPersistentData();
            if (persistentData.m_128471_(NO_KNOCKBACK_KEY)) {
                persistentData.m_128379_(NO_KNOCKBACK_KEY, false);
            }
            if (entity instanceof Raider && (celebrationTime = ((Integer)data.getValue(SRDataProcessors.CELEBRATION_TIME)).intValue()) > 0) {
                data.setValue(SRDataProcessors.CELEBRATION_TIME, (Object)(celebrationTime - 1));
            }
            boolean bl = maskStateChanged = (canBeInvisible = SREvents.maskCanMakeInvisible(entity)) != (invisibleDueToMask = ((Boolean)data.getValue(SRDataProcessors.INVISIBLE_DUE_TO_MASK)).booleanValue());
            if (maskStateChanged) {
                data.setValue(SRDataProcessors.INVISIBLE_DUE_TO_MASK, (Object)canBeInvisible);
                SREvents.spawnMaskParticles(world, entity.m_20191_(), 3);
            }
            if (maskStateChanged || canBeInvisible && !entity.m_20145_()) {
                entity.m_6842_(canBeInvisible || entity.m_21023_(MobEffects.f_19609_));
            }
        }
        if (entity instanceof Evoker) {
            int shieldTime = (Integer)data.getValue(SRDataProcessors.TOTEM_SHIELD_TIME);
            if (shieldTime > 0) {
                data.setValue(SRDataProcessors.TOTEM_SHIELD_TIME, (Object)(shieldTime - 1));
            } else if (shieldTime == 0) {
                data.setValue(SRDataProcessors.TOTEM_SHIELD_COOLDOWN, (Object)1800);
                data.setValue(SRDataProcessors.TOTEM_SHIELD_TIME, (Object)-1);
            }
            int cooldown = (Integer)data.getValue(SRDataProcessors.TOTEM_SHIELD_COOLDOWN);
            if (cooldown > 0) {
                data.setValue(SRDataProcessors.TOTEM_SHIELD_COOLDOWN, (Object)(cooldown - 1));
            }
        }
    }

    @SubscribeEvent
    public static void visibilityMultiplierEvent(LivingEvent.LivingVisibilityEvent event) {
        LivingEntity entity = event.getEntity();
        if (((Boolean)TrackedDataManager.INSTANCE.getValue((Entity)entity, SRDataProcessors.INVISIBLE_DUE_TO_MASK)).booleanValue()) {
            double armorCover = entity.m_21207_();
            if (armorCover < (double)0.1f) {
                armorCover = 0.1f;
            }
            event.modifyVisibility(1.0 / armorCover);
            event.modifyVisibility(0.1);
        }
    }

    private static boolean maskCanMakeInvisible(LivingEntity entity) {
        if (entity.m_6844_(EquipmentSlot.HEAD).m_41720_() == SRItems.MASK_OF_DISHONESTY.get()) {
            return entity.m_6047_();
        }
        return false;
    }

    public static void spawnMaskParticles(Level world, AABB box, int loops) {
        if (!world.f_46443_) {
            RandomSource random = world.m_213780_();
            for (int i = 0; i < loops; ++i) {
                double x = box.m_82340_(Direction.Axis.X) + (double)random.m_188501_() * box.m_82362_();
                double y = box.m_82340_(Direction.Axis.Y) + (double)random.m_188501_() * box.m_82376_();
                double z = box.m_82340_(Direction.Axis.Z) + (double)random.m_188501_() * box.m_82385_();
                NetworkUtil.spawnParticle((String)POOF_KEY, (ResourceKey)world.m_46472_(), (double)x, (double)y, (double)z, (double)0.0, (double)0.0, (double)0.0);
            }
        }
    }

    public static boolean isValidBurningBannerPos(Level world, BlockPos pos) {
        if (world.m_8055_(pos).m_60734_() instanceof AbstractBannerBlock) {
            List banners = world.m_45976_(BurningBanner.class, new AABB(pos));
            boolean noBurningBanners = true;
            for (BurningBanner banner : banners) {
                if (banner.getBannerPosition() == null || !banner.getBannerPosition().equals((Object)pos)) continue;
                noBurningBanners = false;
            }
            return noBurningBanners;
        }
        return false;
    }

    public static ItemStack createRocket(RandomSource random) {
        ItemStack rocket = new ItemStack((ItemLike)Items.f_42688_, random.m_188503_(16) + 1);
        CompoundTag fireworks = rocket.m_41698_("Fireworks");
        ListTag explosions = new ListTag();
        CompoundTag explosion = new CompoundTag();
        fireworks.m_128365_("Explosions", (Tag)explosions);
        explosions.add((Object)explosion);
        explosion.m_128385_("Colors", SREvents.randomColors(random));
        if (random.m_188503_(2) == 0) {
            explosion.m_128385_("FadeColors", SREvents.randomColors(random));
        }
        if (random.m_188503_(2) == 0) {
            explosion.m_128379_("Flicker", true);
        }
        if (random.m_188503_(2) == 0) {
            explosion.m_128379_("Trail", true);
        }
        FireworkRocketItem.Shape[] values = FireworkRocketItem.Shape.values();
        explosion.m_128405_("Type", values[random.m_188503_(values.length)].m_41236_());
        fireworks.m_128405_("Flight", random.m_188503_(3) + 1);
        return rocket;
    }

    public static int[] randomColors(RandomSource random) {
        int[] colors = new int[random.m_188503_(3) + 1];
        DyeColor[] values = DyeColor.values();
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = values[random.m_188503_(values.length)].m_41070_();
        }
        return colors;
    }
}

