/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.common.entity.monster;

import com.teamabnormals.savage_and_ravage.common.entity.monster.Creepie;
import com.teamabnormals.savage_and_ravage.common.entity.projectile.SporeCloud;
import com.teamabnormals.savage_and_ravage.common.item.CreeperSporesItem;
import com.teamabnormals.savage_and_ravage.core.registry.SRItems;
import com.teamabnormals.savage_and_ravage.core.registry.SRSounds;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.phys.HitResult;

public class Griefer
extends AbstractIllager
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> KICKING = SynchedEntityData.m_135353_(Griefer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> APESHIT_MODE = SynchedEntityData.m_135353_(Griefer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final TargetingConditions distance = TargetingConditions.m_148352_().m_26883_(10.0);
    public int creeperSporeStacks;
    public int kickTicks;
    public int kickCoolDown;

    public Griefer(EntityType<? extends Griefer> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(2, (Goal)new KickGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new MeleePhaseGoal(this, 0.9, true));
        this.f_21345_.m_25352_(3, (Goal)new AttackWithSporesGoal(this, 0.9, 200));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true){

            public boolean m_8036_() {
                return !(this.f_25540_.m_21205_().m_41720_() instanceof CreeperSporesItem) && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(KICKING, (Object)false);
        this.f_19804_.m_135372_(APESHIT_MODE, (Object)false);
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        return this.m_37888_() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12307_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12309_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12310_;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)SRItems.GRIEFER_SPAWN_EGG.get());
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12308_;
    }

    public void m_8107_() {
        if (this.kickTicks > 0) {
            --this.kickTicks;
        }
        if (this.kickCoolDown > 0) {
            --this.kickCoolDown;
        }
        super.m_8107_();
    }

    public boolean m_7327_(Entity entityIn) {
        if (this.isKicking()) {
            ((LivingEntity)entityIn).m_147240_(1.5, (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
            this.kickTicks = 10;
            this.f_19853_.m_7605_((Entity)this, (byte)4);
            this.m_21391_(entityIn, 90.0f, 90.0f);
        }
        return super.m_7327_(entityIn);
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.kickTicks = 10;
        } else {
            super.m_7822_(id);
        }
    }

    protected void m_6475_(DamageSource damageSrc, float damageAmount) {
        super.m_6475_(damageSrc, damageAmount);
        if (this.isApeshit() && this.creeperSporeStacks <= 0 && damageSrc.m_7639_() == this.m_5448_() && this.m_5448_() != null) {
            this.creeperSporeStacks = Mth.m_14167_((float)(this.f_20898_ / 2.0f));
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.kickTicks = compound.m_128451_("KickTicks");
        this.creeperSporeStacks = compound.m_128451_("CreeperSporeStacks");
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("KickTicks", this.kickTicks);
        compound.m_128405_("CreeperSporeStacks", this.creeperSporeStacks);
    }

    public int getKickTicks() {
        return this.kickTicks;
    }

    public void kick(LivingEntity entity) {
        this.setKicking(true);
        this.m_7327_((Entity)entity);
        this.kickCoolDown = 30;
    }

    public boolean isKicking() {
        return (Boolean)this.f_19804_.m_135370_(KICKING);
    }

    public boolean isApeshit() {
        return (Boolean)this.f_19804_.m_135370_(APESHIT_MODE);
    }

    public void setKicking(boolean shouldSetKicking) {
        this.f_19804_.m_135381_(KICKING, (Object)shouldSetKicking);
    }

    public void becomeApeshit(boolean shouldBecomeApeshit) {
        this.f_19804_.m_135381_(APESHIT_MODE, (Object)shouldBecomeApeshit);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.populateDefaultEquipmentSlots(difficultyIn);
        this.creeperSporeStacks = 3 + this.f_19796_.m_188503_(3);
        return spawnDataIn;
    }

    protected void populateDefaultEquipmentSlots(DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)SRItems.CREEPER_SPORES.get()));
        this.giveArmorOnRandom(EquipmentSlot.HEAD, new ItemStack((ItemLike)SRItems.GRIEFER_HELMET.get()));
        this.giveArmorOnRandom(EquipmentSlot.CHEST, new ItemStack((ItemLike)SRItems.GRIEFER_CHESTPLATE.get()));
        this.giveArmorOnRandom(EquipmentSlot.LEGS, new ItemStack((ItemLike)SRItems.GRIEFER_LEGGINGS.get()));
        this.giveArmorOnRandom(EquipmentSlot.FEET, new ItemStack((ItemLike)SRItems.GRIEFER_BOOTS.get()));
    }

    private void giveArmorOnRandom(EquipmentSlot slot, ItemStack stack) {
        float chance;
        ItemStack itemstack = this.m_6844_(slot);
        float f = chance = this.m_33067_() ? 1.0f : 0.1f;
        if (itemstack.m_41619_() && this.f_19796_.m_188501_() < chance) {
            this.m_8061_(slot, stack);
        }
    }

    public void m_7895_(int arg0, boolean arg1) {
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (this.f_19853_.m_45971_(Creepie.class, this.distance, (LivingEntity)this, this.m_20191_().m_82377_(10.0, 4.0, 10.0)).size() < 5 && this.m_21205_().m_41720_() instanceof CreeperSporesItem) {
            SporeCloud creeperSpores = new SporeCloud(this.f_19853_, (LivingEntity)this);
            double distance = target.m_20186_() - 1.0;
            double d1 = target.m_20185_() - this.m_20185_();
            double d2 = distance - creeperSpores.m_20186_();
            double d3 = target.m_20189_() - this.m_20189_();
            float f = Mth.m_14116_((float)((float)(d1 * d1 + d3 * d3))) * 0.2f;
            creeperSpores.m_6686_(d1, d2 + (double)f, d3, 1.6f, 12.0f);
            creeperSpores.setCloudSize(creeperSpores.f_19853_.f_46441_.m_188503_(50) == 0 ? 0 : 1 + creeperSpores.f_19853_.f_46441_.m_188503_(3));
            this.m_6674_(this.m_7655_());
            this.m_5496_((SoundEvent)SRSounds.ENTITY_CREEPER_SPORES_THROW.get(), 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            this.f_19853_.m_7967_((Entity)creeperSpores);
            this.m_21391_((Entity)target, 30.0f, 30.0f);
            --this.creeperSporeStacks;
        }
    }

    public static class KickGoal
    extends Goal {
        private final Griefer griefer;

        public KickGoal(Griefer griefer) {
            this.griefer = griefer;
        }

        public boolean m_8036_() {
            LivingEntity entity = this.griefer.m_5448_();
            return this.griefer.m_5448_() != null && entity != null && (double)entity.m_20270_((Entity)this.griefer) <= 2.5 && !this.griefer.isKicking() && this.griefer.kickTicks <= 0 && this.griefer.kickCoolDown == 0 && this.griefer.creeperSporeStacks > 0;
        }

        public void m_8056_() {
            LivingEntity entity = this.griefer.m_5448_();
            if (entity != null) {
                this.griefer.kick(entity);
            }
        }

        public void m_8041_() {
            this.griefer.kickTicks = 0;
            this.griefer.setKicking(false);
        }
    }

    public static class MeleePhaseGoal
    extends MeleeAttackGoal {
        private final Griefer griefer;

        public MeleePhaseGoal(Griefer griefer, double speedIn, boolean useLongMemory) {
            super((PathfinderMob)griefer, speedIn, useLongMemory);
            this.griefer = griefer;
        }

        public boolean m_8036_() {
            return this.griefer.creeperSporeStacks == 0 && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.griefer.creeperSporeStacks == 0 && super.m_8045_();
        }

        public void m_8056_() {
            this.griefer.becomeApeshit(true);
            if (this.griefer.creeperSporeStacks == 0) {
                this.griefer.m_21008_(this.griefer.m_7655_(), ItemStack.f_41583_);
            }
            super.m_8056_();
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double distance = this.m_6639_(enemy);
            int i = this.griefer.f_19853_.f_46441_.m_188503_(3);
            if (distToEnemySqr <= distance && this.f_25548_ <= 0) {
                this.f_25548_ = 60;
                switch (i) {
                    case 0: {
                        this.griefer.m_6674_(InteractionHand.MAIN_HAND);
                        break;
                    }
                    case 1: {
                        this.griefer.m_6674_(InteractionHand.OFF_HAND);
                        break;
                    }
                    case 2: {
                        this.griefer.kick(enemy);
                    }
                }
                this.griefer.m_21391_((Entity)enemy, 30.0f, 30.0f);
                this.griefer.m_7327_((Entity)enemy);
                enemy.m_147240_(1.5, (double)Mth.m_14031_((float)(this.griefer.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.griefer.m_146908_() * ((float)Math.PI / 180)))));
            }
        }
    }

    public static class AttackWithSporesGoal
    extends Goal {
        private final Griefer griefer;
        private int rangedAttackTime = -1;
        private final double entityMoveSpeed;
        private final int attackIntervalMin;
        private final int maxRangedAttackTime;
        private final float attackRadius;
        private boolean strafingClockwise;
        private int seeTime;
        private int strafeTime;

        public AttackWithSporesGoal(Griefer attacker, double moveSpeed, int maxAttackTime) {
            this(attacker, moveSpeed, maxAttackTime, maxAttackTime);
        }

        public AttackWithSporesGoal(Griefer attacker, double moveSpeed, int p_i1650_4_, int maxAttackTime) {
            this.griefer = attacker;
            this.entityMoveSpeed = moveSpeed;
            this.attackIntervalMin = p_i1650_4_;
            this.maxRangedAttackTime = maxAttackTime;
            this.attackRadius = 15.0f;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.griefer.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.griefer.creeperSporeStacks > 0;
        }

        public boolean m_8045_() {
            return this.m_8036_() || !this.griefer.m_21573_().m_26571_();
        }

        public void m_8056_() {
            if (this.griefer.isApeshit()) {
                this.griefer.becomeApeshit(false);
            }
            if (this.griefer.creeperSporeStacks > 0) {
                this.griefer.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)SRItems.CREEPER_SPORES.get()));
            }
        }

        public void m_8041_() {
            this.griefer.m_21561_(false);
            this.griefer.m_6710_(null);
            this.griefer.m_21573_();
            this.rangedAttackTime = -1;
            if (this.griefer.isKicking()) {
                this.griefer.setKicking(false);
            }
        }

        private boolean isWalkable() {
            PathNavigation pathnavigator = this.griefer.m_21573_();
            NodeEvaluator nodeprocessor = pathnavigator.m_26575_();
            return nodeprocessor.m_8086_((BlockGetter)this.griefer.f_19853_, Mth.m_14107_((double)(this.griefer.m_20185_() + 1.0)), Mth.m_14107_((double)this.griefer.m_20186_()), Mth.m_14107_((double)(this.griefer.m_20189_() + 1.0))) == BlockPathTypes.WALKABLE;
        }

        public void m_8037_() {
            LivingEntity attackTarget = this.griefer.m_5448_();
            if (attackTarget != null) {
                float distance = this.griefer.m_20270_((Entity)attackTarget);
                boolean canSee = this.griefer.m_21574_().m_148306_((Entity)attackTarget);
                this.griefer.m_21561_(true);
                this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
                if ((double)distance <= 15.0) {
                    this.griefer.m_21573_().m_26573_();
                } else {
                    this.griefer.m_21573_().m_5624_((Entity)attackTarget, this.entityMoveSpeed);
                }
                if (this.griefer.m_217043_().m_188500_() < 0.3 && this.strafeTime <= 0) {
                    boolean bl = this.strafingClockwise = !this.strafingClockwise;
                }
                if (this.strafeTime > 0) {
                    if (this.isWalkable()) {
                        this.griefer.m_21566_().m_24988_(0.0f, (float)(this.strafingClockwise ? this.entityMoveSpeed : -this.entityMoveSpeed));
                    } else {
                        this.griefer.m_21564_(1.0f);
                        this.griefer.m_21570_(0.0f);
                        this.griefer.m_21573_().m_26573_();
                    }
                }
                this.griefer.m_21563_().m_24960_((Entity)attackTarget, 30.0f, 30.0f);
                this.griefer.m_21391_((Entity)attackTarget, 30.0f, 30.0f);
                if (--this.rangedAttackTime == 0 || this.seeTime == 3) {
                    if (!canSee) {
                        return;
                    }
                    float f = Mth.m_14116_((float)distance) / this.attackRadius;
                    float distanceFactor = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                    this.griefer.m_6504_(attackTarget, distanceFactor);
                    this.strafeTime = 50;
                    this.rangedAttackTime = Mth.m_14143_((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
                } else if (this.rangedAttackTime < 0) {
                    float f2 = Mth.m_14116_((float)distance) / this.attackRadius;
                    this.rangedAttackTime = Mth.m_14143_((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
                }
            }
        }
    }
}

