/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.mimic;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class MimicForgeConfig {
    private static final ForgeConfigSpec.Builder server_builder = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec server_config;
    public static ForgeConfigSpec.IntValue mimicSpawnChance;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> healthBarBlacklist;

    public static boolean shouldHaveNoHealthbar(Entity entity) {
        if (entity == null) {
            return false;
        }
        EntityType type = entity.m_6095_();
        if (type == null) {
            return false;
        }
        ResourceLocation registryName = ForgeRegistries.ENTITY_TYPES.getKey((Object)type);
        if (registryName == null) {
            return false;
        }
        String name = registryName.toString();
        for (String check : (List)healthBarBlacklist.get()) {
            if (!name.equals(check)) continue;
            return true;
        }
        return false;
    }

    public static void loadConfig() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)server_config);
        String path = FMLPaths.CONFIGDIR.get().resolve("mimic-server.toml").toString();
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        server_config.setConfig((CommentedConfig)file);
    }

    static {
        mimicSpawnChance = server_builder.comment("When a chest is generated in a supported structure it will have a 1/x chance of being a mimic. Higher value means fewer mimics. A value of 1 means always a mimic.").defineInRange("mimicSpawnChance", 5, 1, Integer.MAX_VALUE);
        healthBarBlacklist = server_builder.comment(new String[]{"S: registry names of entities that should not have a displayed ToroHealth bar (ex. [\"minecraft:wither\", \"minecraft:villager\"]).", "Mimics are hard coded and will included while stealthed regardless of the list", "Since this is in the server config, all clients will be effected. Nothing will happen if ToroHealth is not installed"}).defineList("healthBarBlacklist", Collections.emptyList(), i -> ((String)i).split(":").length == 2);
        server_config = server_builder.build();
    }
}

