/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lava_monster.entity;

import com.legacy.lava_monster.LavaMonsterConfig;
import com.legacy.lava_monster.entity.LavaMonsterAttackGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.Tags;

public class LavaMonsterEntity
extends Monster
implements RangedAttackMob {
    public int attackDelay = 0;
    private boolean textureInc = true;
    private byte textureTicks = 0;
    private byte textureIndex = 0;

    public LavaMonsterEntity(EntityType<? extends LavaMonsterEntity> type, Level world) {
        super(type, world);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.OPEN, 0.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, SnowGolem.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new LavaMonsterAttackGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        this.m_21051_(Attributes.f_22276_).m_22100_((double)LavaMonsterConfig.monsterHealth);
        this.m_21051_(Attributes.f_22284_).m_22100_(LavaMonsterConfig.monsterArmor);
        this.m_21153_(LavaMonsterConfig.monsterHealth);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static boolean getVanillaSpawnConditions(EntityType<LavaMonsterEntity> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource rand) {
        BlockPos.MutableBlockPos blockpos$mutable = pos.m_122032_();
        do {
            blockpos$mutable.m_122173_(Direction.UP);
        } while (world.m_6425_((BlockPos)blockpos$mutable).m_205070_(FluidTags.f_13132_));
        return world.m_8055_((BlockPos)blockpos$mutable).m_60795_();
    }

    public boolean m_6914_(LevelReader world) {
        return world.m_45784_((Entity)this);
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return 5.0f;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.5f;
    }

    public static AttributeSupplier.Builder registerAttributeMap() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.24f).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 0.0);
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11780_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11920_;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_) {
            this.updateTexture();
        } else {
            if (this.m_20077_()) {
                this.m_20256_(this.m_20184_().m_82542_(1.9, 1.0, 1.9));
            }
            if (this.m_5448_() != null) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 20.0f, 20.0f);
            }
            this.attackDelay = Math.max(0, this.attackDelay - 1);
            if (this.m_20070_()) {
                this.m_6469_(DamageSource.f_19312_, 1.0f);
            }
            BlockPos pos = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20186_()), Mth.m_14107_((double)this.m_20189_()));
            BlockState fire = BaseFireBlock.m_49245_((BlockGetter)this.f_19853_, (BlockPos)pos);
            if (this.f_19853_.m_46859_(pos) && this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_) && this.f_19853_.m_46469_().m_46207_(GameRules.f_46131_) && fire.m_60710_((LevelReader)this.f_19853_, pos)) {
                this.f_19853_.m_7731_(pos, fire, 2);
            }
        }
        if (this.f_19796_.m_188503_(100) == 0) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_() + (double)this.m_20206_() / 2.0, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), 0.0, 0.0, 0.0);
            this.m_5496_(SoundEvents.f_12032_, 0.2f + this.f_19796_.m_188501_() * 0.2f, 0.9f + this.f_19796_.m_188501_() * 0.15f);
        }
        if (this.f_19796_.m_188503_(200) == 0) {
            this.m_5496_(SoundEvents.f_12030_, 0.2f + this.f_19796_.m_188501_() * 0.2f, 0.9f + this.f_19796_.m_188501_() * 0.15f);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_7640_() instanceof Snowball) {
            return super.m_6469_(source, Math.max(3.0f, amount));
        }
        return super.m_6469_(source, amount);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        SmallFireball fireball = new SmallFireball(this.f_19853_, (LivingEntity)this, target.m_20185_() - this.m_20185_(), target.m_20191_().f_82289_ + (double)(target.m_20206_() / 2.0f) - this.m_20186_() - (double)(this.m_20206_() / 2.0f), target.m_20189_() - this.m_20189_());
        fireball.m_6034_(fireball.m_20185_(), this.m_20186_() + (double)this.m_20206_() - 0.5, fireball.m_20189_());
        this.m_5496_(SoundEvents.f_11923_, 1.0f, 1.0f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)fireball);
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        boolean extraChance = worldIn.m_6042_().f_63857_() ? worldIn.m_213780_().m_188501_() < 0.2f : true;
        return extraChance && this.isWhitelistedToDimension() && !worldIn.m_204166_(this.m_20183_()).m_203656_(Tags.Biomes.IS_MUSHROOM);
    }

    public boolean isWhitelistedToDimension() {
        String[] biomeArray = LavaMonsterConfig.dimensionWhitelist.split(",");
        ResourceLocation dimLocation = this.f_19853_.m_46472_().m_135782_();
        boolean isWhitelisted = false;
        if (!isWhitelisted) {
            for (String name : biomeArray) {
                ResourceLocation regName = new ResourceLocation(name);
                if (!dimLocation.toString().matches(regName.toString())) continue;
                isWhitelisted = true;
            }
        }
        return isWhitelisted;
    }

    public void updateTexture() {
        this.textureTicks = (byte)(this.textureTicks + 1);
        if (this.textureTicks < 2) {
            return;
        }
        this.textureTicks = 0;
        this.textureIndex = (byte)(this.textureIndex + (this.textureInc ? 1 : -1));
        if (this.textureIndex < 0) {
            this.textureIndex = 1;
            this.textureInc = true;
        } else if (this.textureIndex > 19) {
            this.textureIndex = (byte)18;
            this.textureInc = false;
        }
    }

    public int getTextureIndex() {
        return this.textureIndex;
    }

    public ItemEntity m_5552_(ItemStack stack, float offsetY) {
        if (stack.m_41619_()) {
            return null;
        }
        if (this.f_19853_.f_46443_) {
            return null;
        }
        ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_() + (double)offsetY, this.m_20189_(), stack);
        itementity.m_32060_();
        itementity.m_20331_(true);
        if (this.captureDrops() != null) {
            this.captureDrops().add(itementity);
        } else {
            this.f_19853_.m_7967_((Entity)itementity);
        }
        return itementity;
    }
}

