/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.message;

import baguchan.enchantwithmob.EnchantWithMob;
import baguchan.enchantwithmob.capability.MobEnchantCapability;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class AncientMobMessage {
    private int entityId;
    private String enchantType;

    public AncientMobMessage(Entity entity, String enchantType) {
        this.entityId = entity.m_19879_();
        this.enchantType = enchantType;
    }

    public AncientMobMessage(int id, String enchantType) {
        this.entityId = id;
        this.enchantType = enchantType;
    }

    public void serialize(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.m_130070_(this.enchantType);
    }

    public static AncientMobMessage deserialize(FriendlyByteBuf buffer) {
        int entityId = buffer.readInt();
        String enchantType = buffer.m_130277_();
        return new AncientMobMessage(entityId, enchantType);
    }

    public static boolean handle(AncientMobMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(message.entityId);
                if (entity != null && entity instanceof LivingEntity) {
                    entity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP, null).ifPresent(enchantCap -> enchantCap.setEnchantType((LivingEntity)entity, MobEnchantCapability.EnchantType.get(message.enchantType)));
                }
            });
        }
        return true;
    }
}

