/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import com.natamus.collective.data.GlobalVariables;
import com.natamus.collective.functions.StringFunctions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;

public class EntityFunctions {
    public static Boolean isHorse(Entity entity) {
        return entity instanceof AbstractHorse;
    }

    public static boolean isModdedVillager(String entitystring) {
        String type = entitystring.split("\\[")[0];
        for (String moddedvillager : GlobalVariables.moddedvillagers) {
            if (!type.equalsIgnoreCase(moddedvillager)) continue;
            return true;
        }
        return false;
    }

    public static boolean isModdedVillager(Entity entity) {
        String entitystring = EntityFunctions.getEntityString(entity);
        return EntityFunctions.isModdedVillager(entitystring);
    }

    public static boolean isMilkable(Entity entity) {
        if (entity instanceof Sheep || entity instanceof Llama || entity instanceof Pig || entity instanceof Donkey || entity instanceof Horse || entity instanceof Mule) {
            if (!(entity instanceof Animal)) {
                return false;
            }
            Animal animal = (Animal)entity;
            return !animal.m_6162_();
        }
        return false;
    }

    public static String getEntityString(Entity entity) {
        String entitystring = "";
        ResourceLocation rl = EntityType.m_20613_((EntityType)entity.m_6095_());
        if (rl != null) {
            entitystring = rl.toString();
            if (entitystring.contains(":")) {
                entitystring = entitystring.split(":")[1];
            }
            entitystring = StringFunctions.capitalizeEveryWord(entitystring.replace("_", " ")).replace(" ", "").replace("Entity", "");
        }
        return entitystring;
    }

    public static void nameEntity(Entity entity, String name) {
        if (!name.equals("")) {
            entity.m_6593_((Component)Component.m_237113_((String)name));
        }
    }

    public static void addPotionEffect(Entity entity, MobEffect effect, Integer ms) {
        MobEffectInstance freeze = new MobEffectInstance(effect, ms / 50);
        LivingEntity le = (LivingEntity)entity;
        le.m_7292_(freeze);
    }

    public static void removePotionEffect(Entity entity, MobEffect effect) {
        LivingEntity le = (LivingEntity)entity;
        le.m_21195_(effect);
    }

    public static void chargeEntity(Entity entity) {
        Level world = entity.m_20193_();
        if (entity instanceof Creeper) {
            entity.m_20088_().m_135381_(Creeper.f_32274_, (Object)true);
        } else if (entity instanceof MushroomCow) {
            ((MushroomCow)entity).m_28928_(MushroomCow.MushroomType.BROWN);
        }
    }

    public static void setEntityFlag(Entity entity, int flag, boolean set) {
        entity.m_20115_(flag, set);
    }

    public static void resetMerchantOffers(Villager villager) {
        for (MerchantOffer offer : villager.m_6616_()) {
            EntityFunctions.resetMerchantOffer(offer);
        }
    }

    public static void resetMerchantOffers(WanderingTrader wanderingTrader) {
        for (MerchantOffer offer : wanderingTrader.m_6616_()) {
            EntityFunctions.resetMerchantOffer(offer);
        }
    }

    public static void resetMerchantOffer(MerchantOffer offer) {
        offer.f_45313_ = 0;
        offer.f_45314_ = Integer.MAX_VALUE;
        offer.f_45317_ = 0;
    }

    public static void forceSetHealth(LivingEntity livingEntity, float health) {
        livingEntity.m_20088_().m_135381_(LivingEntity.f_20961_, (Object)Float.valueOf(health));
    }

    public static boolean fishingHookHasCatch(FishingHook fishingHook) {
        return fishingHook.f_37099_;
    }

    public static void transferItemsBetweenEntities(Entity from, Entity to, boolean ignoremainhand) {
        if (!(from instanceof Mob)) {
            return;
        }
        Mob mobfrom = (Mob)from;
        for (EquipmentSlot equipmentslottype : EquipmentSlot.values()) {
            ItemStack itemstack;
            if (ignoremainhand && equipmentslottype.equals((Object)EquipmentSlot.MAINHAND) || (itemstack = mobfrom.m_6844_(equipmentslottype)).m_41619_()) continue;
            to.m_8061_(equipmentslottype, itemstack.m_41777_());
        }
    }

    public static void transferItemsBetweenEntities(Entity from, Entity to) {
        EntityFunctions.transferItemsBetweenEntities(from, to, false);
    }

    public static Boolean doesEntitySurviveThisDamage(Player player, int halfheartdamage) {
        return EntityFunctions.doesEntitySurviveThisDamage((LivingEntity)player, halfheartdamage);
    }

    public static Boolean doesEntitySurviveThisDamage(LivingEntity entity, int halfheartdamage) {
        float newhealth = entity.m_21223_() - (float)halfheartdamage;
        if (!(newhealth > 0.0f)) {
            entity.m_6469_(DamageSource.f_19319_, Float.MAX_VALUE);
            return false;
        }
        entity.m_6469_(DamageSource.f_19319_, 0.1f);
        entity.m_21153_(newhealth);
        return true;
    }
}

