/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.events;

import com.natamus.collective.check.RegisterMod;
import com.natamus.collective.config.ConfigHandler;
import com.natamus.collective.data.GlobalVariables;
import com.natamus.collective.functions.BlockPosFunctions;
import com.natamus.collective.functions.EntityFunctions;
import com.natamus.collective.functions.SpawnEntityFunctions;
import com.natamus.collective.functions.WorldFunctions;
import com.natamus.collective.objects.SAMObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CollectiveEvents {
    public static WeakHashMap<ServerLevel, List<Entity>> entitiesToSpawn = new WeakHashMap();
    public static WeakHashMap<ServerLevel, WeakHashMap<Entity, Entity>> entitiesToRide = new WeakHashMap();

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load e) {
        Level world = WorldFunctions.getWorldIfInstanceOfAndNotRemote(e.getLevel());
        if (world == null) {
            return;
        }
        ServerLevel serverlevel = (ServerLevel)world;
        entitiesToSpawn.put(serverlevel, new ArrayList());
        entitiesToRide.put(serverlevel, new WeakHashMap());
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent e) {
        Level world = e.level;
        if (world.f_46443_ || !e.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        ServerLevel serverlevel = (ServerLevel)world;
        if (!entitiesToSpawn.containsKey(serverlevel)) {
            entitiesToSpawn.put(serverlevel, new ArrayList());
        } else if (entitiesToSpawn.get(serverlevel).size() > 0) {
            Entity tospawn = entitiesToSpawn.get(serverlevel).get(0);
            serverlevel.m_47205_(tospawn);
            if (!entitiesToRide.containsKey(serverlevel)) {
                entitiesToRide.put(serverlevel, new WeakHashMap());
            } else if (entitiesToRide.get(serverlevel).containsKey(tospawn)) {
                Entity rider = entitiesToRide.get(serverlevel).get(tospawn);
                rider.m_20329_(tospawn);
                entitiesToRide.get(serverlevel).remove(tospawn);
            }
            entitiesToSpawn.get(serverlevel).remove(0);
        }
    }

    @SubscribeEvent
    public void onMobSpawnerSpawn(LivingSpawnEvent.SpecialSpawn e) {
        Level Level2 = WorldFunctions.getWorldIfInstanceOfAndNotRemote(e.getLevel());
        if (Level2 == null) {
            return;
        }
        if (e.getSpawner() != null && !e.isCanceled()) {
            e.getEntity().m_20049_("collective.spawner");
        }
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent e) {
        Level world = e.getLevel();
        if (world.f_46443_) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        if (RegisterMod.shouldDoCheck && entity instanceof Player) {
            RegisterMod.joinWorldProcess(world, (Player)entity);
        }
        if (e.isCanceled()) {
            return;
        }
        if (GlobalVariables.samobjects.isEmpty()) {
            return;
        }
        Set tags = entity.m_19880_();
        if (tags.contains("collective.checked")) {
            return;
        }
        entity.m_20049_("collective.checked");
        EntityType entitytype = entity.m_6095_();
        if (entitytype == null || !GlobalVariables.activesams.contains(entitytype)) {
            return;
        }
        boolean isspawner = tags.contains("collective.spawner");
        ArrayList<SAMObject> possibles = new ArrayList<SAMObject>();
        for (SAMObject samobject : GlobalVariables.samobjects) {
            if (samobject == null || samobject.fromtype == null || !samobject.fromtype.equals((Object)entitytype) || samobject.spawner && !isspawner || !samobject.spawner && isspawner) continue;
            possibles.add(samobject);
        }
        int size = possibles.size();
        if (size == 0) {
            return;
        }
        boolean ageable = entity instanceof AgeableMob;
        for (SAMObject sam : possibles) {
            LivingEntity le;
            double num = GlobalVariables.random.nextDouble();
            if (num > sam.chance) continue;
            Vec3 evec = entity.m_20182_();
            if (sam.surface && !BlockPosFunctions.isOnSurface(world, evec).booleanValue()) continue;
            Entity to = sam.totype.m_20615_(world);
            to.m_6034_(evec.f_82479_, evec.f_82480_, evec.f_82481_);
            if (ageable && to instanceof AgeableMob) {
                AgeableMob am = (AgeableMob)to;
                am.m_146762_(((AgeableMob)entity).m_146764_());
                to = am;
            }
            boolean ignoremainhand = false;
            if (sam.helditem != null && to instanceof LivingEntity && !(le = (LivingEntity)to).m_21205_().m_41720_().equals(sam.helditem)) {
                le.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)sam.helditem, 1));
                ignoremainhand = true;
            }
            boolean ride = false;
            if (EntityFunctions.isHorse(to).booleanValue() && sam.rideable) {
                AbstractHorse ah = (AbstractHorse)to;
                ah.m_30651_(true);
                to = ah;
                ride = true;
            } else if (((Boolean)ConfigHandler.COLLECTIVE.transferItemsBetweenReplacedEntities.get()).booleanValue()) {
                EntityFunctions.transferItemsBetweenEntities(entity, to, ignoremainhand);
            }
            if (!(world instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverworld = (ServerLevel)world;
            if (ride) {
                SpawnEntityFunctions.startRidingEntityOnNextTick(serverworld, to, entity);
            } else {
                e.setCanceled(true);
            }
            to.m_20049_("collective.checked");
            SpawnEntityFunctions.spawnEntityOnNextTick(serverworld, to);
            break;
        }
    }
}

