/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.setup.configs;

import net.minecraftforge.common.ForgeConfigSpec;

final class CommonConfig {
    final ForgeConfigSpec.IntValue[] BLAZECREEPER = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> BLAZECREEPER_BIOME;
    final ForgeConfigSpec.IntValue[] BLAZEWOLF = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> BLAZEWOLF_BIOME;
    final ForgeConfigSpec.IntValue[] ENDERCREEPER = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> ENDERCREEPER_BIOME;
    final ForgeConfigSpec.IntValue[] PHANTOMFOX = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> PHANTOMFOX_BIOME_1;
    final ForgeConfigSpec.ConfigValue<String> PHANTOMFOX_BIOME_2;
    final ForgeConfigSpec.IntValue[] RABBITWOLF = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> RABBITWOLF_BIOME;
    final ForgeConfigSpec.IntValue[] SPIDERLLAMA = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> SPIDERLLAMA_BIOME;
    final ForgeConfigSpec.IntValue[] VEXPIGLIN = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> VEXPIGLIN_BIOME;
    final ForgeConfigSpec.IntValue[] WARDENDRAGON = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> WARDENDRAGON_BIOME;
    final ForgeConfigSpec.IntValue[] WOLFMAN = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> WOLFMAN_BIOME;
    final ForgeConfigSpec.IntValue[] ENDER_GHAST = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> ENDER_GHAST_BIOME;
    final ForgeConfigSpec.IntValue[] GIANT_MOSQUITO = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> GIANT_MOSQUITO_BIOME;
    final ForgeConfigSpec.IntValue[] WITHER_SPIDER = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> WITHER_SPIDER_BIOME;
    final ForgeConfigSpec.IntValue[] BASALT_SNAKE = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> BASALT_SNAKE_BIOME;
    final ForgeConfigSpec.IntValue[] SOUL_BLAZE = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> SOUL_BLAZE_BIOME;
    final ForgeConfigSpec.IntValue[] SILVERFISH_CREEPER = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> SILVERFISH_CREEPER_BIOME;
    final ForgeConfigSpec.IntValue[] BUCKETED_AXOLOTL = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> BUCKETED_AXOLOTL_BIOME;
    final ForgeConfigSpec.IntValue[] GIANT_AXOLOTL = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> GIANT_AXOLOTL_BIOME;
    final ForgeConfigSpec.IntValue[] CREEPER_SPIDERLING = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> CREEPER_SPIDERLING_BIOME;
    final ForgeConfigSpec.IntValue[] CREEPER_SPIDER = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> CREEPER_SPIDER_BIOME;
    final ForgeConfigSpec.IntValue[] CREEPER_SPIDER_BROODMOTHER = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> CREEPER_SPIDER_BROODMOTHER_BIOME;
    final ForgeConfigSpec.IntValue[] ENDER_BLAZE = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> ENDER_BLAZE_BIOME;
    final ForgeConfigSpec.IntValue[] FIRE_GUARDIAN = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> FIRE_GUARDIAN_BIOME;
    final ForgeConfigSpec.IntValue[] CRIMSON_PHANTOM = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> CRIMSON_PHANTOM_BIOME;
    final ForgeConfigSpec.IntValue[] WARPED_PHANTOM = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> WARPED_PHANTOM_BIOME;
    final ForgeConfigSpec.IntValue[] THORN_WOLF = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> THORN_WOLF_BIOME;
    final ForgeConfigSpec.IntValue[] THORN_WOLFMAN_1 = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> THORN_WOLFMAN_1_BIOME;
    final ForgeConfigSpec.IntValue[] THORN_WOLFMAN_2 = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> THORN_WOLFMAN_2_BIOME;
    final ForgeConfigSpec.IntValue[] FEATHERED_WINGED_SERPENT = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> FEATHERED_WINGED_SERPENT_BIOME;
    final ForgeConfigSpec.IntValue[] MEMBRANE_WINGED_SERPENT = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> MEMBRANE_WINGED_SERPENT_BIOME;
    final ForgeConfigSpec.IntValue[] NETHER_WINGED_SERPENT = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> NETHER_WINGED_SERPENT_BIOME_1;
    final ForgeConfigSpec.ConfigValue<String> NETHER_WINGED_SERPENT_BIOME_2;

    CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        builder.comment("Spawn rate and biome settings:\nIf you want to change where the mob should spawn then you have to do in this format:\nFor vanilla minecraft biome --> minecraft:basalt_deltas\nFor other mod biome --> modid:biome_name\nYou can look up vanilla biomes at: https://minecraft.fandom.com/wiki/Biome\n").push("spawnrate");
        CommonConfig.initMobSpawnRate(builder, "Blaze Creeper", "blazecreeper", 10, 0, 1, this.BLAZECREEPER);
        this.BLAZECREEPER_BIOME = builder.comment("\nBiome name where Blaze Creeper should spawn").define("bcr_biome", (Object)"minecraft:nether_wastes");
        CommonConfig.initMobSpawnRate(builder, "Blaze Wolf", "blazewolf", 10, 0, 1, this.BLAZEWOLF);
        this.BLAZEWOLF_BIOME = builder.comment("\nBiome name where Blaze Wolf should spawn").define("bwo_biome", (Object)"minecraft:nether_wastes");
        CommonConfig.initMobSpawnRate(builder, "Ender Creeper", "endercreeper", 10, 0, 1, this.ENDERCREEPER);
        this.ENDERCREEPER_BIOME = builder.comment("\nBiome name where Ender Creeper should spawn").define("ecr_biome", (Object)"minecraft:the_end");
        CommonConfig.initMobSpawnRate(builder, "Phantom Fox", "phantomfox", 10, 0, 1, this.PHANTOMFOX);
        this.PHANTOMFOX_BIOME_1 = builder.comment("\nBiome name where the Normal Phantom fox should spawn").define("pfo_biome", (Object)"minecraft:taiga");
        this.PHANTOMFOX_BIOME_2 = builder.comment("\nBiome name where the Arctic Phantom fox should spawn").define("afpo_biome", (Object)"minecraft:snowy_taiga");
        CommonConfig.initMobSpawnRate(builder, "Rabbit Wolf", "rabbitwolf", 20, 0, 4, this.RABBITWOLF);
        this.RABBITWOLF_BIOME = builder.comment("\nBiome name where Rabbit Wolf should spawn").define("rwo_biome", (Object)"minecraft:forest");
        CommonConfig.initMobSpawnRate(builder, "Spider Llama", "spiderllama", 15, 0, 2, this.SPIDERLLAMA);
        this.SPIDERLLAMA_BIOME = builder.comment("\nBiome name where Spider Llama should spawn").define("sll_biome", (Object)"minecraft:desert");
        CommonConfig.initMobSpawnRate(builder, "Vex Piglin", "vexpiglin", 10, 0, 1, this.VEXPIGLIN);
        this.VEXPIGLIN_BIOME = builder.comment("\nBiome name where Vex Piglin should spawn").define("vpi_biome", (Object)"minecraft:nether_wastes");
        CommonConfig.initMobSpawnRate(builder, "Warden Dragon", "wardendragon", 3, 0, 1, this.WARDENDRAGON);
        this.WARDENDRAGON_BIOME = builder.comment("\nBiome name where Warden Dragon should spawn").define("wdr_biome", (Object)"minecraft:swamp");
        CommonConfig.initMobSpawnRate(builder, "Wolfkind", "wolfkind", 15, 0, 4, this.WOLFMAN);
        this.WOLFMAN_BIOME = builder.comment("\nBiome name where wolfman and wolfwoman should spawn").define("wma_biome", (Object)"minecraft:jungle");
        CommonConfig.initMobSpawnRate(builder, "Ender Ghast", "enderghast", 10, 0, 1, this.ENDER_GHAST);
        this.ENDER_GHAST_BIOME = builder.comment("\nBiome name where Ender Ghast should spawn").define("egh_biome", (Object)"minecraft:end_highlands");
        CommonConfig.initMobSpawnRate(builder, "Giant Mosquito", "giantmosquito", 10, 0, 3, this.GIANT_MOSQUITO);
        this.GIANT_MOSQUITO_BIOME = builder.comment("\nBiome name where Giant Mosquito should spawn").define("gmo_biome", (Object)"minecraft:swamp");
        CommonConfig.initMobSpawnRate(builder, "Wither Spider", "witherspider", 10, 0, 1, this.WITHER_SPIDER);
        this.WITHER_SPIDER_BIOME = builder.comment("\nBiome name where Wither Spider should spawn").define("wsp_biome", (Object)"minecraft:warped_forest");
        CommonConfig.initMobSpawnRate(builder, "Basalt Snake", "basaltsnake", 10, 0, 2, this.BASALT_SNAKE);
        this.BASALT_SNAKE_BIOME = builder.comment("\nBiome name where Basalt Snake should spawn").define("bsn_biome", (Object)"minecraft:basalt_deltas");
        CommonConfig.initMobSpawnRate(builder, "Soul Blaze", "soulblaze", 10, 0, 1, this.SOUL_BLAZE);
        this.SOUL_BLAZE_BIOME = builder.comment("\nBiome name where Soul Blaze should spawn").define("sbl_biome", (Object)"minecraft:soul_sand_valley");
        CommonConfig.initMobSpawnRate(builder, "Silverfish Creeper", "silverfishcreeper", 0, 0, 0, this.SILVERFISH_CREEPER);
        this.SILVERFISH_CREEPER_BIOME = builder.comment("\nBiome name where Silverfish Creeper should spawn").define("sfc_biome", (Object)"minecraft:plains");
        CommonConfig.initMobSpawnRate(builder, "Bucketed Axolotl", "bucketedaxolotl", 10, 0, 1, this.BUCKETED_AXOLOTL);
        this.BUCKETED_AXOLOTL_BIOME = builder.comment("\nBiome name where Bucketed Axolotl should spawn").define("bax_biome", (Object)"minecraft:plains");
        CommonConfig.initMobSpawnRate(builder, "Big Axolotl", "bigaxolotl", 10, 0, 1, this.GIANT_AXOLOTL);
        this.GIANT_AXOLOTL_BIOME = builder.comment("\nBiome name where Big Axolotl should spawn").define("gax_biome", (Object)"minecraft:swamp");
        CommonConfig.initMobSpawnRate(builder, "Creeper Spiderling", "creeper_spiderling", 10, 0, 1, this.CREEPER_SPIDERLING);
        this.CREEPER_SPIDER_BIOME = builder.comment("\nBiome name where Creeper Spiderling should spawn").define("ebl_biome", (Object)"minecraft:dark_forest");
        CommonConfig.initMobSpawnRate(builder, "Creeper Spider", "creeper_spider", 10, 0, 1, this.CREEPER_SPIDER);
        this.CREEPER_SPIDERLING_BIOME = builder.comment("\nBiome name where Creeper Spider should spawn").define("ebl_biome", (Object)"minecraft:dark_forest");
        CommonConfig.initMobSpawnRate(builder, "Creeper Spider Broodmother", "creeper_spider_broodmother", 0, 0, 0, this.CREEPER_SPIDER_BROODMOTHER);
        this.CREEPER_SPIDER_BROODMOTHER_BIOME = builder.comment("\nBiome name where Creeper Spider Broodmother should spawn").define("ebl_biome", (Object)"minecraft:dark_forest");
        CommonConfig.initMobSpawnRate(builder, "Ender Blaze", "enderblaze", 10, 0, 1, this.ENDER_BLAZE);
        this.ENDER_BLAZE_BIOME = builder.comment("\nBiome name where Ender Blaze should spawn").define("ebl_biome", (Object)"minecraft:the_end");
        CommonConfig.initMobSpawnRate(builder, "Fire Guardian", "fire_guardian", 10, 0, 1, this.FIRE_GUARDIAN);
        this.FIRE_GUARDIAN_BIOME = builder.comment("\nBiome name where Fire Guardian should spawn").define("fgu_biome", (Object)"minecraft:nether_wastes");
        CommonConfig.initMobSpawnRate(builder, "Crimson Phantom", "crimson_phantom", 10, 0, 1, this.CRIMSON_PHANTOM);
        this.CRIMSON_PHANTOM_BIOME = builder.comment("\nBiome name where Crimson Phantom should spawn").define("cph_biome", (Object)"minecraft:crimson_forest");
        CommonConfig.initMobSpawnRate(builder, "Warped Phantom", "warped_phantom", 10, 0, 1, this.WARPED_PHANTOM);
        this.WARPED_PHANTOM_BIOME = builder.comment("\nBiome name where Warped Phantom should spawn").define("wph_biome", (Object)"minecraft:warped_forest");
        CommonConfig.initMobSpawnRate(builder, "Thorn Wolf", "thorn_wolf", 10, 0, 1, this.THORN_WOLF);
        this.THORN_WOLF_BIOME = builder.comment("\nBiome name where Thorn Wolf should spawn").define("two_biome", (Object)"minecraft:dark_forest");
        CommonConfig.initMobSpawnRate(builder, "Thorn Corrupted Wolfman First Stage 1", "thorn_wolf_1", 10, 0, 1, this.THORN_WOLFMAN_1);
        this.THORN_WOLFMAN_1_BIOME = builder.comment("\nBiome name where Thorn Corrupted Wolfman-1 should spawn").define("tw1_biome", (Object)"minecraft:dark_forest");
        CommonConfig.initMobSpawnRate(builder, "Thorn Corrupted Wolfman First Stage 2", "thorn_wolf_2", 10, 0, 1, this.THORN_WOLFMAN_2);
        this.THORN_WOLFMAN_2_BIOME = builder.comment("\nBiome name where Thorn Corrupted Wolfman-2 should spawn").define("tw2_biome", (Object)"minecraft:dark_forest");
        CommonConfig.initMobSpawnRate(builder, "Feathered Serpent", "feathered_serpent", 10, 0, 1, this.FEATHERED_WINGED_SERPENT);
        this.FEATHERED_WINGED_SERPENT_BIOME = builder.comment("\nBiome name where Feathered Serpent should spawn").define("fws_biome", (Object)"minecraft:windswept_hills");
        CommonConfig.initMobSpawnRate(builder, "Wind Serpent", "wind_serpent", 10, 0, 1, this.MEMBRANE_WINGED_SERPENT);
        this.MEMBRANE_WINGED_SERPENT_BIOME = builder.comment("\nBiome name where Wind Serpent should spawn").define("mws_biome", (Object)"minecraft:swamp");
        CommonConfig.initMobSpawnRate(builder, "Nether Serpent", "nether_serpent", 10, 0, 1, this.NETHER_WINGED_SERPENT);
        this.NETHER_WINGED_SERPENT_BIOME_1 = builder.comment("\nBiome name where Nether Serpent should spawn").define("nws1_biome", (Object)"minecraft:crimson_forest");
        this.NETHER_WINGED_SERPENT_BIOME_2 = builder.comment("\n\nBiome name where Nether Serpent should spawn").define("nws2_biome", (Object)"minecraft:warped_forest");
        builder.pop();
    }

    public static void initMobSpawnRate(ForgeConfigSpec.Builder builder, String name, String pushname, int weight, int min, int max, ForgeConfigSpec.IntValue[] array) {
        builder.comment(name).push(pushname);
        array[0] = builder.comment("Spawn Chance").translation("weirdmobs.config." + name + "weight").defineInRange("weight", weight, 0, Integer.MAX_VALUE);
        array[1] = builder.comment("Monster Spawn Minimum Number").translation("weirdmobs.config." + name + "min").defineInRange("min", min, 0, Integer.MAX_VALUE);
        array[2] = builder.comment("Monster Spawn Maximum Number").translation("weirdmobs.config." + name + "max").defineInRange("max", max, 0, Integer.MAX_VALUE);
        builder.pop();
    }
}

