/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.setup;

import com.google.gson.JsonElement;
import com.minecraftserverzone.weirdmobs.datagen.ModBiomeTags;
import com.minecraftserverzone.weirdmobs.setup.ModTags;
import com.minecraftserverzone.weirdmobs.setup.Registrations;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="weirdmobs", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BiomeModifierTest {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "weirdmobs";
    public static final ResourceLocation ADD_FEATURES_TO_BIOMES_RL = new ResourceLocation("weirdmobs", "weirdmobs");

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        String[] SPAWNS = new String[]{"spawn_blaze_creeper", "spawn_blaze_wolf", "spawn_phantom_fox", "spawn_rabbit_wolf", "spawn_spider_llama", "spawn_vex_piglin", "spawn_warden_dragon", "spawn_wolfman", "spawn_wolfwoman", "spawn_ender_ghast", "spawn_giant_mosquito", "spawn_wither_spider", "spawn_basalt_snake", "spawn_soul_blaze", "spawn_silverfish_creeper", "spawn_bucketed_axolotl", "spawn_giant_axolotl", "spawn_creeper_spider", "spawn_vex_creeper_spiderling", "spawn_creeper_spider_broodmother", "spawn_ender_blaze", "spawn_fire_guardian", "spawn_crimson_phantom", "spawn_warped_phantom", "spawn_thorn_wolf", "spawn_thorn_wolfman1", "spawn_thorn_wolfman2", "spawn_feathered_winged_serpent", "spawn_membrane_winged_serpent", "spawn_nether_winged_serpent"};
        EntityType[] SPAWN_TYPES = new EntityType[]{(EntityType)Registrations.BLAZE_CREEPER.get(), (EntityType)Registrations.BLAZE_WOLF.get(), (EntityType)Registrations.PHANTOM_FOX.get(), (EntityType)Registrations.RABBIT_WOLF.get(), (EntityType)Registrations.SPIDER_LLAMA.get(), (EntityType)Registrations.VEX_PIGLIN.get(), (EntityType)Registrations.WARDEN_DRAGON.get(), (EntityType)Registrations.WOLF_MAN.get(), (EntityType)Registrations.WOLFWOMAN.get(), (EntityType)Registrations.ENDER_GHAST.get(), (EntityType)Registrations.GIANT_MOSQUITO.get(), (EntityType)Registrations.WITHER_SPIDER.get(), (EntityType)Registrations.BASALT_SNAKE.get(), (EntityType)Registrations.SOUL_BLAZE.get(), (EntityType)Registrations.SILVERFISH_CREEPER.get(), (EntityType)Registrations.BUCKETED_AXOLOTL.get(), (EntityType)Registrations.GIANT_AXOLOTL.get(), (EntityType)Registrations.CREEPER_SPIDER.get(), (EntityType)Registrations.CREEPER_SPIDERLING.get(), (EntityType)Registrations.CREEPER_SPIDER_BROODMOTHER.get(), (EntityType)Registrations.ENDER_BLAZE.get(), (EntityType)Registrations.FIRE_GUARDIAN.get(), (EntityType)Registrations.CRIMSON_PHANTOM.get(), (EntityType)Registrations.WARPED_PHANTOM.get(), (EntityType)Registrations.THORN_WOLF.get(), (EntityType)Registrations.THORN_CORRUPTED_WOLFMAN_STAGE_1.get(), (EntityType)Registrations.THORN_CORRUPTED_WOLFMAN_STAGE_2.get(), (EntityType)Registrations.FEATHERED_WINGED_SERPENT.get(), (EntityType)Registrations.MEMBRANE_WINGED_SERPENT.get(), (EntityType)Registrations.NETHER_WINGED_SERPENT.get()};
        TagKey[] SPAWN_TAGS = new TagKey[]{ModTags.HAS_BLAZE_CREEPER, ModTags.HAS_BLAZE_WOLF, ModTags.HAS_PHANTOM_FOX, ModTags.HAS_RABBIT_WOLF, ModTags.HAS_SPIDER_LLAMA, ModTags.HAS_VEX_PIGLIN, ModTags.HAS_WARDEN_DRAGON, ModTags.HAS_WOLFMAN, ModTags.HAS_WOLFWOMAN, ModTags.HAS_ENDER_GHAST, ModTags.HAS_GIANT_MOSQUITO, ModTags.HAS_WITHER_SPIDER, ModTags.HAS_BASALT_SNAKE, ModTags.HAS_SOUL_BLAZE, ModTags.HAS_SILVERFISH_CREEPER, ModTags.HAS_BUCKETED_AXOLOTL, ModTags.HAS_GIANT_AXOLOTL, ModTags.HAS_CREEPER_SPIDER, ModTags.HAS_CREEPER_SPIDERLING, ModTags.HAS_CREEPER_SPIDER_BROODMOTHER, ModTags.HAS_ENDER_BLAZE, ModTags.HAS_FIRE_GUARDIAN, ModTags.HAS_CRIMSON_PHANTOM, ModTags.HAS_WARPED_PHANTOM, ModTags.HAS_THORN_WOLF, ModTags.HAS_THORN_WOLFMAN1, ModTags.HAS_THORN_WOLFMAN2, ModTags.HAS_FEATHERED_WINGED_SERPENT, ModTags.HAS_MEMBRANE_WINGED_SERPENT, ModTags.HAS_NETHER_WINGED_SERPENT};
        DataGenerator generator = event.getGenerator();
        Path outputFolder = generator.m_123916_();
        final RegistryOps ops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)((RegistryAccess)RegistryAccess.f_123049_.get()));
        String directory = PackType.SERVER_DATA.m_10305_();
        ResourceLocation biomeModifiersRegistryID = ForgeRegistries.Keys.BIOME_MODIFIERS.m_135782_();
        int i = 0;
        for (String spawn : SPAWNS) {
            final String biomeModifierPathString = String.join((CharSequence)"/", directory, MODID, biomeModifiersRegistryID.m_135827_(), biomeModifiersRegistryID.m_135815_(), spawn + ".json");
            final Path biomeModifierPath = outputFolder.resolve(biomeModifierPathString);
            final TestModifier biomeModifiersBrownScorpion = new TestModifier((HolderSet<Biome>)new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), SPAWN_TAGS[i]), new MobSpawnSettings.SpawnerData(SPAWN_TYPES[i], 5, 0, 2));
            ++i;
            if (event.includeServer()) {
                generator.m_236039_(true, (DataProvider)new ModBiomeTags(generator, event.getExistingFileHelper()));
            }
            generator.m_236039_(event.includeServer(), new DataProvider(){

                public void m_213708_(CachedOutput cache) throws IOException {
                    BiomeModifier.DIRECT_CODEC.encodeStart((DynamicOps)ops, (Object)biomeModifiersBrownScorpion).resultOrPartial(msg -> LOGGER.error("Failed to encode {}: {}", (Object)biomeModifierPathString, msg)).ifPresent(json -> {
                        try {
                            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)json, (Path)biomeModifierPath);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                }

                public String m_6055_() {
                    return "weirdmobs data provider";
                }
            });
        }
    }

    public record TestModifier(HolderSet<Biome> biomes, MobSpawnSettings.SpawnerData spawn) implements BiomeModifier
    {
        private static final RegistryObject<Codec<? extends BiomeModifier>> SERIALIZER = RegistryObject.create((ResourceLocation)ADD_FEATURES_TO_BIOMES_RL, (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"weirdmobs");

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD && this.biomes.m_203333_(biome)) {
                builder.getMobSpawnSettings().m_48376_(this.spawn.f_48404_.m_20674_(), this.spawn);
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return (Codec)SERIALIZER.get();
        }

        public static Codec<TestModifier> makeCodec() {
            return RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(TestModifier::biomes), (App)MobSpawnSettings.SpawnerData.f_48403_.fieldOf("spawn").forGetter(TestModifier::spawn)).apply((Applicative)builder, TestModifier::new));
        }
    }
}

