/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs.witherspider;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class WitherSpider
extends Monster {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(WitherSpider.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public WitherSpider(EntityType<? extends WitherSpider> p_33786_, Level p_33787_) {
        super(p_33786_, p_33787_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new SpiderAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new SpiderTargetGoal<Player>(this, Player.class));
        this.f_21346_.m_25352_(3, new SpiderTargetGoal<IronGolem>(this, IronGolem.class));
    }

    public double m_6048_() {
        return this.m_20206_() * 0.5f;
    }

    protected PathNavigation m_6037_(Level p_33802_) {
        return new WallClimberNavigation((Mob)this, p_33802_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.setClimbing(this.f_19862_);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 5.0);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12432_;
    }

    protected SoundEvent m_7975_(DamageSource p_33814_) {
        return SoundEvents.f_12434_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12433_;
    }

    protected void m_7355_(BlockPos p_33804_, BlockState p_33805_) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public void m_7601_(BlockState p_33796_, Vec3 p_33797_) {
        if (!p_33796_.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(p_33796_, p_33797_);
        }
    }

    public boolean m_7327_(Entity p_30372_) {
        boolean flag = p_30372_.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, p_30372_);
        }
        if (p_30372_ instanceof LivingEntity) {
            p_30372_.m_6469_(DamageSource.f_19319_, 1.0f);
            ((LivingEntity)p_30372_).m_7292_(new MobEffectInstance(MobEffects.f_19615_, 100, 0));
        }
        return flag;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean p_33820_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = p_33820_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_33790_, DifficultyInstance p_33791_, MobSpawnType p_33792_, @Nullable SpawnGroupData p_33793_, @Nullable CompoundTag p_33794_) {
        MobEffect mobeffect;
        p_33793_ = super.m_6518_(p_33790_, p_33791_, p_33792_, p_33793_, p_33794_);
        RandomSource randomsource = p_33790_.m_213780_();
        if (randomsource.m_188503_(100) == 0) {
            WitherSkeleton skeleton = (WitherSkeleton)EntityType.f_20497_.m_20615_(this.f_19853_);
            skeleton.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
            skeleton.m_6518_(p_33790_, p_33791_, p_33792_, (SpawnGroupData)null, (CompoundTag)null);
            skeleton.m_20329_((Entity)this);
        }
        if (p_33793_ == null) {
            p_33793_ = new SpiderEffectsGroupData();
            if (p_33790_.m_46791_() == Difficulty.HARD && randomsource.m_188501_() < 0.1f * p_33791_.m_19057_()) {
                ((SpiderEffectsGroupData)p_33793_).setRandomEffect(randomsource);
            }
        }
        if (p_33793_ instanceof SpiderEffectsGroupData && (mobeffect = ((SpiderEffectsGroupData)p_33793_).effect) != null) {
            this.m_7292_(new MobEffectInstance(mobeffect, Integer.MAX_VALUE));
        }
        return p_33793_;
    }

    protected float m_6431_(Pose p_33799_, EntityDimensions p_33800_) {
        return 0.65f;
    }

    static class SpiderAttackGoal
    extends MeleeAttackGoal {
        public SpiderAttackGoal(WitherSpider p_33822_) {
            super((PathfinderMob)p_33822_, 1.0, true);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.f_25540_.m_20160_();
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        protected double m_6639_(LivingEntity p_33825_) {
            return 4.0f + p_33825_.m_20205_();
        }
    }

    static class SpiderTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public SpiderTargetGoal(WitherSpider p_33832_, Class<T> p_33833_) {
            super((Mob)p_33832_, p_33833_, true);
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }
    }

    public static class SpiderEffectsGroupData
    implements SpawnGroupData {
        public MobEffect effect;

        public void setRandomEffect(RandomSource randomsource) {
            int i = randomsource.m_188503_(5);
            if (i <= 1) {
                this.effect = MobEffects.f_19596_;
            } else if (i <= 2) {
                this.effect = MobEffects.f_19600_;
            } else if (i <= 3) {
                this.effect = MobEffects.f_19605_;
            } else if (i <= 4) {
                this.effect = MobEffects.f_19609_;
            }
        }
    }
}

