/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs.wardendragon;

import com.minecraftserverzone.weirdmobs.setup.ModSounds;
import com.minecraftserverzone.weirdmobs.setup.Registrations;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class WardenDragon
extends Monster
implements NeutralMob,
FlyingAnimal {
    public static final float FLAP_DEGREES_PER_TICK = 120.32113f;
    public static final int TICKS_PER_FLAP = Mth.m_14167_((float)1.4959966f);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(WardenDragon.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(WardenDragon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private UUID persistentAngerTarget;
    private float rollAmount;
    private float rollAmountO;
    private float glowingTick;
    private int attackAnimationTick;
    private String glowingDirection;

    public WardenDragon(EntityType<? extends WardenDragon> p_27717_, Level p_27718_) {
        super(p_27717_, p_27718_);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.f_21365_ = new BeeLookControl((Mob)this);
        this.f_21364_ = 50;
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public float m_5610_(BlockPos p_27788_, LevelReader p_27789_) {
        return p_27789_.m_8055_(p_27788_).m_60795_() ? 10.0f : 0.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BeeAttackGoal((PathfinderMob)this, 1.4f, true));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_((TagKey)ItemTags.f_13146_), false));
        this.f_21345_.m_25352_(8, (Goal)new BeeWanderGoal());
        this.f_21345_.m_25352_(9, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new BeeHurtByOtherGoal(this).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new BeeBecomeAngryTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
    }

    public void m_7380_(CompoundTag p_27823_) {
        super.m_7380_(p_27823_);
        this.m_21678_(p_27823_);
    }

    public void m_7378_(CompoundTag p_27793_) {
        super.m_7378_(p_27793_);
        this.m_147285_(this.f_19853_, p_27793_);
    }

    private float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    public boolean m_7327_(Entity p_27722_) {
        boolean flag;
        float f1;
        this.attackAnimationTick = 20;
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        float f = this.getAttackDamage();
        float f2 = f1 = (int)f > 0 ? f / 2.0f + (float)this.f_19796_.m_188503_((int)f) : f;
        if (p_27722_ instanceof Warden) {
            f1 *= 5.0f;
        }
        if (flag = p_27722_.m_6469_(DamageSource.m_19370_((LivingEntity)this), f1)) {
            p_27722_.m_20256_(p_27722_.m_20184_().m_82520_(0.0, (double)0.4f, 0.0));
            this.m_19970_((LivingEntity)this, p_27722_);
        }
        if (this.f_19796_.m_188503_(2) + 0 == 1) {
            this.m_5496_((SoundEvent)ModSounds.WARDEN_ROAR.get(), 1.0f, 1.0f);
        }
        return flag;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.glowingTick > 40.0f) {
            this.glowingTick -= 1.0f;
            this.glowingDirection = "down";
        } else if (this.glowingTick < 2.0f) {
            this.glowingTick += 1.0f;
            this.glowingDirection = "up";
        } else {
            this.glowingTick = this.glowingDirection == "down" ? (this.glowingTick -= 1.0f) : (this.glowingTick += 1.0f);
        }
        this.spawnFluidParticle(this.f_19853_, this.m_20185_() - (double)0.3f, this.m_20185_() + (double)0.3f, this.m_20189_() - (double)0.3f, this.m_20189_() + (double)0.3f, this.m_20227_(0.5), (ParticleOptions)ParticleTypes.f_123760_);
        this.updateRollAmount();
    }

    private void spawnFluidParticle(Level p_27780_, double p_27781_, double p_27782_, double p_27783_, double p_27784_, double p_27785_, ParticleOptions p_27786_) {
        p_27780_.m_7106_(p_27786_, Mth.m_14139_((double)p_27780_.f_46441_.m_188500_(), (double)p_27781_, (double)p_27782_), p_27785_, Mth.m_14139_((double)p_27780_.f_46441_.m_188500_(), (double)p_27783_, (double)p_27784_), 0.0, 0.0, 0.0);
    }

    void pathfindRandomlyTowards(BlockPos p_27881_) {
        Vec3 vec31;
        Vec3 vec3 = Vec3.m_82539_((Vec3i)p_27881_);
        int i = 0;
        BlockPos blockpos = this.m_20183_();
        int j = (int)vec3.f_82480_ - blockpos.m_123342_();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int i1 = blockpos.m_123333_((Vec3i)p_27881_);
        if (i1 < 15) {
            k = i1 / 2;
            l = i1 / 2;
        }
        if ((vec31 = AirRandomPos.m_148387_((PathfinderMob)this, (int)k, (int)l, (int)i, (Vec3)vec3, (double)0.3141592741012573)) != null) {
            this.f_21344_.m_26529_(0.5f);
            this.f_21344_.m_26519_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 1.0);
        }
    }

    public float getRollAmount(float p_27936_) {
        return Mth.m_14179_((float)p_27936_, (float)this.rollAmountO, (float)this.rollAmount);
    }

    private void updateRollAmount() {
        this.rollAmountO = this.rollAmount;
        this.rollAmount = this.isRolling() ? Math.min(1.0f, this.rollAmount + 0.2f) : Math.max(0.0f, this.rollAmount - 0.24f);
    }

    public void m_7822_(byte p_28844_) {
        if (this.glowingTick > 40.0f) {
            this.glowingTick -= 1.0f;
            this.glowingDirection = "down";
        } else if (this.glowingTick < 2.0f) {
            this.glowingTick += 1.0f;
            this.glowingDirection = "up";
        } else {
            this.glowingTick = this.glowingDirection == "down" ? (this.glowingTick -= 1.0f) : (this.glowingTick += 1.0f);
        }
        if (p_28844_ == 4) {
            this.attackAnimationTick = 20;
            this.m_5496_((SoundEvent)ModSounds.WARDEN_ROAR.get(), 1.0f, 1.0f);
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public float getGlowingTick() {
        return this.glowingTick;
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int p_27795_) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)p_27795_);
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID p_27791_) {
        this.persistentAngerTarget = p_27791_;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @VisibleForDebug
    public GoalSelector getGoalSelector() {
        return this.f_21345_;
    }

    protected void m_8025_() {
        super.m_8025_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            boolean flag = this.m_21660_() && this.m_5448_() != null && this.m_5448_().m_20280_((Entity)this) < 4.0;
            this.setRolling(flag);
            this.m_21666_((ServerLevel)this.f_19853_, false);
        }
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    private boolean isRolling() {
        return this.getFlag(2);
    }

    private void setRolling(boolean p_27930_) {
        this.setFlag(2, p_27930_);
    }

    boolean isTooFarAway(BlockPos p_27890_) {
        return !this.closerThan(p_27890_, 32);
    }

    private void setFlag(int p_27833_, boolean p_27834_) {
        if (p_27834_) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) | p_27833_)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & ~p_27833_)));
        }
    }

    private boolean getFlag(int p_27922_) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & p_27922_) != 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 125.0).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_(Attributes.f_22281_, 30.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected PathNavigation m_6037_(Level p_27815_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_27815_){

            public boolean m_6342_(BlockPos p_27947_) {
                return !this.f_26495_.m_8055_(p_27947_.m_7495_()).m_60795_();
            }

            public void m_7638_() {
                super.m_7638_();
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(false);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    protected void m_7355_(BlockPos p_27820_, BlockState p_27821_) {
        this.m_5496_((SoundEvent)ModSounds.WARDEN_STEP.get(), 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.WARDEN_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_27845_) {
        return (SoundEvent)ModSounds.WARDEN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.WARDEN_DEATH.get();
    }

    protected float m_6121_() {
        return 1.0f;
    }

    public WardenDragon getBreedOffspring(ServerLevel p_148760_, AgeableMob p_148761_) {
        return (WardenDragon)((EntityType)Registrations.WARDEN_DRAGON.get()).m_20615_((Level)p_148760_);
    }

    protected float m_6431_(Pose p_27804_, EntityDimensions p_27805_) {
        return this.m_6162_() ? p_27805_.f_20378_ * 0.5f : p_27805_.f_20378_ * 0.5f;
    }

    public boolean m_142535_(float p_148750_, float p_148751_, DamageSource p_148752_) {
        return false;
    }

    protected void m_7840_(double p_27754_, boolean p_27755_, BlockState p_27756_, BlockPos p_27757_) {
    }

    public boolean m_142039_() {
        return this.m_29443_() && this.f_19797_ % TICKS_PER_FLAP == 0;
    }

    public boolean m_29443_() {
        return !this.f_19861_;
    }

    public boolean m_6469_(DamageSource p_27762_, float p_27763_) {
        if (this.m_6673_(p_27762_)) {
            return false;
        }
        return super.m_6469_(p_27762_, p_27763_);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected void m_203347_(TagKey<Fluid> p_204045_) {
        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.01, 0.0));
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.5f * this.m_20192_()), (double)(this.m_20205_() * 0.2f));
    }

    boolean closerThan(BlockPos p_27817_, int p_27818_) {
        return p_27817_.m_123314_((Vec3i)this.m_20183_(), (double)p_27818_);
    }

    class BeeLookControl
    extends LookControl {
        BeeLookControl(Mob p_28059_) {
            super(p_28059_);
        }

        public void m_8128_() {
            if (!WardenDragon.this.m_21660_()) {
                super.m_8128_();
            }
        }
    }

    class BeeAttackGoal
    extends MeleeAttackGoal {
        BeeAttackGoal(PathfinderMob p_27960_, double p_27961_, boolean p_27962_) {
            super(p_27960_, p_27961_, p_27962_);
        }

        public boolean m_8036_() {
            return super.m_8036_() && WardenDragon.this.m_21660_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && WardenDragon.this.m_21660_();
        }
    }

    class BeeWanderGoal
    extends Goal {
        BeeWanderGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return WardenDragon.this.f_21344_.m_26571_() && WardenDragon.this.f_19796_.m_188503_(10) == 0;
        }

        public boolean m_8045_() {
            return WardenDragon.this.f_21344_.m_26572_();
        }

        public void m_8056_() {
            Vec3 vec3 = this.findPos();
            if (vec3 != null) {
                WardenDragon.this.f_21344_.m_26536_(WardenDragon.this.f_21344_.m_7864_(new BlockPos(vec3), 1), 1.0);
            }
        }

        @Nullable
        private Vec3 findPos() {
            Vec3 vec3 = WardenDragon.this.m_20252_(0.0f);
            Vec3 vec32 = HoverRandomPos.m_148465_((PathfinderMob)WardenDragon.this, (int)8, (int)7, (double)vec3.f_82479_, (double)vec3.f_82481_, (float)1.5707964f, (int)3, (int)1);
            return vec32 != null ? vec32 : AirAndWaterRandomPos.m_148357_((PathfinderMob)WardenDragon.this, (int)8, (int)4, (int)-2, (double)vec3.f_82479_, (double)vec3.f_82481_, (double)1.5707963705062866);
        }
    }

    class BeeHurtByOtherGoal
    extends HurtByTargetGoal {
        BeeHurtByOtherGoal(WardenDragon p_28033_) {
            super((PathfinderMob)p_28033_, new Class[0]);
        }

        public boolean m_8045_() {
            return WardenDragon.this.m_21660_() && super.m_8045_();
        }

        protected void m_5766_(Mob p_28035_, LivingEntity p_28036_) {
            if (p_28035_ instanceof WardenDragon && this.f_26135_.m_142582_((Entity)p_28036_)) {
                p_28035_.m_6710_(p_28036_);
            }
        }
    }

    static class BeeBecomeAngryTargetGoal
    extends NearestAttackableTargetGoal<Player> {
        BeeBecomeAngryTargetGoal(WardenDragon p_27966_) {
            super((Mob)p_27966_, Player.class, 10, true, false, arg_0 -> ((WardenDragon)p_27966_).m_21674_(arg_0));
        }

        public boolean m_8036_() {
            return this.beeCanTarget() && super.m_8036_();
        }

        public boolean m_8045_() {
            boolean flag = this.beeCanTarget();
            if (flag && this.f_26135_.m_5448_() != null) {
                return super.m_8045_();
            }
            this.f_26137_ = null;
            return false;
        }

        private boolean beeCanTarget() {
            WardenDragon bee = (WardenDragon)this.f_26135_;
            return bee.m_21660_();
        }
    }

    abstract class BaseBeeGoal
    extends Goal {
        BaseBeeGoal() {
        }

        public abstract boolean canBeeUse();

        public abstract boolean canBeeContinueToUse();

        public boolean m_8036_() {
            return this.canBeeUse() && !WardenDragon.this.m_21660_();
        }

        public boolean m_8045_() {
            return this.canBeeContinueToUse() && !WardenDragon.this.m_21660_();
        }
    }
}

