/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs.thorn_wolf;

import com.minecraftserverzone.weirdmobs.setup.Registrations;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ThornWolf
extends TamableAnimal
implements NeutralMob {
    private static final EntityDataAccessor<Boolean> DATA_INTERESTED_ID = SynchedEntityData.m_135353_(ThornWolf.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.m_135353_(ThornWolf.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(ThornWolf.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float interestedAngle;
    private float interestedAngleO;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    @Nullable
    private UUID persistentAngerTarget;

    public ThornWolf(EntityType<? extends ThornWolf> p_30369_, Level p_30370_) {
        super(p_30369_, p_30370_);
        this.m_7105_(false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, new WolfAvoidEntityGoal<Blaze>(this, Blaze.class, 24.0f, 1.5, 1.5));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((ThornWolf)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 18.0).m_22268_(Attributes.f_22281_, 4.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_INTERESTED_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    protected void m_7355_(BlockPos p_30415_, BlockState p_30416_) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    public void m_7380_(CompoundTag p_30418_) {
        super.m_7380_(p_30418_);
        p_30418_.m_128344_("Color", (byte)this.getColor());
        this.m_21678_(p_30418_);
    }

    public void m_7378_(CompoundTag p_30402_) {
        super.m_7378_(p_30402_);
        if (p_30402_.m_128425_("Color", 99)) {
            this.setColor(p_30402_.m_128451_("Color"));
        }
        this.m_147285_(this.f_19853_, p_30402_);
    }

    protected SoundEvent m_7515_() {
        if (this.m_21660_()) {
            return SoundEvents.f_12619_;
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            return this.m_21824_() && this.m_21223_() < 10.0f ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
        }
        return SoundEvents.f_12617_;
    }

    protected SoundEvent m_7975_(DamageSource p_30424_) {
        return SoundEvents.f_12621_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            this.m_21666_((ServerLevel)this.f_19853_, true);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_()) {
            this.interestedAngleO = this.interestedAngle;
            this.interestedAngle = this.isInterested() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
        }
    }

    public float getHeadRollAngle(float p_30449_) {
        return Mth.m_14179_((float)p_30449_, (float)this.interestedAngleO, (float)this.interestedAngle) * 0.15f * (float)Math.PI;
    }

    protected float m_6431_(Pose p_30409_, EntityDimensions p_30410_) {
        return p_30410_.f_20378_ * 0.8f;
    }

    public int m_8132_() {
        return this.m_21825_() ? 20 : super.m_8132_();
    }

    public boolean m_6469_(DamageSource p_30386_, float p_30387_) {
        if (this.m_6673_(p_30386_)) {
            return false;
        }
        Entity entity = p_30386_.m_7639_();
        this.m_21839_(false);
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            p_30387_ = (p_30387_ + 1.0f) / 2.0f;
        }
        return super.m_6469_(p_30386_, p_30387_);
    }

    public boolean m_7327_(Entity p_30372_) {
        boolean flag = p_30372_.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, p_30372_);
        }
        return flag;
    }

    public void m_7105_(boolean p_30443_) {
        super.m_7105_(p_30443_);
        if (p_30443_) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(4.0);
    }

    public void m_7822_(byte p_30379_) {
        if (p_30379_ != 4) {
            super.m_7822_(p_30379_);
        }
    }

    public float getTailAngle() {
        if (this.m_21660_()) {
            return 1.5393804f;
        }
        return this.m_21824_() ? (0.55f - (this.m_21233_() - this.m_21223_()) * 0.02f) * (float)Math.PI : 0.62831855f;
    }

    public boolean m_6898_(ItemStack p_30440_) {
        Item item = p_30440_.m_41720_();
        return item.m_41472_() && item.m_41473_().m_38746_();
    }

    public int m_5792_() {
        return 8;
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int p_30404_) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID p_30400_) {
        this.persistentAngerTarget = p_30400_;
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(DATA_COLOR);
    }

    public void setColor(int p_30398_) {
        this.f_19804_.m_135381_(DATA_COLOR, (Object)p_30398_);
    }

    public ThornWolf getBreedOffspring(ServerLevel p_149088_, AgeableMob p_149089_) {
        ThornWolf wolf = (ThornWolf)((EntityType)Registrations.THORN_WOLF.get()).m_20615_((Level)p_149088_);
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            wolf.m_21816_(uuid);
            wolf.m_7105_(true);
        }
        int rand = new Random().nextInt(2);
        wolf.setColor(rand);
        return wolf;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_146748_, SpawnGroupData p_146749_, CompoundTag p_146750_) {
        int rand = new Random().nextInt(2);
        this.setColor(rand);
        return super.m_6518_(p_146746_, p_146747_, p_146748_, p_146749_, p_146750_);
    }

    public void setIsInterested(boolean p_30445_) {
        this.f_19804_.m_135381_(DATA_INTERESTED_ID, (Object)p_30445_);
    }

    public boolean m_7848_(Animal p_30392_) {
        if (p_30392_ == this) {
            return false;
        }
        if (!this.m_21824_()) {
            return false;
        }
        if (!(p_30392_ instanceof ThornWolf)) {
            return false;
        }
        ThornWolf wolf = (ThornWolf)p_30392_;
        if (!wolf.m_21824_()) {
            return false;
        }
        if (wolf.m_21825_()) {
            return false;
        }
        return this.m_27593_() && wolf.m_27593_();
    }

    public boolean isInterested() {
        return (Boolean)this.f_19804_.m_135370_(DATA_INTERESTED_ID);
    }

    public boolean m_7757_(LivingEntity p_30389_, LivingEntity p_30390_) {
        if (!(p_30389_ instanceof Creeper) && !(p_30389_ instanceof Ghast)) {
            if (p_30389_ instanceof ThornWolf) {
                ThornWolf wolf = (ThornWolf)p_30389_;
                return !wolf.m_21824_() || wolf.m_21826_() != p_30390_;
            }
            if (p_30389_ instanceof Player && p_30390_ instanceof Player && !((Player)p_30390_).m_7099_((Player)p_30389_)) {
                return false;
            }
            if (p_30389_ instanceof AbstractHorse && ((AbstractHorse)p_30389_).m_30614_()) {
                return false;
            }
            return !(p_30389_ instanceof TamableAnimal) || !((TamableAnimal)p_30389_).m_21824_();
        }
        return false;
    }

    public boolean m_6573_(Player p_30396_) {
        return !this.m_21660_() && super.m_6573_(p_30396_);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public static boolean checkWolfSpawnRules(EntityType<ThornWolf> p_186244_, LevelAccessor p_186245_, MobSpawnType p_186246_, BlockPos p_186247_, Random p_186248_) {
        return p_186245_.m_8055_(p_186247_.m_7495_()).m_204336_(BlockTags.f_184236_) && ThornWolf.m_186209_((BlockAndTintGetter)p_186245_, (BlockPos)p_186247_);
    }

    class WolfAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final ThornWolf wolf;

        public WolfAvoidEntityGoal(ThornWolf p_30454_, Class<T> p_30455_, float p_30456_, double p_30457_, double p_30458_) {
            super((PathfinderMob)p_30454_, p_30455_, p_30456_, p_30457_, p_30458_);
            this.wolf = p_30454_;
        }

        public boolean m_8036_() {
            if (super.m_8036_() && this.f_25016_ instanceof Blaze) {
                return !this.wolf.m_21824_() && this.avoidBlaze((Blaze)this.f_25016_);
            }
            return false;
        }

        private boolean avoidBlaze(Blaze p_30461_) {
            return 5 >= ThornWolf.this.f_19796_.m_188503_(5);
        }

        public void m_8056_() {
            ThornWolf.this.m_6710_(null);
            super.m_8056_();
        }

        public void m_8037_() {
            ThornWolf.this.m_6710_(null);
            super.m_8037_();
        }
    }
}

