/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs.silverfishcreeper;

import com.minecraftserverzone.weirdmobs.entities.mobs.silverfishcreeper.SilverfishCreeperSwellGoal;
import java.util.Collection;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.ForgeEventFactory;

public class SilverfishCreeper
extends Monster
implements PowerableMob {
    private SilverfishWakeUpFriendsGoal friendsGoal;
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(SilverfishCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_POWERED = SynchedEntityData.m_135353_(SilverfishCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_IGNITED = SynchedEntityData.m_135353_(SilverfishCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int oldSwell;
    private int swell;
    private int maxSwell = 10;
    private int explosionRadius = 1;

    public SilverfishCreeper(EntityType<? extends SilverfishCreeper> p_33523_, Level p_33524_) {
        super(p_33523_, p_33524_);
    }

    protected void m_8099_() {
        this.friendsGoal = new SilverfishWakeUpFriendsGoal(this);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SilverfishCreeperSwellGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)this.friendsGoal);
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(6, (Goal)new SilverfishMergeWithStoneGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public boolean m_142535_(float p_149687_, float p_149688_, DamageSource p_149689_) {
        boolean flag = super.m_142535_(p_149687_, p_149688_, p_149689_);
        this.swell = (int)((float)this.swell + p_149687_ * 1.5f);
        if (this.swell > this.maxSwell - 5) {
            this.swell = this.maxSwell - 5;
        }
        return flag;
    }

    public int m_6056_() {
        return this.m_5448_() == null ? 3 : 3 + (int)(this.m_21223_() - 1.0f);
    }

    public double m_6049_() {
        return 0.1;
    }

    protected float m_6431_(Pose p_33540_, EntityDimensions p_33541_) {
        return 0.13f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 1.0);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12419_;
    }

    protected SoundEvent m_7975_(DamageSource p_33549_) {
        return SoundEvents.f_12421_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12420_;
    }

    protected void m_7355_(BlockPos p_33543_, BlockState p_33544_) {
        this.m_5496_(SoundEvents.f_12422_, 0.15f, 1.0f);
    }

    public boolean m_6469_(DamageSource p_33527_, float p_33528_) {
        if (this.m_6673_(p_33527_)) {
            return false;
        }
        if ((p_33527_ instanceof EntityDamageSource || p_33527_ == DamageSource.f_19319_) && this.friendsGoal != null) {
            this.friendsGoal.notifyHurt();
        }
        return super.m_6469_(p_33527_, p_33528_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)-1);
        this.f_19804_.m_135372_(DATA_IS_POWERED, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_IGNITED, (Object)false);
    }

    public void m_7380_(CompoundTag p_32304_) {
        super.m_7380_(p_32304_);
        if (((Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED)).booleanValue()) {
            p_32304_.m_128379_("powered", true);
        }
        p_32304_.m_128376_("Fuse", (short)this.maxSwell);
        p_32304_.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
        p_32304_.m_128379_("ignited", this.isIgnited());
    }

    public void m_7378_(CompoundTag p_32296_) {
        super.m_7378_(p_32296_);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)p_32296_.m_128471_("powered"));
        if (p_32296_.m_128425_("Fuse", 99)) {
            this.maxSwell = p_32296_.m_128448_("Fuse");
        }
        if (p_32296_.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = p_32296_.m_128445_("ExplosionRadius");
        }
        if (p_32296_.m_128471_("ignited")) {
            this.ignite();
        }
    }

    public void m_8119_() {
        this.f_20883_ = this.m_146908_();
        if (this.m_6084_()) {
            int i;
            this.oldSwell = this.swell;
            if (this.isIgnited()) {
                this.setSwellDir(1);
            }
            if ((i = this.getSwellDir()) > 0 && this.swell == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explodeCreeper();
            }
        }
        super.m_8119_();
    }

    public void m_6710_(@Nullable LivingEntity p_149691_) {
        if (!(p_149691_ instanceof Goat)) {
            super.m_6710_(p_149691_);
        }
    }

    public boolean m_7327_(Entity p_32281_) {
        return true;
    }

    public boolean m_7090_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED);
    }

    public float getSwelling(float p_32321_) {
        return Mth.m_14179_((float)p_32321_, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void setSwellDir(int p_32284_) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)p_32284_);
    }

    public void m_8038_(ServerLevel p_32286_, LightningBolt p_32287_) {
        super.m_8038_(p_32286_, p_32287_);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)true);
    }

    protected InteractionResult m_6071_(Player p_32301_, InteractionHand p_32302_) {
        ItemStack itemstack = p_32301_.m_21120_(p_32302_);
        if (itemstack.m_150930_(Items.f_42409_)) {
            this.f_19853_.m_6263_(p_32301_, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11942_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            if (!this.f_19853_.f_46443_) {
                this.ignite();
                itemstack.m_41622_(1, (LivingEntity)p_32301_, p_32290_ -> p_32290_.m_21190_(p_32302_));
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(p_32301_, p_32302_);
    }

    private void explodeCreeper() {
        if (!this.f_19853_.f_46443_) {
            Explosion.BlockInteraction explosion$blockinteraction = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
            float f = this.m_7090_() ? 2.0f : 1.0f;
            this.f_20890_ = true;
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.explosionRadius * f, explosion$blockinteraction);
            this.m_146870_();
            this.spawnLingeringCloud();
        }
    }

    private void spawnLingeringCloud() {
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloud.m_19712_(2.5f);
            areaeffectcloud.m_19732_(-0.5f);
            areaeffectcloud.m_19740_(10);
            areaeffectcloud.m_19734_(areaeffectcloud.m_19748_() / 2);
            areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
            for (MobEffectInstance mobeffectinstance : collection) {
                areaeffectcloud.m_19716_(new MobEffectInstance(mobeffectinstance));
            }
            this.f_19853_.m_7967_((Entity)areaeffectcloud);
        }
    }

    public boolean isIgnited() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_IGNITED);
    }

    public void ignite() {
        this.f_19804_.m_135381_(DATA_IS_IGNITED, (Object)true);
    }

    public void m_5618_(float p_33553_) {
        this.m_146922_(p_33553_);
        super.m_5618_(p_33553_);
    }

    public float m_5610_(BlockPos p_33530_, LevelReader p_33531_) {
        return InfestedBlock.m_54195_((BlockState)p_33531_.m_8055_(p_33530_.m_7495_())) ? 10.0f : super.m_5610_(p_33530_, p_33531_);
    }

    public static boolean checkSliverfishSpawnRules(EntityType<SilverfishCreeper> p_33534_, ServerLevelAccessor p_33535_, MobSpawnType p_33536_, BlockPos p_33537_, RandomSource p_33538_) {
        if (SilverfishCreeper.m_219019_(p_33534_, (LevelAccessor)p_33535_, (MobSpawnType)p_33536_, (BlockPos)p_33537_, (RandomSource)p_33538_)) {
            Player player = p_33535_.m_45924_((double)p_33537_.m_123341_() + 0.5, (double)p_33537_.m_123342_() + 0.5, (double)p_33537_.m_123343_() + 0.5, 5.0, true);
            return player == null;
        }
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    static class SilverfishWakeUpFriendsGoal
    extends Goal {
        private final SilverfishCreeper silverfish;
        private int lookForFriends;

        public SilverfishWakeUpFriendsGoal(SilverfishCreeper p_33565_) {
            this.silverfish = p_33565_;
        }

        public void notifyHurt() {
            if (this.lookForFriends == 0) {
                this.lookForFriends = 20;
            }
        }

        public boolean m_8036_() {
            return this.lookForFriends > 0;
        }

        public void m_8037_() {
            --this.lookForFriends;
            if (this.lookForFriends <= 0) {
                Level level = this.silverfish.f_19853_;
                RandomSource random = this.silverfish.m_217043_();
                BlockPos blockpos = this.silverfish.m_20183_();
                int i = 0;
                while (i <= 5 && i >= -5) {
                    int j = 0;
                    while (j <= 10 && j >= -10) {
                        int k = 0;
                        while (k <= 10 && k >= -10) {
                            BlockPos blockpos1 = blockpos.m_7918_(j, i, k);
                            BlockState blockstate = level.m_8055_(blockpos1);
                            Block block = blockstate.m_60734_();
                            if (block instanceof InfestedBlock) {
                                if (ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)this.silverfish)) {
                                    level.m_46953_(blockpos1, true, (Entity)this.silverfish);
                                } else {
                                    level.m_7731_(blockpos1, ((InfestedBlock)block).m_153432_(level.m_8055_(blockpos1)), 3);
                                }
                                if (random.m_188499_()) {
                                    return;
                                }
                            }
                            k = (k <= 0 ? 1 : 0) - k;
                        }
                        j = (j <= 0 ? 1 : 0) - j;
                    }
                    i = (i <= 0 ? 1 : 0) - i;
                }
            }
        }
    }

    static class SilverfishMergeWithStoneGoal
    extends RandomStrollGoal {
        private Direction selectedDirection;
        private boolean doMerge;

        public SilverfishMergeWithStoneGoal(SilverfishCreeper p_33558_) {
            super((PathfinderMob)p_33558_, 1.0, 10);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.f_25725_.m_5448_() != null) {
                return false;
            }
            if (!this.f_25725_.m_21573_().m_26571_()) {
                return false;
            }
            RandomSource random = this.f_25725_.m_217043_();
            if (ForgeEventFactory.getMobGriefingEvent((Level)this.f_25725_.f_19853_, (Entity)this.f_25725_) && random.m_188503_(10) == 0) {
                this.selectedDirection = Direction.m_235672_((RandomSource)random);
                BlockPos blockpos = new BlockPos(this.f_25725_.m_20185_(), this.f_25725_.m_20186_() + 0.5, this.f_25725_.m_20189_()).m_121945_(this.selectedDirection);
                BlockState blockstate = this.f_25725_.f_19853_.m_8055_(blockpos);
                if (InfestedBlock.m_54195_((BlockState)blockstate)) {
                    this.doMerge = true;
                    return true;
                }
            }
            this.doMerge = false;
            return super.m_8036_();
        }

        public boolean m_8045_() {
            return this.doMerge ? false : super.m_8045_();
        }

        public void m_8056_() {
            if (!this.doMerge) {
                super.m_8056_();
            } else {
                Level levelaccessor = this.f_25725_.f_19853_;
                BlockPos blockpos = new BlockPos(this.f_25725_.m_20185_(), this.f_25725_.m_20186_() + 0.5, this.f_25725_.m_20189_()).m_121945_(this.selectedDirection);
                BlockState blockstate = levelaccessor.m_8055_(blockpos);
                if (InfestedBlock.m_54195_((BlockState)blockstate)) {
                    levelaccessor.m_7731_(blockpos, InfestedBlock.m_153430_((BlockState)blockstate), 3);
                    this.f_25725_.m_21373_();
                    this.f_25725_.m_146870_();
                }
            }
        }
    }
}

