/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs.rabbitwolf;

import com.minecraftserverzone.weirdmobs.setup.Registrations;
import java.util.EnumSet;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarrotBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class RabbitWolfEntity
extends TamableAnimal
implements NeutralMob {
    private static final EntityDataAccessor<Boolean> DATA_INTERESTED_ID = SynchedEntityData.m_135353_(RabbitWolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(RabbitWolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(RabbitWolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Predicate<LivingEntity> PREY_SELECTOR = p_30437_ -> {
        EntityType entitytype = p_30437_.m_6095_();
        return entitytype == EntityType.f_20520_ || entitytype == EntityType.f_20517_ || entitytype == EntityType.f_20452_;
    };
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private UUID persistentAngerTarget;
    public static final double STROLL_SPEED_MOD = 0.6;
    public static final double BREED_SPEED_MOD = 0.8;
    public static final double FOLLOW_SPEED_MOD = 1.0;
    public static final double FLEE_SPEED_MOD = 2.2;
    public static final double ATTACK_SPEED_MOD = 1.4;
    public static final int TYPE_BROWN = 0;
    public static final int TYPE_WHITE = 1;
    public static final int TYPE_BLACK = 2;
    public static final int TYPE_WHITE_SPLOTCHED = 3;
    public static final int TYPE_GOLD = 4;
    public static final int TYPE_SALT = 5;
    public static final int TYPE_EVIL = 99;
    public static final int EVIL_ATTACK_POWER = 8;
    public static final int EVIL_ARMOR_VALUE = 8;
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int jumpDelayTicks;
    int moreCarrotTicks;

    public RabbitWolfEntity(EntityType<? extends RabbitWolfEntity> p_29656_, Level p_29657_) {
        super(p_29656_, p_29657_);
        this.f_21343_ = new RabbitJumpControl(this);
        this.f_21342_ = new RabbitMoveControl(this);
        this.f_21364_ = 3;
        this.setSpeedModifier(0.0);
        this.m_7105_(false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RabbitPanicGoal(this, 2.2));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42619_, Items.f_42677_, Blocks.f_50111_}), false));
        this.f_21345_.m_25352_(5, (Goal)new RaidGardenGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(9, (Goal)new BegGoal(this, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((RabbitWolfEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, PREY_SELECTOR));
        this.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.f_30122_));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 7.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected float m_6118_() {
        if (!(this.f_19862_ || this.f_21342_.m_24995_() && this.f_21342_.m_25001_() > this.m_20186_() + 0.5)) {
            Path path = this.f_21344_.m_26570_();
            if (path != null && !path.m_77392_()) {
                Vec3 vec3 = path.m_77380_((Entity)this);
                if (vec3.f_82480_ > this.m_20186_() + 0.5) {
                    return 0.5f;
                }
            }
            return this.f_21342_.m_24999_() <= 0.6 ? 0.2f : 0.3f;
        }
        return 0.5f;
    }

    protected void m_6135_() {
        double d1;
        super.m_6135_();
        double d0 = this.f_21342_.m_24999_();
        if (d0 > 0.0 && (d1 = this.m_20184_().m_165925_()) < 0.01) {
            this.m_19920_(0.1f, new Vec3(0.0, 0.0, 1.0));
        }
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_7605_((Entity)this, (byte)1);
        }
    }

    public static boolean checkAnimalSpawnRules(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, Random rand) {
        return world.m_45524_(pos, 0) > 8 && world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_);
    }

    public float getJumpCompletion(float p_29736_) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + p_29736_) / (float)this.jumpDuration;
    }

    public void setSpeedModifier(double p_29726_) {
        this.m_21573_().m_26517_(p_29726_);
        this.f_21342_.m_6849_(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_(), p_29726_);
    }

    public void m_6862_(boolean p_29732_) {
        super.m_6862_(p_29732_);
        if (p_29732_) {
            this.m_5496_(this.getJumpSound(), this.m_6121_(), ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void startJumping() {
        this.m_6862_(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_INTERESTED_ID, (Object)false);
        this.f_19804_.m_135372_(COLOR, (Object)(this.f_19796_.m_188503_(3) + 0));
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public void m_8024_() {
        if (this.jumpDelayTicks > 0) {
            --this.jumpDelayTicks;
        }
        if (this.moreCarrotTicks > 0) {
            this.moreCarrotTicks -= this.f_19796_.m_188503_(3);
            if (this.moreCarrotTicks < 0) {
                this.moreCarrotTicks = 0;
            }
        }
        if (this.f_19861_) {
            RabbitJumpControl rabbit$rabbitjumpcontrol;
            LivingEntity livingentity;
            if (!this.wasOnGround) {
                this.m_6862_(false);
                this.checkLandingDelay();
            }
            if (this.jumpDelayTicks == 0 && (livingentity = this.m_5448_()) != null && this.m_20280_((Entity)livingentity) < 16.0) {
                this.facePoint(livingentity.m_20185_(), livingentity.m_20189_());
                this.f_21342_.m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), this.f_21342_.m_24999_());
                this.startJumping();
                this.wasOnGround = true;
            }
            if (!(rabbit$rabbitjumpcontrol = (RabbitJumpControl)this.f_21343_).wantJump()) {
                if (this.f_21342_.m_24995_() && this.jumpDelayTicks == 0) {
                    Path path = this.f_21344_.m_26570_();
                    Vec3 vec3 = new Vec3(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_());
                    if (path != null && !path.m_77392_()) {
                        vec3 = path.m_77380_((Entity)this);
                    }
                    this.facePoint(vec3.f_82479_, vec3.f_82481_);
                    this.startJumping();
                }
            } else if (!rabbit$rabbitjumpcontrol.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.f_19861_;
    }

    public boolean m_5843_() {
        return false;
    }

    private void facePoint(double p_29687_, double p_29688_) {
        this.m_146922_((float)(Mth.m_14136_((double)(p_29688_ - this.m_20189_()), (double)(p_29687_ - this.m_20185_())) * 57.2957763671875) - 90.0f);
    }

    private void enableJumpControl() {
        ((RabbitJumpControl)this.f_21343_).setCanJump(true);
    }

    private void disableJumpControl() {
        ((RabbitJumpControl)this.f_21343_).setCanJump(false);
    }

    private void setLandingDelay() {
        this.jumpDelayTicks = this.f_21342_.m_24999_() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.setLandingDelay();
        this.disableJumpControl();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.m_6862_(false);
        }
        if (!this.f_19853_.f_46443_) {
            this.m_21666_((ServerLevel)this.f_19853_, true);
        }
    }

    public void m_7380_(CompoundTag p_29697_) {
        super.m_7380_(p_29697_);
        p_29697_.m_128405_("MoreCarrotTicks", this.moreCarrotTicks);
        this.m_21678_(p_29697_);
    }

    public void m_7378_(CompoundTag p_29684_) {
        super.m_7378_(p_29684_);
        this.moreCarrotTicks = p_29684_.m_128451_("MoreCarrotTicks");
        this.m_147285_(this.f_19853_, p_29684_);
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.f_12354_;
    }

    protected SoundEvent m_7515_() {
        if (this.m_21660_()) {
            return SoundEvents.f_12619_;
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            return this.m_21824_() && this.m_21223_() < 10.0f ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
        }
        return SoundEvents.f_12617_;
    }

    protected SoundEvent m_7975_(DamageSource p_29715_) {
        return SoundEvents.f_12621_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    protected float m_6121_() {
        return 1.0f;
    }

    public boolean m_6469_(DamageSource p_30386_, float p_30387_) {
        if (this.m_6673_(p_30386_)) {
            return false;
        }
        Entity entity = p_30386_.m_7639_();
        this.m_21839_(false);
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            p_30387_ = (p_30387_ + 1.0f) / 2.0f;
        }
        return super.m_6469_(p_30386_, p_30387_);
    }

    public boolean m_7327_(Entity p_30372_) {
        boolean flag = p_30372_.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, p_30372_);
        }
        return flag;
    }

    public void m_7105_(boolean p_30443_) {
        super.m_7105_(p_30443_);
        if (p_30443_) {
            this.m_21051_(Attributes.f_22276_).m_22100_(18.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(7.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(4.0);
    }

    public InteractionResult m_6071_(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.m_21120_(p_30413_);
        Item item = itemstack.m_41720_();
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)p_30412_) || this.m_21824_() || itemstack.m_150930_(Items.f_42500_) && !this.m_21824_() && !this.m_21660_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                if (!p_30412_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5634_(item.m_41473_().m_38744_());
                this.m_146850_(GameEvent.f_223708_);
                return InteractionResult.SUCCESS;
            }
            if (!(item instanceof DyeItem)) {
                InteractionResult interactionresult = super.m_6071_(p_30412_, p_30413_);
                if ((!interactionresult.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)p_30412_)) {
                    this.m_21839_(!this.m_21827_());
                    this.f_20899_ = false;
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    return InteractionResult.SUCCESS;
                }
                return interactionresult;
            }
        } else if (itemstack.m_150930_(Items.f_42500_) && !this.m_21660_()) {
            if (!p_30412_.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)p_30412_)) {
                this.m_21828_(p_30412_);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(p_30412_, p_30413_);
    }

    public SoundSource m_5720_() {
        return SoundSource.NEUTRAL;
    }

    private static boolean isTemptingItem(ItemStack p_149038_) {
        return p_149038_.m_150930_(Items.f_42619_) || p_149038_.m_150930_(Items.f_42677_) || p_149038_.m_150930_(Blocks.f_50111_.m_5456_());
    }

    public RabbitWolfEntity getBreedOffspring(ServerLevel p_149088_, AgeableMob p_149089_) {
        RabbitWolfEntity wolf = (RabbitWolfEntity)((EntityType)Registrations.RABBIT_WOLF.get()).m_20615_((Level)p_149088_);
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            wolf.m_21816_(uuid);
            wolf.m_7105_(true);
        }
        return wolf;
    }

    public boolean m_6898_(ItemStack p_30440_) {
        Item item = p_30440_.m_41720_();
        return item.m_41472_() && item.m_41473_().m_38746_() || RabbitWolfEntity.isTemptingItem(p_30440_);
    }

    public static boolean checkRabbitSpawnRules(EntityType<RabbitWolfEntity> p_29699_, LevelAccessor p_29700_, MobSpawnType p_29701_, BlockPos p_29702_, Random p_29703_) {
        BlockState blockstate = p_29700_.m_8055_(p_29702_.m_7495_());
        return (blockstate.m_60713_(Blocks.f_50440_) || blockstate.m_60713_(Blocks.f_50125_) || blockstate.m_60713_(Blocks.f_49992_)) && p_29700_.m_45524_(p_29702_, 0) > 8;
    }

    boolean wantsMoreFood() {
        return this.moreCarrotTicks == 0;
    }

    public void m_7822_(byte p_29663_) {
        if (p_29663_ == 1) {
            this.m_20076_();
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.m_7822_(p_29663_);
        }
    }

    public int getTextureColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    public void setTextureColor(int p_30404_) {
        this.f_19804_.m_135381_(COLOR, (Object)p_30404_);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int p_30404_) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID p_30400_) {
        this.persistentAngerTarget = p_30400_;
    }

    public void setIsInterested(boolean p_30445_) {
        this.f_19804_.m_135381_(DATA_INTERESTED_ID, (Object)p_30445_);
    }

    public boolean isInterested() {
        return (Boolean)this.f_19804_.m_135370_(DATA_INTERESTED_ID);
    }

    public boolean m_7848_(Animal p_30392_) {
        if (p_30392_ == this) {
            return false;
        }
        if (!this.m_21824_()) {
            return false;
        }
        if (!(p_30392_ instanceof RabbitWolfEntity)) {
            return false;
        }
        RabbitWolfEntity wolf = (RabbitWolfEntity)p_30392_;
        if (!wolf.m_21824_()) {
            return false;
        }
        if (wolf.m_21825_()) {
            return false;
        }
        return this.m_27593_() && wolf.m_27593_();
    }

    public boolean m_7757_(LivingEntity p_30389_, LivingEntity p_30390_) {
        if (!(p_30389_ instanceof Creeper) && !(p_30389_ instanceof Ghast)) {
            if (p_30389_ instanceof RabbitWolfEntity) {
                RabbitWolfEntity wolf = (RabbitWolfEntity)p_30389_;
                return !wolf.m_21824_() || wolf.m_21826_() != p_30390_;
            }
            if (p_30389_ instanceof Player && p_30390_ instanceof Player && !((Player)p_30390_).m_7099_((Player)p_30389_)) {
                return false;
            }
            if (p_30389_ instanceof AbstractHorse && ((AbstractHorse)p_30389_).m_30614_()) {
                return false;
            }
            return !(p_30389_ instanceof TamableAnimal) || !((TamableAnimal)p_30389_).m_21824_();
        }
        return false;
    }

    public boolean m_6573_(Player p_30396_) {
        return !this.m_21660_() && super.m_6573_(p_30396_);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public class RabbitJumpControl
    extends JumpControl {
        private final RabbitWolfEntity rabbit;
        private boolean canJump;

        public RabbitJumpControl(RabbitWolfEntity p_29757_) {
            super((Mob)p_29757_);
            this.rabbit = p_29757_;
        }

        public boolean wantJump() {
            return this.f_24897_;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean p_29759_) {
            this.canJump = p_29759_;
        }

        public void m_8124_() {
            if (this.f_24897_) {
                this.rabbit.startJumping();
                this.f_24897_ = false;
            }
        }
    }

    static class RabbitMoveControl
    extends MoveControl {
        private final RabbitWolfEntity rabbit;
        private double nextJumpSpeed;

        public RabbitMoveControl(RabbitWolfEntity p_29766_) {
            super((Mob)p_29766_);
            this.rabbit = p_29766_;
        }

        public void m_8126_() {
            if (this.rabbit.f_19861_ && !this.rabbit.f_20899_ && !((RabbitJumpControl)this.rabbit.f_21343_).wantJump()) {
                this.rabbit.setSpeedModifier(0.0);
            } else if (this.m_24995_()) {
                this.rabbit.setSpeedModifier(this.nextJumpSpeed);
            }
            super.m_8126_();
        }

        public void m_6849_(double p_29769_, double p_29770_, double p_29771_, double p_29772_) {
            if (this.rabbit.m_20069_()) {
                p_29772_ = 1.5;
            }
            super.m_6849_(p_29769_, p_29770_, p_29771_, p_29772_);
            if (p_29772_ > 0.0) {
                this.nextJumpSpeed = p_29772_;
            }
        }
    }

    static class RabbitPanicGoal
    extends PanicGoal {
        private final RabbitWolfEntity rabbit;

        public RabbitPanicGoal(RabbitWolfEntity p_29775_, double p_29776_) {
            super((PathfinderMob)p_29775_, p_29776_);
            this.rabbit = p_29775_;
        }

        public void m_8037_() {
            super.m_8037_();
            this.rabbit.setSpeedModifier(this.f_25685_);
        }
    }

    static class RaidGardenGoal
    extends MoveToBlockGoal {
        private final RabbitWolfEntity rabbit;
        private boolean wantsToRaid;
        private boolean canRaid;

        public RaidGardenGoal(RabbitWolfEntity p_29782_) {
            super((PathfinderMob)p_29782_, (double)0.7f, 16);
            this.rabbit = p_29782_;
        }

        public boolean m_8036_() {
            if (this.f_25600_ <= 0) {
                if (!ForgeEventFactory.getMobGriefingEvent((Level)this.rabbit.f_19853_, (Entity)this.rabbit)) {
                    return false;
                }
                this.canRaid = false;
                this.wantsToRaid = this.rabbit.wantsMoreFood();
                this.wantsToRaid = true;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            return this.canRaid && super.m_8045_();
        }

        public void m_8037_() {
            super.m_8037_();
            this.rabbit.m_21563_().m_24950_((double)this.f_25602_.m_123341_() + 0.5, (double)(this.f_25602_.m_123342_() + 1), (double)this.f_25602_.m_123343_() + 0.5, 10.0f, (float)this.rabbit.m_8132_());
            if (this.m_25625_()) {
                Level level = this.rabbit.f_19853_;
                BlockPos blockpos = this.f_25602_.m_7494_();
                BlockState blockstate = level.m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (this.canRaid && block instanceof CarrotBlock) {
                    int i = (Integer)blockstate.m_61143_((Property)CarrotBlock.f_52244_);
                    if (i == 0) {
                        level.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 2);
                        level.m_46953_(blockpos, true, (Entity)this.rabbit);
                    } else {
                        level.m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)CarrotBlock.f_52244_, (Comparable)Integer.valueOf(i - 1)), 2);
                        level.m_46796_(2001, blockpos, Block.m_49956_((BlockState)blockstate));
                    }
                    this.rabbit.moreCarrotTicks = 40;
                }
                this.canRaid = false;
                this.f_25600_ = 10;
            }
        }

        protected boolean m_6465_(LevelReader p_29785_, BlockPos p_29786_) {
            BlockState blockstate = p_29785_.m_8055_(p_29786_);
            if (blockstate.m_60713_(Blocks.f_50093_) && this.wantsToRaid && !this.canRaid && (blockstate = p_29785_.m_8055_(p_29786_.m_7494_())).m_60734_() instanceof CarrotBlock && ((CarrotBlock)blockstate.m_60734_()).m_52307_(blockstate)) {
                this.canRaid = true;
                return true;
            }
            return false;
        }
    }

    public class BegGoal
    extends Goal {
        private final RabbitWolfEntity wolf;
        private Player player;
        private final Level level;
        private final float lookDistance;
        private int lookTime;
        private final TargetingConditions begTargeting;

        public BegGoal(RabbitWolfEntity p_25063_, float p_25064_) {
            this.wolf = p_25063_;
            this.level = p_25063_.f_19853_;
            this.lookDistance = p_25064_;
            this.begTargeting = TargetingConditions.m_148353_().m_26883_((double)p_25064_);
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            this.player = this.level.m_45946_(this.begTargeting, (LivingEntity)this.wolf);
            return this.player == null ? false : this.playerHoldingInteresting(this.player);
        }

        public boolean m_8045_() {
            if (!this.player.m_6084_()) {
                return false;
            }
            if (this.wolf.m_20280_((Entity)this.player) > (double)(this.lookDistance * this.lookDistance)) {
                return false;
            }
            return this.lookTime > 0 && this.playerHoldingInteresting(this.player);
        }

        public void m_8056_() {
            this.wolf.setIsInterested(true);
            this.lookTime = 40 + this.wolf.m_217043_().m_188503_(40);
        }

        public void m_8041_() {
            this.wolf.setIsInterested(false);
            this.player = null;
        }

        public void m_8037_() {
            this.wolf.m_21563_().m_24950_(this.player.m_20185_(), this.player.m_20188_(), this.player.m_20189_(), 10.0f, (float)this.wolf.m_8132_());
            --this.lookTime;
        }

        private boolean playerHoldingInteresting(Player p_25067_) {
            for (InteractionHand interactionhand : InteractionHand.values()) {
                ItemStack itemstack = p_25067_.m_21120_(interactionhand);
                if (this.wolf.m_21824_() && itemstack.m_150930_(Items.f_42500_)) {
                    return true;
                }
                if (!this.wolf.m_6898_(itemstack)) continue;
                return true;
            }
            return false;
        }
    }

    static class EvilRabbitAttackGoal
    extends MeleeAttackGoal {
        public EvilRabbitAttackGoal(RabbitWolfEntity p_29738_) {
            super((PathfinderMob)p_29738_, 1.4, true);
        }

        protected double m_6639_(LivingEntity p_29740_) {
            return 4.0f + p_29740_.m_20205_();
        }
    }
}

