/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs.phantomfox;

import com.google.common.collect.ImmutableList;
import com.minecraftserverzone.weirdmobs.entities.mobs.phantomfox.PhantomFox;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class PhantomFoxModel<T extends PhantomFox>
extends AgeableListModel<T> {
    public final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;
    private final ModelPart ribs;
    private static final int LEG_SIZE = 6;
    private static final float HEAD_HEIGHT = 16.5f;
    private static final float LEG_POS = 17.5f;
    private float legMotionPos;

    public PhantomFoxModel(ModelPart p_170566_) {
        super(true, 8.0f, 3.35f);
        this.head = p_170566_.m_171324_("head");
        this.body = p_170566_.m_171324_("body");
        this.rightHindLeg = p_170566_.m_171324_("right_hind_leg");
        this.leftHindLeg = p_170566_.m_171324_("left_hind_leg");
        this.rightFrontLeg = p_170566_.m_171324_("right_front_leg");
        this.leftFrontLeg = p_170566_.m_171324_("left_front_leg");
        this.tail = this.body.m_171324_("tail");
        this.ribs = this.body.m_171324_("ribs");
    }

    public static LayerDefinition createBones() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition partdefinition1 = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(6, 32).m_171481_(-1.0f, -1.0f, -2.1f, 4.0f, 1.0f, 3.0f), PartPose.m_171419_((float)-1.0f, (float)16.5f, (float)-3.0f));
        partdefinition1.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), PartPose.f_171404_);
        partdefinition1.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), PartPose.f_171404_);
        partdefinition1.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), PartPose.f_171404_);
        PartDefinition partdefinition2 = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(37, 32).m_171481_(-1.0f, 4.0f, -0.5f, 2.0f, 11.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)-6.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition2.m_171599_("ribs", CubeListBuilder.m_171558_().m_171514_(3, 36).m_171481_(-1.5f, -0.1f, 0.0f, 5.0f, 4.0f, 3.0f), PartPose.m_171419_((float)-1.0f, (float)5.0f, (float)-3.0f));
        CubeDeformation cubedeformation = new CubeDeformation(0.001f);
        partdefinition.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(3.0f, -2.5f, -1.0f, 1.0f, 2.0f, 2.0f, cubedeformation), PartPose.m_171419_((float)-5.0f, (float)17.5f, (float)7.0f));
        partdefinition.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(31, 32).m_171488_(2.0f, -2.5f, -1.0f, 1.0f, 2.0f, 2.0f, cubedeformation), PartPose.m_171419_((float)-1.0f, (float)17.5f, (float)7.0f));
        partdefinition.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(25, 32).m_171488_(3.0f, -3.5f, -1.0f, 1.0f, 3.0f, 2.0f, cubedeformation), PartPose.m_171419_((float)-5.0f, (float)17.5f, (float)0.0f));
        partdefinition.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(25, 37).m_171488_(2.0f, -3.5f, -1.0f, 1.0f, 3.0f, 2.0f, cubedeformation), PartPose.m_171419_((float)-1.0f, (float)17.5f, (float)0.0f));
        partdefinition2.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(19, 35).m_171481_(3.0f, 0.5f, 1.5f, 2.0f, 7.0f, 1.0f), PartPose.m_171423_((float)-4.0f, (float)15.0f, (float)-1.0f, (float)-0.05235988f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)48, (int)64);
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition partdefinition1 = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(1, 5).m_171481_(-3.0f, -2.0f, -5.0f, 8.0f, 6.0f, 6.0f), PartPose.m_171419_((float)-1.0f, (float)16.5f, (float)-3.0f));
        partdefinition1.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(8, 1).m_171481_(-3.0f, -4.0f, -4.0f, 2.01f, 2.01f, 1.0f), PartPose.f_171404_);
        partdefinition1.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(15, 1).m_171481_(3.0f, -4.0f, -4.0f, 1.99f, 2.01f, 1.0f), PartPose.f_171404_);
        partdefinition1.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(6, 18).m_171481_(-1.0f, 2.01f, -8.1f, 4.0f, 2.01f, 3.0f), PartPose.f_171404_);
        PartDefinition partdefinition2 = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(24, 15).m_171481_(-3.0f, 3.999f, -3.5f, 6.0f, 11.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)-6.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition2.m_171599_("ribs", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), PartPose.f_171404_);
        CubeDeformation cubedeformation = new CubeDeformation(0.001f);
        CubeListBuilder cubelistbuilder = CubeListBuilder.m_171558_().m_171514_(4, 24).m_171488_(2.0f, 0.5f, -1.0f, 2.0f, 6.0f, 2.0f, cubedeformation);
        CubeListBuilder cubelistbuilder1 = CubeListBuilder.m_171558_().m_171514_(13, 24).m_171488_(2.0f, 0.5f, -1.0f, 2.0f, 6.0f, 2.0f, cubedeformation);
        partdefinition.m_171599_("right_hind_leg", cubelistbuilder1, PartPose.m_171419_((float)-5.0f, (float)17.5f, (float)7.0f));
        partdefinition.m_171599_("left_hind_leg", cubelistbuilder, PartPose.m_171419_((float)-1.0f, (float)17.5f, (float)7.0f));
        partdefinition.m_171599_("right_front_leg", cubelistbuilder1, PartPose.m_171419_((float)-5.0f, (float)17.5f, (float)0.0f));
        partdefinition.m_171599_("left_front_leg", cubelistbuilder, PartPose.m_171419_((float)-1.0f, (float)17.5f, (float)0.0f));
        partdefinition2.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(30, 0).m_171481_(2.0f, 0.0f, -1.0f, 4.0f, 9.0f, 5.0f), PartPose.m_171423_((float)-4.0f, (float)15.0f, (float)-1.0f, (float)-0.05235988f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)48, (int)64);
    }

    public void prepareMobModel(T p_102664_, float p_102665_, float p_102666_, float p_102667_) {
        this.body.f_104203_ = 1.5707964f;
        this.tail.f_104203_ = -0.05235988f;
        this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(p_102665_ * 0.6662f)) * 1.4f * p_102666_;
        this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(p_102665_ * 0.6662f + (float)Math.PI)) * 1.4f * p_102666_;
        this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(p_102665_ * 0.6662f + (float)Math.PI)) * 1.4f * p_102666_;
        this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(p_102665_ * 0.6662f)) * 1.4f * p_102666_;
        this.head.m_104227_(-1.0f, 16.5f, -3.0f);
        this.head.f_104204_ = 0.0f;
        this.head.f_104205_ = ((PhantomFox)((Object)p_102664_)).getHeadRollAngle(p_102667_);
        this.rightHindLeg.f_104207_ = true;
        this.leftHindLeg.f_104207_ = true;
        this.rightFrontLeg.f_104207_ = true;
        this.leftFrontLeg.f_104207_ = true;
        this.body.m_104227_(0.0f, 16.0f, -6.0f);
        this.body.f_104205_ = 0.0f;
        this.rightHindLeg.m_104227_(-5.0f, 17.5f, 7.0f);
        this.leftHindLeg.m_104227_(-1.0f, 17.5f, 7.0f);
        if (((PhantomFox)((Object)p_102664_)).m_6047_()) {
            this.body.f_104203_ = 1.6755161f;
            float f = ((PhantomFox)((Object)p_102664_)).getCrouchAmount(p_102667_);
            this.body.m_104227_(0.0f, 16.0f + ((PhantomFox)((Object)p_102664_)).getCrouchAmount(p_102667_), -6.0f);
            this.head.m_104227_(-1.0f, 16.5f + f, -3.0f);
            this.head.f_104204_ = 0.0f;
        } else if (((PhantomFox)((Object)p_102664_)).m_5803_()) {
            this.body.f_104205_ = -1.5707964f;
            this.body.m_104227_(0.0f, 21.0f, -6.0f);
            this.tail.f_104203_ = -2.6179938f;
            if (this.f_102610_) {
                this.tail.f_104203_ = -2.1816616f;
                this.body.m_104227_(0.0f, 21.0f, -2.0f);
            }
            this.head.m_104227_(1.0f, 19.49f, -3.0f);
            this.head.f_104203_ = 0.0f;
            this.head.f_104204_ = -2.0943952f;
            this.head.f_104205_ = 0.0f;
            this.rightHindLeg.f_104207_ = false;
            this.leftHindLeg.f_104207_ = false;
            this.rightFrontLeg.f_104207_ = false;
            this.leftFrontLeg.f_104207_ = false;
        } else if (p_102664_.m_21825_()) {
            this.body.f_104203_ = 0.5235988f;
            this.body.m_104227_(0.0f, 9.0f, -3.0f);
            this.tail.f_104203_ = 0.7853982f;
            this.tail.m_104227_(-4.0f, 15.0f, -2.0f);
            this.head.m_104227_(-1.0f, 10.0f, -0.25f);
            this.head.f_104203_ = 0.0f;
            this.head.f_104204_ = 0.0f;
            if (this.f_102610_) {
                this.head.m_104227_(-1.0f, 13.0f, -3.75f);
            }
            this.rightHindLeg.f_104203_ = -1.3089969f;
            this.rightHindLeg.m_104227_(-5.0f, 21.5f, 6.75f);
            this.leftHindLeg.f_104203_ = -1.3089969f;
            this.leftHindLeg.m_104227_(-1.0f, 21.5f, 6.75f);
            this.rightFrontLeg.f_104203_ = -0.2617994f;
            this.leftFrontLeg.f_104203_ = -0.2617994f;
        }
    }

    public void m_7695_(PoseStack p_102034_, VertexConsumer p_102035_, int p_102036_, int p_102037_, float p_102038_, float p_102039_, float p_102040_, float p_102041_) {
        super.m_7695_(p_102034_, p_102035_, p_102036_, p_102037_, p_102038_, p_102039_, p_102040_, p_102041_);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg);
    }

    public void setupAnim(T p_102669_, float p_102670_, float p_102671_, float p_102672_, float p_102673_, float p_102674_) {
        if (!(((PhantomFox)((Object)p_102669_)).m_5803_() || ((PhantomFox)((Object)p_102669_)).isFaceplanted() || ((PhantomFox)((Object)p_102669_)).m_6047_())) {
            this.head.f_104203_ = p_102674_ * ((float)Math.PI / 180);
            this.head.f_104204_ = p_102673_ * ((float)Math.PI / 180);
        }
        if (((PhantomFox)((Object)p_102669_)).m_5803_()) {
            this.head.f_104203_ = 0.0f;
            this.head.f_104204_ = -2.0943952f;
            this.head.f_104205_ = Mth.m_14089_((float)(p_102672_ * 0.027f)) / 22.0f;
        }
        if (((PhantomFox)((Object)p_102669_)).m_6047_()) {
            float f;
            this.body.f_104204_ = f = Mth.m_14089_((float)p_102672_) * 0.01f;
            this.rightHindLeg.f_104205_ = f;
            this.leftHindLeg.f_104205_ = f;
            this.rightFrontLeg.f_104205_ = f / 2.0f;
            this.leftFrontLeg.f_104205_ = f / 2.0f;
        }
        if (((PhantomFox)((Object)p_102669_)).isFaceplanted()) {
            float f1 = 0.1f;
            this.legMotionPos += 0.67f;
            this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(this.legMotionPos * 0.4662f)) * 0.1f;
            this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(this.legMotionPos * 0.4662f + (float)Math.PI)) * 0.1f;
            this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(this.legMotionPos * 0.4662f + (float)Math.PI)) * 0.1f;
            this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(this.legMotionPos * 0.4662f)) * 0.1f;
        }
    }
}

