/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs.giantmosquito;

import com.minecraftserverzone.weirdmobs.setup.ModSounds;
import com.minecraftserverzone.weirdmobs.setup.Registrations;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class GiantMosquito
extends Animal
implements NeutralMob,
FlyingAnimal {
    public static final float FLAP_DEGREES_PER_TICK = 120.32113f;
    public static final int TICKS_PER_FLAP = Mth.m_14167_((float)1.4959966f);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(GiantMosquito.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(GiantMosquito.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private UUID persistentAngerTarget;
    private float rollAmount;
    private float rollAmountO;
    private int underWaterTicks;
    private int abdomenSize = 0;

    public GiantMosquito(EntityType<? extends GiantMosquito> p_27717_, Level p_27718_) {
        super(p_27717_, p_27718_);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public float m_5610_(BlockPos p_27788_, LevelReader p_27789_) {
        return p_27789_.m_8055_(p_27788_).m_60795_() ? 10.0f : 0.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)1.4f, true));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.6));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public boolean canBreakDoors() {
        return false;
    }

    public void m_7380_(CompoundTag p_27823_) {
        super.m_7380_(p_27823_);
        this.m_21678_(p_27823_);
    }

    public void m_7378_(CompoundTag p_27793_) {
        super.m_7378_(p_27793_);
        this.m_147285_(this.f_19853_, p_27793_);
    }

    public boolean m_7327_(Entity p_27722_) {
        boolean flag;
        if (this.abdomenSize < 10) {
            this.f_19853_.m_7605_((Entity)this, (byte)4);
        }
        if (flag = p_27722_.m_6469_(DamageSource.m_19364_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)))) {
            this.m_19970_((LivingEntity)this, p_27722_);
            if (p_27722_ instanceof LivingEntity) {
                ((LivingEntity)p_27722_).m_21321_(((LivingEntity)p_27722_).m_21235_() + 1);
                int i = 0;
                if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    i = 10;
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    i = 18;
                }
                if (i > 0) {
                    // empty if block
                }
            }
            this.m_21662_();
            this.m_5496_(SoundEvents.f_11692_, 1.0f, 1.0f);
        }
        return flag;
    }

    public void m_7822_(byte p_27562_) {
        if (p_27562_ == 4) {
            if (this.abdomenSize < 10) {
                ++this.abdomenSize;
            }
        } else if (p_27562_ == 5) {
            if (this.abdomenSize > 0) {
                --this.abdomenSize;
            }
        } else {
            super.m_7822_(p_27562_);
        }
    }

    public int getAbdomenSize() {
        return this.abdomenSize;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 600 == 0 && this.getAbdomenSize() > 0) {
            this.f_19853_.m_7605_((Entity)this, (byte)5);
        }
        this.updateRollAmount();
    }

    void pathfindRandomlyTowards(BlockPos p_27881_) {
        Vec3 vec31;
        Vec3 vec3 = Vec3.m_82539_((Vec3i)p_27881_);
        int i = 0;
        BlockPos blockpos = this.m_20183_();
        int j = (int)vec3.f_82480_ - blockpos.m_123342_();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int i1 = blockpos.m_123333_((Vec3i)p_27881_);
        if (i1 < 15) {
            k = i1 / 2;
            l = i1 / 2;
        }
        if ((vec31 = AirRandomPos.m_148387_((PathfinderMob)this, (int)k, (int)l, (int)i, (Vec3)vec3, (double)0.3141592741012573)) != null) {
            this.f_21344_.m_26529_(0.5f);
            this.f_21344_.m_26519_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 1.0);
        }
    }

    public float getRollAmount(float p_27936_) {
        return Mth.m_14179_((float)p_27936_, (float)this.rollAmountO, (float)this.rollAmount);
    }

    private void updateRollAmount() {
        this.rollAmountO = this.rollAmount;
        this.rollAmount = this.isRolling() ? Math.min(1.0f, this.rollAmount + 0.2f) : Math.max(0.0f, this.rollAmount - 0.24f);
    }

    protected void m_8024_() {
        this.underWaterTicks = this.m_20072_() ? ++this.underWaterTicks : 0;
        if (this.underWaterTicks > 200) {
            this.m_6469_(DamageSource.f_19312_, 1.0f);
        }
        if (!this.f_19853_.f_46443_) {
            this.m_21666_((ServerLevel)this.f_19853_, false);
        }
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int p_27795_) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)p_27795_);
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID p_27791_) {
        this.persistentAngerTarget = p_27791_;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @VisibleForDebug
    public GoalSelector getGoalSelector() {
        return this.f_21345_;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            boolean flag = this.m_21660_() && this.m_5448_() != null && this.m_5448_().m_20280_((Entity)this) < 4.0;
            this.setRolling(flag);
        }
    }

    private boolean isRolling() {
        return this.getFlag(2);
    }

    private void setRolling(boolean p_27930_) {
        this.setFlag(2, p_27930_);
    }

    boolean isTooFarAway(BlockPos p_27890_) {
        return !this.closerThan(p_27890_, 32);
    }

    private void setFlag(int p_27833_, boolean p_27834_) {
        if (p_27834_) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) | p_27833_)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & ~p_27833_)));
        }
    }

    private boolean getFlag(int p_27922_) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & p_27922_) != 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 48.0);
    }

    protected PathNavigation m_6037_(Level p_27815_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_27815_){

            public boolean m_6342_(BlockPos p_27947_) {
                return !this.f_26495_.m_8055_(p_27947_.m_7495_()).m_60795_();
            }

            public void m_7638_() {
                super.m_7638_();
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(false);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public boolean m_6898_(ItemStack p_27895_) {
        return p_27895_.m_204117_(ItemTags.f_13149_);
    }

    protected void m_7355_(BlockPos p_27820_, BlockState p_27821_) {
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.MOSQUITO_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_27845_) {
        return SoundEvents.f_11741_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11740_;
    }

    protected float m_6121_() {
        return 0.15f;
    }

    public GiantMosquito getBreedOffspring(ServerLevel p_148760_, AgeableMob p_148761_) {
        return (GiantMosquito)((EntityType)Registrations.GIANT_MOSQUITO.get()).m_20615_((Level)p_148760_);
    }

    protected float m_6431_(Pose p_27804_, EntityDimensions p_27805_) {
        return this.m_6162_() ? p_27805_.f_20378_ * 0.5f : p_27805_.f_20378_ * 0.5f;
    }

    public boolean m_142535_(float p_148750_, float p_148751_, DamageSource p_148752_) {
        return false;
    }

    protected void m_7840_(double p_27754_, boolean p_27755_, BlockState p_27756_, BlockPos p_27757_) {
    }

    public boolean m_142039_() {
        return this.m_29443_() && this.f_19797_ % TICKS_PER_FLAP == 0;
    }

    public boolean m_29443_() {
        return !this.f_19861_;
    }

    public boolean m_6469_(DamageSource p_27762_, float p_27763_) {
        if (this.m_6673_(p_27762_)) {
            return false;
        }
        if (!this.f_19853_.f_46443_) {
            // empty if block
        }
        return super.m_6469_(p_27762_, p_27763_);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected void m_203347_(TagKey<Fluid> p_27825_) {
        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.01, 0.0));
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.5f * this.m_20192_()), (double)(this.m_20205_() * 0.2f));
    }

    boolean closerThan(BlockPos p_27817_, int p_27818_) {
        return p_27817_.m_123314_((Vec3i)this.m_20183_(), (double)p_27818_);
    }
}

