/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs.giantaxolotl;

import com.google.common.collect.ImmutableList;
import com.minecraftserverzone.weirdmobs.entities.mobs.giantaxolotl.GiantAxolotl;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Map;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class GiantAxolotlModel<T extends GiantAxolotl>
extends AgeableListModel<T> {
    public static final float SWIMMING_LEG_XROT = 1.8849558f;
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftArm;
    private final ModelPart leftLeg;
    private final ModelPart rightArm;
    private final ModelPart rightLeg;
    private final ModelPart leftArm2;
    private final ModelPart leftLeg_2;
    private final ModelPart rightArm2;
    private final ModelPart rightLeg2;
    private final ModelPart head2;
    private final ModelPart gill_p1;
    private final ModelPart gill_p2;
    private final ModelPart gill_p3;
    private final ModelPart gill_p4;
    private final ModelPart gill_p5;
    private final ModelPart gill_p6;
    private final ModelPart head3;
    private final ModelPart part3;
    private final ModelPart part9;
    private final ModelPart part4;
    private final ModelPart part5;
    private final ModelPart part6;
    private final ModelPart part7;
    private final ModelPart part8;

    public GiantAxolotlModel(ModelPart p_170370_) {
        super(true, 8.0f, 3.35f);
        this.root = p_170370_;
        this.body = this.root.m_171324_("body");
        this.head = this.root.m_171324_("head");
        this.gill_p1 = this.head.m_171324_("p1");
        this.gill_p2 = this.head.m_171324_("p2");
        this.gill_p3 = this.head.m_171324_("p3");
        this.gill_p4 = this.head.m_171324_("p4");
        this.gill_p5 = this.head.m_171324_("p5");
        this.gill_p6 = this.head.m_171324_("p6");
        this.head2 = this.head.m_171324_("head2");
        this.head3 = this.head2.m_171324_("head3");
        this.leftArm = this.root.m_171324_("leftArm");
        this.leftArm2 = this.leftArm.m_171324_("leftArm2");
        this.leftLeg = this.root.m_171324_("leftLeg");
        this.leftLeg_2 = this.leftLeg.m_171324_("leftLeg2");
        this.rightArm = this.root.m_171324_("rightArm");
        this.rightArm2 = this.rightArm.m_171324_("rightArm2");
        this.rightLeg = this.root.m_171324_("rightLeg");
        this.rightLeg2 = this.rightLeg.m_171324_("rightLeg2");
        this.part3 = this.body.m_171324_("part3");
        this.part4 = this.part3.m_171324_("part4");
        this.part5 = this.part4.m_171324_("part5");
        this.part6 = this.part5.m_171324_("part6");
        this.part7 = this.part6.m_171324_("part7");
        this.part8 = this.part7.m_171324_("part8");
        this.part9 = this.part8.m_171324_("part9");
    }

    public ModelPart getRoot() {
        return this.root;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 9).m_171481_(-4.0f, 0.0f, 0.0f, 8.0f, 4.0f, 10.0f), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)-7.0f));
        CubeDeformation cubedeformation = new CubeDeformation(0.001f);
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171488_(-4.0f, 0.0f, -5.0f, 8.0f, 5.0f, 5.0f, cubedeformation), PartPose.m_171419_((float)0.0f, (float)13.0f, (float)-7.0f));
        PartDefinition head2 = head.m_171599_("head2", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171481_(-4.0f, 0.0f, -1.0f, 8.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)-5.0f));
        PartDefinition head3 = head2.m_171599_("head3", CubeListBuilder.m_171558_().m_171514_(39, 0).m_171481_(-4.0f, 0.0f, -1.0f, 8.0f, 3.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)-1.0f));
        PartDefinition gill1 = head.m_171599_("p1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-0.5f, -3.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.m_171423_((float)2.5f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.4691445f));
        gill1.m_171599_("part13", CubeListBuilder.m_171558_().m_171514_(0, 59).m_171481_(-1.0f, -4.0f, 0.0f, 2.0f, 5.0f, 0.0f), PartPose.f_171404_);
        PartDefinition gill2 = head.m_171599_("p2", CubeListBuilder.m_171558_().m_171514_(57, 0).m_171481_(-0.5f, -3.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.m_171423_((float)-2.5f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.4691445f));
        gill2.m_171599_("part13_1", CubeListBuilder.m_171558_().m_171514_(0, 53).m_171481_(-1.0f, -4.0f, 0.0f, 2.0f, 5.0f, 0.0f), PartPose.f_171404_);
        PartDefinition gill3 = head.m_171599_("p3", CubeListBuilder.m_171558_().m_171514_(38, 4).m_171481_(-0.5f, -3.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.m_171423_((float)4.1f, (float)1.4f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)1.0164797f));
        gill3.m_171599_("part13_2", CubeListBuilder.m_171558_().m_171514_(5, 59).m_171481_(-1.0f, -4.0f, 0.0f, 2.0f, 5.0f, 0.0f), PartPose.f_171404_);
        PartDefinition gill4 = head.m_171599_("p4", CubeListBuilder.m_171558_().m_171514_(42, 4).m_171481_(-0.5f, -3.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.m_171423_((float)-4.1f, (float)1.4f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)1.3292428f));
        gill4.m_171599_("part13_3", CubeListBuilder.m_171558_().m_171514_(5, 53).m_171481_(-1.0f, -4.0f, 0.0f, 2.0f, 5.0f, 0.0f), PartPose.f_171404_);
        PartDefinition gill5 = head.m_171599_("p5", CubeListBuilder.m_171558_().m_171514_(46, 4).m_171481_(-0.5f, -3.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.m_171423_((float)4.0f, (float)3.8f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)1.3292428f));
        gill5.m_171599_("part13_4", CubeListBuilder.m_171558_().m_171514_(10, 59).m_171481_(-1.0f, -4.0f, 0.0f, 2.0f, 5.0f, 0.0f), PartPose.f_171404_);
        PartDefinition gill6 = head.m_171599_("p6", CubeListBuilder.m_171558_().m_171514_(50, 4).m_171481_(-0.5f, -3.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.m_171423_((float)-4.0f, (float)3.8f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-1.3292428f));
        gill6.m_171599_("part13_5", CubeListBuilder.m_171558_().m_171514_(10, 53).m_171481_(-1.0f, -4.0f, 0.0f, 2.0f, 5.0f, 0.0f), PartPose.f_171404_);
        CubeListBuilder limbs = CubeListBuilder.m_171558_().m_171514_(30, 30).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f);
        CubeListBuilder limbs2 = CubeListBuilder.m_171558_().m_171514_(6, 28).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f);
        PartDefinition rleg = partdefinition.m_171599_("rightLeg", limbs, PartPose.m_171423_((float)-4.0f, (float)16.0f, (float)1.0f, (float)1.0555751f, (float)0.39095375f, (float)1.3292428f));
        PartDefinition rleg2 = rleg.m_171599_("rightLeg2", limbs2, PartPose.m_171423_((float)-1.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)-0.041015238f, (float)-1.1337658f));
        rleg2.m_171599_("f1d", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-0.5f, 0.0f, -2.0f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)1.2f, (float)4.01f, (float)-0.5f, (float)0.0f, (float)-0.6646214f, (float)0.0f));
        rleg2.m_171599_("f2d", CubeListBuilder.m_171558_().m_171514_(38, 32).m_171481_(-0.5f, 0.0f, -3.0f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)0.5f, (float)4.01f, (float)0.0f, (float)0.0f, (float)0.039095376f, (float)0.0f));
        rleg2.m_171599_("f3d", CubeListBuilder.m_171558_().m_171514_(11, 33).m_171481_(-0.5f, 0.0f, -3.0f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)-0.1f, (float)4.01f, (float)0.0f, (float)0.0f, (float)0.43004912f, (float)0.0f));
        rleg2.m_171599_("f4d", CubeListBuilder.m_171558_().m_171514_(19, 33).m_171481_(-0.5f, 0.0f, -2.0f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)-1.1f, (float)4.01f, (float)-0.3f, (float)0.0f, (float)0.938289f, (float)0.0f));
        PartDefinition lleg = partdefinition.m_171599_("leftLeg", limbs, PartPose.m_171423_((float)4.0f, (float)16.0f, (float)1.0f, (float)1.0555751f, (float)-0.39095375f, (float)-1.3292428f));
        PartDefinition lleg2 = lleg.m_171599_("leftLeg2", limbs2, PartPose.m_171423_((float)1.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.041015238f, (float)1.1337658f));
        lleg2.m_171599_("f1c", CubeListBuilder.m_171558_().m_171514_(40, 23).m_171481_(-0.5f, 0.0f, -2.0f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)-1.2f, (float)4.01f, (float)-0.5f, (float)0.0f, (float)0.6646214f, (float)0.0f));
        lleg2.m_171599_("f2c", CubeListBuilder.m_171558_().m_171514_(8, 24).m_171481_(-0.5f, 0.0f, -3.0f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)-0.5f, (float)4.01f, (float)0.0f, (float)0.0f, (float)-0.039095376f, (float)0.0f));
        lleg2.m_171599_("f3c", CubeListBuilder.m_171558_().m_171514_(45, 24).m_171481_(-0.5f, 0.0f, -3.0f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)0.1f, (float)4.01f, (float)0.0f, (float)0.0f, (float)-0.43004912f, (float)0.0f));
        lleg2.m_171599_("f4c", CubeListBuilder.m_171558_().m_171514_(50, 26).m_171481_(-0.5f, 0.0f, -2.0f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)1.1f, (float)4.01f, (float)-0.3f, (float)0.0f, (float)-0.938289f, (float)0.0f));
        PartDefinition rarm = partdefinition.m_171599_("rightArm", limbs, PartPose.m_171423_((float)-4.0f, (float)16.3f, (float)-5.0f, (float)0.35185838f, (float)0.039095376f, (float)1.2119566f));
        PartDefinition rarm2 = rarm.m_171599_("rightArm2", limbs2, PartPose.m_171423_((float)-1.0f, (float)4.0f, (float)0.0f, (float)-0.07819075f, (float)-0.07836528f, (float)-1.2119566f));
        rarm2.m_171599_("f1b", CubeListBuilder.m_171558_().m_171514_(37, 27).m_171481_(-0.5f, 0.0f, -2.0f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)1.2f, (float)4.01f, (float)-0.5f, (float)0.0f, (float)-0.6646214f, (float)0.0f));
        rarm2.m_171599_("f2b", CubeListBuilder.m_171558_().m_171514_(55, 27).m_171481_(-0.5f, 0.0f, -3.0f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)0.5f, (float)4.01f, (float)0.0f, (float)0.0f, (float)0.039095376f, (float)0.0f));
        rarm2.m_171599_("f3b", CubeListBuilder.m_171558_().m_171514_(42, 28).m_171481_(-0.5f, 0.0f, -3.0f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)-0.1f, (float)4.01f, (float)0.0f, (float)0.0f, (float)0.43004912f, (float)0.0f));
        rarm2.m_171599_("f4b", CubeListBuilder.m_171558_().m_171514_(22, 29).m_171481_(-0.5f, 0.0f, -2.0f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)-1.0f, (float)4.01f, (float)-0.2f, (float)0.0f, (float)0.938289f, (float)0.0f));
        PartDefinition larm = partdefinition.m_171599_("leftArm", limbs, PartPose.m_171423_((float)4.0f, (float)16.3f, (float)-5.0f, (float)0.35185838f, (float)-0.039095376f, (float)-1.2119566f));
        PartDefinition larm2 = larm.m_171599_("leftArm2", limbs2, PartPose.m_171423_((float)1.0f, (float)4.0f, (float)0.0f, (float)-0.07819075f, (float)0.07836528f, (float)1.2119566f));
        larm2.m_171599_("f1a", CubeListBuilder.m_171558_().m_171514_(16, 10).m_171481_(-0.5f, 0.0f, -2.0f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)-1.2f, (float)4.01f, (float)-0.5f, (float)0.0f, (float)0.6646214f, (float)0.0f));
        larm2.m_171599_("f2a", CubeListBuilder.m_171558_().m_171514_(42, 15).m_171481_(-0.5f, 0.0f, -3.0f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)-0.5f, (float)4.01f, (float)0.0f, (float)0.0f, (float)-0.039095376f, (float)0.0f));
        larm2.m_171599_("f3a", CubeListBuilder.m_171558_().m_171514_(11, 20).m_171481_(-0.5f, 0.0f, -3.0f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)0.1f, (float)4.01f, (float)0.0f, (float)0.0f, (float)-0.43004912f, (float)0.0f));
        larm2.m_171599_("f4a", CubeListBuilder.m_171558_().m_171514_(16, 23).m_171481_(-0.5f, 0.0f, -2.0f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)1.1f, (float)4.01f, (float)-0.3f, (float)0.0f, (float)-0.938289f, (float)0.0f));
        PartDefinition part3 = body.m_171599_("part3", CubeListBuilder.m_171558_().m_171514_(42, 9).m_171481_(-3.5f, 0.0f, 0.0f, 7.0f, 4.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)10.0f));
        part3.m_171599_("part3b", CubeListBuilder.m_171558_().m_171514_(1, 4).m_171481_(0.0f, -2.0f, 0.0f, 0.0f, 2.0f, 2.0f), PartPose.f_171404_);
        PartDefinition part4 = part3.m_171599_("part4", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171481_(-3.0f, 0.0f, 0.0f, 6.0f, 4.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        part4.m_171599_("part4b", CubeListBuilder.m_171558_().m_171514_(37, 40).m_171481_(0.0f, -2.0f, 0.0f, 0.0f, 7.0f, 2.0f), PartPose.f_171404_);
        PartDefinition part5 = part4.m_171599_("part5", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-2.5f, 0.0f, 0.0f, 5.0f, 4.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        part5.m_171599_("part5b", CubeListBuilder.m_171558_().m_171514_(27, 40).m_171481_(0.0f, -2.0f, 0.0f, 0.0f, 7.0f, 2.0f), PartPose.f_171404_);
        PartDefinition part6 = part5.m_171599_("part6", CubeListBuilder.m_171558_().m_171514_(14, 14).m_171481_(-2.0f, 0.5f, 0.0f, 4.0f, 3.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        part6.m_171599_("part6b", CubeListBuilder.m_171558_().m_171514_(32, 40).m_171481_(0.0f, -2.0f, 0.0f, 0.0f, 7.0f, 2.0f), PartPose.f_171404_);
        PartDefinition part7 = part6.m_171599_("part7", CubeListBuilder.m_171558_().m_171514_(52, 15).m_171481_(-1.5f, 0.5f, 0.0f, 3.0f, 3.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        part7.m_171599_("part7b", CubeListBuilder.m_171558_().m_171514_(6, 0).m_171481_(0.0f, -2.0f, 0.0f, 0.0f, 7.0f, 2.0f), PartPose.f_171404_);
        PartDefinition part8 = part7.m_171599_("part8", CubeListBuilder.m_171558_().m_171514_(26, 5).m_171481_(-1.0f, 1.0f, 0.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        part8.m_171599_("part8b", CubeListBuilder.m_171558_().m_171514_(10, 0).m_171481_(0.0f, -1.0f, 0.0f, 0.0f, 6.0f, 2.0f), PartPose.f_171404_);
        PartDefinition part9 = part8.m_171599_("part9", CubeListBuilder.m_171558_().m_171514_(54, 5).m_171481_(-0.5f, 1.0f, 0.0f, 1.0f, 2.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        part9.m_171599_("part9b", CubeListBuilder.m_171558_().m_171514_(14, 0).m_171481_(0.0f, 0.0f, 0.0f, 0.0f, 4.0f, 3.0f), PartPose.f_171404_);
        body.m_171599_("part10b", CubeListBuilder.m_171558_().m_171514_(44, 52).m_171481_(0.0f, -2.0f, 0.0f, 0.0f, 2.0f, 10.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.root);
    }

    public void m_7695_(PoseStack p_102034_, VertexConsumer p_102035_, int p_102036_, int p_102037_, float p_102038_, float p_102039_, float p_102040_, float p_102041_) {
        p_102034_.m_85836_();
        p_102034_.m_85841_(1.5f, 1.5f, 1.5f);
        p_102034_.m_85837_(0.0, (double)-0.35f, 0.0);
        super.m_7695_(p_102034_, p_102035_, p_102036_, p_102037_, p_102038_, p_102039_, p_102040_, p_102041_);
        p_102034_.m_85849_();
    }

    public void setupAnim(T p_170395_, float p_170396_, float p_170397_, float p_170398_, float p_170399_, float p_170400_) {
        boolean flag;
        this.setupInitialAnimationValues(p_170395_, p_170399_, p_170400_);
        float tickTied = ((GiantAxolotl)((Object)p_170395_)).getTickTied();
        boolean bl = flag = p_170395_.m_20184_().m_165925_() > 1.0E-7 || p_170395_.m_146909_() != ((GiantAxolotl)((Object)p_170395_)).f_19860_ || p_170395_.m_146908_() != ((GiantAxolotl)((Object)p_170395_)).f_19859_ || ((GiantAxolotl)((Object)p_170395_)).f_19790_ != p_170395_.m_20185_() || ((GiantAxolotl)((Object)p_170395_)).f_19792_ != p_170395_.m_20189_();
        if (p_170395_.m_20072_()) {
            if (flag) {
                this.setupSwimmingAnimation(tickTied, p_170400_);
            } else {
                this.setupWaterHoveringAnimation(tickTied);
            }
            this.saveAnimationValues(p_170395_);
        } else {
            if (flag) {
                this.setupGroundCrawlingAnimation(tickTied, p_170399_, p_170396_, p_170397_);
            } else {
                this.setupLayStillOnGroundAnimation(tickTied, p_170399_);
            }
            this.saveAnimationValues(p_170395_);
        }
    }

    private void saveAnimationValues(T p_170389_) {
        Map<String, Vector3f> map = ((GiantAxolotl)((Object)p_170389_)).m_142115_();
        map.put("root", this.getRotationVector(this.root));
        map.put("body", this.getRotationVector(this.body));
        map.put("head", this.getRotationVector(this.head));
        map.put("rightLeg", this.getRotationVector(this.rightLeg));
        map.put("leftLeg", this.getRotationVector(this.leftLeg));
        map.put("rightArm", this.getRotationVector(this.rightArm));
        map.put("leftArm", this.getRotationVector(this.leftArm));
        map.put("part3", this.getRotationVector(this.part3));
        map.put("p1", this.getRotationVector(this.gill_p1));
        map.put("p2", this.getRotationVector(this.gill_p2));
        map.put("p3", this.getRotationVector(this.gill_p3));
        map.put("p4", this.getRotationVector(this.gill_p4));
        map.put("p5", this.getRotationVector(this.gill_p5));
        map.put("p6", this.getRotationVector(this.gill_p6));
    }

    private Vector3f getRotationVector(ModelPart p_170402_) {
        return new Vector3f(p_170402_.f_104203_, p_170402_.f_104204_, p_170402_.f_104205_);
    }

    private void setRotationFromVector(ModelPart p_170409_, Vector3f p_170410_) {
        p_170409_.m_171327_(p_170410_.m_122239_(), p_170410_.m_122260_(), p_170410_.m_122269_());
    }

    private void setupInitialAnimationValues(T p_170391_, float p_170392_, float p_170393_) {
        this.root.f_104200_ = 0.0f;
        this.root.f_104201_ = 0.0f;
        Map<String, Vector3f> map = ((GiantAxolotl)((Object)p_170391_)).m_142115_();
        if (map.isEmpty()) {
            this.root.m_171327_(p_170393_ * ((float)Math.PI / 180), p_170392_ * ((float)Math.PI / 180), 0.0f);
            this.head.m_171327_(0.0f, 0.0f, 0.0f);
            this.body.m_171327_(0.0f, 0.0f, 0.0f);
            this.leftLeg.m_171327_(1.0555751f, -0.39095375f, -1.3292428f);
            this.rightLeg.m_171327_(1.0555751f, 0.39095375f, 1.3292428f);
            this.leftArm.m_171327_(0.35185838f, -0.039095376f, -1.2119566f);
            this.rightArm.m_171327_(0.35185838f, 0.039095376f, 1.2119566f);
            this.part3.m_171327_(0.0f, 0.0f, 0.0f);
            this.gill_p1.m_171327_(0.0f, 0.0f, 0.4691445f);
            this.gill_p2.m_171327_(0.0f, 0.0f, -0.4691445f);
            this.gill_p3.m_171327_(0.0f, 0.0f, 1.0164797f);
            this.gill_p5.m_171327_(0.0f, 0.0f, 1.3292428f);
            this.gill_p6.m_171327_(0.0f, 0.0f, -1.3292428f);
            this.gill_p4.m_171327_(0.0f, 0.0f, -1.0164797f);
        } else {
            this.setRotationFromVector(this.root, map.get("root"));
            this.setRotationFromVector(this.body, map.get("body"));
            this.setRotationFromVector(this.head, map.get("head"));
            this.setRotationFromVector(this.leftLeg, map.get("leftLeg"));
            this.setRotationFromVector(this.rightLeg, map.get("rightLeg"));
            this.setRotationFromVector(this.leftArm, map.get("leftArm"));
            this.setRotationFromVector(this.rightArm, map.get("rightArm"));
            this.setRotationFromVector(this.gill_p1, map.get("p1"));
            this.setRotationFromVector(this.gill_p2, map.get("p2"));
            this.setRotationFromVector(this.gill_p3, map.get("p3"));
            this.setRotationFromVector(this.gill_p4, map.get("p4"));
            this.setRotationFromVector(this.gill_p5, map.get("p5"));
            this.setRotationFromVector(this.gill_p6, map.get("p6"));
            this.setRotationFromVector(this.part3, map.get("part3"));
        }
    }

    private float lerpTo(float p_170375_, float p_170376_) {
        return this.lerpTo(0.05f, p_170375_, p_170376_);
    }

    private float lerpTo(float p_170378_, float p_170379_, float p_170380_) {
        return Mth.m_14189_((float)p_170378_, (float)p_170379_, (float)p_170380_);
    }

    private void lerpPart(ModelPart p_170404_, float p_170405_, float p_170406_, float p_170407_) {
        p_170404_.m_171327_(this.lerpTo(p_170404_.f_104203_, p_170405_), this.lerpTo(p_170404_.f_104204_, p_170406_), this.lerpTo(p_170404_.f_104205_, p_170407_));
    }

    private void setupLayStillOnGroundAnimation(float p_170415_, float p_170416_) {
        float f = p_170415_ * 0.09f;
        float f1 = Mth.m_14031_((float)f);
        float f2 = Mth.m_14089_((float)f);
        float f3 = f1 * f1 - 2.0f * f1;
        float f4 = f2 * f2 - 3.0f * f1;
        this.head.f_104203_ = this.lerpTo(this.head.f_104203_, -0.09f * f3);
        this.head.f_104204_ = this.lerpTo(this.head.f_104204_, 0.0f);
        this.head.f_104205_ = this.lerpTo(this.head.f_104205_, -0.2f);
        this.part3.f_104204_ = this.lerpTo(this.part3.f_104204_ / 1.2f, -0.1f + 0.1f * f3);
        this.part4.f_104204_ = this.lerpTo(this.part4.f_104204_ / 1.2f, -0.1f + 0.1f * f3);
        this.part5.f_104204_ = this.lerpTo(this.part5.f_104204_ / 1.2f, -0.1f + 0.1f * f3);
        this.part6.f_104204_ = this.lerpTo(this.part6.f_104204_ / 1.2f, -0.1f + 0.1f * f3);
        this.part7.f_104204_ = this.lerpTo(this.part7.f_104204_ / 1.2f, -0.1f + 0.1f * f3);
        this.part8.f_104204_ = this.lerpTo(this.part8.f_104204_ / 1.2f, -0.1f + 0.1f * f3);
        this.part9.f_104204_ = this.lerpTo(this.part9.f_104204_ / 1.2f, -0.1f + 0.1f * f3);
        this.gill_p2.f_104203_ = this.lerpTo(this.gill_p2.f_104203_, 0.6f + 0.05f * f4);
        this.gill_p1.f_104203_ = this.lerpTo(this.gill_p1.f_104203_, 0.6f + 0.05f * f4);
        this.gill_p3.f_104203_ = this.lerpTo(this.gill_p3.f_104203_, 0.6f + 0.05f * f4);
        this.gill_p5.f_104203_ = this.lerpTo(this.gill_p5.f_104203_, 0.6f + 0.05f * f4);
        this.gill_p4.f_104203_ = this.lerpTo(this.gill_p4.f_104203_, 0.6f + 0.05f * f4);
        this.gill_p6.f_104203_ = this.lerpTo(this.gill_p6.f_104203_, 0.6f + 0.05f * f4);
        this.lerpPart(this.leftLeg, 1.0555751f, -0.39095375f, -1.3292428f);
        this.lerpPart(this.leftArm, 0.35185838f, -0.039095376f, -1.2119566f);
        this.applyMirrorLegRotations();
        this.root.f_104203_ = this.lerpTo(0.2f, this.root.f_104203_, 0.0f);
        this.root.f_104204_ = this.lerpTo(this.root.f_104204_, p_170416_ * ((float)Math.PI / 180));
        this.root.f_104205_ = this.lerpTo(this.root.f_104205_, 0.0f);
    }

    private void setupGroundCrawlingAnimation(float p_170419_, float p_170420_, float p_104138_, float p_104139_) {
        float f = p_170419_ * 0.11f;
        float fb = p_170419_ * 0.4f;
        float f1 = Mth.m_14089_((float)fb);
        float f2 = (f1 * f1 - 2.0f * f1) / 5.0f;
        float f3 = 0.7f * f1;
        this.head.f_104203_ = this.lerpTo(this.head.f_104203_, 0.0f);
        this.head.f_104204_ = this.lerpTo(this.head.f_104204_, 0.09f * f1);
        this.head.f_104205_ = this.lerpTo(this.head.f_104205_, 0.0f);
        this.part3.f_104204_ = this.lerpTo(this.part3.f_104204_, this.head.f_104204_ * 1.3f);
        this.part4.f_104204_ = this.lerpTo(this.part4.f_104204_, this.head.f_104204_ * 1.3f);
        this.part5.f_104204_ = this.lerpTo(this.part5.f_104204_, this.head.f_104204_ * 1.3f);
        this.part6.f_104204_ = this.lerpTo(this.part6.f_104204_, this.head.f_104204_ * 1.3f);
        this.part7.f_104204_ = this.lerpTo(this.part7.f_104204_, this.head.f_104204_ * 1.3f);
        this.part8.f_104204_ = this.lerpTo(this.part8.f_104204_, this.head.f_104204_ * 1.3f);
        this.part9.f_104204_ = this.lerpTo(this.part9.f_104204_, this.head.f_104204_ * 1.3f);
        this.gill_p2.f_104203_ = this.lerpTo(this.gill_p2.f_104203_, 0.6f - 0.08f * (f1 * f1 + 2.0f * Mth.m_14031_((float)f)));
        this.gill_p1.f_104203_ = this.lerpTo(this.gill_p1.f_104203_, 0.6f - 0.08f * (f1 * f1 + 2.0f * Mth.m_14031_((float)f)));
        this.gill_p3.f_104203_ = this.lerpTo(this.gill_p3.f_104203_, 0.6f - 0.08f * (f1 * f1 + 2.0f * Mth.m_14031_((float)f)));
        this.gill_p5.f_104203_ = this.lerpTo(this.gill_p5.f_104203_, 0.6f - 0.08f * (f1 * f1 + 2.0f * Mth.m_14031_((float)f)));
        this.gill_p4.f_104203_ = this.lerpTo(this.gill_p4.f_104203_, 0.6f - 0.08f * (f1 * f1 + 2.0f * Mth.m_14031_((float)f)));
        this.gill_p6.f_104203_ = this.lerpTo(this.gill_p6.f_104203_, 0.6f - 0.08f * (f1 * f1 + 2.0f * Mth.m_14031_((float)f)));
        this.rightLeg.f_104203_ = 1.0555751f + Mth.m_14089_((float)(p_104138_ * 0.1662f)) * 0.3f * p_104139_;
        this.leftLeg.f_104203_ = 1.0555751f + Mth.m_14089_((float)(p_104138_ * 0.1662f + (float)Math.PI)) * 0.3f * p_104139_;
        this.rightArm.f_104203_ = 0.35185838f + Mth.m_14089_((float)(p_104138_ * 0.1662f + (float)Math.PI)) * 0.3f * p_104139_;
        this.leftArm.f_104203_ = 0.35185838f + Mth.m_14089_((float)(p_104138_ * 0.1662f)) * 0.3f * p_104139_;
        this.lerpPart(this.leftLeg, 1.0555751f, -0.39095375f - f2, -1.3292428f);
        this.lerpPart(this.leftArm, 0.35185838f, -0.039095376f - f3, -1.2119566f);
        this.lerpPart(this.rightLeg, this.leftLeg.f_104203_, 0.39095375f - f2, 1.2119566f);
        this.lerpPart(this.rightArm, 0.35185838f, 0.39095375f - f3, 1.2119566f);
        this.root.f_104203_ = this.lerpTo(0.2f, this.root.f_104203_, 0.0f);
        this.root.f_104204_ = this.lerpTo(this.root.f_104204_, p_170420_ * ((float)Math.PI / 180));
        this.root.f_104205_ = this.lerpTo(this.root.f_104205_, 0.0f);
    }

    private void setupWaterHoveringAnimation(float p_170373_) {
        float f = p_170373_ * 0.075f;
        float f1 = Mth.m_14089_((float)f);
        float f2 = Mth.m_14031_((float)f) * 0.15f;
        this.head.f_104203_ = this.lerpTo(this.head.f_104203_, -this.root.f_104203_);
        this.gill_p2.f_104203_ = this.lerpTo(this.gill_p2.f_104203_, 0.2f * f1);
        this.gill_p1.f_104203_ = this.lerpTo(this.gill_p1.f_104203_, 0.2f * f1);
        this.gill_p3.f_104203_ = this.lerpTo(this.gill_p3.f_104203_, 0.2f * f1);
        this.gill_p5.f_104203_ = this.lerpTo(this.gill_p5.f_104203_, 0.2f * f1);
        this.gill_p4.f_104203_ = this.lerpTo(this.gill_p4.f_104203_, 0.2f * f1);
        this.gill_p6.f_104203_ = this.lerpTo(this.gill_p6.f_104203_, 0.2f * f1);
        this.lerpPart(this.leftLeg, 1.0555751f - f1 * 0.35f, -0.39095375f, -1.3292428f);
        this.lerpPart(this.leftArm, 0.35185838f - f1 * 0.5f, -0.039095376f, -1.2119566f);
        this.applyMirrorLegRotations();
        this.part3.f_104204_ = this.lerpTo(this.part3.f_104204_, 0.5f * f1 * 0.15f);
        this.part4.f_104204_ = this.lerpTo(this.part4.f_104204_, 0.5f * f1 * 0.15f);
        this.part5.f_104204_ = this.lerpTo(this.part5.f_104204_, 0.5f * f1 * 0.15f);
        this.part6.f_104204_ = this.lerpTo(this.part6.f_104204_, 0.5f * f1 * 0.15f);
        this.part7.f_104204_ = this.lerpTo(this.part7.f_104204_, 0.5f * f1 * 0.15f);
        this.part8.f_104204_ = this.lerpTo(this.part8.f_104204_, 0.5f * f1 * 0.15f);
        this.part9.f_104204_ = this.lerpTo(this.part9.f_104204_, 0.5f * f1 * 0.15f);
        this.head.f_104204_ = this.lerpTo(this.head.f_104204_, 0.0f);
        this.head.f_104205_ = this.lerpTo(this.head.f_104205_, 0.0f);
    }

    private void setupSwimmingAnimation(float p_170423_, float p_170424_) {
        float f = p_170423_ * 0.33f;
        float f1 = Mth.m_14031_((float)f);
        float f2 = Mth.m_14089_((float)f);
        float f3 = 0.13f * f1;
        this.head.f_104203_ = -f3 * 1.8f;
        this.gill_p2.f_104203_ = this.lerpTo(this.gill_p2.f_104203_, -0.5f * f1 - 0.8f);
        this.gill_p1.f_104203_ = this.lerpTo(this.gill_p1.f_104203_, -0.5f * f1 - 0.8f);
        this.gill_p3.f_104203_ = this.lerpTo(this.gill_p3.f_104203_, -0.5f * f1 - 0.8f);
        this.gill_p5.f_104203_ = this.lerpTo(this.gill_p5.f_104203_, -0.5f * f1 - 0.8f);
        this.gill_p4.f_104203_ = this.lerpTo(this.gill_p4.f_104203_, -0.5f * f1 - 0.8f);
        this.gill_p6.f_104203_ = this.lerpTo(this.gill_p6.f_104203_, -0.5f * f1 - 0.8f);
        this.part3.f_104204_ = this.lerpTo(this.part3.f_104204_, 0.3f * Mth.m_14089_((float)(f * 0.9f)));
        this.part4.f_104204_ = this.lerpTo(this.part4.f_104204_, 0.3f * Mth.m_14089_((float)(f * 0.9f)));
        this.part5.f_104204_ = this.lerpTo(this.part5.f_104204_, 0.3f * Mth.m_14089_((float)(f * 0.9f)));
        this.part6.f_104204_ = this.lerpTo(this.part6.f_104204_, 0.3f * Mth.m_14089_((float)(f * 0.9f)));
        this.part7.f_104204_ = this.lerpTo(this.part7.f_104204_, 0.3f * Mth.m_14089_((float)(f * 0.9f)));
        this.part8.f_104204_ = this.lerpTo(this.part8.f_104204_, 0.3f * Mth.m_14089_((float)(f * 0.9f)));
        this.part9.f_104204_ = this.lerpTo(this.part9.f_104204_, 0.3f * Mth.m_14089_((float)(f * 0.9f)));
        this.lerpPart(this.leftLeg, 1.5555751f, -0.39095375f * f1 + 0.5f, -1.3292428f);
        this.lerpPart(this.leftArm, 1.3518584f, -0.039095376f - f2 + 0.5f, -1.2119566f);
        this.applyMirrorLegRotations();
        this.head.f_104204_ = this.lerpTo(this.head.f_104204_, 0.0f);
        this.head.f_104205_ = this.lerpTo(this.head.f_104205_, 0.0f);
    }

    private void applyMirrorLegRotations() {
        this.lerpPart(this.rightLeg, this.leftLeg.f_104203_, -this.leftLeg.f_104204_, -this.leftLeg.f_104205_);
        this.lerpPart(this.rightArm, this.leftArm.f_104203_, -this.leftArm.f_104204_, -this.leftArm.f_104205_);
    }
}

