/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs.giantaxolotl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.minecraftserverzone.weirdmobs.entities.mobs.giantaxolotl.GiantAxolotl;
import com.minecraftserverzone.weirdmobs.entities.mobs.giantaxolotl.PlayDead;
import com.minecraftserverzone.weirdmobs.entities.mobs.giantaxolotl.ValidatePlayDead;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RandomSwim;
import net.minecraft.world.entity.ai.behavior.RunIf;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.RunSometimes;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.TryFindWater;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public class GiantAxolotlAi {
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.m_146622_((int)5, (int)16);

    protected static Brain<?> makeBrain(Brain<GiantAxolotl> p_149291_) {
        GiantAxolotlAi.initCoreActivity(p_149291_);
        GiantAxolotlAi.initIdleActivity(p_149291_);
        GiantAxolotlAi.initFightActivity(p_149291_);
        GiantAxolotlAi.initPlayDeadActivity(p_149291_);
        p_149291_.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        p_149291_.m_21944_(Activity.f_37979_);
        p_149291_.m_21962_();
        return p_149291_;
    }

    private static void initPlayDeadActivity(Brain<GiantAxolotl> p_149297_) {
        p_149297_.m_21907_(Activity.f_150238_, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new PlayDead())), (Object)Pair.of((Object)1, (Object)new EraseMemoryIf(BehaviorUtils::m_217126_, MemoryModuleType.f_148195_))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_148195_, (Object)MemoryStatus.VALUE_PRESENT)), (Set)ImmutableSet.of((Object)MemoryModuleType.f_148195_));
    }

    private static void initFightActivity(Brain<GiantAxolotl> p_149303_) {
        p_149303_.m_21895_(Activity.f_37988_, 0, ImmutableList.of((Object)new StopAttackingIfTargetInvalid(GiantAxolotl::onStopAttacking), (Object)new SetWalkTargetFromAttackTargetIfTargetOutOfReach(GiantAxolotlAi::getSpeedModifierChasing), (Object)new MeleeAttack(20), (Object)new EraseMemoryIf(GiantAxolotlAi::isBreeding, MemoryModuleType.f_26372_)), MemoryModuleType.f_26372_);
    }

    private static void initCoreActivity(Brain<GiantAxolotl> p_149307_) {
        p_149307_.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)((Object)new ValidatePlayDead()), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_)));
    }

    private static void initIdleActivity(Brain<GiantAxolotl> p_149309_) {
        p_149309_.m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunSometimes((Behavior)new SetEntityLookTarget(EntityType.f_20532_, 6.0f), UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new AnimalMakeLove(EntityType.f_147039_, 0.2f)), (Object)Pair.of((Object)2, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new FollowTemptation(GiantAxolotlAi::getSpeedModifier), (Object)1), (Object)Pair.of((Object)new BabyFollowAdult(ADULT_FOLLOW_RANGE, GiantAxolotlAi::getSpeedModifierFollowingAdult), (Object)1)))), (Object)Pair.of((Object)3, (Object)new StartAttacking(GiantAxolotlAi::findNearestValidAttackTarget)), (Object)Pair.of((Object)3, (Object)new TryFindWater(6, 0.15f)), (Object)Pair.of((Object)4, (Object)new GateBehavior((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), (Set)ImmutableSet.of(), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.TRY_ALL, (List)ImmutableList.of((Object)Pair.of((Object)new RandomSwim(0.5f), (Object)2), (Object)Pair.of((Object)new RandomStroll(0.15f, false), (Object)2), (Object)Pair.of((Object)new SetWalkTargetFromLookTarget(GiantAxolotlAi::canSetWalkTargetFromLookTarget, GiantAxolotlAi::getSpeedModifier, 3), (Object)3), (Object)Pair.of((Object)new RunIf(Entity::m_20072_, (Behavior)new DoNothing(30, 60)), (Object)5), (Object)Pair.of((Object)new RunIf(Entity::m_20096_, (Behavior)new DoNothing(200, 400)), (Object)5))))));
    }

    private static boolean canSetWalkTargetFromLookTarget(LivingEntity p_182381_) {
        Level level = p_182381_.f_19853_;
        Optional optional = p_182381_.m_6274_().m_21952_(MemoryModuleType.f_26371_);
        if (optional.isPresent()) {
            BlockPos blockpos = ((PositionTracker)optional.get()).m_6675_();
            return level.m_46801_(blockpos) == p_182381_.m_20072_();
        }
        return false;
    }

    public static void updateActivity(GiantAxolotl p_149293_) {
        Brain<GiantAxolotl> brain = p_149293_.m_6274_();
        Activity activity = brain.m_21968_().orElse(null);
        if (activity != Activity.f_150238_) {
            brain.m_21926_((List)ImmutableList.of((Object)Activity.f_150238_, (Object)Activity.f_37988_, (Object)Activity.f_37979_));
            if (activity == Activity.f_37988_ && brain.m_21968_().orElse(null) != Activity.f_37988_) {
                brain.m_21882_(MemoryModuleType.f_148201_, (Object)true, 2400L);
            }
        }
    }

    private static float getSpeedModifierChasing(LivingEntity p_149289_) {
        return p_149289_.m_20072_() ? 0.6f : 0.15f;
    }

    private static float getSpeedModifierFollowingAdult(LivingEntity p_149295_) {
        return p_149295_.m_20072_() ? 0.6f : 0.15f;
    }

    private static float getSpeedModifier(LivingEntity p_149301_) {
        return p_149301_.m_20072_() ? 0.5f : 0.15f;
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(GiantAxolotl p_149299_) {
        return GiantAxolotlAi.isBreeding(p_149299_) ? Optional.empty() : p_149299_.m_6274_().m_21952_(MemoryModuleType.f_148194_);
    }

    public static boolean isBreeding(GiantAxolotl p_149305_) {
        return p_149305_.m_6274_().m_21874_(MemoryModuleType.f_26375_);
    }

    public static Ingredient getTemptations() {
        return Ingredient.m_204132_((TagKey)ItemTags.f_144321_);
    }
}

