/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs.giantaxolotl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.minecraftserverzone.weirdmobs.entities.mobs.giantaxolotl.GiantAxolotlAi;
import com.minecraftserverzone.weirdmobs.setup.Registrations;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LerpingModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;

public class GiantAxolotl
extends TamableAnimal
implements LerpingModel,
Bucketable,
PlayerRideableJumping {
    public static final int TOTAL_PLAYDEAD_TIME = 200;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super GiantAxolotl>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26822_, (Object)SensorType.f_26814_, (Object)SensorType.f_148315_, (Object)SensorType.f_148316_);
    protected static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26375_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_148206_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26373_, (Object)MemoryModuleType.f_26331_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26382_, MemoryModuleType.f_148195_, MemoryModuleType.f_148194_, MemoryModuleType.f_148196_, MemoryModuleType.f_148197_, MemoryModuleType.f_148198_, MemoryModuleType.f_148201_});
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.m_135353_(GiantAxolotl.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_PLAYING_DEAD = SynchedEntityData.m_135353_(GiantAxolotl.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(GiantAxolotl.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final double PLAYER_REGEN_DETECTION_RANGE = 20.0;
    public static final int RARE_VARIANT_CHANCE = 1200;
    public static final String VARIANT_TAG = "Variant";
    private final Map<String, Vector3f> modelRotationValues = Maps.newHashMap();
    private EntityDimensions dimensions;
    protected boolean isJumping;
    private float tickTied;
    protected float playerJumpPendingScale;

    public GiantAxolotl(EntityType<? extends GiantAxolotl> p_149105_, Level p_149106_) {
        super(p_149105_, p_149106_);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new AxolotlMoveControl(this);
        this.f_21365_ = new AxolotlLookControl(this, 20);
        this.f_19793_ = 1.0f;
        this.dimensions = p_149105_.m_20680_();
        this.m_7105_(false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
    }

    public static boolean checkAxolotlSpawnRules(EntityType<? extends LivingEntity> p_186250_, ServerLevelAccessor p_186251_, MobSpawnType p_186252_, BlockPos p_186253_, Random p_186254_) {
        return p_186251_.m_8055_(p_186253_.m_7495_()).m_204336_(BlockTags.f_184229_);
    }

    public InteractionResult m_6071_(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.m_21120_(p_30413_);
        if (!this.m_6162_() && this.m_21824_() && !itemstack.m_150930_(Items.f_42459_)) {
            this.doPlayerRide(p_30412_);
            this.m_6710_(null);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)p_30412_) || this.m_21824_() || itemstack.m_150930_(Items.f_42459_) && !this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (itemstack.m_150930_(Items.f_42459_) && this.m_21223_() < this.m_21233_()) {
                if (!p_30412_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5634_(10.0f);
                this.m_146850_(GameEvent.f_223708_);
                return InteractionResult.SUCCESS;
            }
        } else if (itemstack.m_150930_(Items.f_42459_)) {
            if (!p_30412_.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)p_30412_)) {
                this.m_21828_(p_30412_);
                this.m_6710_(null);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(p_30412_, p_30413_);
    }

    @Nullable
    public GiantAxolotl getBreedOffspring(ServerLevel p_149088_, AgeableMob p_149089_) {
        GiantAxolotl axolotl = (GiantAxolotl)((EntityType)Registrations.GIANT_AXOLOTL.get()).m_20615_((Level)p_149088_);
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            axolotl.m_21816_(uuid);
            axolotl.m_7105_(true);
        }
        return axolotl;
    }

    public boolean m_7848_(Animal p_30392_) {
        if (p_30392_ == this) {
            return false;
        }
        if (!this.m_21824_()) {
            return false;
        }
        if (!(p_30392_ instanceof GiantAxolotl)) {
            return false;
        }
        GiantAxolotl axolotl = (GiantAxolotl)p_30392_;
        if (!axolotl.m_21824_()) {
            return false;
        }
        if (axolotl.m_21825_()) {
            return false;
        }
        return this.m_27593_() && axolotl.m_27593_();
    }

    public boolean m_7757_(LivingEntity p_30389_, LivingEntity p_30390_) {
        if (!(p_30389_ instanceof Creeper) && !(p_30389_ instanceof Ghast)) {
            if (p_30389_ instanceof GiantAxolotl) {
                GiantAxolotl axolotl = (GiantAxolotl)p_30389_;
                return !axolotl.m_21824_() || axolotl.m_21826_() != p_30390_;
            }
            if (p_30389_ instanceof Player && p_30390_ instanceof Player && !((Player)p_30390_).m_7099_((Player)p_30389_)) {
                return false;
            }
            if (p_30389_ instanceof AbstractHorse && ((AbstractHorse)p_30389_).m_30614_()) {
                return false;
            }
            return !(p_30389_ instanceof TamableAnimal) || !((TamableAnimal)p_30389_).m_21824_();
        }
        return false;
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setIsJumping(boolean p_30656_) {
        this.isJumping = p_30656_;
    }

    public double getCustomJump() {
        return this.m_21133_(Attributes.f_22288_);
    }

    public void m_7888_(int p_30591_) {
        if (this.m_21824_()) {
            if (p_30591_ < 0) {
                p_30591_ = 0;
            }
            this.playerJumpPendingScale = p_30591_ >= 90 ? 1.0f : 0.4f + 0.4f * (float)p_30591_ / 90.0f;
        }
    }

    public void m_7199_(int p_30574_) {
    }

    public void m_8012_() {
    }

    public boolean m_7132_() {
        return this.m_21824_();
    }

    public Map<String, Vector3f> m_142115_() {
        return this.modelRotationValues;
    }

    public float m_5610_(BlockPos p_149140_, LevelReader p_149141_) {
        return 0.0f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)0);
        this.f_19804_.m_135372_(DATA_PLAYING_DEAD, (Object)false);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    public void m_7380_(CompoundTag p_149158_) {
        super.m_7380_(p_149158_);
        p_149158_.m_128405_(VARIANT_TAG, this.getVariant().getId());
        p_149158_.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag p_149145_) {
        super.m_7378_(p_149145_);
        this.setVariant(Variant.BY_ID[p_149145_.m_128451_(VARIANT_TAG)]);
        this.m_27497_(p_149145_.m_128471_("FromBucket"));
    }

    public void m_8032_() {
        if (!this.isPlayingDead()) {
            super.m_8032_();
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_149132_, DifficultyInstance p_149133_, MobSpawnType p_149134_, @Nullable SpawnGroupData p_149135_, @Nullable CompoundTag p_149136_) {
        boolean flag = false;
        if (p_149134_ == MobSpawnType.BUCKET) {
            return p_149135_;
        }
        if (p_149135_ instanceof AxolotlGroupData) {
            if (((AxolotlGroupData)((Object)p_149135_)).m_146777_() >= 2) {
                flag = true;
            }
        } else {
            p_149135_ = new AxolotlGroupData(Variant.getCommonSpawnVariant(this.f_19853_.f_46441_), Variant.getCommonSpawnVariant(this.f_19853_.f_46441_));
        }
        this.setVariant(((AxolotlGroupData)((Object)p_149135_)).getVariant(p_149132_.m_213780_()));
        if (flag) {
            this.m_146762_(-24000);
        }
        return super.m_6518_(p_149132_, p_149133_, p_149134_, p_149135_, p_149136_);
    }

    public void m_6075_() {
        super.m_6075_();
    }

    public int m_6062_() {
        return 6000;
    }

    public Variant getVariant() {
        return Variant.BY_ID[(Integer)this.f_19804_.m_135370_(DATA_VARIANT)];
    }

    private void setVariant(Variant p_149118_) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)p_149118_.getId());
    }

    public boolean m_6914_(LevelReader p_149130_) {
        return p_149130_.m_45784_((Entity)this);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public void setPlayingDead(boolean p_149199_) {
        this.f_19804_.m_135381_(DATA_PLAYING_DEAD, (Object)p_149199_);
    }

    public boolean isPlayingDead() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PLAYING_DEAD);
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean p_149196_) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)p_149196_);
    }

    public double m_142593_(LivingEntity p_149185_) {
        return 1.5 + (double)p_149185_.m_20205_() * 2.0;
    }

    public boolean m_6898_(ItemStack p_149189_) {
        return p_149189_.m_204117_(ItemTags.f_144321_);
    }

    public boolean m_6573_(Player p_149122_) {
        return true;
    }

    public float getTickTied() {
        return this.tickTied;
    }

    public void m_8119_() {
        if (!this.f_19853_.f_46443_) {
            this.tickTied = this.f_19797_;
            this.f_19853_.m_7605_((Entity)this, (byte)4);
        }
        super.m_8119_();
    }

    public void m_7822_(byte p_21807_) {
        if (p_21807_ == 4) {
            this.tickTied = this.f_19797_;
        }
        super.m_7822_(p_21807_);
    }

    protected void m_8024_() {
        this.f_19853_.m_46473_().m_6180_("axolotlBrain");
        this.m_6274_().m_21865_((ServerLevel)this.f_19853_, (LivingEntity)this);
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("axolotlActivityUpdate");
        GiantAxolotlAi.updateActivity(this);
        this.f_19853_.m_46473_().m_7238_();
        if (!this.m_21525_()) {
            Optional optional = this.m_6274_().m_21952_(MemoryModuleType.f_148195_);
            this.setPlayingDead(optional.isPresent() && (Integer)optional.get() > 0);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 1.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22288_, 0.6).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 5.0);
    }

    protected PathNavigation m_6037_(Level p_149128_) {
        return new AxolotlPathNavigation(this, p_149128_);
    }

    public boolean m_7327_(Entity p_149201_) {
        boolean flag = p_149201_.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (p_149201_ instanceof Zombie) {
            flag = p_149201_.m_6469_(DamageSource.m_19370_((LivingEntity)this), 100.0f);
        }
        if (flag) {
            this.m_19970_((LivingEntity)this, p_149201_);
            this.m_5496_(SoundEvents.f_144061_, 1.0f, 1.0f);
        }
        return flag;
    }

    public boolean m_6469_(DamageSource p_149115_, float p_149116_) {
        float f = this.m_21223_();
        if (!(this.f_19853_.f_46443_ || this.m_21525_() || this.f_19853_.f_46441_.m_188503_(3) != 0 || !((float)this.f_19853_.f_46441_.m_188503_(3) < p_149116_) && !(f / this.m_21233_() < 0.5f) || !(p_149116_ < f) || !this.m_20069_() || p_149115_.m_7639_() == null && p_149115_.m_7640_() == null || this.isPlayingDead())) {
            this.f_20939_.m_21879_(MemoryModuleType.f_148195_, (Object)200);
        }
        return super.m_6469_(p_149115_, p_149116_);
    }

    protected float m_6431_(Pose p_149152_, EntityDimensions p_149153_) {
        return p_149153_.f_20378_ * 0.655f;
    }

    public int m_8132_() {
        return 1;
    }

    public int m_8085_() {
        return 1;
    }

    protected void doPlayerRide(Player p_30634_) {
        if (!this.f_19853_.f_46443_) {
            p_30634_.m_146922_(this.m_146908_());
            p_30634_.m_146926_(this.m_146909_());
            p_30634_.m_20329_((Entity)this);
        }
    }

    @Deprecated
    public boolean m_6146_() {
        return true;
    }

    public void m_6872_(ItemStack p_149187_) {
        Bucketable.m_148822_((Mob)this, (ItemStack)p_149187_);
        CompoundTag compoundtag = p_149187_.m_41784_();
        compoundtag.m_128405_(VARIANT_TAG, this.getVariant().getId());
        compoundtag.m_128405_("Age", this.m_146764_());
        Brain<GiantAxolotl> brain = this.m_6274_();
        if (brain.m_21874_(MemoryModuleType.f_148201_)) {
            compoundtag.m_128356_("HuntingCooldown", brain.m_147341_(MemoryModuleType.f_148201_));
        }
    }

    public void m_142278_(CompoundTag p_149163_) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)p_149163_);
        this.setVariant(Variant.BY_ID[p_149163_.m_128451_(VARIANT_TAG)]);
        if (p_149163_.m_128441_("Age")) {
            this.m_146762_(p_149163_.m_128451_("Age"));
        }
        if (p_149163_.m_128441_("HuntingCooldown")) {
            this.m_6274_().m_21882_(MemoryModuleType.f_148201_, (Object)true, p_149163_.m_128454_("HuntingCooldown"));
        }
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)Items.f_151057_);
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_144077_;
    }

    public boolean m_142066_() {
        return !this.isPlayingDead() && super.m_142066_();
    }

    public static void onStopAttacking(GiantAxolotl p_218444_, LivingEntity p_218445_) {
        Entity entity;
        DamageSource damagesource;
        Level level = p_218444_.f_19853_;
        if (p_218445_.m_21224_() && (damagesource = p_218445_.m_21225_()) != null && (entity = damagesource.m_7639_()) != null && entity.m_6095_() == EntityType.f_20532_) {
            Player player = (Player)entity;
            List list = level.m_45976_(Player.class, p_218444_.m_20191_().m_82400_(20.0));
            if (list.contains(player)) {
                p_218444_.applySupportingEffects(player);
            }
        }
    }

    public void applySupportingEffects(Player p_149174_) {
        int i;
        MobEffectInstance mobeffectinstance = p_149174_.m_21124_(MobEffects.f_19605_);
        int n = i = mobeffectinstance != null ? mobeffectinstance.m_19557_() : 0;
        if (i < 2400) {
            i = Math.min(2400, 100 + i);
            p_149174_.m_147207_(new MobEffectInstance(MobEffects.f_19605_, i, 0), (Entity)this);
        }
        p_149174_.m_21195_(MobEffects.f_19599_);
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    protected SoundEvent m_7975_(DamageSource p_149161_) {
        return SoundEvents.f_144063_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_144062_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.m_20069_() ? SoundEvents.f_144065_ : SoundEvents.f_144064_;
    }

    protected SoundEvent m_5509_() {
        return SoundEvents.f_144066_;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_144067_;
    }

    protected Brain.Provider<GiantAxolotl> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> p_149138_) {
        return GiantAxolotlAi.makeBrain((Brain<GiantAxolotl>)this.m_5490_().m_22073_(p_149138_));
    }

    public Brain<GiantAxolotl> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    public boolean canBeControlledByRider() {
        return this.m_6688_() instanceof LivingEntity;
    }

    @Nullable
    public Entity m_6688_() {
        return this.m_146895_();
    }

    public double m_6048_() {
        return (double)this.dimensions.f_20378_ * 0.1;
    }

    public double m_6049_() {
        return 0.1;
    }

    public void m_7332_(Entity p_30642_) {
        super.m_7332_(p_30642_);
        if (p_30642_ instanceof Mob) {
            Mob mob = (Mob)p_30642_;
            this.f_20883_ = mob.f_20883_;
        }
        float f3 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = 0.0f;
        float f2 = 0.0f;
        p_30642_.m_6034_(this.m_20185_() + (double)(f1 * f3), this.m_20186_() + this.m_6048_() + this.m_6049_() + (double)f2, this.m_20189_() - (double)(f1 * f));
        if (p_30642_ instanceof LivingEntity) {
            ((LivingEntity)p_30642_).f_20883_ = this.f_20883_;
        }
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        MobEffectInstance mobeffectinstance = this.m_21124_(MobEffects.f_19603_);
        float f = mobeffectinstance == null ? 5.0f : (float)(mobeffectinstance.m_19564_() + 6);
        return Mth.m_14167_((float)((p_21237_ - 3.0f - f) * p_21238_));
    }

    public double m_182332_() {
        return this.m_21023_(MobEffects.f_19603_) ? (double)(0.1f * ((float)this.m_21124_(MobEffects.f_19603_).m_19564_() + 0.5f)) : 0.0;
    }

    public void m_7023_(Vec3 p_30633_) {
        if (this.m_6084_()) {
            if (this.m_20160_() && this.canBeControlledByRider() && this.m_21824_()) {
                LivingEntity livingentity = (LivingEntity)this.m_6688_();
                this.m_146922_(livingentity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float f = livingentity.f_20900_ * 0.5f;
                float f1 = livingentity.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                if (this.playerJumpPendingScale > 0.0f && !this.isJumping() && (this.m_20069_() || this.f_19861_)) {
                    double d0 = this.getCustomJump() * (double)this.playerJumpPendingScale * (double)this.m_20098_();
                    double d1 = d0 + this.m_182332_();
                    Vec3 vec3 = this.m_20184_();
                    this.m_20334_(vec3.f_82479_, d1, vec3.f_82481_);
                    this.setIsJumping(true);
                    this.f_19812_ = true;
                    ForgeHooks.onLivingJump((LivingEntity)this);
                    if (f1 > 0.0f) {
                        float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f2 * this.playerJumpPendingScale), 0.0, (double)(0.4f * f3 * this.playerJumpPendingScale)));
                    }
                    this.playerJumpPendingScale = 0.0f;
                }
                this.m_7910_(f1 * 0.1f);
                this.f_20887_ = 0.02f;
                if (this.m_6109_()) {
                    if (this.m_20069_()) {
                        double d4;
                        double d3 = livingentity.m_20154_().f_82480_;
                        double d = d4 = d3 < -0.2 ? 0.085 : 0.06;
                        if (this.m_6113_() != 0.0f && (d3 <= 0.0 || this.f_20899_ || !this.f_19853_.m_8055_(new BlockPos(this.m_20185_(), this.m_20186_() + 1.0 - 0.1, this.m_20189_())).m_60819_().m_76178_())) {
                            Vec3 vec31 = this.m_20184_();
                            this.m_20256_(vec31.m_82520_(0.0, (d3 - p_30633_.f_82480_) * d4, 0.0));
                        }
                    }
                    this.m_7910_(Math.max(f1 * 0.15f, 0.15f));
                    super.m_7023_(new Vec3((double)f, p_30633_.f_82480_, (double)f1));
                } else if (livingentity instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                this.playerJumpPendingScale = 0.0f;
                this.setIsJumping(false);
                this.m_21043_((LivingEntity)this, false);
                this.m_146872_();
            } else {
                this.f_20887_ = 0.02f;
                super.m_7023_(p_30633_);
            }
        }
    }

    protected void m_142075_(Player p_149124_, InteractionHand p_149125_, ItemStack p_149126_) {
        if (p_149126_.m_150930_(Items.f_42459_)) {
            p_149124_.m_21008_(p_149125_, new ItemStack((ItemLike)Items.f_42447_));
        } else {
            super.m_142075_(p_149124_, p_149125_, p_149126_);
        }
    }

    public boolean m_6785_(double p_149183_) {
        return !this.m_27487_() && !this.m_8077_();
    }

    static class AxolotlMoveControl
    extends SmoothSwimmingMoveControl {
        private final GiantAxolotl axolotl;

        public AxolotlMoveControl(GiantAxolotl p_149215_) {
            super((Mob)p_149215_, 85, 10, 1.0f, 1.0f, false);
            this.axolotl = p_149215_;
        }

        public void m_8126_() {
            if (!this.axolotl.isPlayingDead()) {
                super.m_8126_();
            }
        }
    }

    class AxolotlLookControl
    extends SmoothSwimmingLookControl {
        public AxolotlLookControl(GiantAxolotl p_149210_, int p_149211_) {
            super((Mob)p_149210_, p_149211_);
        }

        public void m_8128_() {
            if (!GiantAxolotl.this.isPlayingDead()) {
                super.m_8128_();
            }
        }
    }

    public static enum Variant {
        LUCY(0, "lucy", true),
        WILD(1, "wild", true),
        GOLD(2, "gold", true),
        CYAN(3, "cyan", true),
        BLUE(4, "blue", false);

        public static final Variant[] BY_ID;
        private final int id;
        private final String name;
        private final boolean common;

        private Variant(int p_149239_, String p_149240_, boolean p_149241_) {
            this.id = p_149239_;
            this.name = p_149240_;
            this.common = p_149241_;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static Variant getCommonSpawnVariant(RandomSource p_149246_) {
            return Variant.getSpawnVariant(p_149246_, true);
        }

        public static Variant getRareSpawnVariant(RandomSource p_149257_) {
            return Variant.getSpawnVariant(p_149257_, false);
        }

        private static Variant getSpawnVariant(RandomSource p_149248_, boolean p_149249_) {
            Variant[] aaxolotl$variant = (Variant[])Arrays.stream(BY_ID).filter(p_149252_ -> p_149252_.common == p_149249_).toArray(Variant[]::new);
            return (Variant)((Object)Util.m_214670_((Object[])aaxolotl$variant, (RandomSource)p_149248_));
        }

        static {
            BY_ID = (Variant[])Arrays.stream(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }

    public static class AxolotlGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final Variant[] types;

        public AxolotlGroupData(Variant ... p_149204_) {
            super(false);
            this.types = p_149204_;
        }

        public Variant getVariant(RandomSource p_149206_) {
            return this.types[p_149206_.m_188503_(this.types.length)];
        }
    }

    static class AxolotlPathNavigation
    extends WaterBoundPathNavigation {
        AxolotlPathNavigation(GiantAxolotl p_149218_, Level p_149219_) {
            super((Mob)p_149218_, p_149219_);
        }

        protected boolean m_7632_() {
            return true;
        }

        protected PathFinder m_5532_(int p_149222_) {
            this.f_26508_ = new AmphibiousNodeEvaluator(false);
            return new PathFinder(this.f_26508_, p_149222_);
        }

        public boolean m_6342_(BlockPos p_149224_) {
            return !this.f_26495_.m_8055_(p_149224_.m_7495_()).m_60795_();
        }
    }
}

