/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs.fire_guardian;

import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.ForgeMod;

public class FireGuardian
extends Monster {
    protected static final int ATTACK_TIME = 80;
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.m_135353_(FireGuardian.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_ID_MOVING = SynchedEntityData.m_135353_(FireGuardian.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_ID_ATTACK_TARGET = SynchedEntityData.m_135353_(FireGuardian.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float clientSideTailAnimation;
    private float clientSideTailAnimationO;
    private float clientSideTailAnimationSpeed;
    private float clientSideSpikesAnimation;
    private float clientSideSpikesAnimationO;
    @Nullable
    private LivingEntity clientSideCachedAttackTarget;
    private int clientSideAttackTime;
    private boolean clientSideTouchedGround;
    @Nullable
    protected RandomStrollGoal randomStrollGoal;

    public FireGuardian(EntityType<? extends FireGuardian> p_32810_, Level p_32811_) {
        super(p_32810_, p_32811_);
        this.f_21364_ = 10;
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.clientSideTailAnimationO = this.clientSideTailAnimation = this.f_19796_.m_188501_();
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6126_() {
        return true;
    }

    private void floatGuardian() {
        if (this.m_20077_()) {
            CollisionContext collisioncontext = CollisionContext.m_82750_((Entity)this);
            if (collisioncontext.m_6513_(LiquidBlock.f_54690_, this.m_20183_(), true) && !this.f_19853_.m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13132_)) {
                this.f_19861_ = true;
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.05, 0.0));
            }
        }
    }

    public void m_8119_() {
        if (this.m_20069_() && this.f_19797_ % 20 == 0) {
            this.m_6469_(DamageSource.f_19318_, 1.0f);
        }
        if (this.m_20094_() > 0) {
            this.m_7311_(0);
        }
        this.floatGuardian();
        super.m_8119_();
    }

    public static boolean checkFireGuardianSpawnRules(EntityType<FireGuardian> p_33922_, ServerLevelAccessor p_33923_, MobSpawnType p_33924_, BlockPos p_33925_, RandomSource p_33926_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_33925_.m_122032_();
        do {
            blockpos$mutableblockpos.m_122173_(Direction.UP);
        } while (p_33923_.m_6425_((BlockPos)blockpos$mutableblockpos).m_205070_(FluidTags.f_13132_));
        return p_33923_.m_8055_((BlockPos)blockpos$mutableblockpos).m_60795_();
    }

    protected void m_8099_() {
        MoveTowardsRestrictionGoal movetowardsrestrictiongoal = new MoveTowardsRestrictionGoal((PathfinderMob)this, 0.7);
        this.randomStrollGoal = new RandomStrollGoal((PathfinderMob)this, 0.7, 80);
        this.f_21345_.m_25352_(3, (Goal)new GuardianAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new FireGuardianGoToLavaGoal(this, 0.7));
        this.f_21345_.m_25352_(5, (Goal)movetowardsrestrictiongoal);
        this.f_21345_.m_25352_(7, (Goal)this.randomStrollGoal);
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, FireGuardian.class, 12.0f, 0.01f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.randomStrollGoal.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        movetowardsrestrictiongoal.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, (Predicate)new GuardianAttackSelector(this)));
    }

    public boolean canStandOnFluid(Fluid p_33893_) {
        return p_33893_.m_205067_(FluidTags.f_13132_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 30.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0);
    }

    protected PathNavigation m_6037_(Level p_33913_) {
        return new StriderPathNavigation(this, p_33913_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_MOVING, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_ATTACK_TARGET, (Object)0);
        this.f_19804_.m_135372_(DATA_COLOR, (Object)0);
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(DATA_COLOR);
    }

    public void setColor(int p_30398_) {
        this.f_19804_.m_135381_(DATA_COLOR, (Object)p_30398_);
    }

    public void m_7380_(CompoundTag p_30418_) {
        super.m_7380_(p_30418_);
        p_30418_.m_128344_("Color", (byte)this.getColor());
    }

    public void m_7378_(CompoundTag p_30402_) {
        super.m_7378_(p_30402_);
        if (p_30402_.m_128425_("Color", 99)) {
            this.setColor(p_30402_.m_128451_("Color"));
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, SpawnGroupData p_21437_, CompoundTag p_21438_) {
        int rand = new Random().nextInt(2);
        this.setColor(rand);
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean isMoving() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_MOVING);
    }

    void setMoving(boolean p_32862_) {
        this.f_19804_.m_135381_(DATA_ID_MOVING, (Object)p_32862_);
    }

    public int getAttackDuration() {
        return 80;
    }

    void setActiveAttackTarget(int p_32818_) {
        this.f_19804_.m_135381_(DATA_ID_ATTACK_TARGET, (Object)p_32818_);
    }

    public boolean hasActiveAttackTarget() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_ATTACK_TARGET) != 0;
    }

    @Nullable
    public LivingEntity getActiveAttackTarget() {
        if (!this.hasActiveAttackTarget()) {
            return null;
        }
        if (this.f_19853_.f_46443_) {
            if (this.clientSideCachedAttackTarget != null) {
                return this.clientSideCachedAttackTarget;
            }
            Entity entity = this.f_19853_.m_6815_(((Integer)this.f_19804_.m_135370_(DATA_ID_ATTACK_TARGET)).intValue());
            if (entity instanceof LivingEntity) {
                this.clientSideCachedAttackTarget = (LivingEntity)entity;
                return this.clientSideCachedAttackTarget;
            }
            return null;
        }
        return this.m_5448_();
    }

    public void m_7350_(EntityDataAccessor<?> p_32834_) {
        super.m_7350_(p_32834_);
        if (DATA_ID_ATTACK_TARGET.equals(p_32834_)) {
            this.clientSideAttackTime = 0;
            this.clientSideCachedAttackTarget = null;
        }
    }

    public int m_8100_() {
        return 160;
    }

    protected SoundEvent m_7515_() {
        return this.m_20072_() ? SoundEvents.f_11999_ : SoundEvents.f_12000_;
    }

    protected SoundEvent m_7975_(DamageSource p_32852_) {
        return this.m_20072_() ? SoundEvents.f_12005_ : SoundEvents.f_12006_;
    }

    protected SoundEvent m_5592_() {
        return this.m_20072_() ? SoundEvents.f_12002_ : SoundEvents.f_12003_;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    protected float m_6431_(Pose p_32843_, EntityDimensions p_32844_) {
        return p_32844_.f_20378_ * 0.5f;
    }

    public float m_5610_(BlockPos p_32831_, LevelReader p_32832_) {
        return p_32832_.m_6425_(p_32831_).m_205070_(FluidTags.f_13131_) ? 10.0f + p_32832_.m_220417_(p_32831_) - 0.5f : super.m_5610_(p_32831_, p_32832_);
    }

    public void m_8107_() {
        if (this.m_6084_()) {
            if (this.f_19853_.f_46443_) {
                this.clientSideTailAnimationO = this.clientSideTailAnimation;
                if (!this.m_20077_()) {
                    this.clientSideTailAnimationSpeed = 2.0f;
                    Vec3 vec3 = this.m_20184_();
                    if (vec3.f_82480_ > 0.0 && this.clientSideTouchedGround && !this.m_20067_()) {
                        this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getFlopSound(), this.m_5720_(), 1.0f, 1.0f, false);
                    }
                    this.clientSideTouchedGround = vec3.f_82480_ < 0.0 && this.f_19853_.m_46575_(this.m_20183_().m_7495_(), (Entity)this);
                } else {
                    this.clientSideTailAnimationSpeed = this.isMoving() ? (this.clientSideTailAnimationSpeed < 0.5f ? 4.0f : (this.clientSideTailAnimationSpeed += (0.5f - this.clientSideTailAnimationSpeed) * 0.1f)) : (this.clientSideTailAnimationSpeed += (0.125f - this.clientSideTailAnimationSpeed) * 0.2f);
                }
                this.clientSideTailAnimation += this.clientSideTailAnimationSpeed;
                this.clientSideSpikesAnimationO = this.clientSideSpikesAnimation;
                this.clientSideSpikesAnimation = !this.m_20077_() ? this.f_19796_.m_188501_() : (this.isMoving() ? (this.clientSideSpikesAnimation += (0.0f - this.clientSideSpikesAnimation) * 0.25f) : (this.clientSideSpikesAnimation += (1.0f - this.clientSideSpikesAnimation) * 0.06f));
                if (this.isMoving() && this.m_20077_()) {
                    Vec3 vec31 = this.m_20252_(0.0f);
                    for (int i = 0; i < 2; ++i) {
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20208_(0.5) - vec31.f_82479_ * 1.5, this.m_20187_() - vec31.f_82480_ * 1.5, this.m_20262_(0.5) - vec31.f_82481_ * 1.5, 0.0, 0.0, 0.0);
                    }
                }
                if (this.hasActiveAttackTarget()) {
                    LivingEntity livingentity;
                    if (this.clientSideAttackTime < this.getAttackDuration()) {
                        ++this.clientSideAttackTime;
                    }
                    if ((livingentity = this.getActiveAttackTarget()) != null) {
                        this.m_21563_().m_24960_((Entity)livingentity, 90.0f, 90.0f);
                        this.m_21563_().m_8128_();
                        double d5 = this.getAttackAnimationScale(0.0f);
                        double d0 = livingentity.m_20185_() - this.m_20185_();
                        double d1 = livingentity.m_20227_(0.5) - this.m_20188_();
                        double d2 = livingentity.m_20189_() - this.m_20189_();
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        double d4 = this.f_19796_.m_188500_();
                        while (d4 < d3) {
                            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() + d0 * (d4 += 1.8 - d5 + this.f_19796_.m_188500_() * (1.7 - d5)), this.m_20188_() + d1 * d4, this.m_20189_() + d2 * d4, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
            if (this.m_20077_()) {
                this.m_20301_(300);
            } else if (this.f_19861_) {
                this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.4f), 0.5, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.4f)));
                this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
                this.f_19861_ = false;
                this.f_19812_ = true;
            }
            if (this.hasActiveAttackTarget()) {
                this.m_146922_(this.f_20885_);
            }
        }
        super.m_8107_();
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12004_;
    }

    public float getTailAnimation(float p_32864_) {
        return Mth.m_14179_((float)p_32864_, (float)this.clientSideTailAnimationO, (float)this.clientSideTailAnimation);
    }

    public float getSpikesAnimation(float p_32866_) {
        return Mth.m_14179_((float)p_32866_, (float)this.clientSideSpikesAnimationO, (float)this.clientSideSpikesAnimation);
    }

    public float getAttackAnimationScale(float p_32813_) {
        return ((float)this.clientSideAttackTime + p_32813_) / (float)this.getAttackDuration();
    }

    public boolean m_6914_(LevelReader p_32829_) {
        return p_32829_.m_45784_((Entity)this);
    }

    public static boolean checkGuardianSpawnRules(EntityType<? extends FireGuardian> p_32837_, LevelAccessor p_32838_, MobSpawnType p_32839_, BlockPos p_32840_, Random p_32841_) {
        return !(p_32841_.nextInt(20) != 0 && p_32838_.m_46861_(p_32840_) || p_32838_.m_46791_() == Difficulty.PEACEFUL || p_32839_ != MobSpawnType.SPAWNER && !p_32838_.m_6425_(p_32840_).m_205070_(FluidTags.f_13132_) || !p_32838_.m_6425_(p_32840_.m_7495_()).m_205070_(FluidTags.f_13132_));
    }

    public boolean m_6469_(DamageSource p_32820_, float p_32821_) {
        if (!this.isMoving() && !p_32820_.m_19387_() && p_32820_.m_7640_() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_32820_.m_7640_();
            if (!p_32820_.m_19372_()) {
                livingentity.m_6469_(DamageSource.m_19335_((Entity)this), 2.0f);
            }
        }
        if (this.randomStrollGoal != null) {
            this.randomStrollGoal.m_25751_();
        }
        return super.m_6469_(p_32820_, p_32821_);
    }

    public int m_8132_() {
        return 180;
    }

    static class GuardianAttackGoal
    extends Goal {
        private final FireGuardian fireGuardian;
        private int attackTime;

        public GuardianAttackGoal(FireGuardian p_32871_) {
            this.fireGuardian = p_32871_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.fireGuardian.m_5448_();
            return livingentity != null && livingentity.m_6084_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.fireGuardian.m_5448_() != null && this.fireGuardian.m_20280_((Entity)this.fireGuardian.m_5448_()) > 9.0;
        }

        public void m_8056_() {
            this.attackTime = -10;
            this.fireGuardian.m_21573_().m_26573_();
            LivingEntity livingentity = this.fireGuardian.m_5448_();
            if (livingentity != null) {
                this.fireGuardian.m_21563_().m_24960_((Entity)livingentity, 90.0f, 90.0f);
            }
            this.fireGuardian.f_19812_ = true;
        }

        public void m_8041_() {
            this.fireGuardian.setActiveAttackTarget(0);
            this.fireGuardian.m_6710_(null);
            this.fireGuardian.randomStrollGoal.m_25751_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.fireGuardian.m_5448_();
            if (livingentity != null) {
                this.fireGuardian.m_21573_().m_26573_();
                this.fireGuardian.m_21563_().m_24960_((Entity)livingentity, 90.0f, 90.0f);
                if (!this.fireGuardian.m_142582_((Entity)livingentity)) {
                    this.fireGuardian.m_6710_(null);
                } else {
                    ++this.attackTime;
                    if (this.attackTime == 0) {
                        this.fireGuardian.setActiveAttackTarget(livingentity.m_19879_());
                        if (!this.fireGuardian.m_20067_()) {
                            // empty if block
                        }
                    } else if (this.attackTime >= this.fireGuardian.getAttackDuration()) {
                        float f = 1.0f;
                        if (this.fireGuardian.f_19853_.m_46791_() == Difficulty.HARD) {
                            f += 2.0f;
                        }
                        livingentity.m_6469_(DamageSource.m_19367_((Entity)this.fireGuardian, (Entity)this.fireGuardian), f);
                        livingentity.m_6469_(DamageSource.m_19370_((LivingEntity)this.fireGuardian), (float)this.fireGuardian.m_21133_(Attributes.f_22281_));
                        this.fireGuardian.m_6710_(null);
                    }
                    super.m_8037_();
                }
            }
        }
    }

    static class FireGuardianGoToLavaGoal
    extends MoveToBlockGoal {
        private final FireGuardian FireGuardian;

        FireGuardianGoToLavaGoal(FireGuardian p_33955_, double p_33956_) {
            super((PathfinderMob)p_33955_, p_33956_, 8, 2);
            this.FireGuardian = p_33955_;
        }

        public BlockPos m_6669_() {
            return this.f_25602_;
        }

        public boolean m_8045_() {
            return !this.FireGuardian.m_20077_() && this.m_6465_((LevelReader)this.FireGuardian.f_19853_, this.f_25602_);
        }

        public boolean m_8036_() {
            return !this.FireGuardian.m_20077_() && super.m_8036_();
        }

        public boolean m_8064_() {
            return this.f_25601_ % 20 == 0;
        }

        protected boolean m_6465_(LevelReader p_33963_, BlockPos p_33964_) {
            return p_33963_.m_8055_(p_33964_).m_60713_(Blocks.f_49991_) && p_33963_.m_8055_(p_33964_.m_7494_()).m_60647_((BlockGetter)p_33963_, p_33964_, PathComputationType.LAND);
        }
    }

    static class GuardianAttackSelector
    implements Predicate<LivingEntity> {
        private final FireGuardian fireGuardian;

        public GuardianAttackSelector(FireGuardian p_32879_) {
            this.fireGuardian = p_32879_;
        }

        @Override
        public boolean test(@Nullable LivingEntity p_32881_) {
            return (p_32881_ instanceof Player || p_32881_ instanceof Squid || p_32881_ instanceof Strider) && p_32881_.m_20280_((Entity)this.fireGuardian) > 9.0;
        }
    }

    static class StriderPathNavigation
    extends GroundPathNavigation {
        StriderPathNavigation(FireGuardian p_33969_, Level p_33970_) {
            super((Mob)p_33969_, p_33970_);
        }

        protected PathFinder m_5532_(int p_33972_) {
            this.f_26508_ = new WalkNodeEvaluator();
            return new PathFinder(this.f_26508_, p_33972_);
        }

        protected boolean m_7367_(BlockPathTypes p_33974_) {
            return p_33974_ != BlockPathTypes.LAVA && p_33974_ != BlockPathTypes.DAMAGE_FIRE && p_33974_ != BlockPathTypes.DANGER_FIRE ? super.m_7367_(p_33974_) : true;
        }

        public boolean m_6342_(BlockPos p_33976_) {
            return this.f_26495_.m_8055_(p_33976_).m_60713_(Blocks.f_49991_) || super.m_6342_(p_33976_);
        }
    }
}

