/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs.endercreeper;

import com.minecraftserverzone.weirdmobs.entities.mobs.endercreeper.EnderCreeperEntity;
import com.minecraftserverzone.weirdmobs.entities.mobs.endercreeper.EnderCreeperModel;
import com.minecraftserverzone.weirdmobs.setup.HelperFunctions;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class EnderCreeperRenderer<T extends EnderCreeperEntity, M extends EnderCreeperModel<T>>
extends MobRenderer<T, M> {
    private final ResourceLocation textureLoc;
    private final Random random = new Random();

    public EnderCreeperRenderer(EntityRendererProvider.Context manager, M model, float shadowSize, String textureName) {
        super(manager, model, shadowSize);
        this.textureLoc = HelperFunctions.getModelTexture(textureName);
    }

    protected void scale(EnderCreeperEntity p_114046_, PoseStack p_114047_, float p_114048_) {
        float f = p_114046_.getSwelling(p_114048_);
        float f1 = 1.0f + Mth.m_14031_((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        p_114047_.m_85841_(f2, f3, f2);
    }

    protected float getWhiteOverlayProgress(EnderCreeperEntity p_114043_, float p_114044_) {
        float f = p_114043_.getSwelling(p_114044_);
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : Mth.m_14036_((float)f, (float)0.5f, (float)1.0f);
    }

    public void render(T p_114339_, float p_114340_, float p_114341_, PoseStack p_114342_, MultiBufferSource p_114343_, int p_114344_) {
        EnderCreeperModel endercreepermodel = (EnderCreeperModel)this.m_7200_();
        endercreepermodel.creepy = ((EnderCreeperEntity)((Object)p_114339_)).isCreepy();
        super.m_7392_(p_114339_, p_114340_, p_114341_, p_114342_, p_114343_, p_114344_);
    }

    public Vec3 getRenderOffset(T p_114336_, float p_114337_) {
        if (((EnderCreeperEntity)((Object)p_114336_)).isCreepy()) {
            return new Vec3(this.random.nextGaussian() * 0.02, 0.0, this.random.nextGaussian() * 0.02);
        }
        return super.m_7860_(p_114336_, p_114337_);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return this.textureLoc;
    }
}

