/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs.endercreeper;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

public class EnderCreeperEntity
extends Monster
implements NeutralMob {
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", (double)0.15f, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(EnderCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_POWERED = SynchedEntityData.m_135353_(EnderCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<BlockState>> DATA_CARRY_STATE = SynchedEntityData.m_135353_(EnderCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    private static final EntityDataAccessor<Boolean> DATA_CREEPY = SynchedEntityData.m_135353_(EnderCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_STARED_AT = SynchedEntityData.m_135353_(EnderCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int lastStareSound = Integer.MIN_VALUE;
    private int targetChangeTime;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;
    private int oldSwell;
    private int swell;
    private int maxSwell = 20;
    private int explosionRadius = 3;

    public EnderCreeperEntity(EntityType<? extends EnderCreeperEntity> p_32485_, Level p_32486_) {
        super(p_32485_, p_32486_);
        this.f_19793_ = 1.0f;
        this.f_21364_ = 10;
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new EnderCreeperSwellGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new EndermanFreezeWhenLookedAt(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new EndermanLookForPlayerGoal(this, arg_0 -> ((EnderCreeperEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    public void m_6710_(@Nullable LivingEntity p_32537_) {
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
        if (p_32537_ == null) {
            this.targetChangeTime = 0;
            this.f_19804_.m_135381_(DATA_CREEPY, (Object)false);
            this.f_19804_.m_135381_(DATA_STARED_AT, (Object)false);
            attributeinstance.m_22130_(SPEED_MODIFIER_ATTACKING);
        } else {
            this.targetChangeTime = this.f_19797_;
            this.f_19804_.m_135381_(DATA_CREEPY, (Object)true);
            if (!attributeinstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
                attributeinstance.m_22118_(SPEED_MODIFIER_ATTACKING);
            }
        }
        super.m_6710_(p_32537_);
    }

    protected float m_6121_() {
        return 1.0f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)-1);
        this.f_19804_.m_135372_(DATA_IS_POWERED, (Object)false);
        this.f_19804_.m_135372_(DATA_CARRY_STATE, Optional.empty());
        this.f_19804_.m_135372_(DATA_CREEPY, (Object)false);
        this.f_19804_.m_135372_(DATA_STARED_AT, (Object)false);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int p_32515_) {
        this.remainingPersistentAngerTime = p_32515_;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(@Nullable UUID p_32509_) {
        this.persistentAngerTarget = p_32509_;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void playStareSound() {
        if (this.f_19797_ >= this.lastStareSound + 400) {
            this.lastStareSound = this.f_19797_;
            if (!this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20188_(), this.m_20189_(), SoundEvents.f_11851_, this.m_5720_(), 2.5f, 1.0f, false);
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> p_32513_) {
        if (DATA_CREEPY.equals(p_32513_) && this.hasBeenStaredAt() && this.f_19853_.f_46443_) {
            this.playStareSound();
        }
        super.m_7350_(p_32513_);
    }

    public void m_7380_(CompoundTag p_32520_) {
        super.m_7380_(p_32520_);
        if (((Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED)).booleanValue()) {
            p_32520_.m_128379_("powered", true);
        }
        p_32520_.m_128376_("Fuse", (short)this.maxSwell);
        p_32520_.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
        this.m_21678_(p_32520_);
    }

    public void m_7378_(CompoundTag p_32511_) {
        super.m_7378_(p_32511_);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)p_32511_.m_128471_("powered"));
        if (p_32511_.m_128425_("Fuse", 99)) {
            this.maxSwell = p_32511_.m_128448_("Fuse");
        }
        if (p_32511_.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = p_32511_.m_128445_("ExplosionRadius");
        }
        this.m_147285_(this.f_19853_, p_32511_);
    }

    boolean isLookingAtMe(Player p_32535_) {
        Vec3 vec3 = p_32535_.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(this.m_20185_() - p_32535_.m_20185_(), this.m_20188_() - p_32535_.m_20188_(), this.m_20189_() - p_32535_.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - 0.025 / d0 ? p_32535_.m_142582_((Entity)this) : false;
    }

    protected float m_6431_(Pose p_32517_, EntityDimensions p_32518_) {
        return 2.55f;
    }

    public void m_8107_() {
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        this.f_20899_ = false;
        if (!this.f_19853_.f_46443_) {
            this.m_21666_((ServerLevel)this.f_19853_, true);
        }
        super.m_8107_();
    }

    public boolean m_6126_() {
        return true;
    }

    protected void m_8024_() {
        float f;
        if (this.f_19853_.m_46461_() && this.f_19797_ >= this.targetChangeTime + 600 && (f = this.m_213856_()) > 0.5f && this.f_19853_.m_45527_(this.m_20183_()) && this.f_19796_.m_188501_() * 30.0f < (f - 0.4f) * 2.0f) {
            this.m_6710_(null);
            this.teleport();
        }
        super.m_8024_();
    }

    public boolean m_7327_(Entity p_32281_) {
        return true;
    }

    public boolean isPowered() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED);
    }

    public float getSwelling(float p_32321_) {
        return Mth.m_14179_((float)p_32321_, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void setSwellDir(int p_32284_) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)p_32284_);
    }

    public void m_8038_(ServerLevel p_32286_, LightningBolt p_32287_) {
        super.m_8038_(p_32286_, p_32287_);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)true);
    }

    protected InteractionResult m_6071_(Player p_32301_, InteractionHand p_32302_) {
        ItemStack itemstack = p_32301_.m_21120_(p_32302_);
        if (itemstack.m_150930_(Items.f_42409_)) {
            this.f_19853_.m_6263_(p_32301_, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11942_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            if (!this.f_19853_.f_46443_) {
                itemstack.m_41622_(1, (LivingEntity)p_32301_, p_32290_ -> p_32290_.m_21190_(p_32302_));
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(p_32301_, p_32302_);
    }

    private void explodeCreeper() {
        if (!this.f_19853_.f_46443_) {
            Explosion.BlockInteraction explosion$blockinteraction = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
            float f = this.isPowered() ? 2.0f : 1.0f;
            this.f_20890_ = false;
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.explosionRadius * f, explosion$blockinteraction);
            this.m_146870_();
            this.spawnLingeringCloud();
        }
    }

    private void spawnLingeringCloud() {
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloud.m_19712_(2.5f);
            areaeffectcloud.m_19732_(-0.5f);
            areaeffectcloud.m_19740_(10);
            areaeffectcloud.m_19734_(areaeffectcloud.m_19748_() / 2);
            areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
            for (MobEffectInstance mobeffectinstance : collection) {
                areaeffectcloud.m_19716_(new MobEffectInstance(mobeffectinstance));
            }
            this.f_19853_.m_7967_((Entity)areaeffectcloud);
        }
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            this.oldSwell = this.swell;
            int i = this.getSwellDir();
            if (i > 0 && this.swell == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explodeCreeper();
            }
        }
        super.m_8119_();
    }

    protected boolean teleport() {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    boolean teleportTowards(Entity p_32501_) {
        Vec3 vec3 = new Vec3(this.m_20185_() - p_32501_.m_20185_(), this.m_20227_(0.5) - p_32501_.m_20188_(), this.m_20189_() - p_32501_.m_20189_());
        vec3 = vec3.m_82541_();
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82479_ * 16.0;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vec3.f_82480_ * 16.0;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82481_ * 16.0;
        return this.teleport(d1, d2, d3);
    }

    private boolean teleport(double p_32544_, double p_32545_, double p_32546_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(p_32544_, p_32545_, p_32546_);
        while (blockpos$mutableblockpos.m_123342_() > this.f_19853_.m_141937_() && !this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos).m_60767_().m_76334_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_60767_().m_76334_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_32544_, (double)p_32545_, (double)p_32546_);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.m_20067_()) {
                this.f_19853_.m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return this.isCreepy() ? SoundEvents.f_11850_ : SoundEvents.f_11899_;
    }

    protected SoundEvent m_7975_(DamageSource p_32527_) {
        return SoundEvents.f_11849_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11900_;
    }

    public boolean m_6469_(DamageSource p_32494_, float p_32495_) {
        if (this.m_6673_(p_32494_)) {
            return false;
        }
        if (p_32494_ instanceof IndirectEntityDamageSource) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleport()) continue;
                return true;
            }
            return false;
        }
        boolean flag = super.m_6469_(p_32494_, p_32495_);
        if (!this.f_19853_.m_5776_() && !(p_32494_.m_7639_() instanceof LivingEntity) && this.f_19796_.m_188503_(10) != 0) {
            this.teleport();
        }
        return flag;
    }

    public boolean isCreepy() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CREEPY);
    }

    public boolean hasBeenStaredAt() {
        return (Boolean)this.f_19804_.m_135370_(DATA_STARED_AT);
    }

    public void setBeingStaredAt() {
        this.f_19804_.m_135381_(DATA_STARED_AT, (Object)true);
    }

    public class EnderCreeperSwellGoal
    extends Goal {
        private final EnderCreeperEntity creeper;
        private LivingEntity target;

        public EnderCreeperSwellGoal(EnderCreeperEntity p_25919_) {
            this.creeper = p_25919_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.creeper.m_5448_();
            return this.creeper.getSwellDir() > 0 || livingentity != null && this.creeper.m_20280_((Entity)livingentity) < 9.0;
        }

        public void m_8056_() {
            this.creeper.m_21573_().m_26573_();
            this.target = this.creeper.m_5448_();
        }

        public void m_8041_() {
            this.target = null;
        }

        public void m_8037_() {
            if (this.target == null) {
                this.creeper.setSwellDir(-1);
            } else if (this.creeper.m_20280_((Entity)this.target) > 49.0) {
                this.creeper.setSwellDir(-1);
            } else if (!this.creeper.m_21574_().m_148306_((Entity)this.target)) {
                this.creeper.setSwellDir(-1);
            } else {
                this.creeper.setSwellDir(1);
            }
        }
    }

    static class EndermanFreezeWhenLookedAt
    extends Goal {
        private final EnderCreeperEntity enderman;
        private LivingEntity target;

        public EndermanFreezeWhenLookedAt(EnderCreeperEntity p_32550_) {
            this.enderman = p_32550_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.target = this.enderman.m_5448_();
            if (!(this.target instanceof Player)) {
                return false;
            }
            double d0 = this.target.m_20280_((Entity)this.enderman);
            return d0 > 256.0 ? false : this.enderman.isLookingAtMe((Player)this.target);
        }

        public void m_8056_() {
            this.enderman.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.enderman.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
        }
    }

    static class EndermanLookForPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final EnderCreeperEntity enderman;
        private Player pendingTarget;
        private int aggroTime;
        private int teleportTime;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.m_148352_().m_148355_();

        public EndermanLookForPlayerGoal(EnderCreeperEntity p_32573_, @Nullable Predicate<LivingEntity> p_32574_) {
            super((Mob)p_32573_, Player.class, 10, false, false, p_32574_);
            this.enderman = p_32573_;
            this.startAggroTargetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(p_32578_ -> p_32573_.isLookingAtMe((Player)p_32578_));
        }

        public boolean m_8036_() {
            this.pendingTarget = this.enderman.f_19853_.m_45946_(this.startAggroTargetConditions, (LivingEntity)this.enderman);
            return this.pendingTarget != null;
        }

        public void m_8056_() {
            this.aggroTime = 5;
            this.teleportTime = 0;
            this.enderman.setBeingStaredAt();
        }

        public void m_8041_() {
            this.pendingTarget = null;
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (this.pendingTarget != null) {
                if (!this.enderman.isLookingAtMe(this.pendingTarget)) {
                    return false;
                }
                this.enderman.m_21391_((Entity)this.pendingTarget, 10.0f, 10.0f);
                return true;
            }
            return this.f_26050_ != null && this.continueAggroTargetConditions.m_26885_((LivingEntity)this.enderman, this.f_26050_) ? true : super.m_8045_();
        }

        public void m_8037_() {
            if (this.enderman.m_5448_() == null) {
                super.m_26070_((LivingEntity)null);
            }
            if (this.pendingTarget != null) {
                if (--this.aggroTime <= 0) {
                    this.f_26050_ = this.pendingTarget;
                    this.pendingTarget = null;
                    super.m_8056_();
                }
            } else {
                if (this.f_26050_ != null && !this.enderman.m_20159_()) {
                    if (this.enderman.isLookingAtMe((Player)this.f_26050_)) {
                        if (this.f_26050_.m_20280_((Entity)this.enderman) < 16.0) {
                            this.enderman.teleport();
                        }
                        this.teleportTime = 0;
                    } else if (this.f_26050_.m_20280_((Entity)this.enderman) > 256.0 && this.teleportTime++ >= 30 && this.enderman.teleportTowards((Entity)this.f_26050_)) {
                        this.teleportTime = 0;
                    }
                }
                super.m_8037_();
            }
        }
    }
}

