/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs.creeper_spider.broodmother;

import com.minecraftserverzone.weirdmobs.entities.mobs.creeper_spider.broodmother.SwellGoal;
import com.minecraftserverzone.weirdmobs.entities.mobs.creeper_spider.spider.CreeperSpider;
import com.minecraftserverzone.weirdmobs.entities.mobs.creeper_spider.spiderling.CreeperSpiderling;
import com.minecraftserverzone.weirdmobs.entities.projectiles.cobweb.Cobweb;
import com.minecraftserverzone.weirdmobs.setup.Registrations;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;

public class CreeperSpiderBroodmother
extends Monster
implements PowerableMob {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(CreeperSpiderBroodmother.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(CreeperSpiderBroodmother.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_POWERED = SynchedEntityData.m_135353_(CreeperSpiderBroodmother.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_IGNITED = SynchedEntityData.m_135353_(CreeperSpiderBroodmother.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int oldSwell;
    private int swell;
    private int maxSwell = 75;
    private int explosionRadius = 10;
    private int attackAnimationTick;
    private int spawnCooldown;
    private int battletick;
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);

    public CreeperSpiderBroodmother(EntityType<? extends CreeperSpiderBroodmother> p_33786_, Level p_33787_) {
        super(p_33786_, p_33787_);
        this.m_21153_(this.m_21233_());
        this.f_21364_ = 100;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SwellGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.6f));
        this.f_21345_.m_25352_(4, (Goal)new SpiderAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{CreeperSpiderling.class, CreeperSpider.class}));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false, h -> this.areCreeperSpiders((LivingEntity)h)));
    }

    public boolean areCreeperSpiders(LivingEntity h) {
        if (h instanceof CreeperSpider) {
            return false;
        }
        return !(h instanceof CreeperSpiderling);
    }

    protected void m_8024_() {
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        super.m_8024_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        if (this.battletick > 0) {
            --this.battletick;
        }
        if (this.spawnCooldown > 0) {
            --this.spawnCooldown;
        }
    }

    public boolean m_21532_() {
        return true;
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 4) {
            this.attackAnimationTick = 10;
            this.m_5496_(SoundEvents.f_12434_, 1.0f, 1.0f);
        } else if (p_28844_ == 5) {
            this.spawnCooldown = 40;
        } else if (p_28844_ == 6) {
            this.battletick = 1000;
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public int getBattleTick() {
        return this.battletick;
    }

    public void m_6457_(ServerPlayer p_31483_) {
        super.m_6457_(p_31483_);
        this.bossEvent.m_6543_(p_31483_);
    }

    public void m_6452_(ServerPlayer p_31488_) {
        super.m_6452_(p_31488_);
        this.bossEvent.m_6539_(p_31488_);
    }

    public boolean m_142535_(float p_149687_, float p_149688_, DamageSource p_149689_) {
        boolean flag = super.m_142535_(p_149687_, p_149688_, p_149689_);
        this.swell = (int)((float)this.swell + p_149687_ * 1.5f);
        if (this.swell > this.maxSwell - 5) {
            this.swell = this.maxSwell - 5;
        }
        return flag;
    }

    public double m_6048_() {
        return this.m_20206_() * 0.5f;
    }

    protected PathNavigation m_6037_(Level p_33802_) {
        return new WallClimberNavigation((Mob)this, p_33802_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)-1);
        this.f_19804_.m_135372_(DATA_IS_POWERED, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_IGNITED, (Object)false);
    }

    public void m_7380_(CompoundTag p_32304_) {
        super.m_7380_(p_32304_);
        if (((Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED)).booleanValue()) {
            p_32304_.m_128379_("powered", true);
        }
        p_32304_.m_128376_("Fuse", (short)this.maxSwell);
        p_32304_.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
        p_32304_.m_128379_("ignited", this.isIgnited());
    }

    public void m_7378_(CompoundTag p_32296_) {
        super.m_7378_(p_32296_);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)p_32296_.m_128471_("powered"));
        if (p_32296_.m_128425_("Fuse", 99)) {
            this.maxSwell = p_32296_.m_128448_("Fuse");
        }
        if (p_32296_.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = p_32296_.m_128445_("ExplosionRadius");
        }
        if (p_32296_.m_128471_("ignited")) {
            this.ignite();
        }
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(@Nullable Component p_31476_) {
        super.m_6593_(p_31476_);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        if (!this.f_19853_.f_46443_ && this.spawnCooldown == 0) {
            this.spawnCooldown = 40;
            this.f_19853_.m_7605_((Entity)this, (byte)5);
            CreeperSpiderling cs = (CreeperSpiderling)((EntityType)Registrations.CREEPER_SPIDERLING.get()).m_20615_(this.f_19853_);
            float f = 0.625f;
            int k = 2 + this.f_19796_.m_188503_(3);
            float f1 = 0.5f * f;
            float f2 = -0.5f * f;
            cs.m_7678_(this.m_20185_() + (double)f1, this.m_20186_() + 1.0, this.m_20189_() + (double)f2, this.f_19796_.m_188501_() * 360.0f, 0.0f);
            cs.m_6710_((LivingEntity)p_21016_.m_7639_());
            this.f_19853_.m_7967_((Entity)cs);
        }
        this.m_20256_(this.m_20184_().m_82520_(0.0, -1.0, 0.0));
        if (p_21016_.m_19372_()) {
            return false;
        }
        return super.m_6469_(p_21016_, p_21017_);
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int i;
            if (this.m_5912_() && this.battletick == 0) {
                this.battletick = 1000;
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            if (!this.f_19853_.f_46443_ && this.m_5448_() != null) {
                if (this.battletick > 600 && this.battletick % 100 == 0) {
                    for (float i2 = 0.0f; i2 < 6.0f; i2 += 1.0f) {
                        Cobweb cobweb = new Cobweb(this.f_19853_, this);
                        double d0 = this.m_5448_().m_20188_() - (double)1.1f;
                        double d1 = this.m_5448_().m_20185_() - this.m_20185_();
                        double d2 = d0 - cobweb.m_20186_();
                        double d3 = this.m_5448_().m_20189_() - this.m_20189_();
                        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
                        cobweb.m_6686_(d1, d2 + d4, d3, 1.6f, 12.0f);
                        if (!this.m_20067_()) {
                            this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12098_, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
                        }
                        this.f_19853_.m_7967_((Entity)cobweb);
                    }
                }
                if (this.battletick == 600) {
                    Explosion.BlockInteraction explosion$blockinteraction = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
                    float f = this.m_7090_() ? 2.0f : 1.0f;
                    this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.explosionRadius / 3.0f * f, explosion$blockinteraction);
                    this.spawnLingeringCloud();
                }
                if (this.battletick == 400) {
                    Explosion.BlockInteraction explosion$blockinteraction = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
                    float f = this.m_7090_() ? 2.0f : 1.0f;
                    this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.explosionRadius / 3.0f * f, explosion$blockinteraction);
                    this.spawnLingeringCloud();
                }
                if (this.battletick < 400 && this.battletick > 200 && this.f_19797_ % 40 == 0) {
                    Cobweb cobweb = new Cobweb(this.f_19853_, this);
                    double d0 = this.m_5448_().m_20188_() - (double)1.1f;
                    double d1 = this.m_5448_().m_20185_() - this.m_20185_();
                    double d2 = d0 - cobweb.m_20186_();
                    double d3 = this.m_5448_().m_20189_() - this.m_20189_();
                    double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
                    cobweb.m_6686_(d1, d2 + d4, d3, 1.6f, 12.0f);
                    if (!this.m_20067_()) {
                        this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12098_, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
                    }
                    this.f_19853_.m_7967_((Entity)cobweb);
                }
                if (this.f_19797_ % 400 == 0) {
                    CreeperSpiderling cs = (CreeperSpiderling)((EntityType)Registrations.CREEPER_SPIDERLING.get()).m_20615_(this.f_19853_);
                    float f = 0.625f;
                    float f1 = 0.5f * f;
                    float f2 = -0.5f * f;
                    cs.m_7678_(this.m_20185_() + (double)f1, this.m_20186_() + 1.0, this.m_20189_() + (double)f2, this.f_19796_.m_188501_() * 360.0f, 0.0f);
                    this.f_19853_.m_7967_((Entity)cs);
                }
                if (this.f_19797_ % 200 == 0) {
                    CreeperSpider cs = (CreeperSpider)((EntityType)Registrations.CREEPER_SPIDER.get()).m_20615_(this.f_19853_);
                    float f = 0.625f;
                    float f1 = 0.5f * f;
                    float f2 = -0.5f * f;
                    cs.m_7678_(this.m_20185_() + (double)f1, this.m_20186_() + 1.0, this.m_20189_() + (double)f2, this.f_19796_.m_188501_() * 360.0f, 0.0f);
                    this.f_19853_.m_7967_((Entity)cs);
                }
            }
            this.oldSwell = this.swell;
            if (this.isIgnited()) {
                this.setSwellDir(1);
            }
            if ((i = this.getSwellDir()) > 0 && this.swell == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explodeCreeper();
            }
        }
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.setClimbing(this.f_19862_);
        }
    }

    public void m_6710_(@Nullable LivingEntity p_149691_) {
        if (!(p_149691_ instanceof Goat)) {
            super.m_6710_(p_149691_);
        }
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        return 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22282_, 10.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22277_, 50.0);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12432_;
    }

    protected SoundEvent m_7975_(DamageSource p_33814_) {
        return SoundEvents.f_12434_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12433_;
    }

    protected void m_7355_(BlockPos p_33804_, BlockState p_33805_) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    private float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    public boolean m_7327_(Entity p_28837_) {
        boolean flag;
        float f1;
        this.attackAnimationTick = 10;
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        float f = this.getAttackDamage();
        float f2 = f1 = (int)f > 0 ? f / 2.0f + (float)this.f_19796_.m_188503_((int)f) : f;
        if (p_28837_ instanceof Warden) {
            f1 *= 4.0f;
        }
        if (flag = p_28837_.m_6469_(DamageSource.m_19370_((LivingEntity)this), f1)) {
            p_28837_.m_20256_(p_28837_.m_20184_().m_82520_(0.0, 1.0, 0.0));
            this.m_19970_((LivingEntity)this, p_28837_);
        }
        this.m_5496_(SoundEvents.f_12434_, 1.0f, 1.0f);
        return flag;
    }

    public boolean m_7090_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED);
    }

    public float getSwelling(float p_32321_) {
        return Mth.m_14179_((float)p_32321_, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void setSwellDir(int p_32284_) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)p_32284_);
    }

    public void m_8038_(ServerLevel p_32286_, LightningBolt p_32287_) {
        super.m_8038_(p_32286_, p_32287_);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)true);
    }

    protected InteractionResult m_6071_(Player p_32301_, InteractionHand p_32302_) {
        ItemStack itemstack = p_32301_.m_21120_(p_32302_);
        if (itemstack.m_150930_(Items.f_42409_) && this.m_21223_() < this.m_21233_() * 0.4f) {
            this.f_19853_.m_6263_(p_32301_, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11942_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            if (!this.f_19853_.f_46443_) {
                this.ignite();
                itemstack.m_41622_(1, (LivingEntity)p_32301_, p_32290_ -> p_32290_.m_21190_(p_32302_));
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(p_32301_, p_32302_);
    }

    private void explodeCreeper() {
        if (!this.f_19853_.f_46443_) {
            Explosion.BlockInteraction explosion$blockinteraction = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
            float f = this.m_7090_() ? 2.0f : 1.0f;
            this.f_20890_ = true;
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.explosionRadius * f, explosion$blockinteraction);
            this.m_146870_();
            this.spawnLingeringCloud();
        }
    }

    private void spawnLingeringCloud() {
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloud.m_19712_(2.5f);
            areaeffectcloud.m_19732_(-0.5f);
            areaeffectcloud.m_19740_(10);
            areaeffectcloud.m_19734_(areaeffectcloud.m_19748_() / 2);
            areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
            for (MobEffectInstance mobeffectinstance : collection) {
                areaeffectcloud.m_19716_(new MobEffectInstance(mobeffectinstance));
            }
            this.f_19853_.m_7967_((Entity)areaeffectcloud);
        }
    }

    public boolean isIgnited() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_IGNITED);
    }

    public void ignite() {
        this.f_19804_.m_135381_(DATA_IS_IGNITED, (Object)true);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public void m_7601_(BlockState p_33796_, Vec3 p_33797_) {
        if (!p_33796_.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(p_33796_, p_33797_);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_7301_(MobEffectInstance p_33809_) {
        if (p_33809_.m_19544_() == MobEffects.f_19614_) {
            MobEffectEvent.Applicable event = new MobEffectEvent.Applicable((LivingEntity)this, p_33809_);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.m_7301_(p_33809_);
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean p_33820_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = p_33820_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_33790_, DifficultyInstance p_33791_, MobSpawnType p_33792_, @Nullable SpawnGroupData p_33793_, @Nullable CompoundTag p_33794_) {
        MobEffect mobeffect;
        if ((p_33793_ = super.m_6518_(p_33790_, p_33791_, p_33792_, p_33793_, p_33794_)) == null) {
            p_33793_ = new SpiderEffectsGroupData();
            if (p_33790_.m_46791_() == Difficulty.HARD && p_33790_.m_213780_().m_188501_() < 0.1f * p_33791_.m_19057_()) {
                ((SpiderEffectsGroupData)p_33793_).setRandomEffect(p_33790_.m_213780_());
            }
        }
        if (p_33793_ instanceof SpiderEffectsGroupData && (mobeffect = ((SpiderEffectsGroupData)p_33793_).effect) != null) {
            this.m_7292_(new MobEffectInstance(mobeffect, Integer.MAX_VALUE));
        }
        return p_33793_;
    }

    protected float m_6431_(Pose p_33799_, EntityDimensions p_33800_) {
        return 2.0f;
    }

    static class SpiderAttackGoal
    extends MeleeAttackGoal {
        public SpiderAttackGoal(CreeperSpiderBroodmother p_33822_) {
            super((PathfinderMob)p_33822_, 1.0, true);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.f_25540_.m_20160_();
        }

        public boolean m_8045_() {
            if (this.f_25540_.m_217043_().m_188503_(100) == 0) {
                this.f_25540_.m_6710_((LivingEntity)null);
                return false;
            }
            return super.m_8045_();
        }

        protected double m_6639_(LivingEntity p_33825_) {
            return 15.0f + p_33825_.m_20205_();
        }
    }

    public static class SpiderEffectsGroupData
    implements SpawnGroupData {
        @Nullable
        public MobEffect effect;

        public void setRandomEffect(RandomSource randomSource) {
            int i = randomSource.m_188503_(5);
            if (i <= 1) {
                this.effect = MobEffects.f_19596_;
            } else if (i <= 2) {
                this.effect = MobEffects.f_19600_;
            } else if (i <= 3) {
                this.effect = MobEffects.f_19605_;
            } else if (i <= 4) {
                this.effect = MobEffects.f_19609_;
            }
        }
    }

    static class SpiderTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public SpiderTargetGoal(CreeperSpiderBroodmother p_33832_, Class<T> p_33833_) {
            super((Mob)p_33832_, p_33833_, true);
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }
    }
}

