/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs.bucketedaxolotl;

import java.util.EnumSet;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class BucketedAxolotl
extends Animal
implements NeutralMob {
    private static final EntityDataAccessor<Integer> ID_SIZE = SynchedEntityData.m_135353_(BucketedAxolotl.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.m_135353_(BucketedAxolotl.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(BucketedAxolotl.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(BucketedAxolotl.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private UUID persistentAngerTarget;
    public static final int MIN_SIZE = 1;
    public static final int MAX_SIZE = 127;
    public float targetSquish;
    public float squish;
    public float oSquish;
    private boolean wasOnGround;
    private int happy;
    public RandomSource f_19796_ = RandomSource.m_216327_();
    public Integer nextHappyTime = this.f_19796_.m_188503_(1000);

    public BucketedAxolotl(EntityType<? extends BucketedAxolotl> p_33588_, Level p_33589_) {
        super(p_33588_, p_33589_);
        this.f_21342_ = new BucketedAxolotlMoveControl(this);
        this.f_21364_ = 5;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new BucketedAxolotlFloatGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BucketedAxolotlAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BucketedAxolotlRandomDirectionGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new BucketedAxolotlKeepOnJumpingGoal(this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)0);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public void m_7380_(CompoundTag p_33619_) {
        super.m_7380_(p_33619_);
        p_33619_.m_128405_("Variant", this.getVariant());
        p_33619_.m_128379_("wasOnGround", this.wasOnGround);
        this.m_21678_(p_33619_);
    }

    public void m_7378_(CompoundTag p_33607_) {
        super.m_7378_(p_33607_);
        this.setVariant(p_33607_.m_128451_("Variant"));
        this.wasOnGround = p_33607_.m_128471_("wasOnGround");
        this.m_147285_(this.f_19853_, p_33607_);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_VARIANT);
    }

    private void setVariant(int p_149118_) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)p_149118_);
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        if (!this.m_21525_()) {
            this.handleAirSupply(i);
        }
    }

    protected void handleAirSupply(int p_149194_) {
        if (this.m_6084_() && !this.m_20071_()) {
            this.m_20301_(p_149194_);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(DamageSource.f_19324_, 2.0f);
            }
        } else {
            this.m_20301_(this.m_6062_());
        }
    }

    public int m_6062_() {
        return 6000;
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    protected ParticleOptions getParticleType() {
        return ParticleTypes.f_123804_;
    }

    protected boolean m_8028_() {
        return true;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, SpawnGroupData p_21437_, CompoundTag p_21438_) {
        int rand = new Random().nextInt(5);
        this.setVariant(rand);
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    public int getHappyTick() {
        return this.happy;
    }

    public void m_8107_() {
        int nextHappyTime;
        super.m_8107_();
        if (this.happy > 0) {
            --this.happy;
        }
        if ((nextHappyTime = this.f_19796_.m_188503_(1000)) == 0 && this.happy == 0) {
            this.happy = 30;
            this.f_19853_.m_7605_((Entity)this, (byte)4);
        }
        if (!this.f_19853_.f_46443_) {
            this.m_21666_((ServerLevel)this.f_19853_, true);
        }
    }

    public void m_8119_() {
        this.squish += (this.targetSquish - this.squish) * 0.5f;
        this.oSquish = this.squish;
        super.m_8119_();
        if (this.f_19861_ && !this.wasOnGround) {
            for (int i = 0; i < 8; ++i) {
                float f = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                float f1 = this.f_19796_.m_188501_() * 0.25f;
                float f2 = Mth.m_14031_((float)f) * (float)i * 0.5f * f1;
                this.f_19853_.m_7106_(this.getParticleType(), this.m_20185_() + (double)f2, this.m_20186_(), this.m_20189_() + (double)f2, 0.0, 0.0, 0.0);
            }
            this.m_5496_(this.getSquishSound(), this.m_6121_(), ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) / 0.8f);
            this.targetSquish = -0.5f;
        } else if (!this.f_19861_ && this.wasOnGround) {
            this.targetSquish = 1.0f;
        }
        this.wasOnGround = this.f_19861_;
        this.decreaseSquish();
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 4) {
            this.happy = 30;
            this.m_5496_(SoundEvents.f_144064_, 1.0f, 1.0f);
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    protected void decreaseSquish() {
        this.targetSquish *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.f_19796_.m_188503_(20) + 10;
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public void m_7350_(EntityDataAccessor<?> p_33609_) {
        if (ID_SIZE.equals(p_33609_)) {
            this.m_6210_();
            this.m_146922_(this.f_20885_);
            this.f_20883_ = this.f_20885_;
            if (this.m_20069_() && this.f_19796_.m_188503_(20) == 0) {
                this.m_5841_();
            }
        }
        super.m_7350_(p_33609_);
    }

    public void m_7334_(Entity p_33636_) {
        super.m_7334_(p_33636_);
    }

    public void m_6123_(Player p_33611_) {
        if (this.isDealsDamage()) {
            this.dealDamage((LivingEntity)p_33611_);
        }
    }

    protected void dealDamage(LivingEntity p_33638_) {
        if (this.m_6084_()) {
            boolean i = true;
            if (this.m_20280_((Entity)p_33638_) < 0.6 * (double)i * 0.6 * (double)i && this.m_142582_((Entity)p_33638_) && p_33638_.m_6469_(DamageSource.m_19370_((LivingEntity)this), this.getAttackDamage())) {
                this.m_5496_(SoundEvents.f_144061_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                this.m_19970_((LivingEntity)this, (Entity)p_33638_);
            }
        }
    }

    public InteractionResult m_6071_(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.m_21120_(p_30413_);
        Item item = itemstack.m_41720_();
        if (this.f_19853_.f_46443_) {
            boolean flag = itemstack.m_150930_(Items.f_42459_);
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (itemstack.m_150930_(Items.f_42459_)) {
            if (!p_30412_.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.happy = 30;
            this.f_19853_.m_7605_((Entity)this, (byte)4);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(p_30412_, p_30413_);
    }

    protected float m_6431_(Pose p_33614_, EntityDimensions p_33615_) {
        return 0.625f * p_33615_.f_20378_;
    }

    protected boolean isDealsDamage() {
        return this.m_6142_();
    }

    protected float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    protected SoundEvent m_7975_(DamageSource p_33631_) {
        return SoundEvents.f_144063_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_144062_;
    }

    protected SoundEvent getSquishSound() {
        return SoundEvents.f_144066_;
    }

    protected float m_6121_() {
        return 0.1f;
    }

    public int m_8132_() {
        return 0;
    }

    protected boolean doPlayJumpSound() {
        return true;
    }

    protected void m_6135_() {
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_, this.m_6118_(), vec3.f_82481_);
        this.f_19812_ = true;
    }

    float getSoundPitch() {
        float f = 0.8f;
        return ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) * f;
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.f_144066_;
    }

    protected boolean spawnCustomParticles() {
        return false;
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int p_30404_) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID p_30400_) {
        this.persistentAngerTarget = p_30400_;
    }

    static class BucketedAxolotlMoveControl
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private final BucketedAxolotl slime;
        private boolean isAggressive;

        public BucketedAxolotlMoveControl(BucketedAxolotl p_33668_) {
            super((Mob)p_33668_);
            this.slime = p_33668_;
            this.yRot = 180.0f * p_33668_.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float p_33673_, boolean p_33674_) {
            this.yRot = p_33673_;
            this.isAggressive = p_33674_;
        }

        public void setWantedMovement(double p_33671_) {
            this.f_24978_ = p_33671_;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.f_24974_.m_20096_()) {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.m_21569_().m_24901_();
                        if (this.slime.doPlayJumpSound()) {
                            this.slime.m_5496_(this.slime.getJumpSound(), this.slime.m_6121_(), this.slime.getSoundPitch());
                        }
                    } else {
                        this.slime.f_20900_ = 0.0f;
                        this.slime.f_20902_ = 0.0f;
                        this.f_24974_.m_7910_(0.0f);
                    }
                } else {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                }
            }
        }
    }

    static class BucketedAxolotlFloatGoal
    extends Goal {
        private final BucketedAxolotl slime;

        public BucketedAxolotlFloatGoal(BucketedAxolotl p_33655_) {
            this.slime = p_33655_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            p_33655_.m_21573_().m_7008_(true);
        }

        public boolean m_8036_() {
            return (this.slime.m_20069_() || this.slime.m_20077_()) && this.slime.m_21566_() instanceof BucketedAxolotlMoveControl;
        }

        public void m_8037_() {
            if (this.slime.m_217043_().m_188501_() < 0.8f) {
                this.slime.m_21569_().m_24901_();
            }
            ((BucketedAxolotlMoveControl)this.slime.m_21566_()).setWantedMovement(1.2);
        }
    }

    static class BucketedAxolotlAttackGoal
    extends Goal {
        private final BucketedAxolotl slime;
        private int growTiredTimer;

        public BucketedAxolotlAttackGoal(BucketedAxolotl p_33648_) {
            this.slime = p_33648_;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            return !this.slime.m_6779_(livingentity) ? false : this.slime.m_21566_() instanceof BucketedAxolotlMoveControl;
        }

        public void m_8056_() {
            this.growTiredTimer = 300;
            super.m_8056_();
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!this.slime.m_6779_(livingentity)) {
                return false;
            }
            return --this.growTiredTimer > 0;
        }

        public void m_8037_() {
            this.slime.m_21391_((Entity)this.slime.m_5448_(), 10.0f, 10.0f);
            ((BucketedAxolotlMoveControl)this.slime.m_21566_()).setDirection(this.slime.m_146908_(), this.slime.isDealsDamage());
        }
    }

    static class BucketedAxolotlRandomDirectionGoal
    extends Goal {
        private final BucketedAxolotl slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public BucketedAxolotlRandomDirectionGoal(BucketedAxolotl p_33679_) {
            this.slime = p_33679_;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.slime.m_5448_() == null && (this.slime.f_19861_ || this.slime.m_20069_() || this.slime.m_20077_() || this.slime.m_21023_(MobEffects.f_19620_)) && this.slime.m_21566_() instanceof BucketedAxolotlMoveControl;
        }

        public void m_8037_() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.slime.m_217043_().m_188503_(60);
                this.chosenDegrees = this.slime.m_217043_().m_188503_(360);
            }
            ((BucketedAxolotlMoveControl)this.slime.m_21566_()).setDirection(this.chosenDegrees, false);
        }
    }

    static class BucketedAxolotlKeepOnJumpingGoal
    extends Goal {
        private final BucketedAxolotl slime;

        public BucketedAxolotlKeepOnJumpingGoal(BucketedAxolotl p_33660_) {
            this.slime = p_33660_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.slime.m_20159_();
        }

        public void m_8037_() {
            ((BucketedAxolotlMoveControl)this.slime.m_21566_()).setWantedMovement(1.0);
        }
    }
}

