/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs.blazewolf;

import com.minecraftserverzone.weirdmobs.entities.mobs.blazewolf.BlazeWolfCollarLayer;
import com.minecraftserverzone.weirdmobs.entities.mobs.blazewolf.BlazeWolfEntity;
import com.minecraftserverzone.weirdmobs.entities.mobs.blazewolf.BlazeWolfModel;
import com.minecraftserverzone.weirdmobs.setup.MyModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlazeWolfRenderer
extends MobRenderer<BlazeWolfEntity, BlazeWolfModel<BlazeWolfEntity>> {
    private static final ResourceLocation WOLF_LOCATION = new ResourceLocation("weirdmobs", "textures/entity/blazewolf_entity.png");
    private static final ResourceLocation WOLF_TAME_LOCATION = new ResourceLocation("weirdmobs", "textures/entity/blazewolf_entity_tame.png");
    private static final ResourceLocation WOLF_ANGRY_LOCATION = new ResourceLocation("weirdmobs", "textures/entity/blazewolf_entity_angry.png");

    public BlazeWolfRenderer(EntityRendererProvider.Context manager, String textureName) {
        super(manager, new BlazeWolfModel(manager.m_174023_(MyModelLayers.BLAZE_WOLF)), 0.5f);
        this.m_115326_(new BlazeWolfCollarLayer((RenderLayerParent<BlazeWolfEntity, BlazeWolfModel<BlazeWolfEntity>>)this));
    }

    protected float getBob(BlazeWolfEntity p_116528_, float p_116529_) {
        return p_116528_.getTailAngle();
    }

    protected int getBlockLightLevel(BlazeWolfEntity p_114496_, BlockPos p_114497_) {
        return 15;
    }

    public void render(BlazeWolfEntity p_116531_, float p_116532_, float p_116533_, PoseStack p_116534_, MultiBufferSource p_116535_, int p_116536_) {
        if (p_116531_.isWet()) {
            float f = p_116531_.getWetShade(p_116533_);
            ((BlazeWolfModel)this.f_115290_).m_102419_(f, f, f);
        }
        super.m_7392_((Mob)p_116531_, p_116532_, p_116533_, p_116534_, p_116535_, p_116536_);
        if (p_116531_.isWet()) {
            ((BlazeWolfModel)this.f_115290_).m_102419_(1.0f, 1.0f, 1.0f);
        }
    }

    public ResourceLocation getTextureLocation(BlazeWolfEntity blazewolfentity) {
        if (blazewolfentity.m_21824_()) {
            return WOLF_TAME_LOCATION;
        }
        return blazewolfentity.m_21660_() ? WOLF_ANGRY_LOCATION : WOLF_LOCATION;
    }
}

