/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs.blazewolf;

import com.minecraftserverzone.weirdmobs.setup.Registrations;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class BlazeWolfEntity
extends TamableAnimal
implements NeutralMob {
    private static final EntityDataAccessor<Boolean> DATA_INTERESTED_ID = SynchedEntityData.m_135353_(BlazeWolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(BlazeWolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(BlazeWolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Predicate<LivingEntity> PREY_SELECTOR = p_30437_ -> {
        EntityType entitytype = p_30437_.m_6095_();
        return entitytype == EntityType.f_20520_ || entitytype == EntityType.f_20517_ || entitytype == EntityType.f_20452_;
    };
    private float interestedAngle;
    private float interestedAngleO;
    private boolean isWet;
    private boolean isShaking;
    private float shakeAnim;
    private float shakeAnimO;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private UUID persistentAngerTarget;

    public BlazeWolfEntity(EntityType<? extends BlazeWolfEntity> p_30369_, Level p_30370_) {
        super(p_30369_, p_30370_);
        this.m_7105_(false);
        this.f_21364_ = 5;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, new WolfAvoidEntityGoal<Llama>(this, Llama.class, 24.0f, 1.5, 1.5));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new BegGoal(this, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((BlazeWolfEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, PREY_SELECTOR));
        this.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.f_30122_));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22281_, 4.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_INTERESTED_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    protected void m_7355_(BlockPos p_30415_, BlockState p_30416_) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    public void m_7380_(CompoundTag p_30418_) {
        super.m_7380_(p_30418_);
        p_30418_.m_128344_("CollarColor", (byte)this.getCollarColor().m_41060_());
        this.m_21678_(p_30418_);
    }

    public static boolean checkAnyLightMonsterSpawnRules(EntityType<? extends BlazeWolfEntity> p_33024_, ServerLevelAccessor p_33025_, MobSpawnType p_33026_, BlockPos p_33027_, RandomSource p_33028_) {
        return p_33025_.m_46791_() != Difficulty.PEACEFUL && BlazeWolfEntity.m_217057_(p_33024_, (LevelAccessor)p_33025_, (MobSpawnType)p_33026_, (BlockPos)p_33027_, (RandomSource)p_33028_);
    }

    public void m_7378_(CompoundTag p_30402_) {
        super.m_7378_(p_30402_);
        if (p_30402_.m_128425_("CollarColor", 99)) {
            this.setCollarColor(DyeColor.m_41053_((int)p_30402_.m_128451_("CollarColor")));
        }
        this.m_147285_(this.f_19853_, p_30402_);
    }

    protected SoundEvent m_7515_() {
        if (this.m_21660_()) {
            return SoundEvents.f_12619_;
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            return this.m_21824_() && this.m_21223_() < 10.0f ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
        }
        return SoundEvents.f_12617_;
    }

    protected SoundEvent m_7975_(DamageSource p_30424_) {
        return SoundEvents.f_12621_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public boolean m_6060_() {
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.isWet && !this.isShaking && !this.m_21691_() && this.f_19861_) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
            this.f_19853_.m_7605_((Entity)this, (byte)8);
        }
        if (!this.f_19853_.f_46443_) {
            this.m_21666_((ServerLevel)this.f_19853_, true);
        }
        for (int i = 0; i < 1; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_()) {
            this.interestedAngleO = this.interestedAngle;
            this.interestedAngle = this.isInterested() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
            if (this.m_20071_()) {
                this.isWet = true;
                if (this.isShaking && !this.f_19853_.f_46443_) {
                    this.f_19853_.m_7605_((Entity)this, (byte)56);
                    this.cancelShake();
                }
            } else if ((this.isWet || this.isShaking) && this.isShaking) {
                if (this.shakeAnim == 0.0f) {
                    this.m_5496_(SoundEvents.f_12623_, this.m_6121_(), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                    this.m_146850_(GameEvent.f_223710_);
                }
                this.shakeAnimO = this.shakeAnim;
                this.shakeAnim += 0.05f;
                if (this.shakeAnimO >= 2.0f) {
                    this.isWet = false;
                    this.isShaking = false;
                    this.shakeAnimO = 0.0f;
                    this.shakeAnim = 0.0f;
                }
                if (this.shakeAnim > 0.4f) {
                    float f = (float)this.m_20186_();
                    int i = (int)(Mth.m_14031_((float)((this.shakeAnim - 0.4f) * (float)Math.PI)) * 7.0f);
                    Vec3 vec3 = this.m_20184_();
                    for (int j = 0; j < i; ++j) {
                        float f1 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                        float f2 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)f1, (double)(f + 0.8f), this.m_20189_() + (double)f2, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                    }
                }
            }
        }
    }

    private void cancelShake() {
        this.isShaking = false;
        this.shakeAnim = 0.0f;
        this.shakeAnimO = 0.0f;
    }

    public void m_6667_(DamageSource p_30384_) {
        this.isWet = false;
        this.isShaking = false;
        this.shakeAnimO = 0.0f;
        this.shakeAnim = 0.0f;
        super.m_6667_(p_30384_);
    }

    public boolean isWet() {
        return this.isWet;
    }

    public float getWetShade(float p_30447_) {
        return Math.min(0.5f + Mth.m_14179_((float)p_30447_, (float)this.shakeAnimO, (float)this.shakeAnim) / 2.0f * 0.5f, 1.0f);
    }

    public float getBodyRollAngle(float p_30433_, float p_30434_) {
        float f = (Mth.m_14179_((float)p_30433_, (float)this.shakeAnimO, (float)this.shakeAnim) + p_30434_) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return Mth.m_14031_((float)(f * (float)Math.PI)) * Mth.m_14031_((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    public float getHeadRollAngle(float p_30449_) {
        return Mth.m_14179_((float)p_30449_, (float)this.interestedAngleO, (float)this.interestedAngle) * 0.15f * (float)Math.PI;
    }

    protected float m_6431_(Pose p_30409_, EntityDimensions p_30410_) {
        return p_30410_.f_20378_ * 0.8f;
    }

    public int m_8132_() {
        return this.m_21825_() ? 20 : super.m_8132_();
    }

    public boolean m_6469_(DamageSource p_30386_, float p_30387_) {
        if (this.m_6673_(p_30386_)) {
            return false;
        }
        Entity entity = p_30386_.m_7639_();
        this.m_21839_(false);
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            p_30387_ = (p_30387_ + 1.0f) / 2.0f;
        }
        return super.m_6469_(p_30386_, p_30387_);
    }

    public boolean m_7327_(Entity p_30372_) {
        boolean flag = p_30372_.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, p_30372_);
        }
        if (p_30372_ instanceof LivingEntity) {
            p_30372_.m_6469_(DamageSource.f_19307_, 1.0f);
            p_30372_.m_7311_(60);
        }
        return flag;
    }

    public void m_7105_(boolean p_30443_) {
        super.m_7105_(p_30443_);
        if (p_30443_) {
            this.m_21051_(Attributes.f_22276_).m_22100_(25.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(12.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(6.0);
    }

    public InteractionResult m_6071_(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.m_21120_(p_30413_);
        Item item = itemstack.m_41720_();
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)p_30412_) || this.m_21824_() || itemstack.m_150930_(Items.f_42585_) && !this.m_21824_() && !this.m_21660_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                if (!p_30412_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5634_(15.0f);
                this.m_146850_(GameEvent.f_223708_);
                return InteractionResult.SUCCESS;
            }
            if (!(item instanceof DyeItem)) {
                InteractionResult interactionresult = super.m_6071_(p_30412_, p_30413_);
                if ((!interactionresult.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)p_30412_)) {
                    this.m_21839_(!this.m_21827_());
                    this.f_20899_ = false;
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    return InteractionResult.SUCCESS;
                }
                return interactionresult;
            }
            DyeColor dyecolor = ((DyeItem)item).m_41089_();
            if (dyecolor != this.getCollarColor()) {
                this.setCollarColor(dyecolor);
                if (!p_30412_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (itemstack.m_150930_(Items.f_42585_) && !this.m_21660_()) {
            if (!p_30412_.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)p_30412_)) {
                this.m_21828_(p_30412_);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(p_30412_, p_30413_);
    }

    public void m_7822_(byte p_30379_) {
        if (p_30379_ == 8) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
        } else if (p_30379_ == 56) {
            this.cancelShake();
        } else {
            super.m_7822_(p_30379_);
        }
    }

    public float getTailAngle() {
        if (this.m_21660_()) {
            return 1.5393804f;
        }
        return this.m_21824_() ? (0.55f - (this.m_21233_() - this.m_21223_()) * 0.02f) * (float)Math.PI : 0.62831855f;
    }

    public boolean m_6898_(ItemStack p_30440_) {
        Item item = p_30440_.m_41720_();
        return item.m_41472_() && item.m_41473_().m_38746_();
    }

    public int m_5792_() {
        return 8;
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int p_30404_) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID p_30400_) {
        this.persistentAngerTarget = p_30400_;
    }

    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor p_30398_) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)p_30398_.m_41060_());
    }

    public BlazeWolfEntity getBreedOffspring(ServerLevel p_149088_, AgeableMob p_149089_) {
        BlazeWolfEntity wolf = (BlazeWolfEntity)((EntityType)Registrations.BLAZE_WOLF.get()).m_20615_((Level)p_149088_);
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            wolf.m_21816_(uuid);
            wolf.m_7105_(true);
        }
        return wolf;
    }

    public void setIsInterested(boolean p_30445_) {
        this.f_19804_.m_135381_(DATA_INTERESTED_ID, (Object)p_30445_);
    }

    public boolean m_7848_(Animal p_30392_) {
        if (p_30392_ == this) {
            return false;
        }
        if (!this.m_21824_()) {
            return false;
        }
        if (!(p_30392_ instanceof BlazeWolfEntity)) {
            return false;
        }
        BlazeWolfEntity wolf = (BlazeWolfEntity)p_30392_;
        if (!wolf.m_21824_()) {
            return false;
        }
        if (wolf.m_21825_()) {
            return false;
        }
        return this.m_27593_() && wolf.m_27593_();
    }

    public boolean isInterested() {
        return (Boolean)this.f_19804_.m_135370_(DATA_INTERESTED_ID);
    }

    public boolean m_7757_(LivingEntity p_30389_, LivingEntity p_30390_) {
        if (!(p_30389_ instanceof Creeper) && !(p_30389_ instanceof Ghast)) {
            if (p_30389_ instanceof BlazeWolfEntity) {
                BlazeWolfEntity wolf = (BlazeWolfEntity)p_30389_;
                return !wolf.m_21824_() || wolf.m_21826_() != p_30390_;
            }
            if (p_30389_ instanceof Player && p_30390_ instanceof Player && !((Player)p_30390_).m_7099_((Player)p_30389_)) {
                return false;
            }
            if (p_30389_ instanceof AbstractHorse && ((AbstractHorse)p_30389_).m_30614_()) {
                return false;
            }
            return !(p_30389_ instanceof TamableAnimal) || !((TamableAnimal)p_30389_).m_21824_();
        }
        return false;
    }

    public boolean m_6573_(Player p_30396_) {
        return !this.m_21660_() && super.m_6573_(p_30396_);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    class WolfAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final BlazeWolfEntity wolf;

        public WolfAvoidEntityGoal(BlazeWolfEntity p_30454_, Class<T> p_30455_, float p_30456_, double p_30457_, double p_30458_) {
            super((PathfinderMob)p_30454_, p_30455_, p_30456_, p_30457_, p_30458_);
            this.wolf = p_30454_;
        }

        public boolean m_8036_() {
            if (super.m_8036_() && this.f_25016_ instanceof Llama) {
                return !this.wolf.m_21824_() && this.avoidLlama((Llama)this.f_25016_);
            }
            return false;
        }

        private boolean avoidLlama(Llama p_30461_) {
            return p_30461_.m_30823_() >= BlazeWolfEntity.this.f_19796_.m_188503_(5);
        }

        public void m_8056_() {
            BlazeWolfEntity.this.m_6710_(null);
            super.m_8056_();
        }

        public void m_8037_() {
            BlazeWolfEntity.this.m_6710_(null);
            super.m_8037_();
        }
    }

    class BegGoal
    extends Goal {
        private final BlazeWolfEntity wolf;
        private Player player;
        private final Level level;
        private final float lookDistance;
        private int lookTime;
        private final TargetingConditions begTargeting;

        public BegGoal(BlazeWolfEntity p_25063_, float p_25064_) {
            this.wolf = p_25063_;
            this.level = p_25063_.f_19853_;
            this.lookDistance = p_25064_;
            this.begTargeting = TargetingConditions.m_148353_().m_26883_((double)p_25064_);
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            this.player = this.level.m_45946_(this.begTargeting, (LivingEntity)this.wolf);
            return this.player == null ? false : this.playerHoldingInteresting(this.player);
        }

        public boolean m_8045_() {
            if (!this.player.m_6084_()) {
                return false;
            }
            if (this.wolf.m_20280_((Entity)this.player) > (double)(this.lookDistance * this.lookDistance)) {
                return false;
            }
            return this.lookTime > 0 && this.playerHoldingInteresting(this.player);
        }

        public void m_8056_() {
            this.wolf.setIsInterested(true);
            this.lookTime = 40 + this.wolf.m_217043_().m_188503_(40);
        }

        public void m_8041_() {
            this.wolf.setIsInterested(false);
            this.player = null;
        }

        public void m_8037_() {
            this.wolf.m_21563_().m_24950_(this.player.m_20185_(), this.player.m_20188_(), this.player.m_20189_(), 10.0f, (float)this.wolf.m_8132_());
            --this.lookTime;
        }

        private boolean playerHoldingInteresting(Player p_25067_) {
            for (InteractionHand interactionhand : InteractionHand.values()) {
                ItemStack itemstack = p_25067_.m_21120_(interactionhand);
                if (this.wolf.m_21824_() && itemstack.m_150930_(Items.f_42585_)) {
                    return true;
                }
                if (!this.wolf.m_6898_(itemstack)) continue;
                return true;
            }
            return false;
        }
    }
}

