/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs.blazecreeper;

import com.minecraftserverzone.weirdmobs.entities.mobs.blazecreeper.BlazeCreeperEntity;
import com.minecraftserverzone.weirdmobs.entities.mobs.blazecreeper.BlazeCreeperModel;
import com.minecraftserverzone.weirdmobs.setup.HelperFunctions;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class BlazeCreeperRenderer<T extends BlazeCreeperEntity, M extends BlazeCreeperModel<T>>
extends MobRenderer<T, M> {
    private final ResourceLocation textureLoc;

    public BlazeCreeperRenderer(EntityRendererProvider.Context manager, M model, float shadowSize, String textureName) {
        super(manager, model, shadowSize);
        this.textureLoc = HelperFunctions.getModelTexture(textureName);
    }

    protected void scale(BlazeCreeperEntity p_114046_, PoseStack p_114047_, float p_114048_) {
        float f = p_114046_.getSwelling(p_114048_);
        float f1 = 1.0f + Mth.m_14031_((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        p_114047_.m_85841_(f2, f3, f2);
    }

    protected float getWhiteOverlayProgress(BlazeCreeperEntity p_114043_, float p_114044_) {
        float f = p_114043_.getSwelling(p_114044_);
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : Mth.m_14036_((float)f, (float)0.5f, (float)1.0f);
    }

    protected int getBlockLightLevel(T p_114496_, BlockPos p_114497_) {
        return 15;
    }

    public ResourceLocation getTextureLocation(T entity) {
        return this.textureLoc;
    }
}

