/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs.blazecreeper;

import com.minecraftserverzone.weirdmobs.entities.mobs.blazecreeper.BlazeCreeperEntity;
import java.util.Arrays;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class BlazeCreeperModel<T extends BlazeCreeperEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart left_hind_leg;
    private final ModelPart left_front_leg;
    private final ModelPart right_front_leg;
    private final ModelPart head;
    private final ModelPart right_hind_leg;
    private final ModelPart[] upperBodyParts;

    public BlazeCreeperModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.left_hind_leg = root.m_171324_("left_hind_leg");
        this.left_front_leg = root.m_171324_("left_front_leg");
        this.right_front_leg = root.m_171324_("right_front_leg");
        this.right_hind_leg = root.m_171324_("right_hind_leg");
        this.upperBodyParts = new ModelPart[12];
        Arrays.setAll(this.upperBodyParts, fire -> root.m_171324_(BlazeCreeperModel.getPartName(fire)));
    }

    private static String getPartName(int num) {
        return "fire" + num;
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition partRoot = mesh.m_171576_();
        partRoot.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        partRoot.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        CubeListBuilder legs = CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, CubeDeformation.f_171458_);
        partRoot.m_171599_("left_hind_leg", legs, PartPose.m_171419_((float)2.0f, (float)18.0f, (float)4.0f));
        partRoot.m_171599_("left_front_leg", legs, PartPose.m_171419_((float)2.0f, (float)18.0f, (float)-4.0f));
        partRoot.m_171599_("right_front_leg", legs, PartPose.m_171419_((float)-2.0f, (float)18.0f, (float)-4.0f));
        partRoot.m_171599_("right_hind_leg", legs, PartPose.m_171419_((float)-2.0f, (float)18.0f, (float)4.0f));
        float f = 0.0f;
        CubeListBuilder cubelistbuilder = CubeListBuilder.m_171558_().m_171514_(56, 22).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 8.0f, 2.0f);
        for (int i = 0; i < 4; ++i) {
            float f1 = Mth.m_14089_((float)f) * 9.0f;
            float f2 = -2.0f + Mth.m_14089_((float)((float)(i * 2) * 0.25f));
            float f3 = Mth.m_14031_((float)f) * 9.0f;
            partRoot.m_171599_(BlazeCreeperModel.getPartName(i), cubelistbuilder, PartPose.m_171419_((float)f1, (float)f2, (float)f3));
            f += 1.0f;
        }
        f = 0.7853982f;
        for (int j = 4; j < 8; ++j) {
            float f4 = Mth.m_14089_((float)f) * 7.0f;
            float f6 = 2.0f + Mth.m_14089_((float)((float)(j * 2) * 0.25f));
            float f8 = Mth.m_14031_((float)f) * 7.0f;
            partRoot.m_171599_(BlazeCreeperModel.getPartName(j), cubelistbuilder, PartPose.m_171419_((float)f4, (float)f6, (float)f8));
            f += 1.0f;
        }
        f = 0.47123894f;
        for (int k = 8; k < 12; ++k) {
            float f5 = Mth.m_14089_((float)f) * 5.0f;
            float f7 = 11.0f + Mth.m_14089_((float)((float)k * 1.5f * 0.5f));
            float f9 = Mth.m_14031_((float)f) * 5.0f;
            partRoot.m_171599_(BlazeCreeperModel.getPartName(k), cubelistbuilder, PartPose.m_171419_((float)f5, (float)f7, (float)f9));
            f += 1.0f;
        }
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.right_front_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.left_hind_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.right_hind_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.left_front_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f = ageInTicks * (float)Math.PI * -0.1f;
        for (int i = 0; i < 4; ++i) {
            this.upperBodyParts[i].f_104201_ = -2.0f + Mth.m_14089_((float)(((float)(i * 2) + ageInTicks) * 0.25f));
            this.upperBodyParts[i].f_104200_ = Mth.m_14089_((float)f) * 9.0f;
            this.upperBodyParts[i].f_104202_ = Mth.m_14031_((float)f) * 9.0f;
            f += 1.0f;
        }
        f = 0.7853982f + ageInTicks * (float)Math.PI * 0.03f;
        for (int j = 4; j < 8; ++j) {
            this.upperBodyParts[j].f_104201_ = 2.0f + Mth.m_14089_((float)(((float)(j * 2) + ageInTicks) * 0.25f));
            this.upperBodyParts[j].f_104200_ = Mth.m_14089_((float)f) * 7.0f;
            this.upperBodyParts[j].f_104202_ = Mth.m_14031_((float)f) * 7.0f;
            f += 1.0f;
        }
        f = 0.47123894f + ageInTicks * (float)Math.PI * -0.05f;
        for (int k = 8; k < 12; ++k) {
            this.upperBodyParts[k].f_104201_ = 11.0f + Mth.m_14089_((float)(((float)k * 1.5f + ageInTicks) * 0.5f));
            this.upperBodyParts[k].f_104200_ = Mth.m_14089_((float)f) * 5.0f;
            this.upperBodyParts[k].f_104202_ = Mth.m_14031_((float)f) * 5.0f;
            f += 1.0f;
        }
    }
}

