/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs.blazecreeper;

import java.util.Collection;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class BlazeCreeperEntity
extends Monster
implements PowerableMob {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(BlazeCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_POWERED = SynchedEntityData.m_135353_(BlazeCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int oldSwell;
    private int swell;
    private int maxSwell = 30;
    private int explosionRadius = 3;
    private int droppedSkulls;
    private float allowedHeightOffset = 0.5f;
    private int nextHeightOffsetChangeTick;

    public BlazeCreeperEntity(EntityType<? extends BlazeCreeperEntity> p_32278_, Level p_32279_) {
        super(p_32278_, p_32279_);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.f_21364_ = 10;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new BlazeCreeperAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new BlazeCreeperSwellGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22276_, 25.0);
    }

    public int m_6056_() {
        return this.m_5448_() == null ? 3 : 3 + (int)(this.m_21223_() - 1.0f);
    }

    public boolean m_142535_(float p_149687_, float p_149688_, DamageSource p_149689_) {
        boolean flag = super.m_142535_(p_149687_, p_149688_, p_149689_);
        this.swell = (int)((float)this.swell + p_149687_ * 1.5f);
        if (this.swell > this.maxSwell - 5) {
            this.swell = this.maxSwell - 5;
        }
        return flag;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)-1);
        this.f_19804_.m_135372_(DATA_IS_POWERED, (Object)false);
    }

    public void m_7380_(CompoundTag p_32304_) {
        super.m_7380_(p_32304_);
        if (((Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED)).booleanValue()) {
            p_32304_.m_128379_("powered", true);
        }
        p_32304_.m_128376_("Fuse", (short)this.maxSwell);
        p_32304_.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
    }

    public void m_7378_(CompoundTag p_32296_) {
        super.m_7378_(p_32296_);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)p_32296_.m_128471_("powered"));
        if (p_32296_.m_128425_("Fuse", 99)) {
            this.maxSwell = p_32296_.m_128448_("Fuse");
        }
        if (p_32296_.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = p_32296_.m_128445_("ExplosionRadius");
        }
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            this.oldSwell = this.swell;
            int i = this.getSwellDir();
            if (i > 0 && this.swell == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explodeCreeper();
            }
        }
        super.m_8119_();
    }

    public void m_6710_(@Nullable LivingEntity p_149691_) {
        if (!(p_149691_ instanceof Goat)) {
            super.m_6710_(p_149691_);
        }
    }

    protected SoundEvent m_7975_(DamageSource p_32309_) {
        return SoundEvents.f_11836_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11835_;
    }

    protected void m_7472_(DamageSource p_32292_, int p_32293_, boolean p_32294_) {
        BlazeCreeperEntity creeper;
        super.m_7472_(p_32292_, p_32293_, p_32294_);
        Entity entity = p_32292_.m_7639_();
        if (entity != this && entity instanceof BlazeCreeperEntity && (creeper = (BlazeCreeperEntity)entity).canDropMobsSkull()) {
            creeper.increaseDroppedSkulls();
            this.m_19998_((ItemLike)Items.f_42682_);
        }
    }

    public boolean m_7327_(Entity p_32281_) {
        return true;
    }

    public boolean m_7090_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED);
    }

    public float getSwelling(float p_32321_) {
        return Mth.m_14179_((float)p_32321_, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void setSwellDir(int p_32284_) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)p_32284_);
    }

    public void m_8038_(ServerLevel p_32286_, LightningBolt p_32287_) {
        super.m_8038_(p_32286_, p_32287_);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)true);
    }

    protected InteractionResult m_6071_(Player p_32301_, InteractionHand p_32302_) {
        ItemStack itemstack = p_32301_.m_21120_(p_32302_);
        if (itemstack.m_150930_(Items.f_42409_)) {
            this.f_19853_.m_6263_(p_32301_, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11942_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            if (!this.f_19853_.f_46443_) {
                itemstack.m_41622_(1, (LivingEntity)p_32301_, p_32290_ -> p_32290_.m_21190_(p_32302_));
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(p_32301_, p_32302_);
    }

    private void explodeCreeper() {
        if (!this.f_19853_.f_46443_) {
            Explosion.BlockInteraction explosion$blockinteraction = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
            float f = this.m_7090_() ? 4.0f : 2.0f;
            this.f_20890_ = true;
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.explosionRadius * f, explosion$blockinteraction);
            this.m_146870_();
            this.spawnLingeringCloud();
        }
    }

    private void spawnLingeringCloud() {
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloud.m_19712_(2.5f);
            areaeffectcloud.m_19732_(-0.5f);
            areaeffectcloud.m_19740_(10);
            areaeffectcloud.m_19734_(areaeffectcloud.m_19748_() / 2);
            areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
            for (MobEffectInstance mobeffectinstance : collection) {
                areaeffectcloud.m_19716_(new MobEffectInstance(mobeffectinstance));
            }
            this.f_19853_.m_7967_((Entity)areaeffectcloud);
        }
    }

    public float m_213856_() {
        return 1.0f;
    }

    public void m_8107_() {
        if (this.f_19861_ || this.m_20184_().f_82480_ < 0.0) {
            // empty if block
        }
        if (this.f_19853_.f_46443_) {
            if (this.f_19796_.m_188503_(24) == 0 && !this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, SoundEvents.f_11702_, this.m_5720_(), 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.m_8107_();
    }

    public boolean m_6126_() {
        return true;
    }

    protected void m_8024_() {
        LivingEntity livingentity;
        --this.nextHeightOffsetChangeTick;
        if (this.nextHeightOffsetChangeTick <= 0) {
            this.nextHeightOffsetChangeTick = 100;
            this.allowedHeightOffset = 0.5f + (float)this.f_19796_.m_188583_() * 3.0f;
        }
        if ((livingentity = this.m_5448_()) != null && livingentity.m_20188_() > this.m_20188_() + (double)this.allowedHeightOffset && this.m_6779_(livingentity)) {
            Vec3 vec3 = this.m_20184_();
            this.f_19812_ = true;
        }
        super.m_8024_();
    }

    public boolean canDropMobsSkull() {
        return this.m_7090_() && this.droppedSkulls < 1;
    }

    public void increaseDroppedSkulls() {
        ++this.droppedSkulls;
    }

    public boolean m_6060_() {
        return false;
    }

    static class BlazeCreeperAttackGoal
    extends Goal {
        private final BlazeCreeperEntity blaze;
        private int attackStep;
        private int attackTime;
        private int lastSeen;

        public BlazeCreeperAttackGoal(BlazeCreeperEntity p_32247_) {
            this.blaze = p_32247_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.blaze.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.blaze.m_6779_(livingentity);
        }

        public void m_8056_() {
            this.attackStep = 0;
        }

        public void m_8041_() {
            this.lastSeen = 0;
        }

        public void m_8037_() {
            --this.attackTime;
            LivingEntity livingentity = this.blaze.m_5448_();
            if (livingentity != null) {
                boolean flag = this.blaze.m_21574_().m_148306_((Entity)livingentity);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.blaze.m_20280_((Entity)livingentity);
                if (d0 < 4.0) {
                    if (!flag) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.blaze.m_7327_((Entity)livingentity);
                    }
                    this.blaze.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    double d1 = livingentity.m_20185_() - this.blaze.m_20185_();
                    double d2 = livingentity.m_20186_() - this.blaze.m_20186_();
                    double d3 = livingentity.m_20189_() - this.blaze.m_20189_();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                        } else if (this.attackStep <= 4) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1) {
                            double d4 = Math.sqrt(Math.sqrt(d0)) * 0.5;
                            if (!this.blaze.m_20067_()) {
                                this.blaze.f_19853_.m_5898_((Player)null, 1018, this.blaze.m_20183_(), 0);
                            }
                            for (int i = 0; i < 1; ++i) {
                                SmallFireball smallfireball = new SmallFireball(this.blaze.f_19853_, (LivingEntity)this.blaze, d1 + this.blaze.m_217043_().m_188583_() * d4, d2, d3 + this.blaze.m_217043_().m_188583_() * d4);
                                smallfireball.m_6034_(smallfireball.m_20185_(), this.blaze.m_20227_(0.5) + 0.5, smallfireball.m_20189_());
                                this.blaze.f_19853_.m_7967_((Entity)smallfireball);
                            }
                        }
                    }
                    this.blaze.m_21563_().m_24960_((Entity)livingentity, 10.0f, 10.0f);
                } else if (this.lastSeen < 1) {
                    this.blaze.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                }
                super.m_8037_();
            }
        }

        private double getFollowDistance() {
            return this.blaze.m_21133_(Attributes.f_22277_);
        }
    }

    public class BlazeCreeperSwellGoal
    extends Goal {
        private final BlazeCreeperEntity blazecreeper;
        private LivingEntity target;

        public BlazeCreeperSwellGoal(BlazeCreeperEntity p_25919_) {
            this.blazecreeper = p_25919_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.blazecreeper.m_5448_();
            return this.blazecreeper.getSwellDir() > 0 || livingentity != null && this.blazecreeper.m_20280_((Entity)livingentity) < 9.0;
        }

        public void m_8056_() {
            this.blazecreeper.m_21573_().m_26573_();
            this.target = this.blazecreeper.m_5448_();
        }

        public void m_8041_() {
            this.target = null;
        }

        public void m_8037_() {
            if (this.target == null) {
                this.blazecreeper.setSwellDir(-1);
            } else if (this.blazecreeper.m_20280_((Entity)this.target) > 49.0) {
                this.blazecreeper.setSwellDir(-1);
            } else if (!this.blazecreeper.m_21574_().m_148306_((Entity)this.target)) {
                this.blazecreeper.setSwellDir(-1);
            } else {
                this.blazecreeper.setSwellDir(1);
            }
        }
    }
}

