/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs.basaltsnake;

import com.minecraftserverzone.weirdmobs.entities.mobs.basaltsnake.BasaltSnakePart;
import com.minecraftserverzone.weirdmobs.setup.ModSounds;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;

public class BasaltSnake
extends Monster {
    private SilverfishWakeUpFriendsGoal friendsGoal;
    public final double[][] positions = new double[64][3];
    public int posPointer = -1;
    public float yRotA;
    public float oFlapTime;
    public float flapTime;
    public boolean inWall;
    private int attackAnimationTick;
    private final BasaltSnakePart[] subEntities;
    public final BasaltSnakePart head = new BasaltSnakePart(this, 1.0f, 1.0f);
    private final BasaltSnakePart neck = new BasaltSnakePart(this, 1.0f, 1.0f);
    private final BasaltSnakePart neck2 = new BasaltSnakePart(this, 1.0f, 1.0f);
    private final BasaltSnakePart neck3 = new BasaltSnakePart(this, 1.0f, 1.0f);
    private final BasaltSnakePart neck4 = new BasaltSnakePart(this, 1.0f, 1.0f);

    public BasaltSnake(EntityType<? extends BasaltSnake> p_33523_, Level p_33524_) {
        super(p_33523_, p_33524_);
        this.subEntities = new BasaltSnakePart[]{this.head, this.neck, this.neck2, this.neck3, this.neck4};
        this.m_21153_(this.m_21233_());
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.f_21364_ = 10;
    }

    public boolean m_142039_() {
        float f = Mth.m_14089_((float)(this.flapTime * ((float)Math.PI * 2)));
        float f1 = Mth.m_14089_((float)(this.oFlapTime * ((float)Math.PI * 2)));
        return f1 <= -0.3f && f >= -0.3f;
    }

    public double[] getLatencyPos(int p_31102_, float p_31103_) {
        if (this.m_21224_()) {
            p_31103_ = 0.0f;
        }
        p_31103_ = 1.0f - p_31103_;
        int i = this.posPointer - p_31102_ & 0x3F;
        int j = this.posPointer - p_31102_ - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.positions[i][0];
        double d1 = Mth.m_14175_((double)(this.positions[j][0] - d0));
        adouble[0] = d0 + d1 * (double)p_31103_;
        d0 = this.positions[i][1];
        d1 = this.positions[j][1] - d0;
        adouble[1] = d0 + d1 * (double)p_31103_;
        adouble[2] = Mth.m_14139_((double)p_31103_, (double)this.positions[i][2], (double)this.positions[j][2]);
        return adouble;
    }

    public void m_8107_() {
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        Vec3 vec3 = this.m_20184_();
        float f = 0.2f / ((float)vec3.m_165924_() * 10.0f + 1.0f);
        this.oFlapTime = this.flapTime;
        this.flapTime += (f *= (float)Math.pow(2.0, vec3.f_82480_));
        if (this.posPointer < 0) {
            for (int i = 0; i < this.positions.length; ++i) {
                this.positions[i][0] = this.m_146908_();
                this.positions[i][1] = this.m_20186_();
            }
        }
        if (++this.posPointer == this.positions.length) {
            this.posPointer = 0;
        }
        this.positions[this.posPointer][0] = this.m_146908_();
        this.positions[this.posPointer][1] = this.m_20186_();
        if (this.f_19853_.f_46443_ && this.f_20903_ > 0) {
            double d7 = this.m_20185_() + (this.f_20904_ - this.m_20185_()) / (double)this.f_20903_;
            double d0 = this.m_20186_() + (this.f_20905_ - this.m_20186_()) / (double)this.f_20903_;
            double d1 = this.m_20189_() + (this.f_20906_ - this.m_20189_()) / (double)this.f_20903_;
            double d2 = Mth.m_14175_((double)(this.f_20907_ - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d2 / (float)this.f_20903_);
            this.m_146926_(this.m_146909_() + (float)(this.f_20908_ - (double)this.m_146909_()) / (float)this.f_20903_);
            --this.f_20903_;
            this.m_6034_(d7, d0, d1);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
        this.f_20883_ = this.m_146908_();
        Vec3[] avec3 = new Vec3[this.subEntities.length];
        for (int j = 0; j < this.subEntities.length; ++j) {
            avec3[j] = new Vec3(this.subEntities[j].m_20185_(), this.subEntities[j].m_20186_(), this.subEntities[j].m_20189_());
        }
        float f11 = 0.0f;
        float f12 = Mth.m_14089_((float)f11);
        float f1 = Mth.m_14031_((float)f11);
        float f3 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180) - this.yRotA * 0.01f));
        float f15 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180) - this.yRotA * 0.01f));
        float f4 = this.getHeadYOffset();
        this.tickPart(this.head, f3 * 0.0f * f12, f4 + f1 * 0.0f, -f15 * 0.0f * f12);
        this.tickPart(this.neck, f3 * 1.0f * f12, f4 + f1 * 1.0f, -f15 * 1.0f * f12);
        this.tickPart(this.neck2, f3 * 2.0f * f12, f4 + f1 * 2.0f, -f15 * 2.0f * f12);
        this.tickPart(this.neck3, f3 * 3.0f * f12, f4 + f1 * 3.0f, -f15 * 3.0f * f12);
        this.tickPart(this.neck4, f3 * 4.0f * f12, f4 + f1 * 4.0f, -f15 * 4.0f * f12);
        if (!this.f_19853_.f_46443_) {
            this.inWall = this.checkWalls(this.head.m_20191_()) | this.checkWalls(this.neck.m_20191_()) | this.checkWalls(this.neck2.m_20191_()) | this.checkWalls(this.neck3.m_20191_()) | this.checkWalls(this.neck4.m_20191_());
        }
        for (int l = 0; l < this.subEntities.length; ++l) {
            this.subEntities[l].f_19854_ = avec3[l].f_82479_;
            this.subEntities[l].f_19855_ = avec3[l].f_82480_;
            this.subEntities[l].f_19856_ = avec3[l].f_82481_;
            this.subEntities[l].f_19790_ = avec3[l].f_82479_;
            this.subEntities[l].f_19791_ = avec3[l].f_82480_;
            this.subEntities[l].f_19792_ = avec3[l].f_82481_;
        }
        super.m_8107_();
    }

    private boolean checkWalls(AABB p_31140_) {
        int i = Mth.m_14107_((double)p_31140_.f_82288_);
        int j = Mth.m_14107_((double)p_31140_.f_82289_);
        int k = Mth.m_14107_((double)p_31140_.f_82290_);
        int l = Mth.m_14107_((double)p_31140_.f_82291_);
        int i1 = Mth.m_14107_((double)p_31140_.f_82292_);
        int j1 = Mth.m_14107_((double)p_31140_.f_82293_);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                    if (blockstate.m_60795_() || blockstate.m_60767_() == Material.f_76309_ || ForgeHooks.canEntityDestroy((Level)this.f_19853_, (BlockPos)blockpos, (LivingEntity)this) && !blockstate.m_204336_(BlockTags.f_13069_)) continue;
                    flag = true;
                }
            }
        }
        if (flag1) {
            BlockPos blockpos1 = new BlockPos(i + this.f_19796_.m_188503_(l - i + 1), j + this.f_19796_.m_188503_(i1 - j + 1), k + this.f_19796_.m_188503_(j1 - k + 1));
            this.f_19853_.m_46796_(2008, blockpos1, 0);
        }
        return flag;
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        if (p_21016_ == DamageSource.f_19307_ || p_21016_ == DamageSource.f_19305_ || p_21016_ == DamageSource.f_19309_ || p_21016_ == DamageSource.f_19308_) {
            return false;
        }
        return super.m_6469_(p_21016_, p_21017_);
    }

    public BasaltSnakePart[] getSubEntities() {
        return this.subEntities;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void m_141965_(ClientboundAddEntityPacket p_149572_) {
        super.m_141965_(p_149572_);
        BasaltSnakePart[] aenderdragonpart = this.getSubEntities();
        for (int i = 0; i < aenderdragonpart.length; ++i) {
            aenderdragonpart[i].m_20234_(i + p_149572_.m_131496_());
        }
    }

    public boolean m_6779_(LivingEntity p_149576_) {
        return p_149576_.m_142066_();
    }

    private void tickPart(BasaltSnakePart p_31116_, double p_31117_, double p_31118_, double p_31119_) {
        p_31116_.m_6034_(this.m_20185_() + p_31117_, this.m_20186_() + 1.0 + p_31118_, this.m_20189_() + p_31119_);
    }

    private float getHeadYOffset() {
        if (this.m_6113_() == 0.0f) {
            return -1.0f;
        }
        double[] adouble = this.getLatencyPos(5, 1.0f);
        double[] adouble1 = this.getLatencyPos(0, 1.0f);
        return (float)(adouble[1] - adouble1[1]);
    }

    public float getHeadPartYOffset(int p_31109_, double[] p_31110_, double[] p_31111_) {
        double d0 = this.m_6113_() == 0.0f ? (double)p_31109_ : (p_31109_ == 11 ? 0.0 : p_31111_[1] - p_31110_[1]);
        return (float)d0;
    }

    public Vec3 getHeadLookVector(float p_31175_) {
        Vec3 vec3;
        if (this.m_6113_() == 0.0f) {
            float f4 = this.m_146909_();
            this.m_146926_(-45.0f);
            vec3 = this.m_20252_(p_31175_);
            this.m_146926_(f4);
        } else {
            vec3 = this.m_20252_(p_31175_);
        }
        return vec3;
    }

    protected void m_8099_() {
        this.friendsGoal = new SilverfishWakeUpFriendsGoal(this);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)this.friendsGoal);
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public double m_6049_() {
        return 0.1;
    }

    protected float m_6431_(Pose p_33540_, EntityDimensions p_33541_) {
        return 0.3f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22278_, (double)0.3f).m_22268_(Attributes.f_22288_, 0.5).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    protected SoundEvent m_7975_(DamageSource p_33549_) {
        return (SoundEvent)ModSounds.SNAKE_AGGRO.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SNAKE_DEATH_HURT.get();
    }

    public boolean m_7327_(Entity p_21372_) {
        this.attackAnimationTick = 20;
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        this.m_5496_((SoundEvent)ModSounds.SNAKE_HIT.get(), 1.0f, 1.0f);
        return super.m_7327_(p_21372_);
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 4) {
            this.attackAnimationTick = 20;
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public void m_8119_() {
        this.f_20883_ = this.m_146908_();
        super.m_8119_();
    }

    public void m_5618_(float p_33553_) {
        this.m_146922_(p_33553_);
        super.m_5618_(p_33553_);
    }

    public float m_5610_(BlockPos p_33530_, LevelReader p_33531_) {
        return InfestedBlock.m_54195_((BlockState)p_33531_.m_8055_(p_33530_.m_7495_())) ? 10.0f : super.m_5610_(p_33530_, p_33531_);
    }

    public static boolean checkSliverfishSpawnRules(EntityType<BasaltSnake> p_33534_, ServerLevelAccessor p_33535_, MobSpawnType p_33536_, BlockPos p_33537_, RandomSource p_33538_) {
        if (BasaltSnake.m_219019_(p_33534_, (LevelAccessor)p_33535_, (MobSpawnType)p_33536_, (BlockPos)p_33537_, (RandomSource)p_33538_)) {
            Player player = p_33535_.m_45924_((double)p_33537_.m_123341_() + 0.5, (double)p_33537_.m_123342_() + 0.5, (double)p_33537_.m_123343_() + 0.5, 5.0, true);
            return player == null;
        }
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    static class SilverfishWakeUpFriendsGoal
    extends Goal {
        private final BasaltSnake silverfish;
        private int lookForFriends;

        public SilverfishWakeUpFriendsGoal(BasaltSnake p_33565_) {
            this.silverfish = p_33565_;
        }

        public void notifyHurt() {
            if (this.lookForFriends == 0) {
                this.lookForFriends = 20;
            }
        }

        public boolean m_8036_() {
            return this.lookForFriends > 0;
        }

        public void m_8037_() {
            --this.lookForFriends;
            if (this.lookForFriends <= 0) {
                Level level = this.silverfish.f_19853_;
                RandomSource random = this.silverfish.m_217043_();
                BlockPos blockpos = this.silverfish.m_20183_();
                int i = 0;
                while (i <= 5 && i >= -5) {
                    int j = 0;
                    while (j <= 10 && j >= -10) {
                        int k = 0;
                        while (k <= 10 && k >= -10) {
                            BlockPos blockpos1 = blockpos.m_7918_(j, i, k);
                            BlockState blockstate = level.m_8055_(blockpos1);
                            Block block = blockstate.m_60734_();
                            if (block instanceof InfestedBlock) {
                                if (ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)this.silverfish)) {
                                    level.m_46953_(blockpos1, true, (Entity)this.silverfish);
                                } else {
                                    level.m_7731_(blockpos1, ((InfestedBlock)block).m_153432_(level.m_8055_(blockpos1)), 3);
                                }
                                if (random.m_188499_()) {
                                    return;
                                }
                            }
                            k = (k <= 0 ? 1 : 0) - k;
                        }
                        j = (j <= 0 ? 1 : 0) - j;
                    }
                    i = (i <= 0 ? 1 : 0) - i;
                }
            }
        }
    }

    static class SilverfishMergeWithStoneGoal
    extends RandomStrollGoal {
        private Direction selectedDirection;
        private boolean doMerge;

        public SilverfishMergeWithStoneGoal(BasaltSnake p_33558_) {
            super((PathfinderMob)p_33558_, 1.0, 10);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.f_25725_.m_5448_() != null) {
                return false;
            }
            if (!this.f_25725_.m_21573_().m_26571_()) {
                return false;
            }
            RandomSource random = this.f_25725_.m_217043_();
            if (ForgeEventFactory.getMobGriefingEvent((Level)this.f_25725_.f_19853_, (Entity)this.f_25725_) && random.m_188503_(10) == 0) {
                this.selectedDirection = Direction.m_235672_((RandomSource)random);
                BlockPos blockpos = new BlockPos(this.f_25725_.m_20185_(), this.f_25725_.m_20186_() + 0.5, this.f_25725_.m_20189_()).m_121945_(this.selectedDirection);
                BlockState blockstate = this.f_25725_.f_19853_.m_8055_(blockpos);
                if (InfestedBlock.m_54195_((BlockState)blockstate)) {
                    this.doMerge = true;
                    return true;
                }
            }
            this.doMerge = false;
            return super.m_8036_();
        }

        public boolean m_8045_() {
            return this.doMerge ? false : super.m_8045_();
        }

        public void m_8056_() {
            if (!this.doMerge) {
                super.m_8056_();
            } else {
                Level levelaccessor = this.f_25725_.f_19853_;
                BlockPos blockpos = new BlockPos(this.f_25725_.m_20185_(), this.f_25725_.m_20186_() + 0.5, this.f_25725_.m_20189_()).m_121945_(this.selectedDirection);
                BlockState blockstate = levelaccessor.m_8055_(blockpos);
                if (InfestedBlock.m_54195_((BlockState)blockstate)) {
                    levelaccessor.m_7731_(blockpos, InfestedBlock.m_153430_((BlockState)blockstate), 3);
                    this.f_25725_.m_21373_();
                    this.f_25725_.m_146870_();
                }
            }
        }
    }
}

