/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.entities.mobs;

import com.minecraftserverzone.weirdmobs.entities.mobs.ExampleBaseEntity;
import com.minecraftserverzone.weirdmobs.entities.projectiles.venomspit.VenomSpit;
import com.minecraftserverzone.weirdmobs.setup.Registrations;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;

public class ExampleEntity
extends ExampleBaseEntity
implements RangedAttackMob,
NeutralMob {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(ExampleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    boolean didSpit;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    public ExampleEntity(EntityType<? extends ExampleEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 4;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            this.m_21666_((ServerLevel)this.f_19853_, true);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.setClimbing(this.f_19862_);
        }
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public void m_7601_(BlockState p_33796_, Vec3 p_33797_) {
        if (!p_33796_.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(p_33796_, p_33797_);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_7301_(MobEffectInstance p_33809_) {
        if (p_33809_.m_19544_() == MobEffects.f_19614_) {
            MobEffectEvent.Applicable event = new MobEffectEvent.Applicable((LivingEntity)this, p_33809_);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.m_7301_(p_33809_);
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean p_33820_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = p_33820_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    private void spit(LivingEntity p_30828_) {
        VenomSpit venomspit = new VenomSpit(this.f_19853_, this);
        double d0 = p_30828_.m_20185_() - this.m_20185_();
        double d1 = p_30828_.m_20227_(0.3333333333333333) - venomspit.m_20186_();
        double d2 = p_30828_.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2) * (double)0.2f;
        venomspit.m_6686_(d0, d1 + d3, d2, 1.5f, 10.0f);
        if (!this.m_20067_()) {
            this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12098_, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        }
        this.f_19853_.m_7967_((Entity)venomspit);
        this.didSpit = true;
    }

    void setDidSpit(boolean p_30753_) {
        this.didSpit = p_30753_;
    }

    public void m_6504_(LivingEntity p_30762_, float p_30763_) {
        this.spit(p_30762_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new ExampleEntityMeleeAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.25, 60, 30.0f));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 0.75, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, (double)1.15f));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, ExampleEntity.class, 5.0f, 0.02f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new ExampleEntityHurtByTargetGoal(this).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((ExampleEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(2, (Goal)new ExampleEntityAttackPlayersGoal());
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    @Override
    public Animal getBreedOffspring(ServerLevel world, AgeableMob entityanimal) {
        return (Animal)((EntityType)Registrations.SPIDER_LLAMA.get()).m_20615_((Level)world);
    }

    protected PathNavigation m_6037_(Level p_33802_) {
        return new WallClimberNavigation((Mob)this, p_33802_);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42405_;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    public static boolean checkAnimalSpawnRules(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, Random rand) {
        return world.m_45524_(pos, 0) > 8 && world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_49992_);
    }

    public void m_7378_(CompoundTag p_29541_) {
        super.m_7378_(p_29541_);
        this.m_147285_(this.f_19853_, p_29541_);
    }

    public void m_7380_(CompoundTag p_29548_) {
        super.m_7380_(p_29548_);
        this.m_21678_(p_29548_);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int p_29543_) {
        this.remainingPersistentAngerTime = p_29543_;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(@Nullable UUID p_29539_) {
        this.persistentAngerTarget = p_29539_;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12432_;
    }

    protected SoundEvent m_7975_(DamageSource p_29559_) {
        return SoundEvents.f_12097_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12095_;
    }

    protected void m_7355_(BlockPos p_29545_, BlockState p_29546_) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    static class ExampleEntityMeleeAttackGoal
    extends MeleeAttackGoal {
        public ExampleEntityMeleeAttackGoal(ExampleEntity entity) {
            super((PathfinderMob)entity, 1.0, true);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.f_25540_.m_20160_();
        }

        public boolean m_8045_() {
            float f = this.f_25540_.m_213856_();
            if (f >= 0.5f && this.f_25540_.m_217043_().m_188503_(100) == 0) {
                this.f_25540_.m_6710_((LivingEntity)null);
                return false;
            }
            return super.m_8045_();
        }

        protected double m_6639_(LivingEntity p_33825_) {
            return 4.0f + p_33825_.m_20205_();
        }
    }

    static class ExampleEntityHurtByTargetGoal
    extends HurtByTargetGoal {
        public ExampleEntityHurtByTargetGoal(ExampleEntity p_30854_) {
            super((PathfinderMob)p_30854_, new Class[0]);
        }

        public boolean m_8045_() {
            if (this.f_26135_ instanceof ExampleEntity) {
                ExampleEntity exampleEntity = (ExampleEntity)this.f_26135_;
                if (exampleEntity.didSpit) {
                    exampleEntity.setDidSpit(false);
                }
            }
            return super.m_8045_();
        }
    }

    class ExampleEntityAttackPlayersGoal
    extends NearestAttackableTargetGoal<Player> {
        public ExampleEntityAttackPlayersGoal() {
            super((Mob)ExampleEntity.this, Player.class, 20, true, true, (Predicate)null);
        }

        public boolean m_8036_() {
            if (ExampleEntity.this.m_6162_()) {
                return false;
            }
            if (super.m_8036_()) {
                for (ExampleEntity polarbear : ExampleEntity.this.f_19853_.m_45976_(ExampleEntity.class, ExampleEntity.this.m_20191_().m_82377_(8.0, 4.0, 8.0))) {
                    if (!polarbear.m_6162_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double m_7623_() {
            return super.m_7623_() * 0.5;
        }
    }
}

