/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weirdmobs.blocks;

import com.google.common.collect.Maps;
import com.minecraftserverzone.weirdmobs.entities.mobs.silverfishcreeper.SilverfishCreeper;
import com.minecraftserverzone.weirdmobs.setup.Registrations;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class NewInfestedBlock
extends Block {
    private final Block hostBlock;
    private static final Map<Block, Block> BLOCK_BY_HOST_BLOCK = Maps.newIdentityHashMap();
    private static final Map<BlockState, BlockState> HOST_TO_INFESTED_STATES = Maps.newIdentityHashMap();
    private static final Map<BlockState, BlockState> INFESTED_TO_HOST_STATES = Maps.newIdentityHashMap();

    public NewInfestedBlock(Block p_54178_, BlockBehaviour.Properties p_54179_) {
        super(p_54179_.m_155954_(p_54178_.m_155943_() / 2.0f).m_155956_(0.75f));
        this.hostBlock = p_54178_;
        BLOCK_BY_HOST_BLOCK.put(p_54178_, this);
    }

    public Block getHostBlock() {
        return this.hostBlock;
    }

    public static boolean isCompatibleHostBlock(BlockState p_54196_) {
        return BLOCK_BY_HOST_BLOCK.containsKey(p_54196_.m_60734_());
    }

    private void spawnInfestation(ServerLevel p_54181_, BlockPos p_54182_) {
        Object silverfish;
        Random rand = new Random();
        if (rand.nextInt(2) == 0) {
            silverfish = (SilverfishCreeper)((EntityType)Registrations.SILVERFISH_CREEPER.get()).m_20615_((Level)p_54181_);
            silverfish.m_7678_((double)p_54182_.m_123341_() + 0.5, (double)p_54182_.m_123342_(), (double)p_54182_.m_123343_() + 0.5, 0.0f, 0.0f);
            p_54181_.m_7967_((Entity)silverfish);
            silverfish.m_21373_();
        }
        silverfish = (Silverfish)EntityType.f_20523_.m_20615_((Level)p_54181_);
        silverfish.m_7678_((double)p_54182_.m_123341_() + 0.5, (double)p_54182_.m_123342_(), (double)p_54182_.m_123343_() + 0.5, 0.0f, 0.0f);
        p_54181_.m_7967_((Entity)silverfish);
        silverfish.m_21373_();
    }

    public void m_213646_(BlockState p_221360_, ServerLevel p_221361_, BlockPos p_221362_, ItemStack p_221363_, boolean p_221364_) {
        super.m_213646_(p_221360_, p_221361_, p_221362_, p_221363_, p_221364_);
        if (p_221361_.m_46469_().m_46207_(GameRules.f_46136_) && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)p_221363_) == 0) {
            this.spawnInfestation(p_221361_, p_221362_);
        }
    }

    public void m_7592_(Level p_54184_, BlockPos p_54185_, Explosion p_54186_) {
        if (p_54184_ instanceof ServerLevel) {
            this.spawnInfestation((ServerLevel)p_54184_, p_54185_);
        }
    }

    public static BlockState infestedStateByHost(BlockState p_153431_) {
        return NewInfestedBlock.getNewStateWithProperties(HOST_TO_INFESTED_STATES, p_153431_, () -> BLOCK_BY_HOST_BLOCK.get(p_153431_.m_60734_()).m_49966_());
    }

    public BlockState hostStateByInfested(BlockState p_153433_) {
        return NewInfestedBlock.getNewStateWithProperties(INFESTED_TO_HOST_STATES, p_153433_, () -> this.getHostBlock().m_49966_());
    }

    private static BlockState getNewStateWithProperties(Map<BlockState, BlockState> p_153424_, BlockState p_153425_, Supplier<BlockState> p_153426_) {
        return p_153424_.computeIfAbsent(p_153425_, p_153429_ -> {
            BlockState blockstate = (BlockState)p_153426_.get();
            for (Property property : p_153429_.m_61147_()) {
                blockstate = blockstate.m_61138_(property) ? (BlockState)blockstate.m_61124_(property, p_153429_.m_61143_(property)) : blockstate;
            }
            return blockstate;
        });
    }
}

