/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure;

import com.legacy.structure_gel.api.registry.RegistryHelper;
import com.legacy.structure_gel.api.tags.GelStructureTags;
import com.legacy.structure_gel.core.SGAccessor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class StructureAccessHelper {
    private static final Set<ResourceKey<? extends Structure>> LAKE_PROOF = new HashSet<ResourceKey<? extends Structure>>();
    private static final Map<ResourceKey<? extends Structure>, Set<ResourceKey<Level>>> STRUCTURE_DIM_FILTERS = new HashMap<ResourceKey<? extends Structure>, Set<ResourceKey<Level>>>();

    public static boolean isLakeProof(RegistryAccess registryAccess, Structure structure) {
        Registry registry = registryAccess.m_175515_(Registry.f_235725_);
        Optional key = registry.m_7854_((Object)structure);
        if (key.isPresent() && LAKE_PROOF.contains(key.get())) {
            return true;
        }
        return RegistryHelper.isInTag(registry, GelStructureTags.LAKE_PROOF, structure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLakeProof(ResourceKey<? extends Structure> structure) {
        Set<ResourceKey<? extends Structure>> set = LAKE_PROOF;
        synchronized (set) {
            LAKE_PROOF.add(structure);
        }
    }

    public static boolean isInStructurePiece(ServerLevel serverLevel, Structure structure, BlockPos pos) {
        return serverLevel.m_215010_().m_220524_(pos, structure).m_73603_();
    }

    public static boolean isInStructurePiece(ServerLevel serverLevel, StructureType<?> type, BlockPos pos) {
        return serverLevel.m_5962_().m_175515_(Registry.f_235725_).m_123024_().filter(s -> type.equals(s.m_213658_())).anyMatch(s -> StructureAccessHelper.isInStructurePiece(serverLevel, s, pos));
    }

    public static boolean isInStructure(ServerLevel serverLevel, Structure structure, BlockPos pos) {
        return serverLevel.m_215010_().m_220494_(pos, structure).m_73603_();
    }

    public static boolean isInStructure(ServerLevel serverLevel, StructureType<?> type, BlockPos pos) {
        return serverLevel.m_5962_().m_175515_(Registry.f_235725_).m_123024_().filter(s -> type.equals(s.m_213658_())).anyMatch(s -> StructureAccessHelper.isInStructure(serverLevel, s, pos));
    }

    public static boolean hasStructureChunkInRange(ChunkGenerator chunkGen, RandomState randomState, TagKey<Structure> structureTag, RegistryAccess registryAccess, long levelSeed, ChunkPos chunkPos, int radius) {
        return StructureAccessHelper.hasStructureChunkInRange(chunkGen, randomState, (HolderSet<Structure>)registryAccess.m_175515_(Registry.f_235725_).m_203561_(structureTag), levelSeed, chunkPos, radius);
    }

    public static boolean hasStructureChunkInRange(ChunkGenerator chunkGen, RandomState randomState, HolderSet<Structure> structures, long levelSeed, ChunkPos chunkPos, int radius) {
        for (Holder structure : structures) {
            if (!StructureAccessHelper.hasStructureChunkInRange(chunkGen, randomState, (Holder<Structure>)structure, levelSeed, chunkPos, radius)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasStructureChunkInRange(ChunkGenerator chunkGen, RandomState randomState, Holder<Structure> structure, long levelSeed, ChunkPos chunkPos, int radius) {
        int chunkX = chunkPos.f_45578_;
        int chunkZ = chunkPos.f_45579_;
        Climate.Sampler sampler = randomState.m_224579_();
        BiomeSource biomeSource = chunkGen.m_62218_();
        for (StructurePlacement placement : SGAccessor.CHUNK_GENERATOR_GET_PLACEMENTS.invoke(chunkGen, structure, randomState)) {
            for (int x = chunkX - radius; x <= chunkX + radius; ++x) {
                for (int z = chunkZ - radius; z <= chunkZ + radius; ++z) {
                    if (!placement.m_227054_(chunkGen, randomState, levelSeed, x, z)) continue;
                    for (int dx = 0; dx < 2; ++dx) {
                        for (int dz = 0; dz < 2; ++dz) {
                            if (!((Structure)structure.m_203334_()).m_226559_().m_203333_(biomeSource.m_203407_(QuartPos.m_175400_((int)((x - dx << 4) + 8)), QuartPos.m_175400_((int)70), QuartPos.m_175400_((int)((z - dz << 4) + 8)), sampler))) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public static boolean isValidDimension(Optional<? extends ResourceKey<? extends Structure>> structureKey, ResourceKey<Level> levelKey) {
        if (structureKey.isPresent()) {
            Set<ResourceKey<Level>> dims = STRUCTURE_DIM_FILTERS.get(structureKey.get());
            return dims == null || dims.isEmpty() || dims.contains(levelKey);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToDimensionFilter(ResourceKey<? extends Structure> structureKey, ResourceKey<Level> levelKey) {
        Map<ResourceKey<? extends Structure>, Set<ResourceKey<Level>>> map = STRUCTURE_DIM_FILTERS;
        synchronized (map) {
            STRUCTURE_DIM_FILTERS.computeIfAbsent(structureKey, s -> new HashSet()).add(levelKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDimensionFilter(ResourceKey<? extends Structure> structureKey, Collection<ResourceKey<Level>> levelKeys) {
        Map<ResourceKey<? extends Structure>, Set<ResourceKey<Level>>> map = STRUCTURE_DIM_FILTERS;
        synchronized (map) {
            Set levels = STRUCTURE_DIM_FILTERS.computeIfAbsent(structureKey, s -> new HashSet());
            levels.clear();
            levels.addAll(levelKeys);
        }
    }
}

