/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common;

import atomicstryker.infernalmobs.client.InfernalMobsClient;
import atomicstryker.infernalmobs.common.EntityEventHandler;
import atomicstryker.infernalmobs.common.GsonConfig;
import atomicstryker.infernalmobs.common.InfernalCommandFindEntityClass;
import atomicstryker.infernalmobs.common.InfernalCommandSpawnInfernal;
import atomicstryker.infernalmobs.common.InfernalMobsConfig;
import atomicstryker.infernalmobs.common.ItemConfigHelper;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.SaveEventHandler;
import atomicstryker.infernalmobs.common.SidedCache;
import atomicstryker.infernalmobs.common.mods.MM_1UP;
import atomicstryker.infernalmobs.common.mods.MM_Alchemist;
import atomicstryker.infernalmobs.common.mods.MM_Berserk;
import atomicstryker.infernalmobs.common.mods.MM_Blastoff;
import atomicstryker.infernalmobs.common.mods.MM_Bulwark;
import atomicstryker.infernalmobs.common.mods.MM_Choke;
import atomicstryker.infernalmobs.common.mods.MM_Cloaking;
import atomicstryker.infernalmobs.common.mods.MM_Darkness;
import atomicstryker.infernalmobs.common.mods.MM_Ender;
import atomicstryker.infernalmobs.common.mods.MM_Exhaust;
import atomicstryker.infernalmobs.common.mods.MM_Fiery;
import atomicstryker.infernalmobs.common.mods.MM_Ghastly;
import atomicstryker.infernalmobs.common.mods.MM_Gravity;
import atomicstryker.infernalmobs.common.mods.MM_Lifesteal;
import atomicstryker.infernalmobs.common.mods.MM_Ninja;
import atomicstryker.infernalmobs.common.mods.MM_Poisonous;
import atomicstryker.infernalmobs.common.mods.MM_Quicksand;
import atomicstryker.infernalmobs.common.mods.MM_Regen;
import atomicstryker.infernalmobs.common.mods.MM_Rust;
import atomicstryker.infernalmobs.common.mods.MM_Sapper;
import atomicstryker.infernalmobs.common.mods.MM_Sprint;
import atomicstryker.infernalmobs.common.mods.MM_Sticky;
import atomicstryker.infernalmobs.common.mods.MM_Storm;
import atomicstryker.infernalmobs.common.mods.MM_Vengeance;
import atomicstryker.infernalmobs.common.mods.MM_Weakness;
import atomicstryker.infernalmobs.common.mods.MM_Webber;
import atomicstryker.infernalmobs.common.mods.MM_Wither;
import atomicstryker.infernalmobs.common.network.AirPacket;
import atomicstryker.infernalmobs.common.network.HealthPacket;
import atomicstryker.infernalmobs.common.network.KnockBackPacket;
import atomicstryker.infernalmobs.common.network.MobModsPacket;
import atomicstryker.infernalmobs.common.network.NetworkHelper;
import atomicstryker.infernalmobs.common.network.VelocityPacket;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="infernalmobs")
@Mod.EventBusSubscriber(modid="infernalmobs")
public class InfernalMobsCore {
    public static final String MOD_ID = "infernalmobs";
    public static Logger LOGGER;
    private static InfernalMobsCore instance;
    private final long existCheckDelay = 5000L;
    public NetworkHelper networkHelper;
    protected File configFile;
    protected InfernalMobsConfig config;
    private long nextExistCheckTime;
    private ItemConfigHelper lootItemDropsElite;
    private ItemConfigHelper lootItemDropsUltra;
    private ItemConfigHelper lootItemDropsInfernal;
    private HashMap<String, Boolean> classesAllowedMap;
    private HashMap<String, Boolean> classesForcedMap;
    private HashMap<String, Double> classesHealthMap;
    private Entity infCheckA;
    private Entity infCheckB;
    private ArrayList<Class<? extends MobModifier>> mobMods = null;
    private ArrayList<Enchantment> enchantmentList;
    private HashMap<String, Long> modifiedPlayerTimes;

    public InfernalMobsCore() {
        instance = this;
        this.nextExistCheckTime = System.currentTimeMillis();
        this.classesAllowedMap = new HashMap();
        this.classesForcedMap = new HashMap();
        this.classesHealthMap = new HashMap();
        this.modifiedPlayerTimes = new HashMap();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new EntityEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SaveEventHandler());
        this.networkHelper = new NetworkHelper(MOD_ID, MobModsPacket.class, HealthPacket.class, VelocityPacket.class, KnockBackPacket.class, AirPacket.class);
        LOGGER = LogManager.getLogger();
    }

    public static InfernalMobsCore instance() {
        return instance;
    }

    public static MobModifier getMobModifiers(LivingEntity ent) {
        return SidedCache.getInfernalMobs(ent.f_19853_).get(ent);
    }

    public static boolean getIsRareEntityOnline(LivingEntity ent) {
        return SidedCache.getInfernalMobs(ent.f_19853_).containsKey(ent);
    }

    public static boolean getWasMobSpawnedBefore(LivingEntity ent) {
        boolean result;
        String storedInfernalTag = ent.getPersistentData().m_128461_(InfernalMobsCore.instance().getNBTTag());
        boolean bl = result = !storedInfernalTag.isEmpty() && InfernalMobsCore.instance().getNBTMarkerForNonInfernalEntities().equals(storedInfernalTag);
        if (result) {
            LOGGER.debug("entity {} was spawned in unmodified before, not modifying it", (Object)ent);
        }
        return result;
    }

    public static void setMobWasSpawnedBefore(LivingEntity ent) {
        ent.getPersistentData().m_128359_(InfernalMobsCore.instance().getNBTTag(), InfernalMobsCore.instance().getNBTMarkerForNonInfernalEntities());
    }

    public static void clearAllElitesOfLevel(net.minecraft.world.level.Level level) {
        SidedCache.getInfernalMobs(level).clear();
    }

    public static void removeEntFromElites(LivingEntity entity) {
        SidedCache.getInfernalMobs(entity.f_19853_).remove(entity);
    }

    public String getNBTTag() {
        return "InfernalMobsMod";
    }

    public String getNBTMarkerForNonInfernalEntities() {
        return "notInfernal";
    }

    @SubscribeEvent
    public void commonSetup(ServerStartedEvent evt) {
        this.initIfNeeded((net.minecraft.world.level.Level)evt.getServer().m_129785_().iterator().next());
    }

    public void initIfNeeded(net.minecraft.world.level.Level world) {
        if (this.mobMods == null) {
            File mcFolder;
            this.prepareModList();
            if (world.m_5776_()) {
                mcFolder = InfernalMobsClient.getMcFolder();
            } else {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                mcFolder = server.m_129971_("");
            }
            this.configFile = new File(mcFolder, File.separatorChar + "config" + File.separatorChar + "infernalmobs.cfg");
            this.loadConfig();
            LOGGER.info("InfernalMobsCore commonSetup completed! Modifiers ready: " + this.mobMods.size());
            LOGGER.info("InfernalMobsCore commonSetup completed! config file at: " + this.configFile.getAbsolutePath());
        }
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent evt) {
        evt.getDispatcher().register(InfernalCommandFindEntityClass.BUILDER);
        evt.getDispatcher().register(InfernalCommandSpawnInfernal.BUILDER);
    }

    private void prepareModList() {
        this.mobMods = new ArrayList();
        this.mobMods.add(MM_1UP.class);
        this.mobMods.add(MM_Alchemist.class);
        this.mobMods.add(MM_Berserk.class);
        this.mobMods.add(MM_Blastoff.class);
        this.mobMods.add(MM_Bulwark.class);
        this.mobMods.add(MM_Choke.class);
        this.mobMods.add(MM_Cloaking.class);
        this.mobMods.add(MM_Darkness.class);
        this.mobMods.add(MM_Ender.class);
        this.mobMods.add(MM_Exhaust.class);
        this.mobMods.add(MM_Fiery.class);
        this.mobMods.add(MM_Ghastly.class);
        this.mobMods.add(MM_Gravity.class);
        this.mobMods.add(MM_Lifesteal.class);
        this.mobMods.add(MM_Ninja.class);
        this.mobMods.add(MM_Poisonous.class);
        this.mobMods.add(MM_Quicksand.class);
        this.mobMods.add(MM_Regen.class);
        this.mobMods.add(MM_Rust.class);
        this.mobMods.add(MM_Sapper.class);
        this.mobMods.add(MM_Sprint.class);
        this.mobMods.add(MM_Sticky.class);
        this.mobMods.add(MM_Storm.class);
        this.mobMods.add(MM_Vengeance.class);
        this.mobMods.add(MM_Weakness.class);
        this.mobMods.add(MM_Webber.class);
        this.mobMods.add(MM_Wither.class);
    }

    private void loadConfig() {
        InfernalMobsConfig defaultConfig = new InfernalMobsConfig();
        defaultConfig.setEliteRarity(15);
        defaultConfig.setUltraRarity(7);
        defaultConfig.setInfernoRarity(7);
        defaultConfig.setUseSimpleEntityClassNames(true);
        defaultConfig.setDisableHealthBar(false);
        defaultConfig.setModHealthFactor(1.0);
        ArrayList<String> dropsElite = new ArrayList<String>();
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42384_)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42385_)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42386_)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42383_)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42387_)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42464_)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42467_)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42465_)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42466_)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42468_)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42471_)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42469_)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42470_)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42572_, 5)));
        defaultConfig.setDroppedItemIDsElite(dropsElite);
        ArrayList<String> dropsUltra = new ArrayList<String>();
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42387_)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42411_)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42464_)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42467_)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42465_)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42466_)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42468_)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42471_)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42469_)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42470_)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42476_)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42479_)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42477_)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42478_)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42436_, 3)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42593_, 5)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42690_)));
        defaultConfig.setDroppedItemIDsUltra(dropsUltra);
        ArrayList<String> dropsInfernal = new ArrayList<String>();
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42690_)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42415_, 3)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42388_)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42391_)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42392_)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42390_)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42389_)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42464_)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42467_)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42465_)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42466_)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42472_)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42475_)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42473_)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42474_)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.f_42584_, 3)));
        defaultConfig.setDroppedItemIDsInfernal(dropsInfernal);
        defaultConfig.setMaxDamage(10.0);
        defaultConfig.setDimensionIDBlackList(new ArrayList<String>());
        HashMap<String, Boolean> modsEnabledMap = new HashMap<String, Boolean>();
        for (Class<? extends MobModifier> c2 : this.mobMods) {
            modsEnabledMap.put(c2.getSimpleName(), true);
        }
        defaultConfig.setModsEnabled(modsEnabledMap);
        this.config = GsonConfig.loadConfigWithDefault(InfernalMobsConfig.class, this.configFile, defaultConfig);
        this.lootItemDropsElite = new ItemConfigHelper(this.config.getDroppedItemIDsElite(), LOGGER);
        this.lootItemDropsUltra = new ItemConfigHelper(this.config.getDroppedItemIDsUltra(), LOGGER);
        this.lootItemDropsInfernal = new ItemConfigHelper(this.config.getDroppedItemIDsInfernal(), LOGGER);
        this.mobMods.removeIf(c -> !this.config.getModsEnabled().containsKey(c.getSimpleName()) || this.config.getModsEnabled().get(c.getSimpleName()) == false);
    }

    public void processEntitySpawn(LivingEntity entity) {
        if (!(entity.f_19853_.f_46443_ || this.config == null || InfernalMobsCore.getIsRareEntityOnline(entity) || InfernalMobsCore.getWasMobSpawnedBefore(entity))) {
            if (this.isClassAllowed(entity) && (instance.checkEntityClassForced(entity) || entity.f_19853_.f_46441_.m_188503_(this.config.getEliteRarity()) == 0)) {
                try {
                    MobModifier mod;
                    ResourceKey worldRegistryKey = entity.m_20193_().m_46472_();
                    ResourceLocation worldResourceLocation = worldRegistryKey.m_135782_();
                    if (!this.config.getDimensionIDBlackList().contains(worldResourceLocation.toString()) && (mod = instance.createMobModifiers(entity)) != null) {
                        SidedCache.getInfernalMobs(entity.f_19853_).put(entity, mod);
                        mod.onSpawningCompleteStoreModsAndBuffHealth(entity);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.ERROR, "processEntitySpawn() threw an exception");
                    e.printStackTrace();
                }
            } else {
                InfernalMobsCore.setMobWasSpawnedBefore(entity);
            }
        }
    }

    private boolean isClassAllowed(LivingEntity entity) {
        if (entity instanceof Enemy) {
            if (entity instanceof TamableAnimal) {
                return false;
            }
            if (instance.checkEntityClassAllowed(entity)) {
                return true;
            }
        }
        return false;
    }

    private String getEntityNameSafe(Entity entity) {
        String result;
        try {
            result = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).m_135815_();
        }
        catch (Exception e) {
            result = entity.getClass().getSimpleName();
            System.err.println("Entity of class " + result + " crashed when EntityList.getEntityString was queried, for shame! Using classname instead.");
            System.err.println("If this message is spamming too much for your taste set useSimpleEntityClassnames true in your Infernal Mobs config");
        }
        return result;
    }

    private boolean checkEntityClassAllowed(LivingEntity entity) {
        String entName;
        String string = entName = this.config.isUseSimpleEntityClassNames() ? entity.getClass().getSimpleName() : this.getEntityNameSafe((Entity)entity);
        if (this.classesAllowedMap.containsKey(entName)) {
            return this.classesAllowedMap.get(entName);
        }
        boolean result = true;
        if (!this.config.getPermittedentities().containsKey(entName)) {
            this.config.getPermittedentities().put(entName, true);
            GsonConfig.saveConfig(this.config, this.configFile);
        } else {
            result = this.config.getPermittedentities().get(entName);
            this.classesAllowedMap.put(entName, result);
        }
        return result;
    }

    private boolean checkEntityClassForced(LivingEntity entity) {
        String entName;
        String string = entName = this.config.isUseSimpleEntityClassNames() ? entity.getClass().getSimpleName() : this.getEntityNameSafe((Entity)entity);
        if (this.classesForcedMap.containsKey(entName)) {
            return this.classesForcedMap.get(entName);
        }
        boolean result = false;
        if (!this.config.getEntitiesalwaysinfernal().containsKey(entName)) {
            this.config.getEntitiesalwaysinfernal().put(entName, false);
            GsonConfig.saveConfig(this.config, this.configFile);
        } else {
            result = this.config.getEntitiesalwaysinfernal().get(entName);
            this.classesForcedMap.put(entName, result);
        }
        return result;
    }

    public double getMobClassMaxHealth(LivingEntity entity) {
        String entName;
        String string = entName = this.config.isUseSimpleEntityClassNames() ? entity.getClass().getSimpleName() : this.getEntityNameSafe((Entity)entity);
        if (this.classesHealthMap.containsKey(entName)) {
            return this.classesHealthMap.get(entName);
        }
        double result = entity.m_21233_();
        if (!this.config.getEntitybasehealth().containsKey(entName)) {
            this.config.getEntitybasehealth().put(entName, Double.valueOf(entity.m_21233_()));
            GsonConfig.saveConfig(this.config, this.configFile);
        } else {
            result = this.config.getEntitybasehealth().get(entName);
            this.classesHealthMap.put(entName, result);
        }
        return result;
    }

    public void setEntityHealthPastMax(LivingEntity entity, float amount) {
        entity.m_21051_(Attributes.f_22276_).m_22100_((double)amount);
        entity.m_21153_(amount);
        instance.sendHealthPacket(entity);
    }

    private MobModifier createMobModifiers(LivingEntity entity) {
        int number = 2 + entity.f_19853_.f_46441_.m_188503_(3);
        ArrayList possibleMods = Lists.newArrayList(this.mobMods);
        if (entity.f_19853_.f_46441_.m_188503_(this.config.getUltraRarity()) == 0) {
            number += 3 + entity.f_19853_.f_46441_.m_188503_(2);
            if (entity.f_19853_.f_46441_.m_188503_(this.config.getInfernoRarity()) == 0) {
                number += 3 + entity.f_19853_.f_46441_.m_188503_(2);
            }
        }
        MobModifier lastMod = null;
        while (number > 0 && !possibleMods.isEmpty()) {
            int index = entity.f_19853_.f_46441_.m_188503_(possibleMods.size());
            MobModifier nextMod = null;
            try {
                nextMod = lastMod == null ? (MobModifier)((Class)possibleMods.get(index)).getConstructor(new Class[0]).newInstance(new Object[0]) : (MobModifier)((Class)possibleMods.get(index)).getConstructor(MobModifier.class).newInstance(lastMod);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            boolean allowed = true;
            if (nextMod != null && nextMod.getBlackListMobClasses() != null) {
                for (Class<?> cl : nextMod.getBlackListMobClasses()) {
                    if (!entity.getClass().isAssignableFrom(cl)) continue;
                    allowed = false;
                    break;
                }
            }
            if (lastMod != null && lastMod.getModsNotToMixWith() != null) {
                for (Class<?> cl : lastMod.getModsNotToMixWith()) {
                    if (!lastMod.containsModifierClass(cl)) continue;
                    allowed = false;
                    break;
                }
            }
            possibleMods.remove(index);
            if (!allowed) continue;
            lastMod = nextMod;
            --number;
        }
        return lastMod;
    }

    public void addEntityModifiersByString(LivingEntity entity, String savedMods) {
        if (!InfernalMobsCore.getIsRareEntityOnline(entity)) {
            this.initIfNeeded(entity.f_19853_);
            MobModifier mod = this.stringToMobModifiers(savedMods);
            LOGGER.debug("reloading mods for {}: {}, mod instance {}", (Object)entity, (Object)savedMods, (Object)mod);
            if (mod != null) {
                SidedCache.getInfernalMobs(entity.f_19853_).put(entity, mod);
                mod.onSpawningCompleteStoreModsAndBuffHealth(entity);
            } else {
                System.err.println("Infernal Mobs error, could not instantiate modifier " + savedMods);
            }
        }
    }

    private MobModifier stringToMobModifiers(String buffer) {
        MobModifier lastMod = null;
        String[] tokens = buffer.split("\\s");
        block2: for (int j = tokens.length - 1; j >= 0; --j) {
            String modName = tokens[j];
            MobModifier nextMod = null;
            for (Class<? extends MobModifier> c : this.mobMods) {
                try {
                    nextMod = lastMod == null ? c.getConstructor(new Class[0]).newInstance(new Object[0]) : c.getConstructor(MobModifier.class).newInstance(lastMod);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (nextMod == null || !nextMod.getModName().equals(modName)) continue;
                lastMod = nextMod;
                continue block2;
            }
        }
        return lastMod;
    }

    public void addRemoteEntityModifiers(net.minecraft.world.level.Level world, int entID, String mods) {
        Entity ent = world.m_6815_(entID);
        if (ent != null) {
            this.addEntityModifiersByString((LivingEntity)ent, mods);
        }
    }

    public void dropLootForEnt(LivingEntity mob, MobModifier mods) {
        int xpDrop;
        for (int xpValue = 25; xpValue > 0; xpValue -= xpDrop) {
            xpDrop = ExperienceOrb.m_20782_((int)xpValue);
            mob.f_19853_.m_7967_((Entity)new ExperienceOrb(mob.f_19853_, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), xpDrop));
        }
        this.dropRandomEnchantedItems(mob, mods);
    }

    private void dropRandomEnchantedItems(LivingEntity mob, MobModifier mods) {
        int prefix;
        int modStr = mods.getModSize();
        int n = modStr <= 5 ? 0 : (prefix = modStr <= 10 ? 1 : 2);
        while (modStr > 0) {
            ItemStack itemStack = this.getRandomItem(mob, prefix);
            if (itemStack != null) {
                Item item = itemStack.m_41720_();
                if (item instanceof EnchantedBookItem) {
                    itemStack = EnchantedBookItem.m_41161_((EnchantmentInstance)this.getRandomEnchantment(mob.m_217043_()));
                } else {
                    int usedStr = modStr - 5 > 0 ? 5 : modStr;
                    this.enchantRandomly(mob.f_19853_.f_46441_, itemStack, item.m_6473_(), usedStr);
                }
                ItemEntity itemEnt = new ItemEntity(mob.f_19853_, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), itemStack);
                mob.f_19853_.m_7967_((Entity)itemEnt);
                modStr -= 5;
                continue;
            }
            --modStr;
        }
    }

    private EnchantmentInstance getRandomEnchantment(RandomSource rand) {
        if (this.enchantmentList == null) {
            this.enchantmentList = new ArrayList(26);
            for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
                if (enchantment == null) continue;
                if (enchantment.m_44702_() <= enchantment.m_6586_()) {
                    this.enchantmentList.add(enchantment);
                    continue;
                }
                LOGGER.error("enchantment " + enchantment.getClass().getCanonicalName() + " has min level > max level which is invalid behaviour!");
            }
        }
        Enchantment e = this.enchantmentList.get(rand.m_188503_(this.enchantmentList.size()));
        int min = e.m_44702_();
        int range = e.m_6586_() - min;
        int lvl = min + rand.m_188503_(range + 1);
        EnchantmentInstance ed = new EnchantmentInstance(e, lvl);
        return ed;
    }

    private void enchantRandomly(RandomSource rand, ItemStack itemStack, int itemEnchantability, int modStr) {
        List enchantments = EnchantmentHelper.m_220297_((RandomSource)rand, (ItemStack)itemStack, (int)itemEnchantability, (boolean)true);
        Iterator iter = enchantments.iterator();
        for (int remainStr = (modStr + 1) / 2; iter.hasNext() && remainStr > 0; --remainStr) {
            EnchantmentInstance eData = (EnchantmentInstance)iter.next();
            itemStack.m_41663_(eData.f_44947_, eData.f_44948_);
        }
    }

    private ItemStack getRandomItem(LivingEntity mob, int prefix) {
        List<ItemStack> list = prefix == 0 ? InfernalMobsCore.instance.lootItemDropsElite.getItemStackList() : (prefix == 1 ? InfernalMobsCore.instance.lootItemDropsUltra.getItemStackList() : InfernalMobsCore.instance.lootItemDropsInfernal.getItemStackList());
        return list.size() > 0 ? list.get(mob.f_19853_.f_46441_.m_188503_(list.size())).m_41777_() : null;
    }

    public void sendVelocityPacket(ServerPlayer target, float xVel, float yVel, float zVel) {
        if (this.getIsEntityAllowedTarget((Entity)target)) {
            this.networkHelper.sendPacketToPlayer(new VelocityPacket(xVel, yVel, zVel), target);
        }
    }

    public void sendKnockBackPacket(ServerPlayer target, float xVel, float zVel) {
        if (this.getIsEntityAllowedTarget((Entity)target)) {
            this.networkHelper.sendPacketToPlayer(new KnockBackPacket(xVel, zVel), target);
        }
    }

    public void sendHealthPacket(LivingEntity mob) {
        this.networkHelper.sendPacketToAllAroundPoint(new HealthPacket("", mob.m_19879_(), mob.m_21223_(), mob.m_21233_()), new PacketDistributor.TargetPoint(mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), 32.0, mob.m_20193_().m_46472_()));
    }

    public void sendHealthRequestPacket(String playerName, LivingEntity mob) {
        this.networkHelper.sendPacketToServer(new HealthPacket(playerName, mob.m_19879_(), 0.0f, 0.0f));
    }

    public void sendAirPacket(ServerPlayer target, int lastAir) {
        if (this.getIsEntityAllowedTarget((Entity)target)) {
            this.networkHelper.sendPacketToPlayer(new AirPacket(lastAir), target);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.LevelTickEvent tick) {
        if (System.currentTimeMillis() > this.nextExistCheckTime) {
            this.nextExistCheckTime = System.currentTimeMillis() + 5000L;
            Map<LivingEntity, MobModifier> mobsmap = SidedCache.getInfernalMobs(tick.level);
            mobsmap.keySet().stream().filter(this::filterMob).forEach(InfernalMobsCore::removeEntFromElites);
            this.resetModifiedPlayerEntitiesAsNeeded(tick.level);
        }
        if (!tick.level.f_46443_) {
            this.infCheckA = null;
            this.infCheckB = null;
        }
    }

    private boolean filterMob(LivingEntity mob) {
        return !mob.m_6084_();
    }

    private void resetModifiedPlayerEntitiesAsNeeded(net.minecraft.world.level.Level world) {
        Iterator<Map.Entry<String, Long>> iterator = this.modifiedPlayerTimes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> entry = iterator.next();
            if (System.currentTimeMillis() <= entry.getValue() + 10000L) continue;
            String username = entry.getKey();
            for (Player player : world.m_6907_()) {
                if (!player.m_7755_().getString().equals(username)) continue;
                for (Class<? extends MobModifier> c : this.mobMods) {
                    try {
                        MobModifier mod = c.getConstructor(new Class[0]).newInstance(new Object[0]);
                        mod.resetModifiedVictim(player);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            iterator.remove();
        }
    }

    public boolean getIsHealthBarDisabled() {
        return this.config.isDisableHealthBar();
    }

    public double getMobModHealthFactor() {
        return this.config.getModHealthFactor();
    }

    public float getLimitedDamage(float test) {
        return (float)Math.min((double)test, this.config.getMaxDamage());
    }

    public boolean getIsEntityAllowedTarget(Entity entity) {
        return !(entity instanceof FakePlayer);
    }

    public boolean isInfiniteLoop(LivingEntity mob, Entity entity) {
        if (mob == this.infCheckA && entity == this.infCheckB || mob == this.infCheckB && entity == this.infCheckA) {
            return true;
        }
        this.infCheckA = mob;
        this.infCheckB = entity;
        return false;
    }

    public HashMap<String, Long> getModifiedPlayerTimes() {
        return this.modifiedPlayerTimes;
    }
}

