/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.SidedCache;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;

public class InfernalCommandSpawnInfernal {
    public static final LiteralArgumentBuilder<CommandSourceStack> BUILDER = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spawninfernal").requires(caller -> caller.m_6761_(2))).then(Commands.m_82129_((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"y", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"z", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"entClass", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"modifiers", (ArgumentType)StringArgumentType.greedyString()).executes(caller -> {
        InfernalCommandSpawnInfernal.execute((CommandSourceStack)caller.getSource(), IntegerArgumentType.getInteger((CommandContext)caller, (String)"x"), IntegerArgumentType.getInteger((CommandContext)caller, (String)"y"), IntegerArgumentType.getInteger((CommandContext)caller, (String)"z"), StringArgumentType.getString((CommandContext)caller, (String)"entClass"), StringArgumentType.getString((CommandContext)caller, (String)"modifiers"));
        return 1;
    }))))));

    private static void execute(CommandSourceStack source, int x, int y, int z, String entClassName, String modifiers) {
        EntityType chosenType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(entClassName));
        if (chosenType == null || chosenType.m_20674_().m_21609_() || chosenType.m_20674_().m_21610_()) {
            source.m_81352_((Component)Component.m_237113_((String)("Invalid SpawnInfernal command, no Entity Resource [" + entClassName + "] known or noncombat entity type")));
            return;
        }
        LivingEntity mob = (LivingEntity)chosenType.m_20615_((net.minecraft.world.level.Level)source.m_81372_());
        if (mob == null) {
            source.m_81352_((Component)Component.m_237113_((String)("Invalid SpawnInfernal command, failed to create [" + entClassName + "] instance in world")));
        }
        mob.m_6034_((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        source.m_81372_().m_7967_((Entity)mob);
        SidedCache.getInfernalMobs(mob.f_19853_).remove(mob);
        InfernalMobsCore.instance().addEntityModifiersByString(mob, modifiers);
        MobModifier mod = InfernalMobsCore.getMobModifiers(mob);
        if (mod != null) {
            InfernalMobsCore.LOGGER.log(Level.INFO, source.m_81368_() + " spawned: " + InfernalMobsCore.getMobModifiers(mob).getLinkedModNameUntranslated() + " at [" + x + "|" + y + "|" + z + "]");
        } else {
            source.m_81352_((Component)Component.m_237113_((String)("Error adding Infernal Modifier " + modifiers + " to mob " + mob)));
        }
    }
}

