/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.common.entity.base;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.Animation;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.CreeperType;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.NeutralCreeper;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.PassiveCreeper;
import tech.thatgravyboat.creeperoverhaul.common.entity.goals.CreeperAvoidEntitiesGoal;
import tech.thatgravyboat.creeperoverhaul.common.entity.goals.CreeperMeleeAttackGoal;
import tech.thatgravyboat.creeperoverhaul.common.entity.goals.CreeperSwellGoal;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModItems;
import tech.thatgravyboat.creeperoverhaul.common.utils.PlatformUtils;

public class BaseCreeper
extends Creeper
implements IAnimatable {
    private static final EntityDataAccessor<Boolean> DATA_IS_ATTACKING = SynchedEntityData.m_135353_(BaseCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_SHEARED = SynchedEntityData.m_135353_(BaseCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private int oldSwell;
    private int swell;
    private int maxSwell = 30;
    public final CreeperType type;

    public BaseCreeper(EntityType<? extends Creeper> entityType, Level level, CreeperType type) {
        super(entityType, level);
        this.type = type;
        if (!level.f_46443_) {
            this.type.entities().forEach(e -> this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, e, true)));
        }
    }

    public static EntityType.EntityFactory<BaseCreeper> of(CreeperType type) {
        return (entityType, level) -> new BaseCreeper((EntityType<? extends Creeper>)entityType, level, type);
    }

    public static EntityType.EntityFactory<PassiveCreeper> ofPassive(CreeperType type) {
        return (entityType, level) -> new PassiveCreeper((EntityType<? extends NeutralCreeper>)entityType, level, type);
    }

    public static EntityType.EntityFactory<NeutralCreeper> ofNeutral(CreeperType type) {
        return (entityType, level) -> new NeutralCreeper((EntityType<? extends NeutralCreeper>)entityType, level, type);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new CreeperSwellGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new CreeperAvoidEntitiesGoal(this, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new CreeperMeleeAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.registerAttackGoals();
        if (this.shouldRevenge()) {
            this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        }
    }

    protected void registerAttackGoals() {
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_IS_ATTACKING, (Object)false);
        this.m_20088_().m_135372_(DATA_IS_SHEARED, (Object)false);
    }

    public void setAttacking(boolean attacking) {
        this.m_20088_().m_135381_(DATA_IS_ATTACKING, (Object)attacking);
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.m_20088_().m_135381_(DATA_IS_SHEARED, (Object)sheared);
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Sheared", this.isSheared());
        tag.m_128376_("Fuse", (short)this.maxSwell);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.setSheared(tag.m_128471_("Sheared"));
        if (tag.m_128425_("Fuse", 99)) {
            this.maxSwell = tag.m_128448_("Fuse");
        }
    }

    public boolean m_142535_(float f, float g, @NotNull DamageSource source) {
        boolean bl = super.m_142535_(f, g, source);
        this.swell += (int)(f * 1.5f);
        if (this.swell > this.maxSwell - 5) {
            this.swell = this.maxSwell - 5;
        }
        return bl;
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int i;
            this.oldSwell = this.swell;
            if (this.m_32311_()) {
                this.m_32283_(1);
            }
            if ((i = this.m_32310_()) > 0 && this.swell == 0) {
                this.m_5496_(this.type.primeSound().get(), 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explode();
            }
        }
        super.m_8119_();
    }

    public void explode() {
        if (!this.f_19853_.f_46443_) {
            Explosion.BlockInteraction interaction = PlatformUtils.getInteractionForCreeper(this);
            this.f_20890_ = true;
            Explosion explosion = this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0f * (this.m_7090_() ? 2.0f : 1.0f), interaction);
            this.type.getExplosionSound().ifPresent(s -> this.f_19853_.m_6269_(null, (Entity)this, s, SoundSource.BLOCKS, 4.0f, (1.0f + (this.f_19853_.f_46441_.m_188501_() - this.f_19853_.f_46441_.m_188501_()) * 0.2f) * 0.7f));
            this.m_146870_();
            if (!this.type.inflictingPotions().isEmpty()) {
                explosion.m_46078_().keySet().forEach(player -> {
                    List<MobEffectInstance> inflictingPotions = this.type.inflictingPotions().stream().map(MobEffectInstance::new).toList();
                    inflictingPotions.forEach(arg_0 -> ((Player)player).m_7292_(arg_0));
                });
            }
            if (!this.type.replacer().isEmpty()) {
                Set<Map.Entry<Predicate<BlockState>, Function<RandomSource, BlockState>>> entries = this.type.replacer().entrySet();
                explosion.m_46081_().stream().map(BlockPos::m_7495_).forEach(pos -> {
                    BlockState state = this.f_19853_.m_8055_(pos);
                    for (Map.Entry entry : entries) {
                        BlockState newState;
                        if (!((Predicate)entry.getKey()).test(state) || (newState = (BlockState)((Function)entry.getValue()).apply(this.f_19796_)) == null) continue;
                        this.f_19853_.m_7731_(pos, newState, 3);
                        break;
                    }
                });
            }
            Stream<MobEffectInstance> potions = Stream.concat(this.m_21220_().stream().map(MobEffectInstance::new), this.type.potionsWhenDead().stream().map(MobEffectInstance::new));
            this.summonCloudWithEffects(potions.toList());
        }
    }

    private void summonCloudWithEffects(Collection<MobEffectInstance> effects) {
        if (!effects.isEmpty()) {
            AreaEffectCloud cloud = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            cloud.m_19712_(2.5f);
            cloud.m_19732_(-0.5f);
            cloud.m_19740_(10);
            cloud.m_19734_(cloud.m_19748_() / 2);
            cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
            effects.forEach(arg_0 -> ((AreaEffectCloud)cloud).m_19716_(arg_0));
            this.f_19853_.m_7967_((Entity)cloud);
        }
    }

    public float m_32320_(float f) {
        return Mth.m_14179_((float)f, (float)this.oldSwell, (float)this.swell) / ((float)this.maxSwell - 2.0f);
    }

    public boolean canSwell() {
        return this.type.melee() == 0;
    }

    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.type.melee() == 0 && PlatformUtils.isFlintAndSteel(stack)) {
            this.f_19853_.m_5594_(player, this.m_20183_(), SoundEvents.f_11942_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            if (!this.f_19853_.m_5776_()) {
                this.m_32312_();
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (this.type.shearable() && !this.isSheared() && PlatformUtils.isShears(stack)) {
            this.f_19853_.m_5594_(player, this.m_20183_(), SoundEvents.f_12480_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            if (!this.f_19853_.m_5776_()) {
                this.f_19804_.m_135381_(DATA_IS_SHEARED, (Object)true);
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                this.m_5552_(new ItemStack((ItemLike)ModItems.TINY_CACTUS.get()), 1.7f);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean shouldRevenge() {
        return true;
    }

    public double m_21133_(@NotNull Attribute attribute) {
        return super.m_21133_(attribute) * (double)(attribute.equals(Attributes.f_22281_) && this.m_7090_() ? 10 : 1);
    }

    public boolean m_7327_(@NotNull Entity entity) {
        int i;
        if (this.type.melee() == 0) {
            return true;
        }
        double f = this.m_21133_(Attributes.f_22281_);
        double g = this.m_21133_(Attributes.f_22282_);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            f += (double)EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)livingEntity.m_6336_());
            g += (double)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            entity.m_20254_(i * 4);
        }
        if (entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)f)) {
            if (g > 0.0 && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_147240_(g * 0.5, (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            this.m_19970_((LivingEntity)this, entity);
            this.m_21335_(entity);
            return true;
        }
        return false;
    }

    public float m_6113_() {
        return super.m_6113_() * (this.m_7090_() ? 1.5f : 1.0f);
    }

    public boolean m_21275_(@NotNull DamageSource source) {
        return super.m_21275_(source) || this.type.immunities().contains(source);
    }

    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return this.type.hurtSound().get();
    }

    protected SoundEvent m_5592_() {
        return this.type.deathSound().get();
    }

    private <E extends IAnimatable> PlayState idle(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.creeper.idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState action(AnimationEvent<E> event) {
        Animation animation = event.getController().getCurrentAnimation();
        if (((Boolean)this.f_19804_.m_135370_(DATA_IS_ATTACKING)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.creeper.attack", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (animation != null && animation.animationName.equals("animation.creeper.attack") && event.getController().getAnimationState().equals((Object)AnimationState.Running)) {
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.creeper.walk", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "action_controller", 3.0f, this::action));
        data.addAnimationController(new AnimationController((IAnimatable)this, "idle_controller", 0.0f, this::idle));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

