/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.fzzyhmstrs.fzzy_config.FC;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.config.ConfigContext;
import me.fzzyhmstrs.fzzy_config.impl.ConfigApiImpl;
import me.fzzyhmstrs.fzzy_config.impl.ConfigApiImplClient;
import me.fzzyhmstrs.fzzy_config.networking.ConfigSyncS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigUpdateC2SCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigUpdateS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.SettingForwardCustomPayload;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import me.fzzyhmstrs.fzzy_config.util.ValidationResult;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_6860;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0017\u001a\u00020\nH\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0003J\u000f\u0010\u0019\u001a\u00020\nH\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0003J\u0017\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001aH\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ7\u0010$\u001a\u00020\n2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040!2\u0006\u0010#\u001a\u00020\u000e\u00a2\u0006\u0004\b$\u0010%R \u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001a0&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry;", "", "<init>", "()V", "", "update", "Ljava/util/UUID;", "player", "scope", "summary", "", "forwardSetting", "(Ljava/lang/String;Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;)V", "Lnet/minecraft/class_1657;", "", "getPlayerPermissionLevel", "(Lnet/minecraft/class_1657;)I", "id", "", "hasConfig$fzzy_config", "(Ljava/lang/String;)Z", "hasConfig", "registerAll$fzzy_config", "registerAll", "registerClient$fzzy_config", "registerClient", "Lme/fzzyhmstrs/fzzy_config/config/Config;", "config", "registerConfig$fzzy_config", "(Lme/fzzyhmstrs/fzzy_config/config/Config;)V", "registerConfig", "", "serializedConfigs", "", "changeHistory", "playerPerm", "updateServer", "(Ljava/util/Map;Ljava/util/List;I)V", "", "syncedConfigs", "Ljava/util/Map;", "fzzy_config"})
public final class SyncedConfigRegistry {
    @NotNull
    public static final SyncedConfigRegistry INSTANCE = new SyncedConfigRegistry();
    @NotNull
    private static final Map<String, Config> syncedConfigs = new LinkedHashMap();

    private SyncedConfigRegistry() {
    }

    public final void forwardSetting(@NotNull String update2, @NotNull UUID player, @NotNull String scope, @NotNull String summary) {
        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)summary, (String)"summary");
        ClientPlayNetworking.send((class_8710)new SettingForwardCustomPayload(update2, player, scope, summary));
    }

    public final void updateServer(@NotNull Map<String, String> serializedConfigs, @NotNull List<String> changeHistory, int playerPerm) {
        Intrinsics.checkNotNullParameter(serializedConfigs, (String)"serializedConfigs");
        Intrinsics.checkNotNullParameter(changeHistory, (String)"changeHistory");
        ClientPlayNetworking.send((class_8710)new ConfigUpdateC2SCustomPayload(serializedConfigs, changeHistory, playerPerm));
    }

    public final void registerClient$fzzy_config() {
        ClientConfigurationNetworking.registerGlobalReceiver(ConfigSyncS2CCustomPayload.Companion.getType(), SyncedConfigRegistry::registerClient$lambda$1);
        ClientPlayNetworking.registerGlobalReceiver(ConfigUpdateS2CCustomPayload.Companion.getType(), SyncedConfigRegistry::registerClient$lambda$2);
        ClientPlayNetworking.registerGlobalReceiver(SettingForwardCustomPayload.Companion.getType(), SyncedConfigRegistry::registerClient$lambda$3);
    }

    public final void registerAll$fzzy_config() {
        PayloadTypeRegistry.configurationC2S().register(ConfigSyncS2CCustomPayload.Companion.getType(), ConfigSyncS2CCustomPayload.Companion.getCodec());
        PayloadTypeRegistry.configurationS2C().register(ConfigSyncS2CCustomPayload.Companion.getType(), ConfigSyncS2CCustomPayload.Companion.getCodec());
        PayloadTypeRegistry.playC2S().register(ConfigSyncS2CCustomPayload.Companion.getType(), ConfigSyncS2CCustomPayload.Companion.getCodec());
        PayloadTypeRegistry.playS2C().register(ConfigSyncS2CCustomPayload.Companion.getType(), ConfigSyncS2CCustomPayload.Companion.getCodec());
        PayloadTypeRegistry.playC2S().register(ConfigUpdateS2CCustomPayload.Companion.getType(), ConfigUpdateS2CCustomPayload.Companion.getCodec());
        PayloadTypeRegistry.playS2C().register(ConfigUpdateS2CCustomPayload.Companion.getType(), ConfigUpdateS2CCustomPayload.Companion.getCodec());
        PayloadTypeRegistry.playC2S().register(ConfigUpdateC2SCustomPayload.Companion.getType(), ConfigUpdateC2SCustomPayload.Companion.getCodec());
        PayloadTypeRegistry.playS2C().register(ConfigUpdateC2SCustomPayload.Companion.getType(), ConfigUpdateC2SCustomPayload.Companion.getCodec());
        PayloadTypeRegistry.playC2S().register(SettingForwardCustomPayload.Companion.getType(), SettingForwardCustomPayload.Companion.getCodec());
        PayloadTypeRegistry.playS2C().register(SettingForwardCustomPayload.Companion.getType(), SettingForwardCustomPayload.Companion.getCodec());
        ServerConfigurationConnectionEvents.CONFIGURE.register(SyncedConfigRegistry::registerAll$lambda$4);
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register(SyncedConfigRegistry::registerAll$lambda$5);
        ServerConfigurationNetworking.registerGlobalReceiver(ConfigSyncS2CCustomPayload.Companion.getType(), SyncedConfigRegistry::registerAll$lambda$6);
        ServerPlayNetworking.registerGlobalReceiver(ConfigUpdateC2SCustomPayload.Companion.getType(), SyncedConfigRegistry::registerAll$lambda$7);
        ServerPlayNetworking.registerGlobalReceiver(SettingForwardCustomPayload.Companion.getType(), SyncedConfigRegistry::registerAll$lambda$8);
    }

    private final int getPlayerPermissionLevel(class_1657 player) {
        int i = 0;
        while (player.method_5687(i)) {
            ++i;
        }
        return i - 1;
    }

    public final boolean hasConfig$fzzy_config(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return syncedConfigs.containsKey(id);
    }

    public final void registerConfig$fzzy_config(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Map<String, Config> map = syncedConfigs;
        String string = config.getId().method_42094();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toTranslationKey(...)");
        map.put(string, config);
    }

    private static final void registerClient$lambda$1$lambda$0(ClientConfigurationNetworking.Context $handler) {
        $handler.responseSender().disconnect((class_2561)FcText.INSTANCE.translatable("fc.networking.restart", new Object[0]));
        ConfigApiImpl.INSTANCE.openRestartScreen$fzzy_config();
    }

    private static final void registerClient$lambda$1(ConfigSyncS2CCustomPayload payload, ClientConfigurationNetworking.Context handler) {
        String id = payload.getId();
        String configString = payload.getSerializedConfig();
        if (syncedConfigs.containsKey(id)) {
            Config config = syncedConfigs.get(id);
            if (config == null) {
                return;
            }
            Config config2 = config;
            List errors = new ArrayList();
            ValidationResult<ConfigContext<Config>> result = ConfigApi.deserializeConfig(config2, configString, errors, (byte)2);
            boolean restart = result.get().getBoolean(ConfigContext.Keys.getRESTART_KEY());
            result.writeError(errors);
            result.get().getConfig().save();
            if (restart) {
                class_310.method_1551().execute(() -> SyncedConfigRegistry.registerClient$lambda$1$lambda$0(handler));
            }
        }
    }

    private static final void registerClient$lambda$2(ConfigUpdateS2CCustomPayload payload, ClientPlayNetworking.Context context) {
        Map<String, String> serializedConfigs = payload.getUpdates();
        for (Map.Entry<String, String> entry : serializedConfigs.entrySet()) {
            Config config;
            String id = entry.getKey();
            String configString = entry.getValue();
            if (!syncedConfigs.containsKey(id)) continue;
            if (syncedConfigs.get(id) == null) {
                return;
            }
            List errors = new ArrayList();
            ValidationResult<ConfigContext<Config>> result = ConfigApiImpl.INSTANCE.deserializeUpdate$fzzy_config(config, configString, errors, (byte)2);
            boolean restart = result.get().getBoolean(ConfigContext.Keys.getRESTART_KEY());
            result.writeError(errors);
            result.get().getConfig().save();
            if (!restart) continue;
            context.player().method_43496((class_2561)FcText.INSTANCE.translate("fc.config.restart.update", new Object[0]));
        }
    }

    private static final void registerClient$lambda$3(SettingForwardCustomPayload payload, ClientPlayNetworking.Context context) {
        String update2 = payload.getUpdate();
        UUID sendingUuid = payload.getPlayer();
        String scope = payload.getScope();
        String summary = payload.getSummary();
        ConfigApiImplClient.INSTANCE.handleForwardedUpdate$fzzy_config(update2, sendingUuid, scope, summary);
    }

    private static final void registerAll$lambda$4(class_8610 handler, MinecraftServer minecraftServer) {
        for (Map.Entry<String, Config> entry : syncedConfigs.entrySet()) {
            String id = entry.getKey();
            Config config = entry.getValue();
            List syncErrors = new ArrayList();
            ConfigSyncS2CCustomPayload payload = new ConfigSyncS2CCustomPayload(id, ConfigApi.serializeConfig(config, syncErrors, (byte)0));
            if (!((Collection)syncErrors).isEmpty()) {
                ValidationResult<Boolean> syncError = ValidationResult.Companion.error(true, "Error encountered while serializing config for S2C configuration stage sync.");
                syncError.writeError(syncErrors);
            }
            ServerConfigurationNetworking.send((class_8610)handler, (class_8710)payload);
        }
    }

    private static final void registerAll$lambda$5(MinecraftServer server, class_6860 class_68602, boolean bl) {
        List players = server.method_3760().method_14571();
        for (class_3222 player : players) {
            for (Map.Entry<String, Config> entry : syncedConfigs.entrySet()) {
                String id = entry.getKey();
                Config config = entry.getValue();
                List syncErrors = new ArrayList();
                ConfigSyncS2CCustomPayload payload = new ConfigSyncS2CCustomPayload(id, ConfigApi.serializeConfig(config, syncErrors, (byte)0));
                if (!((Collection)syncErrors).isEmpty()) {
                    ValidationResult<Boolean> syncError = ValidationResult.Companion.error(true, "Error encountered while serializing config for S2C datapack reload sync.");
                    syncError.writeError(syncErrors);
                }
                ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
            }
        }
    }

    private static final void registerAll$lambda$6(ConfigSyncS2CCustomPayload packet, ServerConfigurationNetworking.Context handler) {
    }

    private static final void registerAll$lambda$7(ConfigUpdateC2SCustomPayload payload, ServerPlayNetworking.Context context) {
        int permLevel = payload.getPlayerPerm();
        Map<String, String> serializedConfigs = payload.getUpdates();
        if (!context.player().method_5687(permLevel)) {
            Logger logger = FC.INSTANCE.getLOGGER$fzzy_config();
            class_2561 class_25612 = context.player().method_5477();
            class_3222 class_32222 = context.player();
            Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"player(...)");
            logger.error("Player [" + class_25612 + "] may have tried to cheat changes to the Server Config! Their perm level: " + INSTANCE.getPlayerPermissionLevel((class_1657)class_32222) + ", perm level synced from client: " + permLevel);
            List<String> changes = payload.getChangeHistory();
            ConfigApiImpl.INSTANCE.printChangeHistory$fzzy_config(changes, serializedConfigs.keySet().toString(), (class_1657)context.player());
            for (class_3222 player : context.player().field_13995.method_3760().method_14571()) {
                if (!player.method_5687(2)) continue;
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)context.player().method_5477(), (String)"getName(...)");
                player.method_43502((class_2561)FcText.INSTANCE.translate("fc.networking.permission.cheat", objectArray), false);
            }
            return;
        }
        for (Map.Entry<String, String> entry : serializedConfigs.entrySet()) {
            Config config;
            String id = entry.getKey();
            String configString = entry.getValue();
            if (syncedConfigs.get(id) == null) continue;
            List errors = new ArrayList();
            ValidationResult<ConfigContext<Config>> result = ConfigApiImpl.INSTANCE.deserializeUpdate$fzzy_config(config, configString, errors, (byte)2);
            boolean restart = result.get().getBoolean(ConfigContext.Keys.getRESTART_KEY());
            result.writeError(errors);
            result.get().getConfig().save();
            if (!restart) continue;
            FC.INSTANCE.getLOGGER$fzzy_config().error("The server has received a config update that may require a restart, please consult the change history below for details. Connected clients have been automatically updated and notified of the potential for restart.");
        }
        for (class_3222 player : context.player().field_13995.method_3760().method_14571()) {
            if (Intrinsics.areEqual((Object)player, (Object)context.player())) continue;
            ConfigUpdateS2CCustomPayload newPayload = new ConfigUpdateS2CCustomPayload(serializedConfigs);
            ServerPlayNetworking.send((class_3222)player, (class_8710)newPayload);
        }
        List<String> changes = payload.getChangeHistory();
        ConfigApiImpl.INSTANCE.printChangeHistory$fzzy_config(changes, serializedConfigs.keySet().toString(), (class_1657)context.player());
    }

    private static final void registerAll$lambda$8(SettingForwardCustomPayload payload, ServerPlayNetworking.Context context) {
        UUID uuid = payload.getPlayer();
        class_3222 class_32222 = context.player().field_13995.method_3760().method_14602(uuid);
        if (class_32222 == null) {
            return;
        }
        class_3222 receivingPlayer = class_32222;
        String scope = payload.getScope();
        String update2 = payload.getUpdate();
        String summary = payload.getSummary();
        class_3222 sendingPlayer = context.player();
        UUID uUID = sendingPlayer.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        ServerPlayNetworking.send((class_3222)receivingPlayer, (class_8710)new SettingForwardCustomPayload(update2, uUID, scope, summary));
    }
}

