/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.client.resource;

import com.google.gson.JsonObject;
import foundationgames.enhancedblockentities.client.resource.AtlasResourceBuilder;
import foundationgames.enhancedblockentities.client.resource.template.TemplateLoader;
import foundationgames.enhancedblockentities.client.resource.template.TemplateProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_7948;
import net.minecraft.class_7954;
import net.minecraft.class_7955;
import net.minecraft.class_9224;
import org.jetbrains.annotations.Nullable;

public class EBEPack
implements class_3262 {
    public static final class_2960 BLOCK_ATLAS = new class_2960("blocks");
    private final Map<class_2960, AtlasResourceBuilder> atlases = new HashMap<class_2960, AtlasResourceBuilder>();
    private final Map<class_2960, class_7367<InputStream>> resources = new HashMap<class_2960, class_7367<InputStream>>();
    private final Set<String> namespaces = new HashSet<String>();
    private final TemplateLoader templates;
    private final JsonObject packMeta;
    private final class_9224 packInfo;

    public EBEPack(class_2960 id, TemplateLoader templates) {
        this.templates = templates;
        this.packMeta = new JsonObject();
        this.packMeta.addProperty("pack_format", (Number)class_155.method_16673().method_48017(class_3264.field_14188));
        this.packMeta.addProperty("description", "Enhanced Block Entities Resources");
        this.packInfo = new class_9224(id.toString(), (class_2561)class_2561.method_43470((String)id.toString()), class_5352.field_25348, Optional.empty());
    }

    public void addAtlasSprite(class_2960 atlas, class_7948 source) {
        AtlasResourceBuilder resource = this.atlases.computeIfAbsent(atlas, id -> new AtlasResourceBuilder());
        resource.put(source);
        this.addResource(new class_2960(atlas.method_12836(), "atlases/" + atlas.method_12832() + ".json"), (class_7367<byte[]>)((class_7367)resource::toBytes));
    }

    public void addSingleBlockSprite(class_2960 path) {
        this.addAtlasSprite(BLOCK_ATLAS, (class_7948)new class_7955(path, Optional.empty()));
    }

    public void addDirBlockSprites(String dir, String prefix) {
        this.addAtlasSprite(BLOCK_ATLAS, (class_7948)new class_7954(dir, prefix));
    }

    public void addResource(class_2960 id, class_7367<byte[]> resource) {
        this.namespaces.add(id.method_12836());
        this.resources.put(id, new LazyBufferedResource(resource));
    }

    public void addResource(class_2960 id, byte[] resource) {
        this.namespaces.add(id.method_12836());
        this.resources.put(id, (class_7367<InputStream>)((class_7367)() -> new ByteArrayInputStream(resource)));
    }

    public void addPlainTextResource(class_2960 id, String plainText) {
        this.addResource(id, plainText.getBytes(StandardCharsets.UTF_8));
    }

    public void addTemplateResource(class_2960 id, TemplateProvider.TemplateApplyingFunction template) {
        this.addResource(id, (class_7367<byte[]>)((class_7367)() -> template.getAndApplyTemplate(new TemplateProvider(this.templates)).getBytes(StandardCharsets.UTF_8)));
    }

    public void addTemplateResource(class_2960 id, String templatePath) {
        this.addTemplateResource(id, (TemplateProvider t) -> t.load(templatePath, d -> {}));
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... segments) {
        return null;
    }

    @Nullable
    public class_7367<InputStream> method_14405(class_3264 type, class_2960 id) {
        if (type != class_3264.field_14188) {
            return null;
        }
        return this.resources.get(id);
    }

    public void method_14408(class_3264 type, String namespace, String prefix, class_3262.class_7664 consumer) {
        if (type != class_3264.field_14188) {
            return;
        }
        for (Map.Entry<class_2960, class_7367<InputStream>> entry : this.resources.entrySet()) {
            class_2960 id = entry.getKey();
            if (!id.method_12836().startsWith(namespace) || !id.method_12832().startsWith(prefix)) continue;
            consumer.accept((Object)id, entry.getValue());
        }
    }

    public Set<String> method_14406(class_3264 type) {
        if (type != class_3264.field_14188) {
            return Set.of();
        }
        return this.namespaces;
    }

    @Nullable
    public <T> T method_14407(class_3270<T> meta) throws IOException {
        if ("pack".equals(meta.method_14420())) {
            return (T)meta.method_14421(this.packMeta);
        }
        return null;
    }

    public class_9224 method_56926() {
        return this.packInfo;
    }

    public void close() {
    }

    public void dump(Path dir) throws IOException {
        dir = dir.resolve("assets");
        for (Map.Entry<class_2960, class_7367<InputStream>> entry : this.resources.entrySet()) {
            class_2960 id = entry.getKey();
            Path file = dir.resolve(id.method_12836()).resolve(id.method_12832());
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            OutputStream out = Files.newOutputStream(file, new OpenOption[0]);
            try {
                int i;
                InputStream in = (InputStream)entry.getValue().get();
                while ((i = in.read()) >= 0) {
                    out.write(i);
                }
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
    }

    public static class LazyBufferedResource
    implements class_7367<InputStream> {
        private final class_7367<byte[]> backing;
        private byte[] buffer = null;

        public LazyBufferedResource(class_7367<byte[]> backing) {
            this.backing = backing;
        }

        public InputStream get() throws IOException {
            if (this.buffer == null) {
                this.buffer = (byte[])this.backing.get();
            }
            return new ByteArrayInputStream(this.buffer);
        }
    }

    public static class PropertyBuilder {
        private Properties properties = new Properties();

        private PropertyBuilder() {
        }

        public PropertyBuilder def(String k, String v) {
            if (this.properties != null) {
                this.properties.setProperty(k, v);
            }
            return this;
        }

        private Properties build() {
            Properties properties = this.properties;
            this.properties = null;
            return properties;
        }
    }
}

